/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.internals.MemoryBatchReader;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockRandom;
import org.junit.jupiter.api.Assertions;

public class RecordTestUtils {
    public static void replayAll(Object target, List<ApiMessageAndVersion> recordsAndVersions) {
        for (ApiMessageAndVersion recordAndVersion : recordsAndVersions) {
            ApiMessage record = recordAndVersion.message();
            try {
                try {
                    Method method = target.getClass().getMethod("replay", record.getClass());
                    method.invoke(target, record);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Method method = target.getClass().getMethod("replay", record.getClass(), Short.TYPE);
                        method.invoke(target, record, recordAndVersion.version());
                    }
                    catch (NoSuchMethodException i) {
                        try {
                            Method method = target.getClass().getMethod("replay", record.getClass(), Long.TYPE);
                            method.invoke(target, record, 0L);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {}
                    }
                }
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void replayOne(Object target, ApiMessageAndVersion recordAndVersion) {
        RecordTestUtils.replayAll(target, Collections.singletonList(recordAndVersion));
    }

    public static <T extends ApiMessage> Optional<T> recordAtIndexAs(Class<T> recordClazz, List<ApiMessageAndVersion> recordsAndVersions, int recordIndex) {
        if (recordIndex > recordsAndVersions.size() - 1) {
            return Optional.empty();
        }
        if (recordIndex == -1) {
            return recordsAndVersions.stream().map(ApiMessageAndVersion::message).filter(record -> record.getClass().isAssignableFrom(recordClazz)).map(recordClazz::cast).findFirst();
        }
        ApiMessageAndVersion messageAndVersion = recordsAndVersions.get(recordIndex);
        ApiMessage record2 = messageAndVersion.message();
        if (record2.getClass().isAssignableFrom(recordClazz)) {
            return Optional.of((ApiMessage)recordClazz.cast(record2));
        }
        return Optional.empty();
    }

    public static void replayAllBatches(Object target, List<List<ApiMessageAndVersion>> batches) {
        for (List<ApiMessageAndVersion> batch : batches) {
            RecordTestUtils.replayAll(target, batch);
        }
    }

    public static <T> Set<T> iteratorToSet(Iterator<T> iterator) {
        HashSet<T> set = new HashSet<T>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static void assertBatchIteratorContains(List<List<ApiMessageAndVersion>> batches, Iterator<List<ApiMessageAndVersion>> iterator) throws Exception {
        ArrayList actual = new ArrayList();
        while (iterator.hasNext()) {
            actual.add(new ArrayList(iterator.next()));
        }
        RecordTestUtils.deepSortRecords(actual);
        ArrayList<ArrayList<ApiMessageAndVersion>> expected = new ArrayList<ArrayList<ApiMessageAndVersion>>();
        for (List<ApiMessageAndVersion> batch : batches) {
            expected.add(new ArrayList<ApiMessageAndVersion>(batch));
        }
        RecordTestUtils.deepSortRecords(expected);
        Assertions.assertEquals(expected, actual);
    }

    public static void deepSortRecords(Object o) throws Exception {
        if (o == null) {
            return;
        }
        if (o instanceof List) {
            List list = (List)o;
            for (Object entry : list) {
                if (entry == null) continue;
                if (Number.class.isAssignableFrom(entry.getClass())) {
                    return;
                }
                RecordTestUtils.deepSortRecords(entry);
            }
            list.sort(Comparator.comparing(Object::toString));
        } else if (o instanceof ImplicitLinkedHashCollection) {
            ImplicitLinkedHashCollection coll = (ImplicitLinkedHashCollection)o;
            for (Object entry : coll) {
                RecordTestUtils.deepSortRecords(entry);
            }
            coll.sort(Comparator.comparing(Object::toString));
        } else if (o instanceof Message || o instanceof ApiMessageAndVersion) {
            for (Field field : o.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                RecordTestUtils.deepSortRecords(field.get(o));
            }
        }
    }

    public static BatchReader<ApiMessageAndVersion> mockBatchReader(long lastOffset, long appendTimestamp, List<ApiMessageAndVersion> records) {
        ArrayList<Batch> batches = new ArrayList<Batch>();
        long offset = lastOffset - (long)records.size() + 1L;
        Iterator<ApiMessageAndVersion> iterator = records.iterator();
        ArrayList<Object> curRecords = new ArrayList<ApiMessageAndVersion>();
        Assertions.assertTrue((boolean)iterator.hasNext());
        while (true) {
            if (!iterator.hasNext() || curRecords.size() >= 2) {
                batches.add(Batch.data((long)offset, (int)0, (long)appendTimestamp, (int)RecordTestUtils.sizeInBytes(curRecords), curRecords));
                if (!iterator.hasNext()) break;
                offset += (long)curRecords.size();
                curRecords = new ArrayList();
            }
            curRecords.add(iterator.next());
        }
        return MemoryBatchReader.of(batches, __ -> {});
    }

    private static int sizeInBytes(List<ApiMessageAndVersion> records) {
        int size = 0;
        for (ApiMessageAndVersion record : records) {
            ObjectSerializationCache cache = new ObjectSerializationCache();
            size += MetadataRecordSerde.INSTANCE.recordSize(record, cache);
        }
        return size;
    }

    public static ApiMessageAndVersion testRecord(int index) {
        MockRandom random = new MockRandom((long)index);
        return new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test" + index).setTopicId(new Uuid(random.nextLong(), random.nextLong())), 0);
    }

    public static RegisterControllerRecord createTestControllerRegistration(int id, boolean zkMigrationReady) {
        return new RegisterControllerRecord().setControllerId(id).setIncarnationId(new Uuid(3465346L, (long)id)).setZkMigrationReady(zkMigrationReady).setEndPoints(new RegisterControllerRecord.ControllerEndpointCollection(Arrays.asList(new RegisterControllerRecord.ControllerEndpoint().setName("CONTROLLER").setHost("localhost").setPort(8000 + id).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id), new RegisterControllerRecord.ControllerEndpoint().setName("CONTROLLER_SSL").setHost("localhost").setPort(9000 + id).setSecurityProtocol(SecurityProtocol.SSL.id)).iterator())).setFeatures(new RegisterControllerRecord.ControllerFeatureCollection(Collections.singletonList(new RegisterControllerRecord.ControllerFeature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_6_IV1.confluentFeatureLevel())).iterator()));
    }

    public static RegisterBrokerRecord createTestBrokerRegistration(int id) {
        return new RegisterBrokerRecord().setBrokerId(id).setIncarnationId(new Uuid(3465346L, (long)id)).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Arrays.asList(new RegisterBrokerRecord.BrokerEndpoint().setName("INTERNAL").setHost("localhost").setPort(6000 + id).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id), new RegisterBrokerRecord.BrokerEndpoint().setName("EXTERNAL").setHost("example.com").setPort(7000 + id).setSecurityProtocol(SecurityProtocol.SSL.id)).iterator())).setFeatures(new RegisterBrokerRecord.BrokerFeatureCollection(Arrays.asList(new RegisterBrokerRecord.BrokerFeature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_6_IV1.confluentFeatureLevel())).iterator()));
    }

    public static Records createBatch(long baseOffset, int leaderEpoch, List<List<ApiMessageAndVersion>> batches) {
        ByteBufferOutputStream out = new ByteBufferOutputStream(0);
        long batchBaseOffset = baseOffset;
        for (List<ApiMessageAndVersion> batch : batches) {
            MemoryRecordsBuilder builder = new MemoryRecordsBuilder(out, RecordVersion.current().value, (Compression)Compression.NONE, TimestampType.CREATE_TIME, batchBaseOffset, Time.SYSTEM.milliseconds(), -1L, -1, -1, false, false, leaderEpoch, Integer.MAX_VALUE, -1L, true);
            ObjectSerializationCache cache = new ObjectSerializationCache();
            for (ApiMessageAndVersion messageAndVersion : batch) {
                ByteBuffer buffer = ByteBuffer.allocate(MetadataRecordSerde.INSTANCE.recordSize(messageAndVersion, cache));
                ByteBufferAccessor recordOut = new ByteBufferAccessor(buffer);
                MetadataRecordSerde.INSTANCE.write(messageAndVersion, cache, (Writable)recordOut);
                ByteBuffer recordBuffer = recordOut.buffer();
                recordBuffer.flip();
                builder.append(new SimpleRecord(recordBuffer));
            }
            builder.close();
            batchBaseOffset += (long)batch.size();
        }
        ByteBuffer buffer = out.buffer();
        buffer.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buffer);
    }

    public static class TestThroughAllIntermediateImagesLeadingToFinalImageHelper<D, I> {
        private final Supplier<I> emptyImageSupplier;
        private final Function<I, D> deltaUponImageCreator;

        public TestThroughAllIntermediateImagesLeadingToFinalImageHelper(Supplier<I> emptyImageSupplier, Function<I, D> deltaUponImageCreator) {
            this.emptyImageSupplier = Objects.requireNonNull(emptyImageSupplier);
            this.deltaUponImageCreator = Objects.requireNonNull(deltaUponImageCreator);
        }

        public I getEmptyImage() {
            return this.emptyImageSupplier.get();
        }

        public D createDeltaUponImage(I image) {
            return this.deltaUponImageCreator.apply(image);
        }

        public I createImageByApplyingDelta(D delta) {
            try {
                try {
                    Method method = delta.getClass().getMethod("apply", new Class[0]);
                    return (I)method.invoke(delta, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public void test(I finalImage, List<ApiMessageAndVersion> fromRecords) {
            for (int numRecordsForfirstImage = 1; numRecordsForfirstImage <= fromRecords.size(); ++numRecordsForfirstImage) {
                D delta = this.createDeltaUponImage(this.getEmptyImage());
                RecordTestUtils.replayAll(delta, fromRecords.subList(0, numRecordsForfirstImage));
                I firstImage = this.createImageByApplyingDelta(delta);
                int remainingRecords = fromRecords.size() - numRecordsForfirstImage;
                if (remainingRecords == 0) {
                    Assertions.assertEquals(finalImage, firstImage);
                    continue;
                }
                for (int maxRecordsForSuccessiveBatches = 1; maxRecordsForSuccessiveBatches <= remainingRecords; ++maxRecordsForSuccessiveBatches) {
                    I latestIntermediateImage = firstImage;
                    int numAdditionalBatches = (int)Math.ceil((double)remainingRecords * 1.0 / (double)maxRecordsForSuccessiveBatches);
                    for (int additionalBatchNum = 0; additionalBatchNum < numAdditionalBatches; ++additionalBatchNum) {
                        delta = this.createDeltaUponImage(latestIntermediateImage);
                        int applyFromIndex = numRecordsForfirstImage + additionalBatchNum * maxRecordsForSuccessiveBatches;
                        int applyToIndex = Math.min(fromRecords.size(), applyFromIndex + maxRecordsForSuccessiveBatches);
                        RecordTestUtils.replayAll(delta, fromRecords.subList(applyFromIndex, applyToIndex));
                        latestIntermediateImage = this.createImageByApplyingDelta(delta);
                    }
                    Assertions.assertEquals(finalImage, latestIntermediateImage);
                }
            }
        }

        public void test(List<ApiMessageAndVersion> fromRecords) {
            D finalImageDelta = this.createDeltaUponImage(this.getEmptyImage());
            RecordTestUtils.replayAll(finalImageDelta, fromRecords);
            I finalImage = this.createImageByApplyingDelta(finalImageDelta);
            this.test(finalImage, fromRecords);
        }
    }

    public static class ImageDeltaPair<I, D> {
        private final Supplier<I> imageSupplier;
        private final Function<I, D> deltaCreator;

        public ImageDeltaPair(Supplier<I> imageSupplier, Function<I, D> deltaCreator) {
            this.imageSupplier = imageSupplier;
            this.deltaCreator = deltaCreator;
        }

        public Supplier<I> imageSupplier() {
            return this.imageSupplier;
        }

        public Function<I, D> deltaCreator() {
            return this.deltaCreator;
        }
    }
}

