/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.MirrorTopicSwitchoverMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MirrorTopicTest {
    @Test
    public void testMirrorTopicStateTransitions() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.ActiveMirrorTopic mirrorTopic = new MirrorTopic.ActiveMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, Collections.singletonList(0L), stoppedSequenceNumber, switchoverMetadata, timeMs);
        Optional pausedTopicOpt = mirrorTopic.toPaused(false, timeMs);
        Assertions.assertTrue((boolean)pausedTopicOpt.isPresent());
        MirrorTopic pausedTopic = (MirrorTopic)pausedTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.PAUSED, (Object)pausedTopic.mirrorState());
        Optional mirrorTopicOpt = pausedTopic.toUnpaused(false, timeMs);
        Assertions.assertTrue((boolean)mirrorTopicOpt.isPresent());
        MirrorTopic newMirrorTopic = (MirrorTopic)mirrorTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.MIRROR, (Object)newMirrorTopic.mirrorState());
        Optional pendingStoppedOpt = newMirrorTopic.toPendingStopped(false, timeMs);
        Assertions.assertTrue((boolean)pendingStoppedOpt.isPresent());
        MirrorTopic pendingStoppedTopic = (MirrorTopic)pendingStoppedOpt.get();
        Optional stoppedTopicOpt = pendingStoppedTopic.toStopped(Collections.singletonList(0L), Collections.singletonList(0), timeMs, stoppedSequenceNumber);
        Assertions.assertTrue((boolean)stoppedTopicOpt.isPresent());
        MirrorTopic stoppedTopic = (MirrorTopic)stoppedTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.STOPPED, (Object)stoppedTopic.mirrorState());
        Optional pendingMirrorTopicOpt = stoppedTopic.toPendingMirror(sourceTopicId, linkId, timeMs, MirrorTopic.State.MIRROR, stoppedSequenceNumber);
        Assertions.assertTrue((boolean)pendingMirrorTopicOpt.isPresent());
        MirrorTopic pendingMirrorTopic = (MirrorTopic)pendingMirrorTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.PENDING_MIRROR, (Object)pendingMirrorTopic.mirrorState());
    }

    @Test
    public void testClearMirrorStartOffsets() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.ActiveMirrorTopic mirrorTopic = new MirrorTopic.ActiveMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, Collections.singletonList(0L), stoppedSequenceNumber, switchoverMetadata, timeMs);
        Optional clearedTopicOpt = mirrorTopic.clearMirrorStartOffsets(timeMs);
        Assertions.assertTrue((boolean)clearedTopicOpt.isPresent());
        MirrorTopic clearedTopic = (MirrorTopic)clearedTopicOpt.get();
        Assertions.assertTrue((boolean)clearedTopic.mirrorStartOffsets().isEmpty());
    }

    @Test
    public void testToStopped() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.ActiveMirrorTopic mirrorTopic = new MirrorTopic.ActiveMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, Collections.singletonList(0L), stoppedSequenceNumber, switchoverMetadata, timeMs);
        mirrorTopic = (MirrorTopic)mirrorTopic.toPendingStopped(false, timeMs).get();
        Optional stoppedTopicOpt = mirrorTopic.toStopped(Collections.singletonList(0L), Collections.singletonList(0), timeMs, stoppedSequenceNumber);
        Assertions.assertTrue((boolean)stoppedTopicOpt.isPresent());
        MirrorTopic stoppedTopic = (MirrorTopic)stoppedTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.STOPPED, (Object)stoppedTopic.mirrorState());
    }

    @Test
    public void testToPaused() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.ActiveMirrorTopic mirrorTopic = new MirrorTopic.ActiveMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, Collections.singletonList(0L), stoppedSequenceNumber, switchoverMetadata, timeMs);
        Optional pausedTopicOpt = mirrorTopic.toPaused(false, timeMs);
        Assertions.assertTrue((boolean)pausedTopicOpt.isPresent());
        MirrorTopic pausedTopic = (MirrorTopic)pausedTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.PAUSED, (Object)pausedTopic.mirrorState());
    }

    @Test
    public void testToUnpaused() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.PausedMirrorTopic mirrorTopic = new MirrorTopic.PausedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, Collections.singletonList(0L), stoppedSequenceNumber, switchoverMetadata, timeMs, false, true, MirrorTopic.State.MIRROR, MirrorTopicError.UNKNOWN, MirrorTopic.State.MIRROR);
        Optional unpausedTopicOpt = mirrorTopic.toUnpaused(true, timeMs);
        Assertions.assertTrue((boolean)unpausedTopicOpt.isPresent());
        MirrorTopic unpausedTopic = (MirrorTopic)unpausedTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.MIRROR, (Object)unpausedTopic.mirrorState());
    }

    @Test
    public void testToPendingStopped() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.ActiveMirrorTopic mirrorTopic = new MirrorTopic.ActiveMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, Collections.singletonList(0L), stoppedSequenceNumber, switchoverMetadata, timeMs);
        Optional pendingStoppedTopicOpt = mirrorTopic.toPendingStopped(false, timeMs);
        Assertions.assertTrue((boolean)pendingStoppedTopicOpt.isPresent());
        MirrorTopic pendingStoppedTopic = (MirrorTopic)pendingStoppedTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.PENDING_STOPPED, (Object)pendingStoppedTopic.mirrorState());
    }

    @Test
    public void testToPendingMirror() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.StoppedMirrorTopic mirrorTopic = new MirrorTopic.StoppedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, stoppedSequenceNumber, switchoverMetadata, timeMs, Collections.singletonList(0L), Collections.singletonList(0));
        Optional pendingMirrorTopicOpt = mirrorTopic.toPendingMirror(sourceTopicId, linkId, timeMs, MirrorTopic.State.MIRROR, stoppedSequenceNumber);
        Assertions.assertTrue((boolean)pendingMirrorTopicOpt.isPresent());
        MirrorTopic pendingMirrorTopic = (MirrorTopic)pendingMirrorTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.PENDING_MIRROR, (Object)pendingMirrorTopic.mirrorState());
    }

    @Test
    public void testToMirror() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.PendingMirrorTopic mirrorTopic = new MirrorTopic.PendingMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, stoppedSequenceNumber, switchoverMetadata, timeMs, MirrorTopic.State.MIRROR);
        Optional mirrorTopicOpt = mirrorTopic.toMirror(timeMs);
        Assertions.assertTrue((boolean)mirrorTopicOpt.isPresent());
        MirrorTopic newMirrorTopic = (MirrorTopic)mirrorTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.MIRROR, (Object)newMirrorTopic.mirrorState());
    }

    @Test
    public void testToPendingRepair() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.FailedMirrorTopic mirrorTopic = new MirrorTopic.FailedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, stoppedSequenceNumber, switchoverMetadata, timeMs, MirrorTopicError.UNKNOWN);
        Optional pendingRepairTopicOpt = mirrorTopic.toPendingRepair(timeMs);
        Assertions.assertTrue((boolean)pendingRepairTopicOpt.isPresent());
        MirrorTopic pendingRepairTopic = (MirrorTopic)pendingRepairTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.PENDING_REPAIR, (Object)pendingRepairTopic.mirrorState());
    }

    @Test
    public void testToFailedMirror() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.PendingMirrorTopic mirrorTopic = new MirrorTopic.PendingMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, stoppedSequenceNumber, switchoverMetadata, timeMs, MirrorTopic.State.MIRROR);
        Optional failedTopicOpt = mirrorTopic.toFailedMirror((short)1, timeMs);
        Assertions.assertTrue((boolean)failedTopicOpt.isPresent());
        MirrorTopic failedTopic = (MirrorTopic)failedTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.FAILED, (Object)failedTopic.mirrorState());
    }

    @Test
    public void testToPendingSynchronize() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.ActiveMirrorTopic mirrorTopic = new MirrorTopic.ActiveMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, Collections.singletonList(0L), stoppedSequenceNumber, switchoverMetadata, timeMs);
        Optional pendingSynchronizeTopicOpt = mirrorTopic.toPendingSynchronize(MirrorTopic.State.MIRROR, timeMs);
        Assertions.assertTrue((boolean)pendingSynchronizeTopicOpt.isPresent());
        MirrorTopic pendingSynchronizeTopic = (MirrorTopic)pendingSynchronizeTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.PENDING_SYNCHRONIZE, (Object)pendingSynchronizeTopic.mirrorState());
    }

    @Test
    public void testToPendingSetupForRestore() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.StoppedMirrorTopic mirrorTopic = new MirrorTopic.StoppedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, stoppedSequenceNumber, switchoverMetadata, timeMs, Collections.singletonList(0L), Collections.singletonList(0));
        Optional pendingSetupForRestoreTopicOpt = mirrorTopic.toPendingSetupForRestore(linkId, sourceTopicId, Collections.singletonList(0), Collections.singletonList(0L), stoppedSequenceNumber, timeMs);
        Assertions.assertTrue((boolean)pendingSetupForRestoreTopicOpt.isPresent());
        MirrorTopic pendingSetupForRestoreTopic = (MirrorTopic)pendingSetupForRestoreTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.PENDING_SETUP_FOR_RESTORE, (Object)pendingSetupForRestoreTopic.mirrorState());
    }

    @Test
    public void testToPendingRestore() {
        Uuid linkId = Uuid.randomUuid();
        Uuid topicId = Uuid.randomUuid();
        Uuid sourceTopicId = Uuid.randomUuid();
        String linkName = "link";
        String topicName = "topic";
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        long stoppedSequenceNumber = 0L;
        MirrorTopicSwitchoverMetadata switchoverMetadata = MirrorTopicSwitchoverMetadata.empty();
        MirrorTopic.PendingSetupForRestoreMirrorTopic mirrorTopic = new MirrorTopic.PendingSetupForRestoreMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, Collections.singletonList(0L), Collections.singletonList(0), stoppedSequenceNumber, switchoverMetadata, timeMs);
        Optional pendingRestoreTopicOpt = mirrorTopic.toPendingRestore(Collections.singletonList(0L), timeMs);
        Assertions.assertTrue((boolean)pendingRestoreTopicOpt.isPresent());
        MirrorTopic pendingRestoreTopic = (MirrorTopic)pendingRestoreTopicOpt.get();
        Assertions.assertEquals((Object)MirrorTopic.State.PENDING_RESTORE, (Object)pendingRestoreTopic.mirrorState());
    }

    @Test
    public void testFromRecordWithNoSwitchoverMetadata() {
        MirrorTopicRecord record = new MirrorTopicRecord().setClusterLinkId(Uuid.randomUuid()).setClusterLinkName("link").setTopicId(Uuid.randomUuid()).setTopicName("topic").setSourceTopicId(Uuid.randomUuid()).setSourceTopicName("sourceTopic").setMirrorTopicState("Mirror").setMirrorStartOffsets(Collections.singletonList(0L)).setTimeMs(System.currentTimeMillis());
        MirrorTopic.ActiveMirrorTopic result = MirrorTopic.ActiveMirrorTopic.fromRecord((MirrorTopicRecord)record);
        Assertions.assertEquals((Object)record.clusterLinkId(), (Object)result.linkId());
        Assertions.assertEquals((Object)record.clusterLinkName(), (Object)result.linkName());
        Assertions.assertEquals((Object)record.topicId(), (Object)result.topicId());
        Assertions.assertEquals((Object)record.topicName(), (Object)result.topicName());
        Assertions.assertEquals((Object)record.sourceTopicId(), (Object)result.sourceTopicId());
        Assertions.assertEquals((Object)record.sourceTopicName(), (Object)result.sourceTopicName());
        Assertions.assertEquals((Object)MirrorTopic.State.MIRROR, (Object)result.mirrorState());
        Assertions.assertEquals((Object)record.mirrorStartOffsets(), (Object)result.mirrorStartOffsets());
        Assertions.assertEquals((long)record.stoppedSequenceNumber(), (long)result.stoppedSequenceNumber());
        Assertions.assertEquals((long)record.timeMs(), (long)result.timeMs());
    }
}

