/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.EncryptedEnvelopeRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.AesGcm128MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class MetadataEncryptorTest {
    private static final Uuid FOO = Uuid.fromString((String)"ZUpeNz1eSKyT_qiVKswGfA");

    private byte[] sequentialBytes(int startingByte, int length) {
        byte[] secret = new byte[length];
        for (int i = 0; i < secret.length; ++i) {
            secret[i] = (byte)((startingByte + i) % 255);
        }
        return secret;
    }

    @Test
    public void testNoOpEncryptorHasZeroUuidAndEmptySecret() throws Exception {
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)NoOpMetadataEncryptor.INSTANCE.id());
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])NoOpMetadataEncryptor.INSTANCE.secret());
    }

    @Test
    public void testNoOpEncryptorMustHaveZeroUuidAndEmptySecret() throws Exception {
        Assertions.assertEquals((Object)"NoOpMetadataEncryptor cannot be created with a non-zero ID.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new NoOpMetadataEncryptor(FOO, new byte[0]))).getMessage());
        Assertions.assertEquals((Object)"NoOpMetadataEncryptor cannot be created with a non-empty secret.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new NoOpMetadataEncryptor(Uuid.ZERO_UUID, new byte[1]))).getMessage());
    }

    @Test
    public void testAesGcm128EncryptorCannotHaveZeroUuid() throws Exception {
        Assertions.assertEquals((Object)"Invalid zero id.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new AesGcm128MetadataEncryptor(Uuid.ZERO_UUID, this.sequentialBytes(1, 16)))).getMessage());
    }

    @Test
    public void testAesGcm128EncryptorMustHaveCorrectKeyLength() throws Exception {
        Assertions.assertEquals((Object)"Invalid key length 17. AesGcm128MetadataEncryptor requires a length of 16", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new AesGcm128MetadataEncryptor(FOO, this.sequentialBytes(1, 17)))).getMessage());
    }

    @Test
    public void testAesGcm128GetSecretGetId() throws Exception {
        byte[] secret = this.sequentialBytes(1, 16);
        AesGcm128MetadataEncryptor encryptor = new AesGcm128MetadataEncryptor(FOO, secret);
        Assertions.assertArrayEquals((byte[])secret, (byte[])encryptor.secret());
        Assertions.assertEquals((Object)FOO, (Object)encryptor.id());
    }

    @Test
    public void testAesGcm128EncryptionRoundTrip() throws Exception {
        AesGcm128MetadataEncryptor encryptor = new AesGcm128MetadataEncryptor(FOO, this.sequentialBytes(1, 16));
        this.roundTripTest((MetadataEncryptor)encryptor, this.sequentialBytes(100, 5));
        this.roundTripTest((MetadataEncryptor)encryptor, this.sequentialBytes(0, 100));
        this.roundTripTest((MetadataEncryptor)encryptor, new byte[]{0});
    }

    private void roundTripTest(MetadataEncryptor encryptor, byte[] plaintext) {
        byte[] ciphertext = encryptor.encrypt(plaintext);
        Assertions.assertTrue((plaintext.length <= ciphertext.length ? 1 : 0) != 0);
        byte[] plaintextAgain = encryptor.decrypt(ciphertext);
        Assertions.assertArrayEquals((byte[])plaintextAgain, (byte[])plaintext);
    }

    @Test
    public void testAesGcm128StringEncryptionRoundTrip() throws Exception {
        AesGcm128MetadataEncryptor encryptor = new AesGcm128MetadataEncryptor(FOO, this.sequentialBytes(2, 16));
        this.roundTripTest((MetadataEncryptor)encryptor, "");
        this.roundTripTest((MetadataEncryptor)encryptor, "foo, bar, and also baz");
        this.roundTripTest((MetadataEncryptor)encryptor, " ");
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 500; ++i) {
            b.append("a");
        }
        this.roundTripTest((MetadataEncryptor)encryptor, b.toString());
    }

    private void roundTripTest(MetadataEncryptor encryptor, String plaintext) {
        byte[] ciphertext = encryptor.encryptString(plaintext);
        String plaintextAgain = encryptor.decryptString(ciphertext);
        Assertions.assertEquals((Object)plaintextAgain, (Object)plaintext);
    }

    @Test
    public void testAesGcm128SMessageEncryptionRoundTrip() throws Exception {
        AesGcm128MetadataEncryptor encryptor = new AesGcm128MetadataEncryptor(FOO, this.sequentialBytes(2, 16));
        this.roundTripTest((MetadataEncryptor)encryptor, new ApiMessageAndVersion((ApiMessage)new UnregisterBrokerRecord().setBrokerId(123).setBrokerEpoch(4567L), 0));
    }

    private void roundTripTest(MetadataEncryptor encryptor, ApiMessageAndVersion messageAndVersion) {
        ApiMessageAndVersion envelope = encryptor.encrypt(messageAndVersion);
        Assertions.assertEquals(EncryptedEnvelopeRecord.class, (Object)envelope.message().getClass());
        ApiMessageAndVersion messageAndVersionAgain = encryptor.decrypt((EncryptedEnvelopeRecord)envelope.message());
        Assertions.assertEquals((Object)messageAndVersionAgain, (Object)messageAndVersion);
    }

    @Test
    public void testNoOpMessageEncryptorOnMessage() throws Exception {
        ApiMessageAndVersion messageAndVersion = new ApiMessageAndVersion((ApiMessage)new UnregisterBrokerRecord().setBrokerId(123).setBrokerEpoch(4567L), 0);
        Assertions.assertEquals((Object)messageAndVersion, (Object)NoOpMetadataEncryptor.INSTANCE.encrypt(messageAndVersion));
    }

    @Test
    public void testNoOpMessageEncryptorCannotEncrypt() throws Exception {
        Assertions.assertEquals((Object)"No metadata encryptor configured.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> NoOpMetadataEncryptor.INSTANCE.encrypt(new byte[0]))).getMessage());
    }

    @Test
    public void testNoOpMessageEncryptorCannotDecrypt() throws Exception {
        Assertions.assertEquals((Object)"No metadata encryptor configured.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> NoOpMetadataEncryptor.INSTANCE.decrypt(new byte[0]))).getMessage());
    }
}

