/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.InstallMetadataEncryptorRecord;
import org.apache.kafka.metadata.AesGcm128MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorConfigEntry;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MetadataEncryptorSecrets;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class MetadataEncryptorFactoryTest {
    public static final Uuid FOO_ID = Uuid.fromString((String)"ZUpeNz1eSKyT_qiVKswGfA");
    public static final Uuid BAR_ID = Uuid.fromString((String)"8PKWuzWBR3C7cFAZKzdmkg");
    public static final Uuid BAZ_ID = Uuid.fromString((String)"mZXxfuVgR4Ka70TYtTrYqw");
    public static final Uuid QUX_ID = Uuid.fromString((String)"oozG5ebNR9yf2xrWNI_1QA");
    public static final Map<String, Object> TEST_LEGACY_CONFIG = Collections.unmodifiableMap(MetadataEncryptorFactoryTest.generateLegacyConfig());
    public static final MetadataEncryptorFactory TEST_LEGACY_ENCRYPTOR_FACTORY = new MetadataEncryptorFactory(TEST_LEGACY_CONFIG);
    private static final String ENCRYPTOR_FILE_JSON_ONE_SECRET = "{\n  \"encryptors_by_uuid\": {\n    \"oozG5ebNR9yf2xrWNI_1QA\": {\n      \"created\": \"2023-10-15T17:26:49.335813Z\",\n      \"class_name\": \"org.apache.kafka.metadata.AesGcm128MetadataEncryptor\",\n      \"bytes\": \"KE9KWGMEwd6zGWyXdYksdA\"\n    }\n  }\n}";
    private static final String ENCRYPTOR_FILE_JSON_NO_SECRETS = "{\n  \"encryptors_by_uuid\": {\n  }\n}";
    private static final String ENCRYPTOR_FILE_JSON_MULTIPLE_SECRETS = "{\n  \"encryptors_by_uuid\": {\n    \"oozG5ebNR9yf2xrWNI_1QA\": {\n      \"created\": \"2023-10-15T17:26:49.335813Z\",\n      \"class_name\": \"org.apache.kafka.metadata.AesGcm128MetadataEncryptor\",\n      \"bytes\": \"KE9KWGMEwd6zGWyXdYksdA\"\n    },\n    \"0qSB-Af8QSul9VVVbkMDTg\": {\n      \"created\": \"2023-10-27T00:10:27.9163187\",\n      \"class_name\": \"org.apache.kafka.metadata.AesGcm128MetadataEncryptor\",\n      \"bytes\": \"UmH54bzhhvQm9tVv5SlZoA\"\n    },\n    \"SJdKDikKT_SsGCDi0MNPbg\": {\n      \"created\": \"2023-10-26T23:12:47.526994787Z\",\n      \"class_name\": \"org.apache.kafka.metadata.AesGcm128MetadataEncryptor\",\n      \"bytes\": \"9A_buSXHP5XOjTaeO8SNog\"\n    }\n  }\n}";
    private static final String ENCRYPTOR_FILE_JSON_SECRET_WITH_UNKNOWN_FIELD = "{\n  \"encryptors_by_uuid\": {\n    \"oozG5ebNR9yf2xrWNI_1QA\": {\n      \"created\": \"2023-10-15T17:26:49.335813Z\",\n      \"class_name\": \"org.apache.kafka.metadata.AesGcm128MetadataEncryptor\",\n      \"bytes\": \"KE9KWGMEwd6zGWyXdYksdA\",\n      \"extra_field\": \"extra_value\"\n    }\n  }\n}";

    private static HashMap<String, Object> generateLegacyConfig() {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put("confluent.metadata.active.encryptor", "ZUpeNz1eSKyT_qiVKswGfA");
        newMap.put("confluent.metadata.encryptor.classes", "ZUpeNz1eSKyT_qiVKswGfA=" + AesGcm128MetadataEncryptor.class.getCanonicalName() + ",8PKWuzWBR3C7cFAZKzdmkg=" + AesGcm128MetadataEncryptor.class.getCanonicalName());
        newMap.put("confluent.metadata.encryptor.secrets", "ZUpeNz1eSKyT_qiVKswGfA=cG9ubWxramloZ2ZlZGNiYQ,8PKWuzWBR3C7cFAZKzdmkg=YWJjZGVmZ2hpamtsbW5vcA");
        return newMap;
    }

    @Test
    public void testCreateFromEmptyConfig() {
        MetadataEncryptorFactory factory = new MetadataEncryptorFactory(Collections.emptyMap());
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)factory.activeIdFromLegacyConfig());
        MetadataEncryptor encryptor = factory.createFromConfig(Uuid.ZERO_UUID);
        Assertions.assertEquals(NoOpMetadataEncryptor.class, (Object)encryptor.getClass());
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)encryptor.id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadAndWriteJson() throws IOException {
        MetadataEncryptorConfigEntry entry = new MetadataEncryptorConfigEntry(new Date(), "org.apache.kafka.metadata.AesGcm128MetadataEncryptor", "KE9KWGMEwd6zGWyXdYksdA");
        HashMap<String, MetadataEncryptorConfigEntry> entriesMap = new HashMap<String, MetadataEncryptorConfigEntry>();
        entriesMap.put("oozG5ebNR9yf2xrWNI_1QA", entry);
        MetadataEncryptorSecrets secrets = new MetadataEncryptorSecrets(entriesMap);
        ObjectMapper objectMapper = MetadataEncryptorFactory.getNewObjectMapper();
        File tempJsonFile = null;
        try {
            tempJsonFile = TestUtils.tempFile((String)"secrets", (String)".json");
            objectMapper.writeValue(tempJsonFile, (Object)secrets);
            MetadataEncryptorSecrets newSecrets = (MetadataEncryptorSecrets)objectMapper.readValue(tempJsonFile, MetadataEncryptorSecrets.class);
            Assertions.assertEquals((Object)secrets, (Object)newSecrets);
        }
        finally {
            if (tempJsonFile != null) {
                tempJsonFile.delete();
            }
        }
    }

    @Test
    public void testCreateFromConfig() {
        MetadataEncryptorFactory factory = new MetadataEncryptorFactory(MetadataEncryptorFactoryTest.generateLegacyConfig());
        Assertions.assertEquals((Object)FOO_ID, (Object)factory.activeIdFromLegacyConfig());
        MetadataEncryptor encryptor = factory.createFromConfig(BAR_ID);
        Assertions.assertEquals(AesGcm128MetadataEncryptor.class, (Object)encryptor.getClass());
        Assertions.assertEquals((Object)BAR_ID, (Object)encryptor.id());
        Assertions.assertArrayEquals((byte[])new byte[]{97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112}, (byte[])encryptor.secret());
        Assertions.assertEquals(new HashSet<Uuid>(Arrays.asList(FOO_ID, BAR_ID)), (Object)factory.legacyEncryptorIds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateFromFile() throws IOException {
        File tempJsonFile = null;
        try {
            tempJsonFile = TestUtils.tempFile((String)ENCRYPTOR_FILE_JSON_ONE_SECRET);
            HashMap<String, String> newerMap = new HashMap<String, String>();
            newerMap.put("confluent.metadata.encryptor.secret.file", tempJsonFile.getAbsolutePath());
            MetadataEncryptorFactory factory = new MetadataEncryptorFactory(newerMap);
            InstallMetadataEncryptorRecord record = new InstallMetadataEncryptorRecord().setKeyId(QUX_ID);
            MetadataEncryptor encryptorFromRecord = factory.createFromConfig(record);
            Assertions.assertEquals(AesGcm128MetadataEncryptor.class, (Object)encryptorFromRecord.getClass());
            Assertions.assertEquals((Object)QUX_ID, (Object)encryptorFromRecord.id());
            Assertions.assertArrayEquals((byte[])new byte[]{40, 79, 74, 88, 99, 4, -63, -34, -77, 25, 108, -105, 117, -119, 44, 116}, (byte[])encryptorFromRecord.secret());
            Assertions.assertEquals(Collections.emptySet(), (Object)factory.legacyEncryptorIds());
        }
        finally {
            if (tempJsonFile != null) {
                tempJsonFile.delete();
            }
        }
    }

    @Test
    public void testCreateRandom() throws Exception {
        MetadataEncryptorFactory factory = new MetadataEncryptorFactory(Collections.emptyMap());
        String className = AesGcm128MetadataEncryptor.class.getCanonicalName();
        MetadataEncryptor first = factory.createRandom(className);
        TestUtils.retryOnExceptionWithTimeout((long)30000L, (long)0L, () -> {
            MetadataEncryptor second = factory.createRandom(className);
            Assertions.assertNotEquals((Object)first.id(), (Object)second.id());
            Assertions.assertNotEquals((Object)first.secret(), (Object)second.secret());
        });
    }

    @Test
    public void testCreateFromConfigFailsWithoutConfig() {
        MetadataEncryptorFactory factory = new MetadataEncryptorFactory(MetadataEncryptorFactoryTest.generateLegacyConfig());
        Assertions.assertEquals((Object)"No configuration found for metadata encryptor mZXxfuVgR4Ka70TYtTrYqw", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> factory.createFromConfig(BAZ_ID))).getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsAwareOfAtLeastOneEncryptor() throws IOException {
        MetadataEncryptorFactory factoryOne = new MetadataEncryptorFactory(MetadataEncryptorFactoryTest.generateLegacyConfig());
        Assertions.assertTrue((boolean)factoryOne.isAwareOfAtLeastOneEncryptor());
        File tempJsonFile = null;
        try {
            tempJsonFile = TestUtils.tempFile((String)ENCRYPTOR_FILE_JSON_ONE_SECRET);
            HashMap<String, String> newerMap = new HashMap<String, String>();
            newerMap.put("confluent.metadata.encryptor.secret.file", tempJsonFile.getAbsolutePath());
            MetadataEncryptorFactory factoryTwo = new MetadataEncryptorFactory(newerMap);
            Assertions.assertTrue((boolean)factoryTwo.isAwareOfAtLeastOneEncryptor());
            HashMap<String, Object> newestMap = MetadataEncryptorFactoryTest.generateLegacyConfig();
            newestMap.put("confluent.metadata.encryptor.secret.file", tempJsonFile.getAbsolutePath());
            MetadataEncryptorFactory factoryThree = new MetadataEncryptorFactory(newestMap);
            Assertions.assertTrue((boolean)factoryThree.isAwareOfAtLeastOneEncryptor());
            MetadataEncryptorFactory factoryFour = new MetadataEncryptorFactory(Collections.emptyMap());
            Assertions.assertFalse((boolean)factoryFour.isAwareOfAtLeastOneEncryptor());
        }
        finally {
            if (tempJsonFile != null) {
                tempJsonFile.delete();
            }
        }
        File tempJsonFileNoSecret = null;
        try {
            tempJsonFileNoSecret = TestUtils.tempFile((String)ENCRYPTOR_FILE_JSON_NO_SECRETS);
            HashMap<String, String> testMap = new HashMap<String, String>();
            testMap.put("confluent.metadata.encryptor.secret.file", tempJsonFileNoSecret.getAbsolutePath());
            MetadataEncryptorFactory factoryFive = new MetadataEncryptorFactory(testMap);
            Assertions.assertFalse((boolean)factoryFive.isAwareOfAtLeastOneEncryptor());
        }
        finally {
            if (tempJsonFileNoSecret != null) {
                tempJsonFileNoSecret.delete();
            }
        }
    }

    @Test
    public void testUnknownFieldsInJson() throws IOException {
        File tempJsonFile = null;
        try {
            tempJsonFile = TestUtils.tempFile((String)ENCRYPTOR_FILE_JSON_SECRET_WITH_UNKNOWN_FIELD);
            MetadataEncryptorSecrets metadataEncryptorSecrets = (MetadataEncryptorSecrets)MetadataEncryptorFactory.getNewObjectMapper().readValue(tempJsonFile, MetadataEncryptorSecrets.class);
        }
        finally {
            if (tempJsonFile != null) {
                tempJsonFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllKnownEncryptorIds() throws IOException {
        MetadataEncryptorFactory factoryLegacyOnly = new MetadataEncryptorFactory(MetadataEncryptorFactoryTest.generateLegacyConfig());
        Set<Uuid> expectedEncryptorIdsLegacy = Collections.unmodifiableSet(new HashSet<Uuid>(Arrays.asList(Uuid.fromString((String)"ZUpeNz1eSKyT_qiVKswGfA"), Uuid.fromString((String)"8PKWuzWBR3C7cFAZKzdmkg"))));
        Assertions.assertEquals(expectedEncryptorIdsLegacy, (Object)factoryLegacyOnly.getAllKnownEncryptorIds());
        File tempJsonFile = null;
        try {
            tempJsonFile = TestUtils.tempFile((String)ENCRYPTOR_FILE_JSON_MULTIPLE_SECRETS);
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            configMap.put("confluent.metadata.encryptor.secret.file", tempJsonFile.getAbsolutePath());
            MetadataEncryptorFactory factoryFile = new MetadataEncryptorFactory(configMap);
            Set<Uuid> expectedEncrytorIdsFile = Collections.unmodifiableSet(new HashSet<Uuid>(Arrays.asList(Uuid.fromString((String)"oozG5ebNR9yf2xrWNI_1QA"), Uuid.fromString((String)"0qSB-Af8QSul9VVVbkMDTg"), Uuid.fromString((String)"SJdKDikKT_SsGCDi0MNPbg"))));
            Assertions.assertEquals(expectedEncrytorIdsFile, (Object)factoryFile.getAllKnownEncryptorIds());
            configMap.putAll(MetadataEncryptorFactoryTest.generateLegacyConfig());
            MetadataEncryptorFactory factoryFilePlusLegacy = new MetadataEncryptorFactory(configMap);
            HashSet<Uuid> expectedEncrytorIdsFilePlusLegacy = new HashSet<Uuid>(expectedEncrytorIdsFile);
            expectedEncrytorIdsFilePlusLegacy.addAll(expectedEncryptorIdsLegacy);
            Assertions.assertEquals(expectedEncrytorIdsFilePlusLegacy, (Object)factoryFilePlusLegacy.getAllKnownEncryptorIds());
        }
        finally {
            if (tempJsonFile != null) {
                tempJsonFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCreateDateForEncryptor() throws IOException {
        File tempJsonFile = null;
        try {
            tempJsonFile = TestUtils.tempFile((String)ENCRYPTOR_FILE_JSON_MULTIPLE_SECRETS);
            HashMap<String, Object> configMap = MetadataEncryptorFactoryTest.generateLegacyConfig();
            configMap.put("confluent.metadata.encryptor.secret.file", tempJsonFile.getAbsolutePath());
            MetadataEncryptorFactory factory = new MetadataEncryptorFactory(configMap);
            Assertions.assertEquals((Object)MetadataEncryptorFactory.UNIX_EPOCH, (Object)factory.getCreateDateForEncryptor(Uuid.fromString((String)"ZUpeNz1eSKyT_qiVKswGfA")));
            Assertions.assertEquals((Object)MetadataEncryptorFactory.UNIX_EPOCH, (Object)factory.getCreateDateForEncryptor(Uuid.fromString((String)"8PKWuzWBR3C7cFAZKzdmkg")));
            Assertions.assertEquals((Object)OffsetDateTime.parse("2023-10-15T17:26:49.335Z", DateTimeFormatter.ISO_OFFSET_DATE_TIME), (Object)factory.getCreateDateForEncryptor(Uuid.fromString((String)"oozG5ebNR9yf2xrWNI_1QA")));
            Assertions.assertEquals((Object)OffsetDateTime.parse("2023-10-26T23:12:47.526Z", DateTimeFormatter.ISO_OFFSET_DATE_TIME), (Object)factory.getCreateDateForEncryptor(Uuid.fromString((String)"SJdKDikKT_SsGCDi0MNPbg")));
            Assertions.assertEquals((Object)OffsetDateTime.parse("2023-10-27T00:10:27.916Z", DateTimeFormatter.ISO_OFFSET_DATE_TIME), (Object)factory.getCreateDateForEncryptor(Uuid.fromString((String)"0qSB-Af8QSul9VVVbkMDTg")));
            Assertions.assertNull((Object)factory.getCreateDateForEncryptor(Uuid.ZERO_UUID));
        }
        finally {
            if (tempJsonFile != null) {
                tempJsonFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNewerKnownEncryptorIds() throws IOException {
        File tempJsonFile = null;
        try {
            tempJsonFile = TestUtils.tempFile((String)ENCRYPTOR_FILE_JSON_MULTIPLE_SECRETS);
            HashMap<String, Object> configMap = MetadataEncryptorFactoryTest.generateLegacyConfig();
            configMap.put("confluent.metadata.encryptor.secret.file", tempJsonFile.getAbsolutePath());
            MetadataEncryptorFactory factory = new MetadataEncryptorFactory(configMap);
            Set<Uuid> all3EncryptorIdsFromFile = Collections.unmodifiableSet(new HashSet<Uuid>(Arrays.asList(Uuid.fromString((String)"oozG5ebNR9yf2xrWNI_1QA"), Uuid.fromString((String)"0qSB-Af8QSul9VVVbkMDTg"), Uuid.fromString((String)"SJdKDikKT_SsGCDi0MNPbg"))));
            Set<Uuid> newest2EncryptorIds = Collections.unmodifiableSet(new HashSet<Uuid>(Arrays.asList(Uuid.fromString((String)"SJdKDikKT_SsGCDi0MNPbg"), Uuid.fromString((String)"0qSB-Af8QSul9VVVbkMDTg"))));
            Set<Uuid> newestEncryptorId = Collections.singleton(Uuid.fromString((String)"0qSB-Af8QSul9VVVbkMDTg"));
            Uuid encryptorIdFromLegacyConfig = Uuid.fromString((String)"ZUpeNz1eSKyT_qiVKswGfA");
            Assertions.assertEquals(all3EncryptorIdsFromFile, (Object)factory.getNewerKnownEncryptorIds(all3EncryptorIdsFromFile, encryptorIdFromLegacyConfig));
            Assertions.assertEquals(newest2EncryptorIds, (Object)factory.getNewerKnownEncryptorIds(all3EncryptorIdsFromFile, Uuid.fromString((String)"oozG5ebNR9yf2xrWNI_1QA")));
            Assertions.assertEquals(newestEncryptorId, (Object)factory.getNewerKnownEncryptorIds(all3EncryptorIdsFromFile, Uuid.fromString((String)"SJdKDikKT_SsGCDi0MNPbg")));
            Assertions.assertEquals(Collections.emptySet(), (Object)factory.getNewerKnownEncryptorIds(all3EncryptorIdsFromFile, Uuid.fromString((String)"0qSB-Af8QSul9VVVbkMDTg")));
            Assertions.assertEquals(newestEncryptorId, (Object)factory.getNewerKnownEncryptorIds(newestEncryptorId, Uuid.ZERO_UUID));
            Assertions.assertEquals(newest2EncryptorIds, (Object)factory.getNewerKnownEncryptorIds(newest2EncryptorIds, Uuid.ZERO_UUID));
            Assertions.assertEquals(all3EncryptorIdsFromFile, (Object)factory.getNewerKnownEncryptorIds(all3EncryptorIdsFromFile, Uuid.ZERO_UUID));
        }
        finally {
            if (tempJsonFile != null) {
                tempJsonFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getCreateTimeMillisSinceEpoch() throws IOException {
        File tempJsonFile = null;
        try {
            tempJsonFile = TestUtils.tempFile((String)ENCRYPTOR_FILE_JSON_ONE_SECRET);
            HashMap<String, Object> map = new HashMap<String, Object>(MetadataEncryptorFactoryTest.generateLegacyConfig());
            map.put("confluent.metadata.encryptor.secret.file", tempJsonFile.getAbsolutePath());
            MetadataEncryptorFactory staticAndFileBasedEncryptorFactory = new MetadataEncryptorFactory(map);
            Assertions.assertEquals((long)0L, (long)staticAndFileBasedEncryptorFactory.getCreateTimeMillisSinceEpoch(staticAndFileBasedEncryptorFactory.activeIdFromLegacyConfig()));
            Assertions.assertEquals((long)1697390809335L, (long)staticAndFileBasedEncryptorFactory.getCreateTimeMillisSinceEpoch(QUX_ID));
        }
        finally {
            if (tempJsonFile != null) {
                tempJsonFile.delete();
            }
        }
    }
}

