/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class LeaderAndIsrTest {
    @Test
    public void testRecoveringLeaderAndIsr() {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, Arrays.asList(1, 2));
        LeaderAndIsr recoveringLeaderAndIsr = leaderAndIsr.newRecoveringLeaderAndIsr(3, Collections.singletonList(3));
        Assertions.assertEquals((int)3, (int)recoveringLeaderAndIsr.leader());
        Assertions.assertEquals(Collections.singletonList(3), (Object)recoveringLeaderAndIsr.isr());
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERING, (Object)recoveringLeaderAndIsr.leaderRecoveryState());
    }

    @Test
    public void testNewLeaderAndIsr() {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, Arrays.asList(1, 2));
        LeaderAndIsr newLeaderAndIsr = leaderAndIsr.newLeaderAndIsr(2, Arrays.asList(1, 2));
        Assertions.assertEquals((int)2, (int)newLeaderAndIsr.leader());
        Assertions.assertEquals(Arrays.asList(1, 2), (Object)newLeaderAndIsr.isr());
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERED, (Object)newLeaderAndIsr.leaderRecoveryState());
    }

    @Test
    public void testNewLeader() {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(2, Arrays.asList(1, 2, 3));
        Assertions.assertEquals((int)2, (int)leaderAndIsr.leader());
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)leaderAndIsr.isr());
        LeaderAndIsr newLeaderAndIsr = leaderAndIsr.newLeader(3);
        Assertions.assertEquals((int)3, (int)newLeaderAndIsr.leader());
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)newLeaderAndIsr.isr());
    }

    @Test
    public void testNewEpoch() {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(3, Arrays.asList(1, 2, 3));
        Assertions.assertEquals((int)0, (int)leaderAndIsr.leaderEpoch());
        LeaderAndIsr leaderWithNewEpoch = leaderAndIsr.newEpoch();
        Assertions.assertEquals((int)1, (int)leaderWithNewEpoch.leaderEpoch());
    }

    @Test
    public void testLeaderOpt() {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(2, Arrays.asList(1, 2, 3));
        Assertions.assertEquals((int)2, (Integer)leaderAndIsr.leaderOpt().orElse(0));
    }
}

