/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class DegradedBrokerHealthStateTest {
    private static final String REASON1 = "rcca-123";
    private static final BrokerComponent COMPONENT1 = BrokerComponent.UNSPECIFIED;
    private static final String REASON2 = "rcca-234";
    private static final BrokerComponent COMPONENT2 = BrokerComponent.STORAGE;
    private static final RegisterBrokerRecord.DegradedComponent REGISTRATION_RECORD_DEGRADED_COMPONENT1 = new RegisterBrokerRecord.DegradedComponent().setReason("rcca-123").setComponentCode(COMPONENT1.id());
    private static final List<RegisterBrokerRecord.DegradedComponent> REGISTRATION_RECORD_DEGRADED_COMPONENTS = Arrays.asList(REGISTRATION_RECORD_DEGRADED_COMPONENT1, new RegisterBrokerRecord.DegradedComponent().setReason("rcca-234").setComponentCode(COMPONENT2.id()));
    private static final DegradedBrokerHealthState DEGRADED_BROKER_HEALTH_STATE1 = new DegradedBrokerHealthState("rcca-123", COMPONENT1);
    private static final Set<DegradedBrokerHealthState> DEGRADED_BROKER_HEALTH_STATES = new HashSet<DegradedBrokerHealthState>(Arrays.asList(DEGRADED_BROKER_HEALTH_STATE1, new DegradedBrokerHealthState("rcca-234", COMPONENT2)));
    private static final BrokerRegistrationChangeRecord.DegradedComponent CHANGE_RECORD_DEGRADED_COMPONENT1 = new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-123").setComponentCode(COMPONENT1.id());
    private static final List<BrokerRegistrationChangeRecord.DegradedComponent> CHANGE_RECORD_DEGRADED_COMPONENTS = Arrays.asList(CHANGE_RECORD_DEGRADED_COMPONENT1, new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-234").setComponentCode(COMPONENT2.id()));

    @Test
    public void testToRegisterBrokerRecordDegradedComponent() {
        List degradedComponents = DegradedBrokerHealthState.toRegisterBrokerRecordDegradedComponent(DEGRADED_BROKER_HEALTH_STATES);
        Assertions.assertEquals((int)REGISTRATION_RECORD_DEGRADED_COMPONENTS.size(), (int)degradedComponents.size());
        Assertions.assertTrue((boolean)REGISTRATION_RECORD_DEGRADED_COMPONENTS.containsAll(degradedComponents));
    }

    @Test
    public void testFromRegisterBrokerRecord() {
        Set degradedBrokerHealthStates = DegradedBrokerHealthState.fromRegisterBrokerRecord(REGISTRATION_RECORD_DEGRADED_COMPONENTS);
        Assertions.assertEquals((int)DEGRADED_BROKER_HEALTH_STATES.size(), (int)degradedBrokerHealthStates.size());
        Assertions.assertTrue((boolean)DEGRADED_BROKER_HEALTH_STATES.containsAll(degradedBrokerHealthStates));
    }

    @Test
    public void testFromBrokerRegistrationChangeRecord() {
        Set degradedBrokerHealthStates = DegradedBrokerHealthState.fromBrokerRegistrationChangeRecord(CHANGE_RECORD_DEGRADED_COMPONENTS);
        Assertions.assertEquals((int)DEGRADED_BROKER_HEALTH_STATES.size(), (int)degradedBrokerHealthStates.size());
        Assertions.assertTrue((boolean)DEGRADED_BROKER_HEALTH_STATES.containsAll(degradedBrokerHealthStates));
    }

    @Test
    public void testFromRegisterBrokerRecordDegradedComponent() {
        DegradedBrokerHealthState degradedBrokerHealthState = DegradedBrokerHealthState.fromDegradedComponent((RegisterBrokerRecord.DegradedComponent)REGISTRATION_RECORD_DEGRADED_COMPONENT1);
        Assertions.assertEquals((Object)DEGRADED_BROKER_HEALTH_STATE1, (Object)degradedBrokerHealthState);
    }

    @Test
    public void testFromBrokerRegistrationChangeRecordDegradedComponent() {
        DegradedBrokerHealthState degradedBrokerHealthState = DegradedBrokerHealthState.fromDegradedComponent((BrokerRegistrationChangeRecord.DegradedComponent)CHANGE_RECORD_DEGRADED_COMPONENT1);
        Assertions.assertEquals((Object)DEGRADED_BROKER_HEALTH_STATE1, (Object)degradedBrokerHealthState);
    }
}

