/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.ClusterLinkSwitchoverMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

public class ClusterLinkTest {
    @ParameterizedTest
    @NullSource
    @ValueSource(strings={"tenantPrefix"})
    public void testHandlesTenantPrefix(String tenantPrefix) {
        String linkName = "linkName";
        Uuid linkId = Uuid.fromString((String)"UOiKbNCCQjeSl_oI5kA6rQ");
        String sourceClusterId = "sourceClusterId";
        String linkMode = "DESTINATION";
        ClusterLink clusterLink = new ClusterLink(linkName, linkId, tenantPrefix, sourceClusterId, linkMode);
        Assertions.assertEquals((Object)clusterLink, (Object)clusterLink);
        ClusterLinkRecord clusterLinkRecord = new ClusterLinkRecord();
        clusterLinkRecord.setClusterLinkId(linkId).setClusterLinkName(linkName).setLinkMode(linkMode).setRemoteClusterId(sourceClusterId).setTenantPrefix(tenantPrefix);
        Assertions.assertEquals((Object)clusterLinkRecord, (Object)clusterLink.toRecord());
        String expectedToStr = tenantPrefix != null ? "ClusterLinkImage(linkName=linkName, linkId=UOiKbNCCQjeSl_oI5kA6rQ, tenantPrefix=tenantPrefix, remoteClusterId=sourceClusterId, linkMode=DESTINATION, switchoverMetadata=Optional.empty)" : "ClusterLinkImage(linkName=linkName, linkId=UOiKbNCCQjeSl_oI5kA6rQ, remoteClusterId=sourceClusterId, linkMode=DESTINATION, switchoverMetadata=Optional.empty)";
        Assertions.assertEquals((Object)expectedToStr, (Object)clusterLink.toString());
    }

    @Test
    public void testSwitchoverMetadata() {
        String linkName = "linkName";
        Uuid linkId = Uuid.fromString((String)"UOiKbNCCQjeSl_oI5kA6rQ");
        String sourceClusterId = "sourceClusterId";
        String linkMode = "DESTINATION";
        String tenantPrefix = "tenantPrefix";
        ClusterLinkSwitchoverMetadata clusterLinkSwitchoverMetadata = new ClusterLinkSwitchoverMetadata(ClusterLinkSwitchoverMetadata.SwitchoverType.REVERSE, 1L, ClusterLinkSwitchoverMetadata.SwitchoverState.PRIMARY, 0, "");
        ClusterLink clusterLink = new ClusterLink(linkName, linkId, tenantPrefix, sourceClusterId, linkMode, clusterLinkSwitchoverMetadata);
        ClusterLinkRecord clusterLinkRecord = new ClusterLinkRecord();
        clusterLinkRecord.setClusterLinkId(linkId).setClusterLinkName(linkName).setLinkMode(linkMode).setRemoteClusterId(sourceClusterId).setTenantPrefix(tenantPrefix).setSwitchoverMetadata(new ClusterLinkRecord.ClusterLinkSwitchoverMetadataRecord().setSwitchoverType((byte)1).setSwitchoverState((byte)0).setSwitchoverTimestamp(1L).setErrorCode((short)0).setErrorMessage(""));
        Assertions.assertEquals((Object)clusterLinkRecord, (Object)clusterLink.toRecord());
        String expectedToStr = "ClusterLinkImage(linkName=linkName, linkId=UOiKbNCCQjeSl_oI5kA6rQ, tenantPrefix=tenantPrefix, remoteClusterId=sourceClusterId, linkMode=DESTINATION, switchoverMetadata=Optional[ClusterLinkSwitchoverMetadata(switchoverType=REVERSE, switchoverTimestamp=1, switchoverState=PRIMARY, errorCode=0, errorMessage=)])";
        Assertions.assertEquals((Object)expectedToStr, (Object)clusterLink.toString());
    }
}

