/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.writer;

import java.util.function.Consumer;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImageTest;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImageTest;
import org.apache.kafka.image.ConfluentKeyValueStreamsImage;
import org.apache.kafka.image.DelegationTokenImageTest;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicsImageTest;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.UnwritableMetadataException;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.server.common.EligibleLeaderReplicasVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class ImageWriterOptionsTest {
    @Test
    public void testDefaultLossHandler() {
        ImageWriterOptions options = new ImageWriterOptions.Builder(MetadataVersion.latestProduction()).build();
        Assertions.assertEquals((Object)"stuff", (Object)((UnwritableMetadataException)Assertions.assertThrows(UnwritableMetadataException.class, () -> options.handleLoss("stuff"))).loss());
    }

    @Test
    public void testHandleLoss() {
        String expectedMessage = "stuff";
        for (int i = MetadataVersion.MINIMUM_VERSION.ordinal(); i < MetadataVersion.VERSIONS.length; ++i) {
            MetadataVersion version = MetadataVersion.VERSIONS[i];
            String formattedMessage = String.format("Metadata has been lost because the following could not be represented in metadata.version %s: %s", version, expectedMessage);
            Consumer<UnwritableMetadataException> customLossHandler = e -> Assertions.assertEquals((Object)formattedMessage, (Object)e.getMessage());
            ImageWriterOptions options = new ImageWriterOptions.Builder(version).setLossHandler(customLossHandler).build();
            options.handleLoss(expectedMessage);
        }
    }

    @Test
    public void testSetEligibleLeaderReplicasEnabled() {
        MetadataVersion version = MetadataVersion.MINIMUM_VERSION;
        ImageWriterOptions options = new ImageWriterOptions.Builder(version).setEligibleLeaderReplicasEnabled(true).build();
        Assertions.assertEquals((Object)true, (Object)options.isEligibleLeaderReplicasEnabled());
        options = new ImageWriterOptions.Builder(version).build();
        Assertions.assertEquals((Object)false, (Object)options.isEligibleLeaderReplicasEnabled());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testConstructionWithImage(boolean isElrEnabled) {
        FeaturesDelta featuresDelta = new FeaturesDelta(FeaturesImage.EMPTY);
        featuresDelta.replay(new FeatureLevelRecord().setName("eligible.leader.replicas.version").setFeatureLevel(isElrEnabled ? EligibleLeaderReplicasVersion.ELRV_1.featureLevel() : EligibleLeaderReplicasVersion.ELRV_0.featureLevel()));
        featuresDelta.replay(new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(MetadataVersion.IBP_4_0_IV1A.confluentFeatureLevel()));
        MetadataImage metadataImage = new MetadataImage(new MetadataProvenance(100L, 4, 2000L, true), featuresDelta.apply(), ClusterImageTest.IMAGE1, TopicsImageTest.IMAGE1, ConfigurationsImageTest.IMAGE1, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, DelegationTokenImageTest.IMAGE1, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE, ConfluentKeyValueStreamsImage.EMPTY);
        ImageWriterOptions options = new ImageWriterOptions.Builder(metadataImage).build();
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV1A, (Object)options.metadataVersion());
        if (isElrEnabled) {
            Assertions.assertEquals((Object)true, (Object)options.isEligibleLeaderReplicasEnabled());
        } else {
            Assertions.assertEquals((Object)false, (Object)options.isEligibleLeaderReplicasEnabled());
        }
    }
}

