/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.node.MetadataLeafNode;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.TopicImageNode;
import org.apache.kafka.image.node.printer.MetadataNodePrinter;
import org.apache.kafka.image.node.printer.NodeStringifier;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class TopicImageNodeTest {
    private static final TopicImageNode NODE = new TopicImageNode(TopicImageNodeTest.newTopicImage("topic-image-node-test-topic", Uuid.ZERO_UUID, new PartitionRegistration.Builder().setReplicas(new int[]{2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{2, 3}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).build()));

    private static TopicImage newTopicImage(String name, Uuid id, PartitionRegistration ... partitions) {
        HashMap<Integer, PartitionRegistration> partitionMap = new HashMap<Integer, PartitionRegistration>();
        int i = 0;
        for (PartitionRegistration partition : partitions) {
            partitionMap.put(i++, partition);
        }
        return new TopicImage(name, id, partitionMap, null);
    }

    @Test
    public void testChildNames() {
        Assertions.assertEquals(Arrays.asList("name", "id", "0"), (Object)NODE.childNames());
    }

    @Test
    public void testNameChild() {
        MetadataNode child = NODE.child("name");
        Assertions.assertNotNull((Object)child);
        Assertions.assertEquals(MetadataLeafNode.class, (Object)child.getClass());
    }

    @Test
    public void testIdChild() {
        MetadataNode child = NODE.child("id");
        Assertions.assertNotNull((Object)child);
        Assertions.assertEquals(MetadataLeafNode.class, (Object)child.getClass());
    }

    @Test
    public void testUnknownChild() {
        Assertions.assertNull((Object)NODE.child("unknown"));
    }

    @Test
    public void testChildPartitionId() {
        MetadataNode child = NODE.child("0");
        Assertions.assertNotNull((Object)child);
        NodeStringifier stringifier = new NodeStringifier();
        child.print((MetadataNodePrinter)stringifier);
        Assertions.assertEquals((Object)"PartitionRegistration(replicas=[2, 3, 4], observers=[], directories=[AAAAAAAAAAAAAAAAAAAAAA, AAAAAAAAAAAAAAAAAAAAAA, AAAAAAAAAAAAAAAAAAAAAA], isr=[2, 3], removingReplicas=[], addingReplicas=[], removingObservers=[], addingObservers=[], elr=[], lastKnownElr=[], leader=2, leaderRecoveryState=RECOVERED, leaderEpoch=1, partitionEpoch=345, linkedLeaderEpoch=-1, linkState=NOT_MIRROR)", (Object)stringifier.toString());
    }

    @Test
    public void testChildPartitionIdNull() {
        MetadataNode child1 = NODE.child("1");
        MetadataNode child2 = NODE.child("a");
        Assertions.assertNull((Object)child1);
        Assertions.assertNull((Object)child2);
    }
}

