/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.loader;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.AbortTransactionRecord;
import org.apache.kafka.common.metadata.BeginTransactionRecord;
import org.apache.kafka.common.metadata.EndTransactionRecord;
import org.apache.kafka.common.metadata.NoOpRecord;
import org.apache.kafka.common.metadata.NoTraceContextRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.TraceContextRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.image.loader.MetadataBatchLoader;
import org.apache.kafka.metadata.MetadataEncryptorFactoryTest;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class MetadataBatchLoaderTest {
    static final Uuid TOPIC_FOO = Uuid.fromString((String)"c6uHMgPkRp2Urjlh-RxMNQ");
    static final Uuid TOPIC_BAR = Uuid.fromString((String)"tUWOOPvzQhmZZ_eXmTCcig");
    static final List<ApiMessageAndVersion> TOPIC_TXN_BATCH_1;
    static final List<ApiMessageAndVersion> TOPIC_TXN_BATCH_2;
    static final List<ApiMessageAndVersion> TOPIC_NO_TXN_BATCH;
    static final List<ApiMessageAndVersion> TXN_BEGIN_SINGLETON;
    static final List<ApiMessageAndVersion> TXN_END_SINGLETON;
    static final List<ApiMessageAndVersion> TXN_ABORT_SINGLETON;
    static final List<ApiMessageAndVersion> TRACING_RECORD_BATCH_START;
    static final List<ApiMessageAndVersion> TRACING_RECORD_BATCH_END;
    static final List<ApiMessageAndVersion> TRACING_RECORD_BATCH_START_END;
    static final LeaderAndEpoch LEADER_AND_EPOCH;
    static final Batch<ApiMessageAndVersion> START_TRACE_BATCH;
    static final Batch<ApiMessageAndVersion> END_TRACE_BATCH;
    static final Batch<ApiMessageAndVersion> START_AND_END_TRACE_BATCH;
    static final List<ApiMessageAndVersion> START_TRACE_SINGLETON;
    static final List<ApiMessageAndVersion> END_TRACE_SINGLETON;
    static final Batch<ApiMessageAndVersion> START_TX_BATCH;
    static final Batch<ApiMessageAndVersion> END_TX_BATCH;
    static final Batch<ApiMessageAndVersion> NO_TX_BATCH;
    static byte[] validTraceId;
    static byte[] validSpanId;
    static byte traceFlagByte;

    static List<ApiMessageAndVersion> noOpRecords(int n) {
        return IntStream.range(0, n).mapToObj(__ -> new ApiMessageAndVersion((ApiMessage)new NoOpRecord(), 0)).collect(Collectors.toList());
    }

    static MetadataBatchLoader newMetadataBatchLoader(String testName, MetadataBatchLoader.MetadataUpdater updater) {
        return MetadataBatchLoaderTest.newMetadataBatchLoader((FaultHandler)new MockFaultHandler(testName), updater);
    }

    static MetadataBatchLoader newMetadataBatchLoader(FaultHandler faultHandler, MetadataBatchLoader.MetadataUpdater updater) {
        return new MetadataBatchLoader(new LogContext(), (Time)new MockTime(), faultHandler, updater, MetadataEncryptorFactoryTest.TEST_LEGACY_ENCRYPTOR_FACTORY, Function.identity());
    }

    @Test
    public void testAlignedTransactionBatches() {
        Batch batch1 = Batch.data((long)10L, (int)1, (long)0L, (int)10, TOPIC_TXN_BATCH_1);
        Batch batch2 = Batch.data((long)13L, (int)2, (long)0L, (int)10, MetadataBatchLoaderTest.noOpRecords(3));
        Batch batch3 = Batch.data((long)16L, (int)2, (long)0L, (int)30, TOPIC_TXN_BATCH_2);
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader("testAlignedTransactionBatches", (MetadataBatchLoader.MetadataUpdater)updater);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch1, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        batchLoader.loadBatch(batch2, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        batchLoader.loadBatch(batch3, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("foo"));
        Assertions.assertEquals((long)18L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertEquals((int)2, (int)updater.latestImage.provenance().lastContainedEpoch());
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
    }

    @Test
    public void testSingletonBeginAndEnd() {
        Batch batch1 = Batch.data((long)13L, (int)1, (long)0L, (int)30, MetadataBatchLoaderTest.noOpRecords(3));
        Batch batch2 = Batch.data((long)16L, (int)2, (long)0L, (int)30, TXN_BEGIN_SINGLETON);
        Batch batch3 = Batch.data((long)17L, (int)3, (long)0L, (int)10, TOPIC_NO_TXN_BATCH);
        Batch batch4 = Batch.data((long)20L, (int)4, (long)0L, (int)10, TXN_END_SINGLETON);
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader("testSingletonBeginAndEnd", (MetadataBatchLoader.MetadataUpdater)updater);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch1, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        batchLoader.loadBatch(batch2, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        Assertions.assertNull((Object)updater.latestImage.topics().getTopic("bar"));
        batchLoader.loadBatch(batch3, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        batchLoader.loadBatch(batch4, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("bar"));
        Assertions.assertEquals((long)20L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertEquals((int)4, (int)updater.latestImage.provenance().lastContainedEpoch());
        updater.reset();
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch1, LEADER_AND_EPOCH);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)1, (int)updater.updates);
        batchLoader.loadBatch(batch2, LEADER_AND_EPOCH);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)1, (int)updater.updates);
        batchLoader.loadBatch(batch3, LEADER_AND_EPOCH);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)1, (int)updater.updates);
        batchLoader.loadBatch(batch4, LEADER_AND_EPOCH);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)2, (int)updater.updates);
    }

    @Test
    public void testUnexpectedBeginTransaction() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testUnexpectedBeginTransaction");
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader((FaultHandler)faultHandler, (MetadataBatchLoader.MetadataUpdater)updater);
        Batch batch1 = Batch.data((long)10L, (int)2, (long)0L, (int)30, TOPIC_TXN_BATCH_1);
        Batch batch2 = Batch.data((long)13L, (int)2, (long)0L, (int)30, TXN_BEGIN_SINGLETON);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch1, LEADER_AND_EPOCH);
        Assertions.assertNull((Object)faultHandler.firstException());
        batchLoader.loadBatch(batch2, LEADER_AND_EPOCH);
        Assertions.assertEquals(RuntimeException.class, faultHandler.firstException().getCause().getClass());
        Assertions.assertEquals((Object)"Encountered BeginTransactionRecord while already in a transaction", (Object)faultHandler.firstException().getCause().getMessage());
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)0, (int)updater.updates);
    }

    @Test
    public void testUnexpectedEndTransaction() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testUnexpectedAbortTransaction");
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader((FaultHandler)faultHandler, (MetadataBatchLoader.MetadataUpdater)updater);
        Batch batch1 = Batch.data((long)10L, (int)2, (long)0L, (int)30, TOPIC_NO_TXN_BATCH);
        Batch batch2 = Batch.data((long)13L, (int)2, (long)0L, (int)30, TXN_END_SINGLETON);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch1, LEADER_AND_EPOCH);
        Assertions.assertNull((Object)faultHandler.firstException());
        batchLoader.loadBatch(batch2, LEADER_AND_EPOCH);
        Assertions.assertEquals(RuntimeException.class, faultHandler.firstException().getCause().getClass());
        Assertions.assertEquals((Object)"Encountered EndTransactionRecord without having seen a BeginTransactionRecord", (Object)faultHandler.firstException().getCause().getMessage());
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("bar"));
    }

    @Test
    public void testUnexpectedAbortTransaction() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testUnexpectedAbortTransaction");
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader((FaultHandler)faultHandler, (MetadataBatchLoader.MetadataUpdater)updater);
        Batch batch1 = Batch.data((long)10L, (int)2, (long)0L, (int)30, TOPIC_NO_TXN_BATCH);
        Batch batch2 = Batch.data((long)13L, (int)2, (long)0L, (int)30, TXN_ABORT_SINGLETON);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch1, LEADER_AND_EPOCH);
        Assertions.assertNull((Object)faultHandler.firstException());
        batchLoader.loadBatch(batch2, LEADER_AND_EPOCH);
        Assertions.assertEquals(RuntimeException.class, faultHandler.firstException().getCause().getClass());
        Assertions.assertEquals((Object)"Encountered AbortTransactionRecord without having seen a BeginTransactionRecord", (Object)faultHandler.firstException().getCause().getMessage());
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("bar"));
    }

    private MetadataBatchLoader loadSingleBatch(MockMetadataUpdater updater, MockFaultHandler faultHandler, List<ApiMessageAndVersion> batchRecords) {
        Batch batch = Batch.data((long)10L, (int)42, (long)0L, (int)100, batchRecords);
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader((FaultHandler)faultHandler, (MetadataBatchLoader.MetadataUpdater)updater);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch, LEADER_AND_EPOCH);
        return batchLoader;
    }

    @Test
    public void testMultipleTransactionsInOneBatch() {
        ArrayList<ApiMessageAndVersion> batchRecords = new ArrayList<ApiMessageAndVersion>();
        batchRecords.addAll(TOPIC_TXN_BATCH_1);
        batchRecords.addAll(TOPIC_TXN_BATCH_2);
        batchRecords.addAll(TXN_BEGIN_SINGLETON);
        batchRecords.addAll(TOPIC_NO_TXN_BATCH);
        batchRecords.addAll(TXN_END_SINGLETON);
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testMultipleTransactionsInOneBatch");
        MetadataBatchLoader batchLoader = this.loadSingleBatch(updater, faultHandler, batchRecords);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertEquals((long)0L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((long)15L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        Assertions.assertEquals((int)42, (int)updater.latestImage.provenance().lastContainedEpoch());
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("foo"));
        Assertions.assertNull((Object)updater.latestImage.topics().getTopic("bar"));
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)2, (int)updater.updates);
        Assertions.assertEquals((long)100L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((long)20L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertEquals((int)42, (int)updater.latestImage.provenance().lastContainedEpoch());
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("foo"));
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("bar"));
    }

    @Test
    public void testMultipleTransactionsInOneBatchesWithNoOp() {
        ArrayList<ApiMessageAndVersion> batchRecords = new ArrayList<ApiMessageAndVersion>();
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(1));
        batchRecords.addAll(TOPIC_TXN_BATCH_1);
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(1));
        batchRecords.addAll(TOPIC_TXN_BATCH_2);
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(1));
        batchRecords.addAll(TXN_BEGIN_SINGLETON);
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(1));
        batchRecords.addAll(TOPIC_NO_TXN_BATCH);
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(1));
        batchRecords.addAll(TXN_END_SINGLETON);
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(1));
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testMultipleTransactionsInOneBatches");
        MetadataBatchLoader batchLoader = this.loadSingleBatch(updater, faultHandler, batchRecords);
        Assertions.assertEquals((int)2, (int)updater.updates);
        Assertions.assertEquals((long)0L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((long)18L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertEquals((int)42, (int)updater.latestImage.provenance().lastContainedEpoch());
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("foo"));
        Assertions.assertNull((Object)updater.latestImage.topics().getTopic("bar"));
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)3, (int)updater.updates);
        Assertions.assertEquals((long)100L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((long)26L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertEquals((int)42, (int)updater.latestImage.provenance().lastContainedEpoch());
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("foo"));
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("bar"));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOneTransactionInMultipleBatches(boolean abortTxn) {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader("testOneTransactionInMultipleBatches", (MetadataBatchLoader.MetadataUpdater)updater);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(Batch.data((long)16L, (int)2, (long)0L, (int)10, TXN_BEGIN_SINGLETON), LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        batchLoader.loadBatch(Batch.data((long)17L, (int)3, (long)0L, (int)30, TOPIC_NO_TXN_BATCH), LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        if (abortTxn) {
            batchLoader.loadBatch(Batch.data((long)20L, (int)4, (long)0L, (int)10, TXN_ABORT_SINGLETON), LEADER_AND_EPOCH);
        } else {
            batchLoader.loadBatch(Batch.data((long)20L, (int)4, (long)0L, (int)10, TXN_END_SINGLETON), LEADER_AND_EPOCH);
        }
        Assertions.assertEquals((int)0, (int)updater.updates);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((long)50L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((int)3, (int)updater.latestManifest.numBatches());
        Assertions.assertEquals((long)20L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertEquals((int)4, (int)updater.latestImage.provenance().lastContainedEpoch());
        if (abortTxn) {
            Assertions.assertNull((Object)updater.latestImage.topics().getTopic("bar"));
        } else {
            Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("bar"));
        }
    }

    @Test
    public void testTransactionAlignmentOnBatchBoundary() {
        ArrayList<ApiMessageAndVersion> batchRecords = new ArrayList<ApiMessageAndVersion>();
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(3));
        batchRecords.addAll(TOPIC_TXN_BATCH_1);
        batchRecords.addAll(TOPIC_TXN_BATCH_2);
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(3));
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testMultipleTransactionsInOneBatch");
        MetadataBatchLoader batchLoader = this.loadSingleBatch(updater, faultHandler, batchRecords);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertEquals((long)0L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((long)12L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        batchLoader.loadBatch(Batch.data((long)22L, (int)42, (long)0L, (int)10, TXN_BEGIN_SINGLETON), LEADER_AND_EPOCH);
        Assertions.assertEquals((int)2, (int)updater.updates);
        Assertions.assertEquals((long)100L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((long)21L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
    }

    @Test
    public void testFlushTracingRecords() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader("testFlushingTracingRecords", (MetadataBatchLoader.MetadataUpdater)updater);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(END_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        Assertions.assertNull((Object)batchLoader.getTraceContext());
        updater.reset();
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(START_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
    }

    @Test
    public void testStartAndEndTraceInSameBatchNotAligned() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader("testStartAndEndTraceInSameBatch", (MetadataBatchLoader.MetadataUpdater)updater);
        updater.reset();
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(START_AND_END_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)2, (int)updater.updates);
        Assertions.assertNull((Object)batchLoader.getTraceContext());
        Assertions.assertNotNull((Object)updater.latestImage);
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
    }

    @Test
    public void testStartAndEndTraceInSameBatchAligned() {
        ArrayList<ApiMessageAndVersion> batchRecords = new ArrayList<ApiMessageAndVersion>();
        batchRecords.addAll(START_TRACE_SINGLETON);
        batchRecords.addAll(TOPIC_NO_TXN_BATCH);
        batchRecords.addAll(END_TRACE_SINGLETON);
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testMultipleTransactionsInOneBatch");
        this.loadSingleBatch(updater, faultHandler, batchRecords);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
    }

    @Test
    public void testMultipleBatchTrace() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader("testMultipleBatchTrace", (MetadataBatchLoader.MetadataUpdater)updater);
        updater.reset();
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(START_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        MetadataBatchLoaderTest.checkValidSpanCtx(batchLoader);
        batchLoader.loadBatch(NO_TX_BATCH, LEADER_AND_EPOCH);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        MetadataBatchLoaderTest.checkValidSpanCtx(batchLoader);
        batchLoader.loadBatch(END_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertNull((Object)batchLoader.getTraceContext());
        Assertions.assertEquals((int)4, (int)updater.updates);
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        updater.reset();
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(START_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        MetadataBatchLoaderTest.checkValidSpanCtx(batchLoader);
        batchLoader.loadBatch(NO_TX_BATCH, LEADER_AND_EPOCH);
        batchLoader.loadBatch(END_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertNull((Object)batchLoader.getTraceContext());
        Assertions.assertEquals((int)2, (int)updater.updates);
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
    }

    @Test
    public void testFlushTracingOverLapWithTransactionFront() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader("testTracingAndTransactionOverlapFront", (MetadataBatchLoader.MetadataUpdater)updater);
        updater.reset();
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(START_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        MetadataBatchLoaderTest.checkValidSpanCtx(batchLoader);
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)2, (int)updater.updates);
        MetadataBatchLoaderTest.checkValidSpanCtx(batchLoader);
        batchLoader.loadBatch(NO_TX_BATCH, LEADER_AND_EPOCH);
        batchLoader.loadBatch(START_TX_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)3, (int)updater.updates);
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        Assertions.assertNull((Object)batchLoader.getTraceContext());
        batchLoader.loadBatch(END_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)3, (int)updater.updates);
        batchLoader.loadBatch(END_TX_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)3, (int)updater.updates);
        Assertions.assertNull((Object)batchLoader.getTraceContext());
    }

    @Test
    public void testFlushTracingRecordsOverLapWithTransactionCaseBack() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader("testTracingAndTransactionOverlapBack", (MetadataBatchLoader.MetadataUpdater)updater);
        updater.reset();
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(NO_TX_BATCH, LEADER_AND_EPOCH);
        batchLoader.loadBatch(START_TX_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        batchLoader.loadBatch(START_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertNull((Object)batchLoader.getTraceContext());
        batchLoader.loadBatch(END_TX_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        batchLoader.loadBatch(END_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertNull((Object)batchLoader.getTraceContext());
    }

    @Test
    public void testFlushTracingRecordsOverLapWithTransactionCaseInside() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader("testTracingAndTransactionOverlapInside", (MetadataBatchLoader.MetadataUpdater)updater);
        updater.reset();
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(NO_TX_BATCH, LEADER_AND_EPOCH);
        batchLoader.loadBatch(START_TX_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        batchLoader.loadBatch(START_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertNull((Object)batchLoader.getTraceContext());
        batchLoader.loadBatch(END_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        batchLoader.loadBatch(END_TX_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertNull((Object)batchLoader.getTraceContext());
    }

    @Test
    public void testFlushTracingRecordsOverLapWithTransactionCaseOutside() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = MetadataBatchLoaderTest.newMetadataBatchLoader("testTracingAndTransactionOverlapOutside", (MetadataBatchLoader.MetadataUpdater)updater);
        updater.reset();
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(START_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        MetadataBatchLoaderTest.checkValidSpanCtx(batchLoader);
        Assertions.assertEquals((int)2, (int)updater.updates);
        batchLoader.loadBatch(NO_TX_BATCH, LEADER_AND_EPOCH);
        batchLoader.loadBatch(START_TX_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)3, (int)updater.updates);
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        Assertions.assertNull((Object)batchLoader.getTraceContext());
        batchLoader.loadBatch(END_TX_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)3, (int)updater.updates);
        batchLoader.loadBatch(END_TRACE_BATCH, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)3, (int)updater.updates);
        Assertions.assertNull((Object)batchLoader.getTraceContext());
    }

    public static void checkValidSpanCtx(MetadataBatchLoader batchLoader) {
        SpanContext spCtx = Span.fromContext((Context)batchLoader.getTraceContext()).getSpanContext();
        Assertions.assertArrayEquals((byte[])spCtx.getSpanIdBytes(), (byte[])validSpanId);
        Assertions.assertArrayEquals((byte[])spCtx.getTraceIdBytes(), (byte[])validTraceId);
        Assertions.assertEquals((byte)spCtx.getTraceFlags().asByte(), (byte)traceFlagByte);
    }

    static {
        LEADER_AND_EPOCH = new LeaderAndEpoch(OptionalInt.of(1), 42);
        validTraceId = new byte[TraceId.getLength() / 2];
        validSpanId = new byte[SpanId.getLength() / 2];
        traceFlagByte = 1;
        MetadataBatchLoaderTest.validTraceId[0] = 1;
        MetadataBatchLoaderTest.validSpanId[0] = 1;
        TOPIC_TXN_BATCH_1 = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new BeginTransactionRecord().setName("txn-1"), 0), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(TOPIC_FOO), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(TOPIC_FOO), 0));
        TOPIC_TXN_BATCH_2 = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(1).setTopicId(TOPIC_FOO), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(2).setTopicId(TOPIC_FOO), 0), new ApiMessageAndVersion((ApiMessage)new EndTransactionRecord(), 0));
        TOPIC_NO_TXN_BATCH = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("bar").setTopicId(TOPIC_BAR), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(TOPIC_BAR), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(1).setTopicId(TOPIC_BAR), 0));
        TXN_BEGIN_SINGLETON = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new BeginTransactionRecord().setName("txn-1"), 0));
        TXN_END_SINGLETON = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new EndTransactionRecord(), 0));
        TXN_ABORT_SINGLETON = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new AbortTransactionRecord(), 0));
        TRACING_RECORD_BATCH_START = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(TOPIC_BAR), 0), new ApiMessageAndVersion((ApiMessage)new TraceContextRecord().setTraceId(validTraceId).setSpanId(validSpanId).setTraceFlags(traceFlagByte), 0));
        TRACING_RECORD_BATCH_END = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(TOPIC_BAR), 0), new ApiMessageAndVersion((ApiMessage)new NoTraceContextRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(TOPIC_BAR), 0));
        TRACING_RECORD_BATCH_START_END = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("bar").setTopicId(TOPIC_BAR), 0), new ApiMessageAndVersion((ApiMessage)new TraceContextRecord().setTraceId(validTraceId).setSpanId(validSpanId).setTraceFlags(traceFlagByte), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(2).setTopicId(TOPIC_BAR), 0), new ApiMessageAndVersion((ApiMessage)new NoTraceContextRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(2).setTopicId(TOPIC_BAR), 0));
        START_TRACE_SINGLETON = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new TraceContextRecord().setTraceId(validTraceId).setSpanId(validSpanId).setTraceFlags(traceFlagByte), 0));
        END_TRACE_SINGLETON = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new NoTraceContextRecord(), 0));
        START_TRACE_BATCH = Batch.data((long)16L, (int)1, (long)0L, (int)40, TRACING_RECORD_BATCH_START);
        END_TRACE_BATCH = Batch.data((long)16L, (int)1, (long)0L, (int)40, TRACING_RECORD_BATCH_END);
        START_AND_END_TRACE_BATCH = Batch.data((long)16L, (int)1, (long)0L, (int)40, TRACING_RECORD_BATCH_START_END);
        START_TX_BATCH = Batch.data((long)16L, (int)2, (long)0L, (int)10, TOPIC_TXN_BATCH_1);
        END_TX_BATCH = Batch.data((long)16L, (int)2, (long)0L, (int)10, TOPIC_TXN_BATCH_2);
        NO_TX_BATCH = Batch.data((long)16L, (int)2, (long)0L, (int)10, TOPIC_NO_TXN_BATCH);
    }

    static class MockMetadataUpdater
    implements MetadataBatchLoader.MetadataUpdater {
        MetadataImage latestImage = null;
        MetadataDelta latestDelta = null;
        LogDeltaManifest latestManifest = null;
        int updates = 0;

        MockMetadataUpdater() {
        }

        public void update(MetadataDelta delta, MetadataImage image, LogDeltaManifest manifest) {
            this.latestDelta = delta;
            this.latestImage = image;
            this.latestManifest = manifest;
            ++this.updates;
        }

        public void reset() {
            this.latestImage = null;
            this.latestDelta = null;
            this.latestManifest = null;
            this.updates = 0;
        }
    }
}

