/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClearElrRecord;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ClusterLinksImageTest;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.image.writer.UnwritableMetadataException;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.MirrorTopicSwitchoverMetadata;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.TopicType;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class TopicsImageTest {
    public static final TopicsImage IMAGE1;
    public static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final TopicsDelta DELTA1;
    static final TopicsImage IMAGE2;
    static final TopicsImage TOPIC_PLACEMENT_IMAGE;
    static final List<TopicImage> TOPIC_IMAGES1;
    public static final Uuid FOO_UUID;
    private static final Uuid FOO_UUID2;
    private static final Uuid BAR_UUID;
    private static final Uuid BAZ_UUID;
    private static final Uuid FREIGHT_UUID;
    private static final Uuid TOPIC_PLACEMENT_UUID;
    private static final MirrorTopic NULL_MIRROR_TOPIC_STATE;
    private static final MirrorTopicRecord.MirrorTopicSwitchoverMetadata EMPTY_SWITCHOVER_METADATA;
    private static final MirrorTopicRecord.MirrorTopicSwitchoverMetadata NONEMPTY_SWITCHOVER_METADATA;
    private static final MirrorTopic ACTIVE_MIRROR_TOPIC_STATE;
    private static final MirrorTopic FAILED_MIRROR_TOPIC_STATE;
    private static final MirrorTopicRecord PENDING_MIRROR_TOPIC_RECORD;
    private static final MirrorTopicRecord PENDING_SETUP_FOR_RESTORE_RECORD;
    private static final MirrorTopic PENDING_MIRROR_TOPIC_STATE;
    private static final MirrorTopic PENDING_SETUP_FOR_RESTORE_MIRROR_TOPIC_STATE;
    private static final Uuid BAM_UUID;
    private static final Uuid BAM_UUID2;

    private static TopicImage newTopicImage(String name, Uuid id, MirrorTopic mirrorTopic, PartitionRegistration ... partitions) {
        return TopicsImageTest.newTopicImage(name, id, TopicType.STANDARD, mirrorTopic, partitions);
    }

    private static TopicImage newTopicImage(String name, Uuid id, TopicType topicType, MirrorTopic mirrorTopic, PartitionRegistration ... partitions) {
        HashMap<Integer, PartitionRegistration> partitionMap = new HashMap<Integer, PartitionRegistration>();
        int i = 0;
        for (PartitionRegistration partition : partitions) {
            partitionMap.put(i++, partition);
        }
        return new TopicImage(name, id, topicType.id(), partitionMap, mirrorTopic);
    }

    private static ImmutableMap<Uuid, TopicImage> newTopicsByIdMap(Collection<TopicImage> topics) {
        ImmutableMap map = ImmutableMap.empty();
        for (TopicImage topic : topics) {
            map = map.updated((Object)topic.id(), (Object)topic);
        }
        return map;
    }

    private static ImmutableMap<String, TopicImage> newTopicsByNameMap(Collection<TopicImage> topics) {
        ImmutableMap map = ImmutableMap.empty();
        for (TopicImage topic : topics) {
            map = map.updated((Object)topic.name(), (Object)topic);
        }
        return map;
    }

    private static ImmutableMap<Uuid, ImmutableMap<Uuid, TopicImage>> newTopicsByLinkIdMap(Collection<TopicImage> topics) {
        ImmutableMap map = ImmutableMap.empty();
        for (TopicImage topic : topics) {
            if (!topic.mirrorTopic().isPresent()) continue;
            Uuid linkId = ((MirrorTopic)topic.mirrorTopic().get()).linkId();
            ImmutableMap images = (ImmutableMap)map.getOrDefault((Object)linkId, (Object)ImmutableMap.empty());
            images = images.updated((Object)topic.id(), (Object)topic);
            map = map.updated((Object)linkId, (Object)images);
        }
        return map;
    }

    private ApiMessageAndVersion newPartitionRecord(Uuid topicId, int partitionId, List<Integer> replicas) {
        return new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(partitionId).setTopicId(topicId).setReplicas(replicas).setIsr(replicas).setLeader(replicas.get(0).intValue()).setLeaderEpoch(1).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion());
    }

    private PartitionRegistration newPartition(int[] replicas) {
        Uuid[] directories = new Uuid[replicas.length];
        for (int i = 0; i < replicas.length; ++i) {
            directories[i] = DirectoryId.random();
        }
        return new PartitionRegistration.Builder().setReplicas(replicas).setDirectories(directories).setIsr(replicas).setLeader(Integer.valueOf(replicas[0])).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(1)).build();
    }

    @Test
    public void testBasicLocalChanges() {
        int localId = 3;
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>(DELTA1_RECORDS);
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("bam").setTopicId(BAM_UUID2), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        topicRecords.add(this.newPartitionRecord(BAM_UUID2, 0, Arrays.asList(0, 1, 2)));
        topicRecords.add(this.newPartitionRecord(BAM_UUID2, 1, Arrays.asList(0, 1, localId)));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(1).setTopicId(BAZ_UUID).setReplicas(Arrays.asList(4, 2, localId)).setIsr(Arrays.asList(4, 2, localId)).setLeader(4).setLeaderEpoch(2).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(IMAGE1, __ -> null);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(Collections.singletonList(new TopicPartition("baz", 0))), changes.electedLeaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(Collections.singletonList(new TopicPartition("baz", 0))), changes.leaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("baz", 1), new TopicPartition("bar", 0), new TopicPartition("bam", 1))), changes.followers().keySet());
        TopicsImage finalImage = delta.apply();
        List<ApiMessageAndVersion> imageRecords = TopicsImageTest.getImageRecords(IMAGE1);
        imageRecords.addAll(topicRecords);
        TopicsImageTest.testToImage(finalImage, Optional.of(imageRecords));
    }

    @Test
    public void testDeleteAfterChanges() {
        int localId = 3;
        Uuid zooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("zoo", zooId, NULL_MIRROR_TOPIC_STATE, this.newPartition(new int[]{localId, 1, 2})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics), ImmutableMap.empty(), ImmutableMap.empty());
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(0).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(zooId), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image, __ -> null);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(Collections.singletonList(new TopicPartition("zoo", 0))), (Object)changes.deletes());
        Assertions.assertEquals(Collections.emptyMap(), (Object)changes.electedLeaders());
        Assertions.assertEquals(Collections.emptyMap(), (Object)changes.leaders());
        Assertions.assertEquals(Collections.emptyMap(), (Object)changes.followers());
        TopicsImage finalImage = delta.apply();
        List<ApiMessageAndVersion> imageRecords = TopicsImageTest.getImageRecords(image);
        imageRecords.addAll(topicRecords);
        TopicsImageTest.testToImage(finalImage, Optional.of(imageRecords));
    }

    @Test
    public void testUpdatedLeaders() {
        int localId = 3;
        Uuid zooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("zoo", zooId, NULL_MIRROR_TOPIC_STATE, this.newPartition(new int[]{localId, 1, 2})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics), ImmutableMap.empty(), ImmutableMap.empty());
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(0).setIsr(Arrays.asList(localId, 1)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image, __ -> null);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(Collections.emptySet(), (Object)changes.deletes());
        Assertions.assertEquals(Collections.emptyMap(), (Object)changes.electedLeaders());
        Assertions.assertEquals(new HashSet<TopicPartition>(Collections.singletonList(new TopicPartition("zoo", 0))), changes.leaders().keySet());
        Assertions.assertEquals(Collections.emptyMap(), (Object)changes.followers());
    }

    @Test
    public void testClearElrRecords() {
        Uuid fooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        Uuid barId = Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("foo", fooId, NULL_MIRROR_TOPIC_STATE, this.newPartition(new int[]{0, 1, 2, 3})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics), ImmutableMap.empty(), ImmutableMap.empty());
        ArrayList<Object> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(fooId).setPartitionId(0).setIsr(Arrays.asList(0, 1)).setEligibleLeaderReplicas(Arrays.asList(2)).setLastKnownElr(Arrays.asList(3)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image, __ -> null);
        RecordTestUtils.replayAll(delta, topicRecords);
        image = delta.apply();
        Assertions.assertEquals((int)1, (int)((PartitionRegistration)image.getTopic((Uuid)fooId).partitions().get((Object)Integer.valueOf((int)0))).elr.length);
        Assertions.assertEquals((int)1, (int)((PartitionRegistration)image.getTopic((Uuid)fooId).partitions().get((Object)Integer.valueOf((int)0))).lastKnownElr.length);
        topicRecords = new ArrayList();
        topicRecords.addAll(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setTopicId(barId).setName("bar"), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setTopicId(barId).setPartitionId(0).setLeader(0).setIsr(Arrays.asList(1)).setEligibleLeaderReplicas(Arrays.asList(2)).setLastKnownElr(Arrays.asList(3)), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ClearElrRecord().setTopicName("bar"), MetadataRecordType.CLEAR_ELR_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ClearElrRecord(), MetadataRecordType.CLEAR_ELR_RECORD.highestSupportedVersion())));
        delta = new TopicsDelta(image, __ -> null);
        RecordTestUtils.replayAll(delta, topicRecords);
        image = delta.apply();
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)fooId).partitions().get((Object)Integer.valueOf((int)0))).elr.length);
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)fooId).partitions().get((Object)Integer.valueOf((int)0))).lastKnownElr.length);
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)barId).partitions().get((Object)Integer.valueOf((int)0))).elr.length);
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)barId).partitions().get((Object)Integer.valueOf((int)0))).lastKnownElr.length);
    }

    @Test
    public void testClearElrRecordForNonExistTopic() {
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(Collections.emptyList()), TopicsImageTest.newTopicsByNameMap(Collections.emptyList()), ImmutableMap.empty(), ImmutableMap.empty());
        TopicsDelta delta = new TopicsDelta(image, __ -> null);
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.addAll(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new ClearElrRecord().setTopicName("non-exist"), MetadataRecordType.CLEAR_ELR_RECORD.highestSupportedVersion())));
        Assertions.assertThrows(RuntimeException.class, () -> RecordTestUtils.replayAll(delta, topicRecords));
    }

    @Test
    public void testLocalReassignmentChanges() {
        int localId = 3;
        Uuid zooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("zoo", zooId, NULL_MIRROR_TOPIC_STATE, this.newPartition(new int[]{0, 1, localId}), this.newPartition(new int[]{localId, 1, 2}), this.newPartition(new int[]{0, 1, localId}), this.newPartition(new int[]{localId, 1, 2}), this.newPartition(new int[]{0, 1, 2}), this.newPartition(new int[]{0, 1, 2})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics), ImmutableMap.empty(), ImmutableMap.empty());
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(0).setLeader(localId), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(1).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(2).setIsr(Arrays.asList(0, 1, 2)).setReplicas(Arrays.asList(0, 1, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(3).setLeader(0).setIsr(Arrays.asList(0, 1, 2)).setReplicas(Arrays.asList(0, 1, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(4).setLeader(localId).setIsr(Arrays.asList(localId, 1, 2)).setReplicas(Arrays.asList(localId, 1, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(5).setIsr(Arrays.asList(0, 1, localId)).setReplicas(Arrays.asList(0, 1, localId)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image, __ -> null);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 2), new TopicPartition("zoo", 3))), (Object)changes.deletes());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 0), new TopicPartition("zoo", 4))), changes.electedLeaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 0), new TopicPartition("zoo", 4))), changes.leaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 1), new TopicPartition("zoo", 5))), changes.followers().keySet());
        TopicsImage finalImage = delta.apply();
        List<ApiMessageAndVersion> imageRecords = TopicsImageTest.getImageRecords(image);
        imageRecords.addAll(topicRecords);
        TopicsImageTest.testToImage(finalImage, Optional.of(imageRecords));
    }

    @Test
    public void testEmptyImageRoundTrip() {
        TopicsImageTest.testToImage(TopicsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        TopicsImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testImageHandlesIsTopicPlacementSupported() {
        RecordListWriter latestWriter = new RecordListWriter();
        MetadataVersion latest = MetadataVersion.latestTesting();
        TOPIC_PLACEMENT_IMAGE.write((ImageWriter)latestWriter, new ImageWriterOptions.Builder(latest).build());
        TopicsDelta latestDelta = new TopicsDelta(TopicsImage.EMPTY, __ -> null);
        RecordTestUtils.replayAll(latestDelta, latestWriter.records());
        TopicsImage latestImage = latestDelta.apply();
        Assertions.assertEquals((int)1, (int)latestImage.getPartition((Uuid)TopicsImageTest.TOPIC_PLACEMENT_UUID, (int)0).observers.length);
        Assertions.assertEquals((int)1, (int)latestImage.getPartition((Uuid)TopicsImageTest.TOPIC_PLACEMENT_UUID, (int)0).observers[0]);
        TopicsImageTest.testToImage(latestImage, Optional.of(latestWriter.records()));
        MetadataVersion metadataVersion34 = MetadataVersion.IBP_3_4_IV0;
        RecordListWriter version34Writer = new RecordListWriter();
        Throwable throwable = Assertions.assertThrows(UnwritableMetadataException.class, () -> TOPIC_PLACEMENT_IMAGE.write((ImageWriter)version34Writer, new ImageWriterOptions.Builder(metadataVersion34).build()));
        Assertions.assertEquals((Object)("Metadata has been lost because the following could not be represented in metadata.version 3.4-IV0: the observer metadata for topic " + String.valueOf(TOPIC_PLACEMENT_UUID) + ", partition 0."), (Object)throwable.getMessage());
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = TopicsImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        TopicsImageTest.testToImage(IMAGE2, records, (String __) -> null);
    }

    @Test
    public void testImage2RoundTrip() {
        TopicsImageTest.testToImage(IMAGE2);
    }

    private static void testToImage(TopicsImage image) {
        TopicsImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(TopicsImage image, Function<String, String> nameToTenantCallback) {
        TopicsImageTest.testToImage(image, Optional.empty(), nameToTenantCallback);
    }

    private static void testToImage(TopicsImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        TopicsImageTest.testToImage(image, fromRecords, (String __) -> null);
    }

    private static void testToImage(TopicsImage image, Optional<List<ApiMessageAndVersion>> fromRecords, Function<String, String> nameToTenantCallback) {
        TopicsImageTest.testToImage(image, fromRecords.orElseGet(() -> TopicsImageTest.getImageRecords(image)), nameToTenantCallback);
    }

    private static void testToImage(TopicsImage image, List<ApiMessageAndVersion> fromRecords, Function<String, String> nameToTenantCallback) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<TopicsDelta, TopicsImage>(() -> TopicsImage.EMPTY, i -> new TopicsDelta(i, nameToTenantCallback)).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(TopicsImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.latestProduction()).build());
        return writer.records();
    }

    @Test
    public void testTopicNameToIdView() {
        Map map = IMAGE1.topicNameToIdView();
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertEquals((Object)FOO_UUID, map.get("foo"));
        Assertions.assertTrue((boolean)map.containsKey("bar"));
        Assertions.assertEquals((Object)BAR_UUID, map.get("bar"));
        Assertions.assertFalse((boolean)map.containsKey("baz"));
        Assertions.assertNull(map.get("baz"));
        HashSet uuids = new HashSet();
        map.values().iterator().forEachRemaining(uuids::add);
        HashSet<Uuid> expectedUuids = new HashSet<Uuid>(Arrays.asList(Uuid.fromString((String)"ThIaNwRnSM2Nt9Mx1v0RvA"), Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw"), Uuid.fromString((String)"uNBNqj97TKGB0c5qq2FJAQ")));
        Assertions.assertEquals(expectedUuids, uuids);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.remove("foo"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put("bar", FOO_UUID));
    }

    @Test
    public void testTopicIdToNameView() {
        Map map = IMAGE1.topicIdToNameView();
        Assertions.assertTrue((boolean)map.containsKey(FOO_UUID));
        Assertions.assertEquals((Object)"foo", map.get(FOO_UUID));
        Assertions.assertTrue((boolean)map.containsKey(BAR_UUID));
        Assertions.assertEquals((Object)"bar", map.get(BAR_UUID));
        Assertions.assertFalse((boolean)map.containsKey(BAZ_UUID));
        Assertions.assertNull(map.get(BAZ_UUID));
        HashSet names = new HashSet();
        map.values().iterator().forEachRemaining(names::add);
        HashSet<String> expectedNames = new HashSet<String>(Arrays.asList("foo", "freight", "bar"));
        Assertions.assertEquals(expectedNames, names);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.remove(FOO_UUID));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put(FOO_UUID, "bar"));
    }

    private void addTopicWithName(TopicsDelta delta, String name) {
        Uuid topicId = new Uuid((long)name.hashCode(), (long)name.hashCode());
        delta.replay(new TopicRecord().setName(name).setTopicId(topicId));
        delta.replay(new PartitionRecord().setPartitionId(0).setTopicId(topicId).setReplicas(Arrays.asList(0, 1, 2)).setIsr(Arrays.asList(0, 1, 2)).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()).setLeader(0).setLeaderEpoch(123).setPartitionEpoch(456));
    }

    @Test
    public void testTenantToTopics() {
        TopicsDelta delta = new TopicsDelta(TopicsImage.EMPTY, (Function)TopicNameToTenant.INSTANCE);
        this.addTopicWithName(delta, "lkc-abcdef_foo");
        this.addTopicWithName(delta, "bar");
        this.addTopicWithName(delta, "lkc-fedcba_foo");
        this.addTopicWithName(delta, "baz");
        this.addTopicWithName(delta, "lkc-fedcba_bar");
        TopicsImage image = delta.apply();
        Assertions.assertEquals(Collections.singleton("lkc-abcdef_foo"), (Object)image.topicsByTenant("lkc-abcdef_"));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("lkc-fedcba_foo", "lkc-fedcba_bar")), (Object)image.topicsByTenant("lkc-fedcba_"));
        Assertions.assertEquals(Collections.emptySet(), (Object)image.topicsByTenant("lkc-blahba_"));
        Assertions.assertEquals(Collections.emptySet(), (Object)image.topicsByTenant(""));
        TopicsImageTest.testToImage(image, TopicNameToTenant.INSTANCE);
    }

    @Test
    public void testDeleteClusterLink() {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.add(new ApiMessageAndVersion((ApiMessage)new RemoveClusterLinkRecord().setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("doesn't matter"), MetadataRecordType.REMOVE_CLUSTER_LINK_RECORD.highestSupportedVersion()));
        Assertions.assertFalse((boolean)IMAGE1.topicsByLinkId(ClusterLinksImageTest.LINK_FOO_UUID).isEmpty());
        Assertions.assertNotNull((Object)IMAGE1.getTopic(BAR_UUID));
        Assertions.assertTrue((boolean)IMAGE1.getTopic(BAR_UUID).mirrorTopic().isPresent());
        TopicsDelta delta = new TopicsDelta(IMAGE1, __ -> null);
        RecordTestUtils.replayAll(delta, records);
        TopicsImage image = delta.apply();
        Assertions.assertTrue((boolean)image.topicsByLinkId(ClusterLinksImageTest.LINK_FOO_UUID).isEmpty(), (String)"Link was removed, so expected zero topics");
        Assertions.assertNotNull((Object)image.getTopic(BAR_UUID), (String)"Topic should still exist after un-linking");
        Assertions.assertFalse((boolean)image.getTopic(BAR_UUID).mirrorTopic().isPresent(), (String)"Mirror topic data should not be present after un-linking");
        List<ApiMessageAndVersion> imageRecords = TopicsImageTest.getImageRecords(IMAGE1);
        imageRecords.addAll(records);
        TopicsImageTest.testToImage(image, Optional.of(imageRecords));
    }

    @Test
    public void testAddPendingMirrorTopic() {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.add(new ApiMessageAndVersion((ApiMessage)PENDING_MIRROR_TOPIC_RECORD, MetadataRecordType.MIRROR_TOPIC_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(IMAGE1, __ -> null);
        RecordTestUtils.replayAll(delta, records);
        TopicsImage image = delta.apply();
        Assertions.assertEquals((int)1, (int)((ImmutableMap)IMAGE1.topicsByLinkId().get((Object)ClusterLinksImageTest.LINK_FOO_UUID)).size());
        Assertions.assertEquals((int)2, (int)((ImmutableMap)image.topicsByLinkId().get((Object)ClusterLinksImageTest.LINK_FOO_UUID)).size());
        TopicImage pendingMirrorTopicImage = (TopicImage)image.topicsById().get((Object)FOO_UUID);
        Assertions.assertFalse((boolean)pendingMirrorTopicImage.partitions().isEmpty());
        Assertions.assertTrue((boolean)pendingMirrorTopicImage.mirrorTopic().isPresent());
        Assertions.assertEquals((Object)PENDING_MIRROR_TOPIC_STATE, pendingMirrorTopicImage.mirrorTopic().get());
    }

    @Test
    public void testAddPendingSetupForRestoreMirrorTopic() {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.add(new ApiMessageAndVersion((ApiMessage)PENDING_SETUP_FOR_RESTORE_RECORD, MetadataRecordType.MIRROR_TOPIC_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(IMAGE1, __ -> null);
        RecordTestUtils.replayAll(delta, records);
        TopicsImage image = delta.apply();
        Assertions.assertEquals((int)1, (int)((ImmutableMap)IMAGE1.topicsByLinkId().get((Object)ClusterLinksImageTest.LINK_FOO_UUID)).size());
        Assertions.assertEquals((int)2, (int)((ImmutableMap)image.topicsByLinkId().get((Object)ClusterLinksImageTest.LINK_FOO_UUID)).size());
        TopicImage pendingSetupForRestoreMirrorTopicImage = (TopicImage)image.topicsById().get((Object)FOO_UUID);
        Assertions.assertFalse((boolean)pendingSetupForRestoreMirrorTopicImage.partitions().isEmpty());
        Assertions.assertTrue((boolean)pendingSetupForRestoreMirrorTopicImage.mirrorTopic().isPresent());
        Assertions.assertEquals((Object)PENDING_SETUP_FOR_RESTORE_MIRROR_TOPIC_STATE, pendingSetupForRestoreMirrorTopicImage.mirrorTopic().get());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testCreateMirrorTopicAndModifyState(boolean removeClusterLink) {
        String clusterLinkName = "myClusterLink";
        Uuid clusterLinkId = Uuid.fromString((String)"IuhBqpV2S0O6D_UgPr_YSw");
        Uuid remoteClusterId = Uuid.fromString((String)"RlnrMlrZT_6tTA1hd8o7GA");
        String destinationTopicName = "destination";
        Uuid destinationTopicId = Uuid.fromString((String)"bFmT8AQSQUayhuNKLehnvQ");
        String sourceTopicName = "source";
        Uuid sourceTopicId = Uuid.fromString((String)"2jYFLPWISZaCftP1xFKCRw");
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.add(new ApiMessageAndVersion((ApiMessage)new ClusterLinkRecord().setClusterLinkName("myClusterLink").setClusterLinkId(clusterLinkId).setRemoteClusterId(remoteClusterId.toString()).setTenantPrefix("").setLinkMode(ClusterLinkConfig.LinkMode.DESTINATION.toString()), 1));
        records.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("destination").setTopicId(destinationTopicId), 0));
        records.add(new ApiMessageAndVersion((ApiMessage)new MirrorTopicRecord().setTopicId(destinationTopicId).setTopicName("destination").setClusterLinkId(clusterLinkId).setClusterLinkName("myClusterLink").setSourceTopicName("source").setSourceTopicId(sourceTopicId).setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setLastSwitchoverMetadata(EMPTY_SWITCHOVER_METADATA).setTimeMs(123L), 1));
        records.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(destinationTopicId).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setLeader(1).setLeaderEpoch(123).setPartitionEpoch(456).setLinkedLeaderEpoch(300).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode), 2));
        if (removeClusterLink) {
            records.add(new ApiMessageAndVersion((ApiMessage)new RemoveClusterLinkRecord().setClusterLinkName("myClusterLink").setClusterLinkId(clusterLinkId), 0));
        }
        MetadataDelta initialDelta = new MetadataDelta(MetadataImage.EMPTY, __ -> null, new MetadataEncryptorFactory());
        FeatureLevelRecord featureLevelRecord = new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(MetadataVersion.IBP_3_5_IV0.confluentFeatureLevel());
        initialDelta.replay(featureLevelRecord);
        MetadataImage initialImage = initialDelta.apply(MetadataProvenance.EMPTY);
        MetadataDelta testDelta = new MetadataDelta(initialImage, __ -> null, new MetadataEncryptorFactory());
        for (ApiMessageAndVersion record : records) {
            testDelta.replay(record.message(), record.version());
        }
        MetadataImage testImage = testDelta.apply(MetadataProvenance.EMPTY);
        MirrorTopic.ActiveMirrorTopic expectedMirrorTopic = null;
        if (!removeClusterLink) {
            expectedMirrorTopic = new MirrorTopic.ActiveMirrorTopic(clusterLinkId, "myClusterLink", destinationTopicId, "destination", sourceTopicId, "source", Collections.emptyList(), 0L, MirrorTopicSwitchoverMetadata.empty(), 123L);
        }
        TopicImage destinationTopic = new TopicImage("destination", destinationTopicId, Collections.singletonMap(0, new PartitionRegistration(new PartitionRecord().setPartitionId(0).setTopicId(destinationTopicId).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setLeader(1).setLeaderEpoch(123).setPartitionEpoch(removeClusterLink ? 457 : 456).setLinkedLeaderEpoch(removeClusterLink ? -1 : 300).setLinkState(removeClusterLink ? PartitionRegistration.LinkState.NOT_MIRROR.levelCode : PartitionRegistration.LinkState.ACTIVE.levelCode))), (MirrorTopic)expectedMirrorTopic);
        Assertions.assertEquals((Object)new TopicsImage(ImmutableMap.singleton((Object)destinationTopicId, (Object)destinationTopic), ImmutableMap.singleton((Object)"destination", (Object)destinationTopic), ImmutableMap.empty(), removeClusterLink ? ImmutableMap.empty() : ImmutableMap.singleton((Object)clusterLinkId, (Object)ImmutableMap.singleton((Object)destinationTopicId, (Object)destinationTopic))), (Object)testImage.topics());
        ArrayList<ApiMessageAndVersion> allRecords = new ArrayList<ApiMessageAndVersion>(records.size() + 1);
        allRecords.add(new ApiMessageAndVersion((ApiMessage)featureLevelRecord, 0));
        allRecords.addAll(records);
        ImageWriterOptions options = new ImageWriterOptions.Builder(testImage.features().metadataVersionOrThrow()).build();
        MetadataImageTest.testToImage(testImage, options, Optional.of(allRecords));
    }

    @Test
    public void testRemoveMirrorTopicAndClusterLinkInSameDelta() {
        String clusterLinkName = "myClusterLink";
        Uuid clusterLinkId = Uuid.fromString((String)"IuhBqpV2S0O6D_UgPr_YSw");
        Uuid sourceClusterId = Uuid.fromString((String)"RlnrMlrZT_6tTA1hd8o7GA");
        String destinationTopicName = "destination";
        Uuid destinationTopicId = Uuid.fromString((String)"bFmT8AQSQUayhuNKLehnvQ");
        String sourceTopicName = "source";
        Uuid sourceTopicId = Uuid.fromString((String)"2jYFLPWISZaCftP1xFKCRw");
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(MetadataVersion.latestProduction().confluentFeatureLevel()), 0));
        records.add(new ApiMessageAndVersion((ApiMessage)new ClusterLinkRecord().setClusterLinkName("myClusterLink").setClusterLinkId(clusterLinkId).setRemoteClusterId(sourceClusterId.toString()).setTenantPrefix("").setLinkMode(ClusterLinkConfig.LinkMode.DESTINATION.toString()), 1));
        records.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("destination").setTopicId(destinationTopicId), 0));
        records.add(new ApiMessageAndVersion((ApiMessage)new MirrorTopicRecord().setTopicId(destinationTopicId).setTopicName("destination").setClusterLinkId(clusterLinkId).setClusterLinkName("myClusterLink").setSourceTopicName("source").setSourceTopicId(sourceTopicId).setLastSwitchoverMetadata(EMPTY_SWITCHOVER_METADATA).setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setTimeMs(123L), 1));
        records.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(destinationTopicId).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setLeader(1).setLeaderEpoch(123).setPartitionEpoch(456).setLinkedLeaderEpoch(300).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode), 2));
        MetadataImage image = MetadataImage.EMPTY;
        MetadataDelta delta = new MetadataDelta(image, name -> null, new MetadataEncryptorFactory());
        records.forEach(r -> delta.replay(r.message(), r.version()));
        image = delta.apply(MetadataProvenance.EMPTY);
        ArrayList<ApiMessageAndVersion> otherRecords = new ArrayList<ApiMessageAndVersion>();
        MetadataDelta otherDelta = new MetadataDelta(image, name -> null, new MetadataEncryptorFactory());
        otherRecords.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(destinationTopicId), 0));
        otherRecords.add(new ApiMessageAndVersion((ApiMessage)new RemoveClusterLinkRecord().setClusterLinkName("myClusterLink").setClusterLinkId(clusterLinkId), 0));
        otherRecords.forEach(r -> otherDelta.replay(r.message(), r.version()));
        image = otherDelta.apply(image.provenance());
        Assertions.assertFalse((boolean)image.topics().topicsByName().containsKey((Object)"destination"));
        Assertions.assertFalse((boolean)image.clusterLinks().linksById().containsKey(clusterLinkId));
        ArrayList<ApiMessageAndVersion> allRecords = new ArrayList<ApiMessageAndVersion>(records.size() + otherRecords.size());
        allRecords.addAll(records);
        allRecords.addAll(otherRecords);
        ImageWriterOptions options = new ImageWriterOptions.Builder(image.features().metadataVersionOrThrow()).build();
        MetadataImageTest.testToImage(image, options, Optional.of(allRecords));
    }

    static {
        FOO_UUID = Uuid.fromString((String)"ThIaNwRnSM2Nt9Mx1v0RvA");
        FOO_UUID2 = Uuid.fromString((String)"9d3lha5qv8DoIl93jf8pbX");
        BAR_UUID = Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw");
        BAZ_UUID = Uuid.fromString((String)"tgHBnRglT5W_RlENnuG5vg");
        FREIGHT_UUID = Uuid.fromString((String)"uNBNqj97TKGB0c5qq2FJAQ");
        TOPIC_PLACEMENT_UUID = Uuid.fromString((String)"p0HptygTTjet8SL5ZeREiw");
        NULL_MIRROR_TOPIC_STATE = null;
        EMPTY_SWITCHOVER_METADATA = new MirrorTopicRecord.MirrorTopicSwitchoverMetadata().setErrorCode((short)0).setErrorMessage("").setMessagesTruncated(0L);
        NONEMPTY_SWITCHOVER_METADATA = new MirrorTopicRecord.MirrorTopicSwitchoverMetadata().setErrorCode((short)3).setErrorMessage("test error").setMessagesTruncated(40L);
        ACTIVE_MIRROR_TOPIC_STATE = MirrorTopic.fromRecord((MirrorTopicRecord)new MirrorTopicRecord().setTopicName("bar").setTopicId(BAR_UUID).setSourceTopicName("bar").setSourceTopicId(Uuid.ZERO_UUID).setMirrorTopicState("Mirror").setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("link-foo").setPreviousToPausedState(null).setLastSwitchoverMetadata(EMPTY_SWITCHOVER_METADATA).setStoppedLogEndOffsets(Collections.emptyList()));
        FAILED_MIRROR_TOPIC_STATE = MirrorTopic.fromRecord((MirrorTopicRecord)new MirrorTopicRecord().setTopicName("bar").setTopicId(BAR_UUID).setSourceTopicName("bar").setSourceTopicId(Uuid.ZERO_UUID).setMirrorTopicState("FailedMirror").setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("link-foo").setPreviousToPausedState(null).setLastSwitchoverMetadata(NONEMPTY_SWITCHOVER_METADATA).setStoppedLogEndOffsets(Collections.emptyList()));
        PENDING_MIRROR_TOPIC_RECORD = new MirrorTopicRecord().setTopicName("PendingMirror").setTopicId(FOO_UUID).setSourceTopicName("foo").setSourceTopicId(Uuid.ZERO_UUID).setMirrorTopicState("PendingMirror").setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("link-foo").setPreviousToPausedState(null).setStoppedLogEndOffsets(Collections.emptyList()).setLastSwitchoverMetadata(EMPTY_SWITCHOVER_METADATA).setNextState("Mirror");
        PENDING_SETUP_FOR_RESTORE_RECORD = new MirrorTopicRecord().setTopicName("PendingSetupForRestoreMirror").setTopicId(FOO_UUID).setSourceTopicName("foo").setSourceTopicId(Uuid.ZERO_UUID).setMirrorTopicState("PendingSetupForRestoreMirror").setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("link-foo").setStoppedLogEndOffsets(Collections.singletonList(10L)).setLastSwitchoverMetadata(EMPTY_SWITCHOVER_METADATA).setStoppedEpochs(Collections.singletonList(1));
        PENDING_MIRROR_TOPIC_STATE = MirrorTopic.fromRecord((MirrorTopicRecord)PENDING_MIRROR_TOPIC_RECORD);
        PENDING_SETUP_FOR_RESTORE_MIRROR_TOPIC_STATE = MirrorTopic.fromRecord((MirrorTopicRecord)PENDING_SETUP_FOR_RESTORE_RECORD);
        BAM_UUID = Uuid.fromString((String)"b66ybsWIQoygs01vdjH07A");
        BAM_UUID2 = Uuid.fromString((String)"yd6Sq3a9aK1G8snlKv7ag5");
        TOPIC_IMAGES1 = Arrays.asList(TopicsImageTest.newTopicImage("foo", FOO_UUID, NULL_MIRROR_TOPIC_STATE, new PartitionRegistration.Builder().setReplicas(new int[]{2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{2, 3}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{3, 4, 5}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{3, 4, 5}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(4)).setPartitionEpoch(Integer.valueOf(684)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{2, 4, 5}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{2, 4, 5}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(10)).setPartitionEpoch(Integer.valueOf(84)).build()), TopicsImageTest.newTopicImage("bar", BAR_UUID, ACTIVE_MIRROR_TOPIC_STATE, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)5)).setIsr(new int[]{0, 1, 2, 3}).setRemovingReplicas(new int[]{1}).setAddingReplicas(new int[]{3, 4}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).build()), TopicsImageTest.newTopicImage("freight", FREIGHT_UUID, TopicType.FREIGHT, NULL_MIRROR_TOPIC_STATE, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{0, 1, 2}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).build()));
        IMAGE1 = new TopicsImage(TopicsImageTest.newTopicsByIdMap(TOPIC_IMAGES1), TopicsImageTest.newTopicsByNameMap(TOPIC_IMAGES1), ImmutableMap.empty(), TopicsImageTest.newTopicsByLinkIdMap(TOPIC_IMAGES1));
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(FOO_UUID), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(BAR_UUID).setPartitionId(0).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("baz").setTopicId(BAZ_UUID), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(BAZ_UUID).setReplicas(Arrays.asList(1, 2, 3, 4)).setIsr(Arrays.asList(3, 4)).setRemovingReplicas(Collections.singletonList(2)).setAddingReplicas(Collections.singletonList(1)).setLeader(3).setLeaderEpoch(2).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new MirrorTopicChangeRecord().setTopicId(BAR_UUID).setMirrorTopicState("FailedMirror").setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("link-foo").setPreviousToPausedState(null).setLastSwitchoverMetadata(new MirrorTopicChangeRecord.MirrorTopicSwitchoverMetadata().setErrorCode((short)3).setErrorMessage("test error").setMessagesTruncated(40L)).setStoppedLogEndOffsets(Collections.emptyList()), MetadataRecordType.MIRROR_TOPIC_CHANGE_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(FOO_UUID2), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("bam").setTopicId(BAM_UUID), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(BAM_UUID), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()));
        DELTA1 = new TopicsDelta(IMAGE1, __ -> null);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        List<TopicImage> topics2 = Arrays.asList(TopicsImageTest.newTopicImage("foo", FOO_UUID2, NULL_MIRROR_TOPIC_STATE, new PartitionRegistration[0]), TopicsImageTest.newTopicImage("bar", BAR_UUID, FAILED_MIRROR_TOPIC_STATE, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)5)).setIsr(new int[]{0, 1, 2, 3}).setRemovingReplicas(new int[]{1}).setAddingReplicas(new int[]{3, 4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(2)).setPartitionEpoch(Integer.valueOf(347)).setLinkState(PartitionRegistration.LinkState.FAILED).build()), TopicsImageTest.newTopicImage("baz", BAZ_UUID, NULL_MIRROR_TOPIC_STATE, new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)4)).setIsr(new int[]{3, 4}).setRemovingReplicas(new int[]{2}).setAddingReplicas(new int[]{1}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(2)).setPartitionEpoch(Integer.valueOf(1)).build()), TopicsImageTest.newTopicImage("freight", FREIGHT_UUID, TopicType.FREIGHT, NULL_MIRROR_TOPIC_STATE, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setIsr(new int[]{0, 1, 2}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).setDirectories(DirectoryId.migratingArray((int)3)).build()));
        IMAGE2 = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics2), TopicsImageTest.newTopicsByNameMap(topics2), ImmutableMap.empty(), TopicsImageTest.newTopicsByLinkIdMap(topics2));
        List<TopicImage> placementTopics = Arrays.asList(TopicsImageTest.newTopicImage("placement-topic", TOPIC_PLACEMENT_UUID, NULL_MIRROR_TOPIC_STATE, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setObservers(new int[]{1}).setIsr(new int[]{0}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(1)).setDirectories(DirectoryId.migratingArray((int)2)).build()));
        TOPIC_PLACEMENT_IMAGE = new TopicsImage(TopicsImageTest.newTopicsByIdMap(placementTopics), TopicsImageTest.newTopicsByNameMap(placementTopics), ImmutableMap.empty(), TopicsImageTest.newTopicsByLinkIdMap(placementTopics));
    }

    private static class TopicNameToTenant
    implements Function<String, String> {
        static final TopicNameToTenant INSTANCE = new TopicNameToTenant();

        private TopicNameToTenant() {
        }

        @Override
        public String apply(String name) {
            int i = name.indexOf(95);
            return i == -1 ? null : name.substring(0, i + 1);
        }
    }
}

