/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.kafka.common.Tenant;
import org.apache.kafka.common.metadata.RemoveTenantRecord;
import org.apache.kafka.common.metadata.TenantRecord;
import org.apache.kafka.image.TenantDelta;
import org.apache.kafka.image.TenantImage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TenantDeltaTest {
    TenantDeltaTest() {
    }

    @Test
    void testReplay() {
        String tenantId = "lkc-abcd";
        HashMap<String, Tenant> tenantIdToTenant = new HashMap<String, Tenant>();
        tenantIdToTenant.put(tenantId, new Tenant(tenantId, Arrays.asList(0)));
        String secondTenantId = "lkc-efgh";
        tenantIdToTenant.put(secondTenantId, new Tenant(secondTenantId, Arrays.asList(0)));
        TenantImage image = new TenantImage(tenantIdToTenant);
        TenantDelta delta = new TenantDelta(image);
        String thirdTenantId = "lkc-ijkl";
        delta.replay(new TenantRecord().setTenantId(thirdTenantId).setCellId(2));
        delta.replay(new RemoveTenantRecord().setTenantId(tenantId).setTenantId(tenantId));
        HashMap<String, Tenant> expectedTenantIdToTenant = new HashMap<String, Tenant>();
        expectedTenantIdToTenant.put(secondTenantId, new Tenant(secondTenantId, Arrays.asList(0)));
        expectedTenantIdToTenant.put(thirdTenantId, new Tenant(thirdTenantId, Arrays.asList(2)));
        TenantImage expectedImage = new TenantImage(expectedTenantIdToTenant);
        Assertions.assertEquals((Object)expectedImage, (Object)delta.apply());
    }

    @Test
    void testGetTenantFromTenantRecordBasedOnVersion() {
        String tenantId = "lkc-abcd";
        Tenant tenant = TenantDelta.getTenantFromTenantRecord((TenantRecord)new TenantRecord().setTenantId(tenantId).setCellIds(Arrays.asList(1, 2)));
        Tenant expectedTenant = new Tenant(tenantId, Arrays.asList(1, 2));
        Assertions.assertEquals((Object)expectedTenant, (Object)tenant);
        String tenantId2 = "lkc-efgh";
        Tenant tenant2 = TenantDelta.getTenantFromTenantRecord((TenantRecord)new TenantRecord().setTenantId(tenantId2).setCellId(1));
        Tenant expectedTenant2 = new Tenant(tenantId2, Arrays.asList(1));
        Assertions.assertEquals((Object)expectedTenant2, (Object)tenant2);
    }
}

