/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.KRaftClientQuotaClusterDescriber;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.apache.kafka.server.quota.ClientQuotaClusterDescriber;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class KRaftClientQuotaDescriberTest {
    private static final TopicsImage IMAGE_A;
    private static final KRaftClientQuotaClusterDescriber DESCRIBER;

    @Test
    public void testTopicNames() {
        HashSet<String> topicNames = new HashSet<String>();
        Iterator iterator = DESCRIBER.topicNames();
        while (iterator.hasNext()) {
            topicNames.add((String)iterator.next());
        }
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("foobar", "baaz", "quux")), topicNames);
    }

    @Test
    public void testPartitionsForNonExistentTopic() {
        Iterator iterator = DESCRIBER.partitionsForTopic("nonexistent");
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testPartitionsForTopic() {
        ArrayList<ClientQuotaClusterDescriber.Partition> partitions = new ArrayList<ClientQuotaClusterDescriber.Partition>();
        Iterator iterator = DESCRIBER.partitionsForTopic("foobar");
        while (iterator.hasNext()) {
            partitions.add((ClientQuotaClusterDescriber.Partition)iterator.next());
        }
        Assertions.assertEquals(Arrays.asList(new ClientQuotaClusterDescriber.Partition(0, 0), new ClientQuotaClusterDescriber.Partition(1, 1), new ClientQuotaClusterDescriber.Partition(2, -1)), partitions);
    }

    static {
        Uuid foobarUuid = Uuid.fromString((String)"MqFxr03kR1SRED_8-m4nmA");
        Uuid baazUuid = Uuid.fromString((String)"evyZzU7FTP67SdVlUV2tFg");
        Uuid quuxUuid = Uuid.fromString((String)"PubD3mi3R92yGD0qhFAyyA");
        ImmutableMap topicsById = ImmutableMap.empty();
        ImmutableMap topicsByName = ImmutableMap.empty();
        HashMap<Integer, PartitionRegistration> foobarPartitions = new HashMap<Integer, PartitionRegistration>();
        foobarPartitions.put(0, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{0, 1, 2}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(123)).setPartitionEpoch(Integer.valueOf(456)).build());
        foobarPartitions.put(1, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{0, 1, 2}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(123)).setPartitionEpoch(Integer.valueOf(456)).build());
        foobarPartitions.put(2, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[0]).setLeader(Integer.valueOf(-1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(123)).setPartitionEpoch(Integer.valueOf(456)).build());
        TopicImage foobarImage = new TopicImage("foobar", foobarUuid, foobarPartitions, null);
        topicsById = topicsById.updated((Object)foobarUuid, (Object)foobarImage);
        topicsByName = topicsByName.updated((Object)"foobar", (Object)foobarImage);
        HashMap<Integer, PartitionRegistration> baazPartitions = new HashMap<Integer, PartitionRegistration>();
        baazPartitions.put(0, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{0, 1, 2}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(123)).setPartitionEpoch(Integer.valueOf(456)).build());
        TopicImage baazImage = new TopicImage("baaz", baazUuid, baazPartitions, null);
        topicsById = topicsById.updated((Object)baazUuid, (Object)baazImage);
        topicsByName = topicsByName.updated((Object)"baaz", (Object)baazImage);
        HashMap<Integer, PartitionRegistration> quuxPartitions = new HashMap<Integer, PartitionRegistration>();
        quuxPartitions.put(0, new PartitionRegistration.Builder().setReplicas(new int[]{3, 4, 0}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{3, 4, 0}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(123)).setPartitionEpoch(Integer.valueOf(456)).build());
        TopicImage quuxImage = new TopicImage("quux", quuxUuid, quuxPartitions, null);
        topicsById = topicsById.updated((Object)quuxUuid, (Object)quuxImage);
        topicsByName = topicsByName.updated((Object)"quux", (Object)quuxImage);
        IMAGE_A = new TopicsImage(topicsById, topicsByName, ImmutableMap.empty(), ImmutableMap.empty());
        DESCRIBER = new KRaftClientQuotaClusterDescriber(IMAGE_A);
    }
}

