/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FeaturesDeltaTest {
    FeaturesDeltaTest() {
    }

    @Test
    public void testReplayWithUnsupportedFeatureLevel() {
        FeaturesDelta featuresDelta = new FeaturesDelta(new FeaturesImage(Collections.emptyMap(), MetadataVersion.MINIMUM_VERSION));
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> featuresDelta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)6)));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Unsupported metadata version - if you are currently upgrading your cluster, please ensure the metadata version is set to " + MetadataVersion.MINIMUM_VERSION.confluentRelease()), (String)("Expected substring missing from exception message: " + exception.getMessage()));
    }

    @Test
    public void testReplayKraftVersionFeatureLevel() {
        FeaturesDelta featuresDelta = new FeaturesDelta(new FeaturesImage(Collections.emptyMap(), MetadataVersion.MINIMUM_VERSION));
        featuresDelta.replay(new FeatureLevelRecord().setName("kraft.version").setFeatureLevel(KRaftVersion.LATEST_PRODUCTION.featureLevel()));
        Assertions.assertEquals(Collections.emptyMap(), (Object)featuresDelta.changes());
    }
}

