/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamChangeRecord;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamEntryRecord;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamTopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ConfluentKeyValueStreamsDelta;
import org.apache.kafka.image.ConfluentKeyValueStreamsImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ConfluentKeyValueStreamsImageTest {
    public static final ConfluentKeyValueStreamsImage IMAGE1;
    public static final ConfluentKeyValueStreamsImage IMAGE2;
    public static final ConfluentKeyValueStreamsImage IMAGE3;
    public static final List<ApiMessageAndVersion> DELTA_RECORDS;
    static final ConfluentKeyValueStreamsDelta DELTA;
    static final List<ConfluentKeyValueStreamChangeRecord> TEST_RECORDS;
    static final List<ConfluentKeyValueStreamTopicRecord> TEST_CHANGE_OFFSET_RECORDS;
    static final List<ConfluentKeyValueStreamEntryRecord> TEST_CHANGE_KV_RECORDS;
    static final short TOPIC_A = 0;
    static final short TOPIC_B = 1;

    @Test
    public void testEmptyImageRoundTrip() {
        ConfluentKeyValueStreamsImageTest.testToImage(ConfluentKeyValueStreamsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        ConfluentKeyValueStreamsImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA.apply());
        List<ApiMessageAndVersion> records = ConfluentKeyValueStreamsImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA_RECORDS);
        ConfluentKeyValueStreamsImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        ConfluentKeyValueStreamsImageTest.testToImage(IMAGE2);
    }

    @Test
    public void testImage3RoundTrip() {
        ConfluentKeyValueStreamsImageTest.testToImage(IMAGE3);
    }

    private static void testToImage(ConfluentKeyValueStreamsImage image) {
        ConfluentKeyValueStreamsImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(ConfluentKeyValueStreamsImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        ConfluentKeyValueStreamsImageTest.testToImage(image, fromRecords.orElseGet(() -> ConfluentKeyValueStreamsImageTest.getImageRecords(image)));
    }

    private static void testToImage(ConfluentKeyValueStreamsImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<ConfluentKeyValueStreamsDelta, ConfluentKeyValueStreamsImage>(() -> ConfluentKeyValueStreamsImage.EMPTY, ConfluentKeyValueStreamsDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(ConfluentKeyValueStreamsImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.latestProduction()).build());
        return writer.records();
    }

    private static List<ConfluentKeyValueStreamChangeRecord> getTestFullRecords() {
        ConfluentKeyValueStreamChangeRecord record1 = new ConfluentKeyValueStreamChangeRecord();
        record1.setType((short)0).setEntryKey("test_auth_key_1").setEntryValue("test_auth_value").setOffset(100L).setPartition((short)1);
        ConfluentKeyValueStreamChangeRecord record2 = new ConfluentKeyValueStreamChangeRecord();
        record2.setType((short)0).setEntryKey("test_auth_key_1").setEntryValue("test_auth_value_overwrite").setOffset(111L).setPartition((short)1);
        ConfluentKeyValueStreamChangeRecord record3 = new ConfluentKeyValueStreamChangeRecord();
        record3.setType((short)0).setEntryKey("test_auth_key_2").setEntryValue("test_auth_value_2").setOffset(1L).setPartition((short)0);
        ConfluentKeyValueStreamChangeRecord record4 = new ConfluentKeyValueStreamChangeRecord();
        record4.setType((short)0).setEntryKey("test_auth_key_3").setEntryValue("test_auth_value_3").setOffset(2L).setPartition((short)0);
        return Arrays.asList(record1, record2, record3, record4);
    }

    private static List<ConfluentKeyValueStreamEntryRecord> getTestOffsetChangeRecords() {
        ConfluentKeyValueStreamEntryRecord record1 = new ConfluentKeyValueStreamEntryRecord();
        record1.setType((short)0).setEntryKey("test_auth_key_1").setEntryValue("test_auth_value_1");
        ConfluentKeyValueStreamEntryRecord record2 = new ConfluentKeyValueStreamEntryRecord();
        record2.setType((short)1).setEntryKey("test_auth_key_2").setEntryValue("test_auth_value_2");
        return Arrays.asList(record1, record2);
    }

    private static List<ConfluentKeyValueStreamTopicRecord> getTestKvChangeRecords() {
        ConfluentKeyValueStreamTopicRecord record1 = new ConfluentKeyValueStreamTopicRecord();
        record1.setType((short)0).setPartitions(Arrays.asList(new ConfluentKeyValueStreamTopicRecord.Partition().setId((short)1).setOffset(111L)));
        ConfluentKeyValueStreamTopicRecord record2 = new ConfluentKeyValueStreamTopicRecord();
        record2.setType((short)1).setPartitions(Arrays.asList(new ConfluentKeyValueStreamTopicRecord.Partition().setId((short)2).setOffset(0L)));
        return Arrays.asList(record1, record2);
    }

    static {
        TEST_RECORDS = ConfluentKeyValueStreamsImageTest.getTestFullRecords();
        TEST_CHANGE_OFFSET_RECORDS = ConfluentKeyValueStreamsImageTest.getTestKvChangeRecords();
        TEST_CHANGE_KV_RECORDS = ConfluentKeyValueStreamsImageTest.getTestOffsetChangeRecords();
        HashMap topicKv = new HashMap();
        HashMap<String, String> kv = new HashMap<String, String>();
        kv.put(TEST_RECORDS.get(0).entryKey(), TEST_RECORDS.get(0).entryValue());
        topicKv.put((short)0, kv);
        HashMap topicOffset = new HashMap();
        HashMap<Short, Long> offset = new HashMap<Short, Long>();
        offset.put(TEST_RECORDS.get(0).partition(), TEST_RECORDS.get(0).offset());
        topicOffset.put((short)0, offset);
        IMAGE1 = new ConfluentKeyValueStreamsImage(topicKv, topicOffset);
        DELTA_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA_RECORDS.add(new ApiMessageAndVersion((ApiMessage)TEST_RECORDS.get(1), 0));
        DELTA_RECORDS.add(new ApiMessageAndVersion((ApiMessage)TEST_RECORDS.get(2), 0));
        DELTA_RECORDS.add(new ApiMessageAndVersion((ApiMessage)TEST_RECORDS.get(3), 0));
        DELTA = new ConfluentKeyValueStreamsDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA, DELTA_RECORDS);
        HashMap topicKv2 = new HashMap();
        HashMap<String, String> kv2 = new HashMap<String, String>();
        kv2.put(TEST_RECORDS.get(1).entryKey(), TEST_RECORDS.get(1).entryValue());
        kv2.put(TEST_RECORDS.get(2).entryKey(), TEST_RECORDS.get(2).entryValue());
        kv2.put(TEST_RECORDS.get(3).entryKey(), TEST_RECORDS.get(3).entryValue());
        topicKv2.put((short)0, kv2);
        HashMap topicOffset2 = new HashMap();
        HashMap<Short, Long> offset2 = new HashMap<Short, Long>();
        offset2.put(TEST_RECORDS.get(1).partition(), TEST_RECORDS.get(1).offset());
        offset2.put(TEST_RECORDS.get(2).partition(), TEST_RECORDS.get(2).offset());
        offset2.put(TEST_RECORDS.get(3).partition(), TEST_RECORDS.get(3).offset());
        topicOffset2.put((short)0, offset2);
        IMAGE2 = new ConfluentKeyValueStreamsImage(topicKv2, topicOffset2);
        HashMap topicKv3 = new HashMap();
        HashMap<String, String> kv3a = new HashMap<String, String>();
        kv3a.put(TEST_CHANGE_KV_RECORDS.get(0).entryKey(), TEST_CHANGE_KV_RECORDS.get(0).entryValue());
        HashMap<String, String> kv3b = new HashMap<String, String>();
        kv3b.put(TEST_CHANGE_KV_RECORDS.get(1).entryKey(), TEST_CHANGE_KV_RECORDS.get(1).entryValue());
        topicKv3.put((short)0, kv3a);
        topicKv3.put((short)1, kv3b);
        HashMap topicOffset3 = new HashMap();
        HashMap<Short, Long> offset3a = new HashMap<Short, Long>();
        offset3a.put(((ConfluentKeyValueStreamTopicRecord.Partition)TEST_CHANGE_OFFSET_RECORDS.get(0).partitions().get(0)).id(), ((ConfluentKeyValueStreamTopicRecord.Partition)TEST_CHANGE_OFFSET_RECORDS.get(0).partitions().get(0)).offset());
        HashMap<Short, Long> offset3b = new HashMap<Short, Long>();
        offset3b.put(((ConfluentKeyValueStreamTopicRecord.Partition)TEST_CHANGE_OFFSET_RECORDS.get(1).partitions().get(0)).id(), ((ConfluentKeyValueStreamTopicRecord.Partition)TEST_CHANGE_OFFSET_RECORDS.get(1).partitions().get(0)).offset());
        topicOffset3.put((short)0, offset3a);
        topicOffset3.put((short)1, offset3b);
        IMAGE3 = new ConfluentKeyValueStreamsImage(topicKv3, topicOffset3);
    }
}

