/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamChangeRecord;
import org.apache.kafka.image.ConfluentKeyValueStreamsDelta;
import org.apache.kafka.image.ConfluentKeyValueStreamsImage;
import org.apache.kafka.metadata.InternalTopicType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ConfluentKeyValueStreamsDeltaTest {
    @Test
    public void testNewRecordsInImage() {
        ConfluentKeyValueStreamsImage image = new ConfluentKeyValueStreamsImage(Collections.emptyMap(), Collections.emptyMap());
        ConfluentKeyValueStreamsDelta delta = new ConfluentKeyValueStreamsDelta(image);
        ConfluentKeyValueStreamChangeRecord inputAuthRecord = this.testRbacAuthRecord();
        Assertions.assertEquals((int)0, (int)delta.keyValueStreamsChanges().size());
        Assertions.assertEquals((int)0, (int)delta.topicOffsetChanges().size());
        delta.replay(inputAuthRecord);
        Assertions.assertEquals(this.singleTopicChange(inputAuthRecord), (Object)delta.keyValueStreamsChanges());
        Assertions.assertEquals(this.singleTopicOffsetChange(inputAuthRecord), (Object)delta.topicOffsetChanges());
    }

    @Test
    public void testOverwritingRecordsInImage() {
        ConfluentKeyValueStreamsImage image = new ConfluentKeyValueStreamsImage(this.singleTopicChange(this.testRbacAuthRecord()), this.singleTopicOffsetChange(this.testRbacAuthRecord()));
        ConfluentKeyValueStreamsDelta delta = new ConfluentKeyValueStreamsDelta(image);
        ConfluentKeyValueStreamChangeRecord overWriteAuthRecord = this.testRbacAuthOverWriteRecord();
        Assertions.assertEquals((int)0, (int)delta.keyValueStreamsChanges().size());
        Assertions.assertEquals((int)0, (int)delta.topicOffsetChanges().size());
        delta.replay(overWriteAuthRecord);
        Assertions.assertEquals(this.singleTopicChange(overWriteAuthRecord), (Object)delta.keyValueStreamsChanges());
        Assertions.assertEquals(this.singleTopicOffsetChange(overWriteAuthRecord), (Object)delta.topicOffsetChanges());
    }

    @Test
    public void testDeletingRecordsInImage() {
        ConfluentKeyValueStreamsImage image = new ConfluentKeyValueStreamsImage(this.singleTopicChange(this.testRbacAuthRecord()), this.singleTopicOffsetChange(this.testRbacAuthRecord()));
        ConfluentKeyValueStreamsDelta delta = new ConfluentKeyValueStreamsDelta(image);
        ConfluentKeyValueStreamChangeRecord inputAuthRecord = this.testRbacAuthRecord();
        ConfluentKeyValueStreamChangeRecord deleteAuthRecord = this.testRbacAuthDeleteRecord();
        Assertions.assertEquals((int)0, (int)delta.keyValueStreamsChanges().size());
        Assertions.assertEquals((int)0, (int)delta.topicOffsetChanges().size());
        delta.replay(inputAuthRecord);
        Assertions.assertEquals((int)1, (int)((Map)delta.keyValueStreamsChanges().get(InternalTopicType.RBAC_AUTH.value())).size());
        Assertions.assertEquals((int)1, (int)((Map)delta.topicOffsetChanges().get(InternalTopicType.RBAC_AUTH.value())).size());
        delta.replay(deleteAuthRecord);
        Assertions.assertEquals((int)0, (int)((Map)delta.keyValueStreamsChanges().get(InternalTopicType.RBAC_AUTH.value())).size());
        Assertions.assertEquals((int)1, (int)((Map)delta.topicOffsetChanges().get(InternalTopicType.RBAC_AUTH.value())).size());
    }

    private ConfluentKeyValueStreamChangeRecord testRbacAuthRecord() {
        ConfluentKeyValueStreamChangeRecord record = new ConfluentKeyValueStreamChangeRecord();
        record.setEntryKey("test_auth_key");
        record.setEntryValue("test_auth_value");
        record.setOffset(100L);
        record.setPartition((short)1);
        record.setType(InternalTopicType.RBAC_AUTH.value());
        return record;
    }

    private ConfluentKeyValueStreamChangeRecord testRbacAuthOverWriteRecord() {
        ConfluentKeyValueStreamChangeRecord record = new ConfluentKeyValueStreamChangeRecord();
        record.setEntryKey("test_auth_key");
        record.setEntryValue("test_auth_value_overwrite");
        record.setOffset(111L);
        record.setPartition((short)1);
        record.setType(InternalTopicType.RBAC_AUTH.value());
        return record;
    }

    private ConfluentKeyValueStreamChangeRecord testRbacAuthDeleteRecord() {
        ConfluentKeyValueStreamChangeRecord record = new ConfluentKeyValueStreamChangeRecord();
        record.setEntryKey("test_auth_key");
        record.setEntryValue("");
        record.setOffset(111L);
        record.setPartition((short)1);
        record.setType(InternalTopicType.RBAC_AUTH.value());
        return record;
    }

    public Map<Short, Map<String, String>> singleTopicChange(ConfluentKeyValueStreamChangeRecord r) {
        LinkedHashMap<String, String> change = new LinkedHashMap<String, String>();
        change.put(r.entryKey(), r.entryValue());
        LinkedHashMap<Short, Map<String, String>> changeWithTopicType = new LinkedHashMap<Short, Map<String, String>>();
        changeWithTopicType.put(r.type(), change);
        return changeWithTopicType;
    }

    public Map<Short, Map<Short, Long>> singleTopicOffsetChange(ConfluentKeyValueStreamChangeRecord r) {
        LinkedHashMap<Short, Long> change = new LinkedHashMap<Short, Long>();
        change.put(r.partition(), r.offset());
        LinkedHashMap<Short, Map<Short, Long>> changeWithTopicType = new LinkedHashMap<Short, Map<Short, Long>>();
        changeWithTopicType.put(r.type(), change);
        return changeWithTopicType;
    }
}

