/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.EncryptedEnvelopeRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ConfigurationImage;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.AesGcm128MetadataEncryptor;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ConfigurationsImageTest {
    public static final ConfigurationsImage IMAGE1;
    public static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final ConfigurationsDelta DELTA1;
    static final ConfigurationsImage IMAGE2;

    @Test
    public void testEmptyImageRoundTrip() {
        ConfigurationsImageTest.testToImage(ConfigurationsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        ConfigurationsImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = ConfigurationsImageTest.getImageRecords(IMAGE1, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
        records.addAll(DELTA1_RECORDS);
        ConfigurationsImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        ConfigurationsImageTest.testToImage(IMAGE2);
    }

    @Test
    public void testWriterEncrypts() throws GeneralSecurityException {
        AesGcm128MetadataEncryptor encryptor = new AesGcm128MetadataEncryptor();
        ConfigDef brokerConfigDef = new ConfigDef().define("xyz", ConfigDef.Type.PASSWORD, ConfigDef.Importance.MEDIUM, "This is a fake secret config");
        KafkaConfigSchema schema = new KafkaConfigSchema(Collections.singletonMap(ConfigResource.Type.BROKER, brokerConfigDef), Collections.emptyMap());
        RecordListWriter writer = new RecordListWriter();
        ConfigurationsImage image = ConfigurationsImage.EMPTY;
        ConfigurationsDelta delta = new ConfigurationsDelta(image);
        ConfigRecord configRecord = new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("ExistingTopic").setName("xyz").setValue("override_xyz");
        delta.replay(configRecord);
        ConfigurationsImage newImage = delta.apply();
        newImage.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.latestProduction()).setConfigSchema(schema).build(), (MetadataEncryptor)encryptor);
        List batch = writer.records();
        ApiMessageAndVersion encryptedRecordAndVersion = (ApiMessageAndVersion)batch.get(0);
        Assertions.assertTrue((boolean)(encryptedRecordAndVersion.message() instanceof EncryptedEnvelopeRecord));
        ApiMessageAndVersion decryptedRecordAndVersion = encryptor.decrypt((EncryptedEnvelopeRecord)encryptedRecordAndVersion.message());
        Assertions.assertEquals((Object)configRecord, (Object)decryptedRecordAndVersion.message());
        ConfigurationsImageTest.testToImage(newImage);
    }

    private static void testToImage(ConfigurationsImage image) {
        ConfigurationsImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(ConfigurationsImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        ConfigurationsImageTest.testToImage(image, fromRecords.orElseGet(() -> ConfigurationsImageTest.getImageRecords(image, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE)));
    }

    private static void testToImage(ConfigurationsImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<ConfigurationsDelta, ConfigurationsImage>(() -> ConfigurationsImage.EMPTY, ConfigurationsDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(ConfigurationsImage image, MetadataEncryptor encryptor) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.latestProduction()).build(), encryptor);
        return writer.records();
    }

    static {
        HashMap<ConfigResource, ConfigurationImage> map1 = new HashMap<ConfigResource, ConfigurationImage>();
        HashMap<String, String> broker0Map = new HashMap<String, String>();
        broker0Map.put("foo", "bar");
        broker0Map.put("baz", "quux");
        map1.put(new ConfigResource(ConfigResource.Type.BROKER, "0"), new ConfigurationImage(new ConfigResource(ConfigResource.Type.BROKER, "0"), broker0Map));
        HashMap<String, String> broker1Map = new HashMap<String, String>();
        broker1Map.put("foobar", "foobaz");
        map1.put(new ConfigResource(ConfigResource.Type.BROKER, "1"), new ConfigurationImage(new ConfigResource(ConfigResource.Type.BROKER, "1"), broker1Map));
        IMAGE1 = new ConfigurationsImage(map1);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("baz").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("1").setName("foobar").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("1").setName("barfoo").setValue("bazfoo"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("2").setName("foo").setValue("bar"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
        DELTA1 = new ConfigurationsDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<ConfigResource, ConfigurationImage> map2 = new HashMap<ConfigResource, ConfigurationImage>();
        Map<String, String> broker1Map2 = Collections.singletonMap("barfoo", "bazfoo");
        map2.put(new ConfigResource(ConfigResource.Type.BROKER, "1"), new ConfigurationImage(new ConfigResource(ConfigResource.Type.BROKER, "1"), broker1Map2));
        Map<String, String> broker2Map = Collections.singletonMap("foo", "bar");
        map2.put(new ConfigResource(ConfigResource.Type.BROKER, "2"), new ConfigurationImage(new ConfigResource(ConfigResource.Type.BROKER, "2"), broker2Map));
        IMAGE2 = new ConfigurationsImage(map2);
    }
}

