/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.ClusterDelta;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerRegistrationInControlledShutdownChange;
import org.apache.kafka.metadata.ControllerRegistration;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ClusterImageTest {
    public static final ClusterImage IMAGE1;
    static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final ClusterDelta DELTA1;
    static final ClusterImage IMAGE2;
    static final List<ApiMessageAndVersion> DELTA2_RECORDS;
    static final ClusterDelta DELTA2;
    static final ClusterImage IMAGE3;

    @Test
    public void testEmptyImageRoundTrip() {
        ClusterImageTest.testToImage(ClusterImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        ClusterImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = ClusterImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        ClusterImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        ClusterImageTest.testToImage(IMAGE2);
    }

    @Test
    public void testApplyDelta2() {
        Assertions.assertEquals((Object)IMAGE3, (Object)DELTA2.apply());
        List<ApiMessageAndVersion> records = ClusterImageTest.getImageRecords(IMAGE2);
        records.addAll(DELTA2_RECORDS);
        ClusterImageTest.testToImage(IMAGE3, records);
    }

    @Test
    public void testImage3RoundTrip() {
        ClusterImageTest.testToImage(IMAGE3);
    }

    private static void testToImage(ClusterImage image) {
        ClusterImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(ClusterImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        ClusterImageTest.testToImage(image, fromRecords.orElseGet(() -> ClusterImageTest.getImageRecords(image)));
    }

    private static void testToImage(ClusterImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<ClusterDelta, ClusterImage>(() -> ClusterImage.EMPTY, ClusterDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(ClusterImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.latestProduction()).build());
        return writer.records();
    }

    @Test
    public void testHandleLossOfControllerRegistrations() {
        ClusterImage testImage = new ClusterImage(Collections.emptyMap(), Collections.singletonMap(1000, new ControllerRegistration.Builder().setId(1000).setIncarnationId(Uuid.fromString((String)"9ABu6HEgRuS-hjHLgC4cHw")).setListeners(Collections.singletonMap("PLAINTEXT", new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 19092))).setSupportedFeatures(Collections.emptyMap()).build()));
        RecordListWriter writer = new RecordListWriter();
        AtomicReference<String> lossString = new AtomicReference<String>("");
        testImage.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.IBP_3_6_IV2).setLossHandler(loss -> lossString.compareAndSet("", loss.loss())).build());
        Assertions.assertEquals((Object)"controller registration data", (Object)lossString.get());
    }

    @Test
    public void testBrokerEpoch() {
        Assertions.assertEquals((long)123L, (long)IMAGE1.brokerEpoch(2));
    }

    @Test
    public void testBrokerEpochForNonExistentBroker() {
        Assertions.assertEquals((long)-1L, (long)IMAGE1.brokerEpoch(20));
    }

    static {
        HashMap<Integer, BrokerRegistration> map1 = new HashMap<Integer, BrokerRegistration>();
        map1.put(0, new BrokerRegistration.Builder().setId(0).setEpoch(1000L).setIncarnationId(Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q")).setListeners(Collections.singletonList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9092))).setSupportedFeatures(Collections.singletonMap("foo", VersionRange.of((short)1, (short)3))).setRack(Optional.empty()).setFenced(true).setInControlledShutdown(false).build());
        map1.put(1, new BrokerRegistration.Builder().setId(1).setEpoch(1001L).setIncarnationId(Uuid.fromString((String)"U52uRe20RsGI0RvpcTx33Q")).setListeners(Collections.singletonList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9093))).setSupportedFeatures(Collections.singletonMap("foo", VersionRange.of((short)1, (short)3))).setRack(Optional.empty()).setFenced(false).setInControlledShutdown(false).setDegradedComponents(new HashSet<DegradedBrokerHealthState>(Collections.singleton(new DegradedBrokerHealthState("RCCA-123", BrokerComponent.UNSPECIFIED)))).build());
        map1.put(2, new BrokerRegistration.Builder().setId(2).setEpoch(123L).setIncarnationId(Uuid.fromString((String)"hr4TVh3YQiu3p16Awkka6w")).setListeners(Collections.singletonList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9094))).setSupportedFeatures(Collections.emptyMap()).setRack(Optional.of("arack")).setFenced(false).setInControlledShutdown(false).build());
        HashMap<Integer, ControllerRegistration> cmap1 = new HashMap<Integer, ControllerRegistration>();
        cmap1.put(1000, new ControllerRegistration.Builder().setId(1000).setIncarnationId(Uuid.fromString((String)"9ABu6HEgRuS-hjHLgC4cHw")).setZkMigrationReady(false).setListeners(Collections.singletonMap("PLAINTEXT", new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 19092))).setSupportedFeatures(Collections.emptyMap()).build());
        IMAGE1 = new ClusterImage(map1, cmap1);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new UnfenceBrokerRecord().setId(0).setEpoch(1000L), MetadataRecordType.UNFENCE_BROKER_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FenceBrokerRecord().setId(1).setEpoch(1001L), MetadataRecordType.FENCE_BROKER_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(1000L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value()), MetadataRecordType.BROKER_REGISTRATION_CHANGE_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(1001L).setDegradedComponents(Collections.singletonList(new BrokerRegistrationChangeRecord.DegradedComponent().setComponentCode(BrokerComponent.UNSPECIFIED.id()).setReason("RCCA-234"))), MetadataRecordType.BROKER_REGISTRATION_CHANGE_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new UnregisterBrokerRecord().setBrokerId(2).setBrokerEpoch(123L), 0));
        RegisterControllerRecord.ControllerEndpointCollection endpointsFor1001 = new RegisterControllerRecord.ControllerEndpointCollection();
        endpointsFor1001.add((ImplicitLinkedHashCollection.Element)new RegisterControllerRecord.ControllerEndpoint().setHost("localhost").setName("PLAINTEXT").setPort(19093).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RegisterControllerRecord().setControllerId(1001).setIncarnationId(Uuid.fromString((String)"FdEHF-IqScKfYyjZ1CjfNQ")).setZkMigrationReady(true).setEndPoints(endpointsFor1001), 0));
        DELTA1 = new ClusterDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<Integer, BrokerRegistration> map2 = new HashMap<Integer, BrokerRegistration>();
        map2.put(0, new BrokerRegistration.Builder().setId(0).setEpoch(1000L).setIncarnationId(Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q")).setListeners(Collections.singletonList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9092))).setSupportedFeatures(Collections.singletonMap("foo", VersionRange.of((short)1, (short)3))).setRack(Optional.empty()).setFenced(false).setInControlledShutdown(true).build());
        map2.put(1, new BrokerRegistration.Builder().setId(1).setEpoch(1001L).setIncarnationId(Uuid.fromString((String)"U52uRe20RsGI0RvpcTx33Q")).setListeners(Collections.singletonList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9093))).setSupportedFeatures(Collections.singletonMap("foo", VersionRange.of((short)1, (short)3))).setRack(Optional.empty()).setFenced(true).setInControlledShutdown(false).setDegradedComponents(new HashSet<DegradedBrokerHealthState>(Collections.singleton(new DegradedBrokerHealthState("RCCA-234", BrokerComponent.UNSPECIFIED)))).build());
        HashMap<Integer, ControllerRegistration> cmap2 = new HashMap<Integer, ControllerRegistration>(cmap1);
        cmap2.put(1001, new ControllerRegistration.Builder().setId(1001).setIncarnationId(Uuid.fromString((String)"FdEHF-IqScKfYyjZ1CjfNQ")).setZkMigrationReady(true).setListeners(Collections.singletonMap("PLAINTEXT", new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 19093))).setSupportedFeatures(Collections.emptyMap()).build());
        IMAGE2 = new ClusterImage(map2, cmap2);
        DELTA2_RECORDS = new ArrayList<ApiMessageAndVersion>(DELTA1_RECORDS);
        DELTA2_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FenceBrokerRecord().setId(0).setEpoch(1000L), MetadataRecordType.FENCE_BROKER_RECORD.highestSupportedVersion()));
        DELTA2_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new UnfenceBrokerRecord().setId(1).setEpoch(1001L), MetadataRecordType.UNFENCE_BROKER_RECORD.highestSupportedVersion()));
        DELTA2_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(1000L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.NONE.value()), MetadataRecordType.BROKER_REGISTRATION_CHANGE_RECORD.highestSupportedVersion()));
        DELTA2_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(2).setIsMigratingZkBroker(true).setIncarnationId(Uuid.fromString((String)"Am5Yse7GQxaw0b2alM74bP")).setBrokerEpoch(1002L).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singletonList(new RegisterBrokerRecord.BrokerEndpoint().setName("PLAINTEXT").setHost("localhost").setPort(9094).setSecurityProtocol((short)0)).iterator())).setFeatures(new RegisterBrokerRecord.BrokerFeatureCollection(Collections.singleton(new RegisterBrokerRecord.BrokerFeature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.apacheFeatureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_6_IV0.apacheFeatureLevel())).iterator())).setRack("rack3").setMetadataEncryptors(Collections.emptyList()), MetadataRecordType.REGISTER_BROKER_RECORD.highestSupportedVersion()));
        DELTA2 = new ClusterDelta(IMAGE2);
        RecordTestUtils.replayAll(DELTA2, DELTA2_RECORDS);
        HashMap<Integer, BrokerRegistration> map3 = new HashMap<Integer, BrokerRegistration>();
        map3.put(0, new BrokerRegistration.Builder().setId(0).setEpoch(1000L).setIncarnationId(Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q")).setListeners(Collections.singletonList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9092))).setSupportedFeatures(Collections.singletonMap("foo", VersionRange.of((short)1, (short)3))).setRack(Optional.empty()).setFenced(true).setInControlledShutdown(true).build());
        map3.put(1, new BrokerRegistration.Builder().setId(1).setEpoch(1001L).setIncarnationId(Uuid.fromString((String)"U52uRe20RsGI0RvpcTx33Q")).setListeners(Collections.singletonList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9093))).setSupportedFeatures(Collections.singletonMap("foo", VersionRange.of((short)1, (short)3))).setRack(Optional.empty()).setFenced(false).setInControlledShutdown(false).setDegradedComponents(Collections.singleton(new DegradedBrokerHealthState("RCCA-234", BrokerComponent.UNSPECIFIED))).build());
        map3.put(2, new BrokerRegistration.Builder().setId(2).setEpoch(1002L).setIncarnationId(Uuid.fromString((String)"Am5Yse7GQxaw0b2alM74bP")).setListeners(Collections.singletonList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9094))).setSupportedFeatures(Collections.singletonMap("metadata.version", VersionRange.of((short)MetadataVersion.MINIMUM_VERSION.apacheFeatureLevel(), (short)MetadataVersion.IBP_3_6_IV0.apacheFeatureLevel()))).setRack(Optional.of("rack3")).setFenced(true).setIsMigratingZkBroker(true).build());
        IMAGE3 = new ClusterImage(map3, cmap2);
    }
}

