/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.metadata.CellMigrationRecord;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RemoveCellRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.CellDelta;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
class CellImageTest {
    CellImageTest() {
    }

    @Test
    void testIsEmpty() {
        CellImage image = new CellImage(new HashMap(), CellMigrationState.INACTIVE.code());
        Assertions.assertTrue((boolean)image.isEmpty());
        Assertions.assertTrue((boolean)CellImage.EMPTY.isEmpty());
        CellImageTest.testToImage(image);
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        byte cellMigrationState = CellMigrationState.INITIATED.code();
        cellIdToCell.put(0, new Cell(0, new HashSet(), CellState.READY, 3, 6));
        CellImage cellImage = new CellImage(cellIdToCell, cellMigrationState);
        Assertions.assertFalse((boolean)cellImage.isEmpty());
        CellImageTest.testToImage(cellImage);
    }

    @Test
    void testCellImage() {
        CellImage image = new CellImage(new HashMap(), CellMigrationState.INACTIVE.code());
        Assertions.assertEquals(new HashMap(), (Object)image.cellIdToCell());
        Assertions.assertEquals(new HashMap(), (Object)CellImage.EMPTY.cellIdToCell());
        Assertions.assertEquals((int)0, (int)image.cellMigrationState());
        Assertions.assertEquals((int)0, (int)CellImage.EMPTY.cellMigrationState());
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        CellMigrationState cellMigrationState = CellMigrationState.INITIATED;
        cellIdToCell.put(0, new Cell(0, new HashSet(), CellState.READY, 3, 6));
        CellImage cellImage = new CellImage(cellIdToCell, cellMigrationState.code());
        Assertions.assertEquals(cellIdToCell, (Object)cellImage.cellIdToCell());
        Assertions.assertEquals((byte)cellMigrationState.code(), (byte)cellImage.cellMigrationState());
        CellImageTest.testToImage(cellImage);
    }

    @Test
    void testEquals() {
        Assertions.assertEquals((Object)new CellImage(new HashMap(), CellMigrationState.INACTIVE.code()), (Object)new CellImage(new HashMap(), CellMigrationState.INACTIVE.code()));
        Assertions.assertEquals((Object)CellImage.EMPTY, (Object)CellImage.EMPTY);
        Assertions.assertEquals((Object)new CellImage(new HashMap(), CellMigrationState.INACTIVE.code()), (Object)CellImage.EMPTY);
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        byte cellMigrationState = CellMigrationState.INITIATED.code();
        cellIdToCell.put(0, new Cell(0, new HashSet(), CellState.READY, 3, 6));
        cellIdToCell.put(1, new Cell(1, new HashSet(), CellState.QUARANTINED, 2, 4));
        CellImage image = new CellImage(cellIdToCell, cellMigrationState);
        Assertions.assertEquals((Object)new CellImage(cellIdToCell, cellMigrationState), (Object)new CellImage(cellIdToCell, cellMigrationState));
        Assertions.assertNotEquals((Object)CellImage.EMPTY, (Object)new CellImage(cellIdToCell, cellMigrationState));
        Assertions.assertNotEquals((Object)new CellImage(cellIdToCell, cellMigrationState), (Object)CellImage.EMPTY);
        HashMap<Integer, Cell> secondCellIdToCell = new HashMap<Integer, Cell>();
        byte secondCellMigrationState = CellMigrationState.PAUSED.code();
        secondCellIdToCell.put(0, new Cell(0, new HashSet(), CellState.EXCLUDED, 3, 6));
        secondCellIdToCell.put(1, new Cell(1, new HashSet(), CellState.READY, 2, 4));
        CellImage secondImage = new CellImage(secondCellIdToCell, secondCellMigrationState);
        Assertions.assertNotEquals((Object)image, (Object)secondImage);
    }

    @Test
    void testGetBrokerCellId() {
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        cellIdToCell.put(0, new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 6));
        cellIdToCell.put(1, new Cell(1, new HashSet<Integer>(Arrays.asList(3, 4, 5)), CellState.QUARANTINED, 2, 4));
        CellImage image = new CellImage(cellIdToCell, CellMigrationState.INITIATED.code());
        Assertions.assertEquals((int)0, (int)image.getBrokerCellId(0));
        Assertions.assertEquals((int)0, (int)image.getBrokerCellId(1));
        Assertions.assertEquals((int)0, (int)image.getBrokerCellId(2));
        Assertions.assertEquals((int)1, (int)image.getBrokerCellId(3));
        Assertions.assertEquals((int)1, (int)image.getBrokerCellId(4));
        Assertions.assertEquals((int)1, (int)image.getBrokerCellId(5));
        Assertions.assertEquals((int)-1, (int)image.getBrokerCellId(6));
        Assertions.assertEquals((int)2, (int)image.cellMigrationState());
        CellImageTest.testToImage(image);
    }

    @Test
    void testWrite() {
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        cellIdToCell.put(0, new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 6));
        cellIdToCell.put(1, new Cell(1, new HashSet(), CellState.QUARANTINED, 2, 4));
        CellImage image = new CellImage(cellIdToCell, CellMigrationState.INITIATED.code());
        HashSet<ApiMessageAndVersion> expectedBatch = new HashSet<ApiMessageAndVersion>(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2)), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(1).setState(CellState.QUARANTINED.code()).setMinSize((short)2).setMaxSize((short)4), MetadataRecordType.CELL_RECORD.highestSupportedVersion())));
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.IBP_3_7_IV1).build());
        Assertions.assertEquals(expectedBatch, new HashSet(writer.records()));
        CellImageTest.testToImage(image);
    }

    @Test
    void testWriteWithCellMigrationSupportedMetadataVersion() {
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        cellIdToCell.put(0, new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 6));
        cellIdToCell.put(1, new Cell(1, new HashSet(), CellState.QUARANTINED, 2, 4));
        CellImage image = new CellImage(cellIdToCell, CellMigrationState.INITIATED.code());
        HashSet<ApiMessageAndVersion> expectedBatch = new HashSet<ApiMessageAndVersion>(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2)), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(1).setState(CellState.QUARANTINED.code()).setMinSize((short)2).setMaxSize((short)4), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellMigrationRecord().setState(CellMigrationState.INITIATED.code()), MetadataRecordType.CELL_MIGRATION_RECORD.lowestSupportedVersion())));
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.IBP_3_7_IV2).build());
        Assertions.assertEquals(expectedBatch, new HashSet(writer.records()));
        CellImageTest.testToImage(image);
    }

    @Test
    void testWriteWithLatestMetadataVersion() {
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        cellIdToCell.put(0, new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 6));
        cellIdToCell.put(1, new Cell(1, new HashSet(), CellState.QUARANTINED, 2, 4));
        CellImage image = new CellImage(cellIdToCell, CellMigrationState.INITIATED.code());
        HashSet<ApiMessageAndVersion> expectedBatch = new HashSet<ApiMessageAndVersion>(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2)), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(1).setState(CellState.QUARANTINED.code()).setMinSize((short)2).setMaxSize((short)4), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellMigrationRecord().setState(CellMigrationState.INITIATED.code()), MetadataRecordType.CELL_MIGRATION_RECORD.lowestSupportedVersion())));
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.latestTesting()).build());
        Assertions.assertEquals(expectedBatch, new HashSet(writer.records()));
        CellImageTest.testToImage(image);
    }

    @Test
    void testCellDeltaReplayAndImageWriteNewCell() {
        CellDelta cellDelta = new CellDelta(new CellImage(Collections.emptyMap(), CellMigrationState.INACTIVE.code()));
        cellDelta.replay(new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2));
        RecordListWriter writer = new RecordListWriter();
        CellImage image = cellDelta.apply();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.IBP_3_7_IV1).build());
        List<ApiMessageAndVersion> expectedBatch = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2), MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedBatch, (Object)writer.records());
        CellImageTest.testToImage(image);
    }

    @Test
    void testCellDeltaReplayAndImageWriteNewCellAndUpdateMigrationState() {
        CellDelta cellDelta = new CellDelta(new CellImage(Collections.emptyMap(), CellMigrationState.INACTIVE.code()));
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        CellRecord cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        CellMigrationRecord cellMigrationRecord = new CellMigrationRecord().setState(CellMigrationState.INITIATED.code());
        records.add(new ApiMessageAndVersion((ApiMessage)cellMigrationRecord, 0));
        cellDelta.replay(cellMigrationRecord);
        RecordListWriter writer = new RecordListWriter();
        CellImage image = cellDelta.apply();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.latestTesting()).build());
        HashSet<ApiMessageAndVersion> expectedBatch = new HashSet<ApiMessageAndVersion>(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellMigrationRecord().setState(CellMigrationState.INITIATED.code()), MetadataRecordType.CELL_MIGRATION_RECORD.lowestSupportedVersion())));
        Assertions.assertEquals(expectedBatch, new HashSet(writer.records()));
        CellImageTest.testToImage(image, Optional.of(records));
    }

    @Test
    void testCellDeltaReplayAndImageWriteNewCellAndRemove() {
        CellDelta cellDelta = new CellDelta(new CellImage(Collections.emptyMap(), CellMigrationState.INACTIVE.code()));
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        CellRecord cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        RemoveCellRecord removeCellRecord = new RemoveCellRecord().setCellId(0);
        records.add(new ApiMessageAndVersion((ApiMessage)removeCellRecord, 0));
        cellDelta.replay(removeCellRecord);
        RecordListWriter writer = new RecordListWriter();
        CellImage image = cellDelta.apply();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.IBP_3_7_IV1).build());
        Assertions.assertEquals(Collections.emptyList(), (Object)writer.records());
        CellImageTest.testToImage(image, Optional.of(records));
    }

    @Test
    void testCellDeltaReplayAndImageWriteNewCellAfterDelete() {
        CellDelta cellDelta = new CellDelta(new CellImage(Collections.emptyMap(), CellMigrationState.INACTIVE.code()));
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        CellRecord cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        RemoveCellRecord removeCellRecord = new RemoveCellRecord().setCellId(0);
        records.add(new ApiMessageAndVersion((ApiMessage)removeCellRecord, 0));
        cellDelta.replay(removeCellRecord);
        cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        RecordListWriter writer = new RecordListWriter();
        CellImage image = cellDelta.apply();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.IBP_3_7_IV1).build());
        List<ApiMessageAndVersion> expectedBatch = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2), MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedBatch, (Object)writer.records());
        CellImageTest.testToImage(image, Optional.of(records));
    }

    @Test
    void testCellDeltaReplayAndImageWriteUpdateCell() {
        CellDelta cellDelta = new CellDelta(new CellImage(Collections.emptyMap(), CellMigrationState.INACTIVE.code()));
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        CellRecord cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)1).setMaxSize((short)4);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        RecordListWriter writer = new RecordListWriter();
        CellImage image = cellDelta.apply();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.IBP_3_7_IV1).build());
        List<ApiMessageAndVersion> expectedBatch = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)1).setMaxSize((short)4), MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedBatch, (Object)writer.records());
        CellImageTest.testToImage(image, Optional.of(records));
    }

    @Test
    void testCellDeltaReplayAndImageWriteUpdateCellAndMigrationStateWithOldVersion() {
        CellDelta cellDelta = new CellDelta(new CellImage(Collections.emptyMap(), CellMigrationState.INACTIVE.code()));
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        CellRecord cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)1).setMaxSize((short)4);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        CellMigrationRecord cellMigrationRecord = new CellMigrationRecord().setState(CellMigrationState.INITIATED.code());
        records.add(new ApiMessageAndVersion((ApiMessage)cellMigrationRecord, 0));
        cellDelta.replay(cellMigrationRecord);
        RecordListWriter writer = new RecordListWriter();
        CellImage image = cellDelta.apply();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.IBP_3_7_IV1).build());
        List<ApiMessageAndVersion> expectedBatch = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)1).setMaxSize((short)4), MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedBatch, (Object)writer.records());
        CellImageTest.testToImage(image, Optional.of(records));
    }

    @Test
    void testCellDeltaReplayAndImageWriteUpdateCellAndMigrationStateWithLatestVersion() {
        CellDelta cellDelta = new CellDelta(new CellImage(Collections.emptyMap(), CellMigrationState.INACTIVE.code()));
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        CellRecord cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)1).setMaxSize((short)4);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        CellMigrationRecord cellMigrationRecord = new CellMigrationRecord().setState(CellMigrationState.INITIATED.code());
        records.add(new ApiMessageAndVersion((ApiMessage)cellMigrationRecord, 0));
        cellDelta.replay(cellMigrationRecord);
        RecordListWriter writer = new RecordListWriter();
        CellImage image = cellDelta.apply();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.latestTesting()).build());
        HashSet<ApiMessageAndVersion> expectedBatch = new HashSet<ApiMessageAndVersion>(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)1).setMaxSize((short)4), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellMigrationRecord().setState(CellMigrationState.INITIATED.code()), MetadataRecordType.CELL_MIGRATION_RECORD.lowestSupportedVersion())));
        Assertions.assertEquals(expectedBatch, new HashSet(writer.records()));
        CellImageTest.testToImage(image, Optional.of(records));
    }

    @Test
    void testCellDeltaReplayAndImageWriteUpdateMigrationState() {
        CellDelta cellDelta = new CellDelta(new CellImage(Collections.emptyMap(), CellMigrationState.INACTIVE.code()));
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        CellRecord cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)1).setMaxSize((short)4);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        CellMigrationRecord cellMigrationRecord = new CellMigrationRecord().setState(CellMigrationState.INITIATED.code());
        records.add(new ApiMessageAndVersion((ApiMessage)cellMigrationRecord, 0));
        cellDelta.replay(cellMigrationRecord);
        cellMigrationRecord = new CellMigrationRecord().setState(CellMigrationState.PAUSED.code());
        records.add(new ApiMessageAndVersion((ApiMessage)cellMigrationRecord, 0));
        cellDelta.replay(cellMigrationRecord);
        RecordListWriter writer = new RecordListWriter();
        CellImage image = cellDelta.apply();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.latestTesting()).build());
        HashSet<ApiMessageAndVersion> expectedBatch = new HashSet<ApiMessageAndVersion>(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)1).setMaxSize((short)4), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellMigrationRecord().setState(CellMigrationState.PAUSED.code()), MetadataRecordType.CELL_MIGRATION_RECORD.lowestSupportedVersion())));
        Assertions.assertEquals(expectedBatch, new HashSet(writer.records()));
        CellImageTest.testToImage(image, Optional.of(records));
    }

    @Test
    void testCellDeltaReplayAndImageWriteWithOriginalImage() {
        HashMap<Integer, Cell> originalCellIdToCell = new HashMap<Integer, Cell>();
        originalCellIdToCell.put(0, new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 6));
        originalCellIdToCell.put(1, new Cell(1, new HashSet(), CellState.QUARANTINED, 1, 4));
        originalCellIdToCell.put(2, new Cell(2, new HashSet<Integer>(Arrays.asList(3, 4)), CellState.EXCLUDED, 2, 4));
        CellImage originalImage = new CellImage(originalCellIdToCell, CellMigrationState.INACTIVE.code());
        List<ApiMessageAndVersion> records = CellImageTest.getImageRecords(originalImage);
        CellDelta cellDelta = new CellDelta(originalImage);
        RemoveCellRecord removeCellRecord = new RemoveCellRecord().setCellId(0);
        records.add(new ApiMessageAndVersion((ApiMessage)removeCellRecord, 0));
        cellDelta.replay(removeCellRecord);
        CellRecord cellRecord = new CellRecord().setCellId(1).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        cellRecord = new CellRecord().setCellId(3).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)2).setMaxSize((short)3);
        records.add(new ApiMessageAndVersion((ApiMessage)cellRecord, 0));
        cellDelta.replay(cellRecord);
        CellMigrationRecord cellMigrationRecord = new CellMigrationRecord().setState(CellMigrationState.INITIATED.code());
        records.add(new ApiMessageAndVersion((ApiMessage)cellMigrationRecord, 0));
        cellDelta.replay(cellMigrationRecord);
        RecordListWriter writer = new RecordListWriter();
        CellImage image = cellDelta.apply();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.IBP_3_7_IV2).build());
        HashSet<ApiMessageAndVersion> expectedBatch = new HashSet<ApiMessageAndVersion>(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(1).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(2).setBrokers(Arrays.asList(3, 4)).setState(CellState.EXCLUDED.code()).setMinSize((short)2).setMaxSize((short)4), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(3).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)2).setMaxSize((short)3), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellMigrationRecord().setState(CellMigrationState.INITIATED.code()), MetadataRecordType.CELL_MIGRATION_RECORD.lowestSupportedVersion())));
        Assertions.assertEquals(expectedBatch, new HashSet(writer.records()));
        CellImageTest.testToImage(image, Optional.of(records));
    }

    private static void testToImage(CellImage image) {
        CellImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(CellImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        CellImageTest.testToImage(image, fromRecords.orElseGet(() -> CellImageTest.getImageRecords(image)));
    }

    private static void testToImage(CellImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<CellDelta, CellImage>(() -> CellImage.EMPTY, CellDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(CellImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.latestTesting()).build());
        return writer.records();
    }
}

