/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.BrokerReplicaExclusionsDelta;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BrokerReplicaExclusionsImageTest {
    static final BrokerReplicaExclusionsImage IMAGE1;
    static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final BrokerReplicaExclusionsImage IMAGE2;
    static final BrokerReplicaExclusionsDelta DELTA1;

    @Test
    public void testEmptyImageRoundTrip() {
        BrokerReplicaExclusionsImageTest.testToImage(BrokerReplicaExclusionsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        BrokerReplicaExclusionsImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = BrokerReplicaExclusionsImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        BrokerReplicaExclusionsImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        BrokerReplicaExclusionsImageTest.testToImage(IMAGE2);
    }

    private static void testToImage(BrokerReplicaExclusionsImage image) {
        BrokerReplicaExclusionsImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(BrokerReplicaExclusionsImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        BrokerReplicaExclusionsImageTest.testToImage(image, fromRecords.orElseGet(() -> BrokerReplicaExclusionsImageTest.getImageRecords(image)));
    }

    private static void testToImage(BrokerReplicaExclusionsImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<BrokerReplicaExclusionsDelta, BrokerReplicaExclusionsImage>(() -> BrokerReplicaExclusionsImage.EMPTY, BrokerReplicaExclusionsDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(BrokerReplicaExclusionsImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.latestProduction()).build());
        return writer.records();
    }

    private static ApiMessageAndVersion record(Map<Integer, String> exclusions) {
        return new ApiMessageAndVersion((ApiMessage)new BrokerReplicaExclusionRecord().setBrokerExclusions(BrokerReplicaExclusionsImageTest.recordExclusions(exclusions)), MetadataRecordType.BROKER_REPLICA_EXCLUSION_RECORD.highestSupportedVersion());
    }

    private static List<BrokerReplicaExclusionRecord.BrokerReplicaExclusion> recordExclusions(Map<Integer, String> exclusions) {
        return exclusions.entrySet().stream().map(e -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(((Integer)e.getKey()).intValue()).setReason((String)e.getValue())).collect(Collectors.toList());
    }

    static {
        HashMap<Integer, String> map1 = new HashMap<Integer, String>();
        map1.put(1, "1");
        map1.put(2, "2");
        map1.put(3, "3");
        IMAGE1 = new BrokerReplicaExclusionsImage(map1);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(BrokerReplicaExclusionsImageTest.record(map1));
        map1.put(4, "4");
        DELTA1_RECORDS.add(BrokerReplicaExclusionsImageTest.record(map1));
        map1.put(5, "5");
        DELTA1_RECORDS.add(BrokerReplicaExclusionsImageTest.record(map1));
        map1.remove(2);
        DELTA1_RECORDS.add(BrokerReplicaExclusionsImageTest.record(map1));
        map1.remove(1);
        map1.remove(3);
        DELTA1_RECORDS.add(BrokerReplicaExclusionsImageTest.record(map1));
        DELTA1 = new BrokerReplicaExclusionsDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<Integer, String> finalMap = new HashMap<Integer, String>();
        finalMap.put(4, "4");
        finalMap.put(5, "5");
        IMAGE2 = new BrokerReplicaExclusionsImage(finalMap);
    }
}

