/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.controller.metrics.ControllerMetadataMetricsPublisher;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.ConfluentKeyValueStreamsImage;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.image.loader.SnapshotManifest;
import org.apache.kafka.image.writer.ImageReWriter;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;

public class ControllerMetadataMetricsPublisherTest {
    static final TopicsImage TOPICS_IMAGE1 = ControllerMetricsTestUtils.fakeTopicsImage(ControllerMetricsTestUtils.fakeTopicImage("foo", Uuid.fromString((String)"JKNp6fQaT-icHxh654ok-w"), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL)), ControllerMetricsTestUtils.fakeTopicImage("bar", Uuid.fromString((String)"pEMSdUVWTXaFQUzLTznFSw"), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER)), ControllerMetricsTestUtils.fakeTopicImage("quux", Uuid.fromString((String)"zkUT4lyyRke6VIaTw6RQWg"), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.OFFLINE), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.OFFLINE), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.OFFLINE)));
    static final MetadataImage IMAGE1 = ControllerMetadataMetricsPublisherTest.fakeImageFromTopicsImage(TOPICS_IMAGE1);

    @Test
    public void testMetricsBeforePublishing() {
        try (TestEnv env = new TestEnv();){
            Assertions.assertEquals((int)0, (int)env.metrics.activeBrokerCount());
            Assertions.assertEquals((int)0, (int)env.metrics.metadataErrorCount());
        }
    }

    static MetadataImage fakeImageFromTopicsImage(TopicsImage topicsImage) {
        return new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, topicsImage, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE, ConfluentKeyValueStreamsImage.EMPTY);
    }

    @Test
    public void testPublish() {
        try (TestEnv env = new TestEnv();){
            Assertions.assertEquals((int)0, (int)env.metrics.activeBrokerCount());
            Assertions.assertEquals((int)0, (int)env.metrics.metadataErrorCount());
        }
    }

    @Test
    public void testIncrementMetadataErroCount() {
        try (TestEnv env = new TestEnv();){
            Assertions.assertEquals((int)0, (int)env.metrics.metadataErrorCount());
            env.metrics.incrementMetadataErrorCount();
            Assertions.assertEquals((int)1, (int)env.metrics.metadataErrorCount());
        }
    }

    static LoaderManifest fakeManifest(boolean isSnapshot) {
        if (isSnapshot) {
            return new SnapshotManifest(MetadataProvenance.EMPTY, 0L);
        }
        return LogDeltaManifest.newBuilder().provenance(MetadataProvenance.EMPTY).leaderAndEpoch(LeaderAndEpoch.UNKNOWN).numBatches(0).elapsedNs(0L).numBytes(0L).build();
    }

    @Test
    public void testLoadSnapshot() {
        try (TestEnv env = new TestEnv();){
            MetadataDelta delta = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY).build();
            ImageReWriter writer = new ImageReWriter(delta);
            IMAGE1.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.MINIMUM_VERSION).build());
            env.publisher.onMetadataUpdate(delta, IMAGE1, ControllerMetadataMetricsPublisherTest.fakeManifest(true));
            Assertions.assertEquals((int)0, (int)env.metrics.activeBrokerCount());
            Assertions.assertEquals((int)0, (int)env.metrics.metadataErrorCount());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testExclusions(boolean loadSnapshot) {
        try (TestEnv env = new TestEnv();){
            Assertions.assertEquals((int)0, (int)env.metrics.excludedBrokerCount());
            MetadataDelta delta = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY).build();
            delta.replay(new BrokerReplicaExclusionRecord().setBrokerExclusions(Arrays.asList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(0).setReason("excluded"))));
            MetadataImage image2 = delta.apply(new MetadataProvenance(100L, 200, 300L, true));
            env.publisher.onMetadataUpdate(delta, image2, ControllerMetadataMetricsPublisherTest.fakeManifest(loadSnapshot));
            Assertions.assertEquals((int)0, (int)env.metrics.activeBrokerCount());
            Assertions.assertEquals((int)0, (int)env.metrics.metadataErrorCount());
            Assertions.assertEquals((int)0, (int)env.metrics.brokersWithDegradedHealthCount());
            Assertions.assertEquals((int)1, (int)env.metrics.excludedBrokerCount());
        }
    }

    @ParameterizedTest
    @CsvSource(value={"UNSPECIFIED,false", "UNSPECIFIED,true", "STORAGE,false", "STORAGE,true", "NETWORK,false", "NETWORK,true"})
    public void testDegradedBrokers(BrokerComponent component, boolean loadSnapshot) {
        try (TestEnv env = new TestEnv();){
            Assertions.assertEquals((int)0, (int)env.metrics.brokersWithDegradedHealthCount());
            Assertions.assertEquals((int)0, (int)env.metrics.brokersWithDegradedStorageCount());
            Assertions.assertEquals((int)0, (int)env.metrics.brokersWithDegradedNetworkCount());
            MetadataDelta delta = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY).build();
            delta.replay(new RegisterBrokerRecord().setBrokerId(0));
            BrokerRegistrationChangeRecord registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setDegradedComponents(Collections.singletonList(new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-123").setComponentCode(BrokerComponent.UNSPECIFIED.id())));
            delta.replay(registrationChangeRecord);
            delta.replay(new RegisterBrokerRecord().setBrokerId(1));
            registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(1).setDegradedComponents(Collections.singletonList(new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-234").setComponentCode(component.id())));
            delta.replay(registrationChangeRecord);
            MetadataImage image2 = delta.apply(new MetadataProvenance(100L, 200, 300L, true));
            env.publisher.onMetadataUpdate(delta, image2, ControllerMetadataMetricsPublisherTest.fakeManifest(loadSnapshot));
            Assertions.assertEquals((int)0, (int)env.metrics.activeBrokerCount());
            Assertions.assertEquals((int)0, (int)env.metrics.metadataErrorCount());
            Assertions.assertEquals((int)0, (int)env.metrics.excludedBrokerCount());
            if (component == BrokerComponent.UNSPECIFIED) {
                Assertions.assertEquals((int)2, (int)env.metrics.brokersWithDegradedHealthCount());
                Assertions.assertEquals((int)0, (int)env.metrics.brokersWithDegradedStorageCount());
                Assertions.assertEquals((int)0, (int)env.metrics.brokersWithDegradedNetworkCount());
            } else if (component == BrokerComponent.STORAGE) {
                Assertions.assertEquals((int)2, (int)env.metrics.brokersWithDegradedHealthCount());
                Assertions.assertEquals((int)1, (int)env.metrics.brokersWithDegradedStorageCount());
                Assertions.assertEquals((int)0, (int)env.metrics.brokersWithDegradedNetworkCount());
            } else if (component == BrokerComponent.NETWORK) {
                Assertions.assertEquals((int)2, (int)env.metrics.brokersWithDegradedHealthCount());
                Assertions.assertEquals((int)0, (int)env.metrics.brokersWithDegradedStorageCount());
                Assertions.assertEquals((int)1, (int)env.metrics.brokersWithDegradedNetworkCount());
            }
        }
    }

    static class TestEnv
    implements AutoCloseable {
        MockFaultHandler faultHandler = new MockFaultHandler("ControllerMetadataMetricsPublisher");
        ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.empty());
        ControllerMetadataMetricsPublisher publisher = new ControllerMetadataMetricsPublisher(this.metrics, (FaultHandler)this.faultHandler);

        TestEnv() {
        }

        @Override
        public void close() {
            this.publisher.close();
            this.faultHandler.maybeRethrowFirstException();
        }
    }
}

