/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.controller.metrics.ConfluentControllerMetrics;
import org.apache.kafka.controller.metrics.ConfluentControllerMetricsPublisher;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.image.loader.SnapshotManifest;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ConfluentControllerMetricsPublisherTest {
    public static final Function<String, String> TOPIC_NAME_TO_TENANT = input -> {
        if (!input.startsWith("lkc-")) {
            return null;
        }
        int underscoreIndex = input.indexOf("_");
        if (underscoreIndex < 0) {
            return null;
        }
        return input.substring(0, underscoreIndex);
    };
    private static final List<ApiMessageAndVersion> INITIAL_RECORDS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(MetadataVersion.IBP_3_7_IV3.confluentFeatureLevel()), 0));
    private static final List<ApiMessageAndVersion> BROKER_RECORDS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setIncarnationId(Uuid.fromString((String)"FXjVuJultw3kdl8FjC_-qQ")).setFenced(true), 3), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setIncarnationId(Uuid.fromString((String)"8i6bdaNRG3UOc2cHBgiWNQ")).setFenced(true), 3), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(2).setIncarnationId(Uuid.fromString((String)"JS00vZmC0AsP5146SUBMpA")).setFenced(false), 3), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(3).setIncarnationId(Uuid.fromString((String)"_e3w-SNs_zebc66SvAH3QQ")).setFenced(false), 3), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(4).setIncarnationId(Uuid.fromString((String)"xtHAxyhBZ66tg7UHPuPHJg")).setFenced(false), 3));
    private static final List<ApiMessageAndVersion> TOPIC_RECORDS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("lkc-a_topic00000").setTopicId(Uuid.fromString((String)"p6OA7NJPBtX_RB-8DL8SFA")), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(Uuid.fromString((String)"p6OA7NJPBtX_RB-8DL8SFA")).setReplicas(Arrays.asList(0, 1, 2)).setIsr(Arrays.asList(0, 1)).setLeader(0), 2), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(1).setTopicId(Uuid.fromString((String)"p6OA7NJPBtX_RB-8DL8SFA")).setReplicas(Arrays.asList(0, 1, 2)).setIsr(Arrays.asList(0, 1, 2)).setLeader(0), 2), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(2).setTopicId(Uuid.fromString((String)"p6OA7NJPBtX_RB-8DL8SFA")).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1)).setLeader(1), 2), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("lkc-b_topic00000").setTopicId(Uuid.fromString((String)"fwFCzQW_WI81qX_uyCh71g")), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(Uuid.fromString((String)"fwFCzQW_WI81qX_uyCh71g")).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1)).setLeader(-1), 2), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("lkc-b_topic00001").setTopicId(Uuid.fromString((String)"v7mJFvbIh0nwWf_zPlhykg")), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(Uuid.fromString((String)"v7mJFvbIh0nwWf_zPlhykg")).setReplicas(Arrays.asList(3, 2, 1)).setIsr(Arrays.asList(3, 2, 1)).setLeader(2), 2));
    private static final List<ApiMessageAndVersion> CONFIG_RECORDS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("1").setName("min.insync.replicas").setValue("1"), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("2").setName("min.insync.replicas").setValue("2"), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("lkc-b_topic00000").setName("min.insync.replicas").setValue("3"), 0));
    private static final List<ApiMessageAndVersion> EXTRA_TOPIC_CONFIG_RECORDS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("lkc-b_topic00000").setName("min.insync.replicas").setValue("1"), 0));
    private static final List<ApiMessageAndVersion> TOPIC_DELETION_RECORDS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(Uuid.fromString((String)"fwFCzQW_WI81qX_uyCh71g")), 0));
    private static final List<ApiMessageAndVersion> TOPIC_RECORDS_WITH_MIN_INSYNC_REPLICAS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("lkc-a_topic00001").setTopicId(Uuid.fromString((String)"Em0Aaf-NQg2LUV8vjWHv_w")), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(Uuid.fromString((String)"Em0Aaf-NQg2LUV8vjWHv_w")).setReplicas(Arrays.asList(1, 0, 2)).setIsr(Arrays.asList(0)).setLeader(0), 2), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("lkc-a_topic00001").setName("min.insync.replicas").setValue("1"), 0));

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testPublishEmptyImage(boolean snapshotLoad) throws InterruptedException {
        try (TestEnv testEnv = new TestEnv();){
            testEnv.onMetadataUpdate(snapshotLoad, Arrays.asList(INITIAL_RECORDS));
            testEnv.checkForEmptyMetrics();
            Assertions.assertEquals((long)1L, (long)testEnv.publisher.numSnapshotLoads());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testPublishEmptyImageTwice(boolean snapshotLoad) throws InterruptedException {
        try (TestEnv testEnv = new TestEnv();){
            testEnv.onMetadataUpdate(snapshotLoad, Arrays.asList(INITIAL_RECORDS));
            testEnv.checkForEmptyMetrics();
            Assertions.assertEquals((long)1L, (long)testEnv.publisher.numSnapshotLoads());
            testEnv.onMetadataUpdate(snapshotLoad, Arrays.asList(INITIAL_RECORDS));
            testEnv.checkForEmptyMetrics();
            if (snapshotLoad) {
                Assertions.assertEquals((long)2L, (long)testEnv.publisher.numSnapshotLoads());
            } else {
                Assertions.assertEquals((long)1L, (long)testEnv.publisher.numSnapshotLoads());
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testPublishImage(boolean snapshotLoad) throws InterruptedException {
        try (TestEnv testEnv = new TestEnv();){
            if (snapshotLoad) {
                testEnv.onMetadataUpdate(snapshotLoad, Arrays.asList(INITIAL_RECORDS));
            }
            testEnv.onMetadataUpdate(snapshotLoad, Arrays.asList(INITIAL_RECORDS, BROKER_RECORDS, TOPIC_RECORDS));
            if (snapshotLoad) {
                Assertions.assertEquals((long)2L, (long)testEnv.publisher.numSnapshotLoads());
            } else {
                Assertions.assertEquals((long)1L, (long)testEnv.publisher.numSnapshotLoads());
            }
            Assertions.assertEquals((int)3, (int)testEnv.metrics.globalTopicCount());
            Assertions.assertEquals((int)5, (int)testEnv.metrics.globalPartitionCount());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.globalOfflinePartitionCount());
            Assertions.assertEquals((int)2, (int)testEnv.metrics.globalUnderMinIsrCount());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.preferredReplicaImbalanceCount());
            Assertions.assertEquals((double)0.6, (double)testEnv.metrics.globalPartitionAvailability());
            Assertions.assertEquals((Object)new ConfluentControllerMetrics.TenantPartitionMetrics(3, 1), (Object)testEnv.metrics.tenantPartitionMetrics("lkc-a"));
            Assertions.assertEquals((Object)new ConfluentControllerMetrics.TenantPartitionMetrics(2, 1), (Object)testEnv.metrics.tenantPartitionMetrics("lkc-b"));
            Assertions.assertEquals((Object)new ConfluentControllerMetrics.TenantPartitionMetrics(0, 0), (Object)testEnv.metrics.tenantPartitionMetrics("lkc-c"));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testPublishImageWithConfigs(boolean snapshotLoad) throws InterruptedException {
        try (TestEnv testEnv = new TestEnv();){
            testEnv.onMetadataUpdate(snapshotLoad, Arrays.asList(INITIAL_RECORDS));
            testEnv.onMetadataUpdate(snapshotLoad, Arrays.asList(INITIAL_RECORDS, BROKER_RECORDS, TOPIC_RECORDS, CONFIG_RECORDS));
            Assertions.assertEquals((long)2L, (long)testEnv.publisher.numSnapshotLoads());
            Assertions.assertEquals((int)3, (int)testEnv.metrics.globalTopicCount());
            Assertions.assertEquals((int)5, (int)testEnv.metrics.globalPartitionCount());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.globalOfflinePartitionCount());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.globalUnderMinIsrCount());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.preferredReplicaImbalanceCount());
            Assertions.assertEquals((double)0.8, (double)testEnv.metrics.globalPartitionAvailability());
            Assertions.assertEquals((Object)new ConfluentControllerMetrics.TenantPartitionMetrics(3, 0), (Object)testEnv.metrics.tenantPartitionMetrics("lkc-a"));
            Assertions.assertEquals((Object)new ConfluentControllerMetrics.TenantPartitionMetrics(2, 1), (Object)testEnv.metrics.tenantPartitionMetrics("lkc-b"));
            Assertions.assertEquals((Object)new ConfluentControllerMetrics.TenantPartitionMetrics(0, 0), (Object)testEnv.metrics.tenantPartitionMetrics("lkc-c"));
        }
    }

    @Test
    public void testPublishImageWithExtraTopicConfigs() throws InterruptedException {
        try (TestEnv testEnv = new TestEnv();){
            testEnv.onMetadataUpdate(true, Arrays.asList(INITIAL_RECORDS, BROKER_RECORDS, TOPIC_RECORDS, CONFIG_RECORDS));
            testEnv.onMetadataUpdate(false, Arrays.asList(EXTRA_TOPIC_CONFIG_RECORDS));
            Assertions.assertEquals((long)1L, (long)testEnv.publisher.numSnapshotLoads());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.globalOfflinePartitionCount());
            Assertions.assertEquals((int)0, (int)testEnv.metrics.globalUnderMinIsrCount());
            Assertions.assertEquals((Object)new ConfluentControllerMetrics.TenantPartitionMetrics(2, 1), (Object)testEnv.metrics.tenantPartitionMetrics("lkc-b"));
        }
    }

    @Test
    public void testPublishImageWithTopicDeletions() throws InterruptedException {
        try (TestEnv testEnv = new TestEnv();){
            testEnv.onMetadataUpdate(true, Arrays.asList(INITIAL_RECORDS, BROKER_RECORDS, TOPIC_RECORDS, CONFIG_RECORDS));
            testEnv.onMetadataUpdate(false, Arrays.asList(TOPIC_DELETION_RECORDS));
            Assertions.assertEquals((long)1L, (long)testEnv.publisher.numSnapshotLoads());
            Assertions.assertEquals((int)0, (int)testEnv.metrics.globalUnderMinIsrCount());
            Assertions.assertEquals((Object)new ConfluentControllerMetrics.TenantPartitionMetrics(1, 0), (Object)testEnv.metrics.tenantPartitionMetrics("lkc-b"));
        }
    }

    @Test
    public void testPublishDeltaWithNewTopicWithMinInSyncReplicas() throws InterruptedException {
        try (TestEnv testEnv = new TestEnv();){
            testEnv.onMetadataUpdate(true, Arrays.asList(INITIAL_RECORDS, BROKER_RECORDS, TOPIC_RECORDS, CONFIG_RECORDS));
            Assertions.assertEquals((long)1L, (long)testEnv.publisher.numSnapshotLoads());
            Assertions.assertEquals((int)3, (int)testEnv.metrics.globalTopicCount());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.globalOfflinePartitionCount());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.globalUnderMinIsrCount());
            Assertions.assertEquals((Object)new ConfluentControllerMetrics.TenantPartitionMetrics(3, 0), (Object)testEnv.metrics.tenantPartitionMetrics("lkc-a"));
            Assertions.assertEquals((int)3, (int)testEnv.metrics.globalTopicCount());
            testEnv.onMetadataUpdate(false, Arrays.asList(TOPIC_RECORDS_WITH_MIN_INSYNC_REPLICAS));
            Assertions.assertEquals((int)4, (int)testEnv.metrics.globalTopicCount());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.globalOfflinePartitionCount());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.globalUnderMinIsrCount());
            Assertions.assertEquals((Object)new ConfluentControllerMetrics.TenantPartitionMetrics(4, 0), (Object)testEnv.metrics.tenantPartitionMetrics("lkc-a"));
        }
    }

    static class TestEnv
    implements AutoCloseable {
        final ConfluentControllerMetrics metrics;
        final MockFaultHandler faultHandler;
        final ConfluentControllerMetricsPublisher publisher;
        MetadataImage prevImage = MetadataImage.EMPTY;

        TestEnv() {
            this.metrics = new ConfluentControllerMetrics(Optional.empty());
            this.faultHandler = new MockFaultHandler("ConfluentControllerMetricsPublisher");
            this.publisher = new ConfluentControllerMetricsPublisher(this.metrics, (FaultHandler)this.faultHandler, TOPIC_NAME_TO_TENANT, 1, 2);
        }

        void onMetadataUpdate(boolean snapshotLoad, List<List<ApiMessageAndVersion>> recordLists) {
            MetadataDelta delta = new MetadataDelta.Builder().setImage(this.prevImage).setNameToTenantCallback(TOPIC_NAME_TO_TENANT).build();
            for (List<ApiMessageAndVersion> recordList : recordLists) {
                recordList.forEach(record -> delta.replay(record.message(), record.version()));
            }
            MetadataImage newImage = delta.apply(MetadataProvenance.EMPTY);
            Object manifest = snapshotLoad ? new SnapshotManifest(newImage.provenance(), 0L) : LogDeltaManifest.newBuilder().provenance(newImage.provenance()).leaderAndEpoch(LeaderAndEpoch.UNKNOWN).numBatches(1).numBytes(10000L).elapsedNs(1000L).build();
            this.publisher.onMetadataUpdate(delta, newImage, (LoaderManifest)manifest);
            this.prevImage = newImage;
        }

        private void checkForEmptyMetrics() {
            Assertions.assertEquals((int)0, (int)this.metrics.globalTopicCount());
            Assertions.assertEquals((int)0, (int)this.metrics.globalPartitionCount());
            Assertions.assertEquals((int)0, (int)this.metrics.globalOfflinePartitionCount());
            Assertions.assertEquals((int)0, (int)this.metrics.globalUnderMinIsrCount());
            Assertions.assertEquals((int)0, (int)this.metrics.preferredReplicaImbalanceCount());
            Assertions.assertEquals((double)1.0, (double)this.metrics.globalPartitionAvailability());
        }

        @Override
        public void close() throws InterruptedException {
            this.publisher.close();
        }
    }
}

