/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.kafka.controller.metrics.CellControllerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CellControllerMetricsTest {
    private static final Map<Integer, CellControllerMetrics.CellMetrics> TEST_CELL_METRICS_MAP;

    public static void assertMetricsForTypeEqual(MetricsRegistry registry, String expectedPrefix, Set<String> expected) {
        TreeSet actual = new TreeSet();
        registry.allMetrics().forEach((name, __) -> {
            StringBuilder bld = new StringBuilder();
            bld.append(name.getGroup());
            bld.append(":type=").append(name.getType());
            bld.append(",name=").append(name.getName());
            if (name.hasScope()) {
                bld.append(",scope=").append(name.getScope());
            }
            if (bld.toString().startsWith(expectedPrefix)) {
                actual.add(bld.toString());
            }
        });
        Assertions.assertEquals(new TreeSet<String>(expected), actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricNames() {
        MetricsRegistry registry = new MetricsRegistry();
        try {
            try (CellControllerMetrics metrics = new CellControllerMetrics(Optional.of(registry));){
                CellControllerMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", Collections.emptySet());
                metrics.createCellMetricsIfNeeded();
                HashSet<String> expected = new HashSet<String>(Arrays.asList("kafka.controller:type=KafkaController,name=ReadyCellCount", "kafka.controller:type=KafkaController,name=QuarantinedCellCount", "kafka.controller:type=KafkaController,name=ExcludedCellCount", "kafka.controller:type=KafkaController,name=NotTenantAssignableCellCount", "kafka.controller:type=KafkaController,name=StrayBrokerCount", "kafka.controller:type=KafkaController,name=CellMigrationState"));
                CellControllerMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", expected);
            }
            CellControllerMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", Collections.emptySet());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerCellMetricNames() {
        MetricsRegistry registry = new MetricsRegistry();
        try {
            try (CellControllerMetrics metrics = new CellControllerMetrics(Optional.of(registry));){
                CellControllerMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", Collections.emptySet());
                metrics.setCellMetrics(TEST_CELL_METRICS_MAP);
                HashSet<String> expected = new HashSet<String>(Arrays.asList("kafka.controller:type=KafkaController,name=BrokerCount,scope=cellId.0", "kafka.controller:type=KafkaController,name=BrokerCount,scope=cellId.1", "kafka.controller:type=KafkaController,name=IncomingTenantCount,scope=cellId.0", "kafka.controller:type=KafkaController,name=IncomingTenantCount,scope=cellId.1", "kafka.controller:type=KafkaController,name=OutgoingTenantCount,scope=cellId.0", "kafka.controller:type=KafkaController,name=OutgoingTenantCount,scope=cellId.1", "kafka.controller:type=KafkaController,name=ReplicaCount,scope=cellId.0", "kafka.controller:type=KafkaController,name=ReplicaCount,scope=cellId.1", "kafka.controller:type=KafkaController,name=TenantCount,scope=cellId.0", "kafka.controller:type=KafkaController,name=TenantCount,scope=cellId.1"));
                CellControllerMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", expected);
            }
            CellControllerMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", Collections.emptySet());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIntGaugeMetric(Function<CellControllerMetrics, Integer> metricsGetter, Function<MetricsRegistry, Integer> registryGetter, BiConsumer<CellControllerMetrics, Integer> setter) {
        MetricsRegistry registry = new MetricsRegistry();
        try (CellControllerMetrics metrics = new CellControllerMetrics(Optional.of(registry));){
            metrics.createCellMetricsIfNeeded();
            Assertions.assertEquals((int)0, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)0, (Integer)registryGetter.apply(registry));
            setter.accept(metrics, 123);
            Assertions.assertEquals((int)123, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)123, (Integer)registryGetter.apply(registry));
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testByteGaugeMetric(Function<CellControllerMetrics, Byte> metricsGetter, Function<MetricsRegistry, Byte> registryGetter, BiConsumer<CellControllerMetrics, Byte> setter) {
        MetricsRegistry registry = new MetricsRegistry();
        try (CellControllerMetrics metrics = new CellControllerMetrics(Optional.of(registry));){
            metrics.createCellMetricsIfNeeded();
            Assertions.assertEquals((byte)0, (Byte)metricsGetter.apply(metrics));
            Assertions.assertEquals((byte)0, (Byte)registryGetter.apply(registry));
            setter.accept(metrics, (byte)123);
            Assertions.assertEquals((byte)123, (Byte)metricsGetter.apply(metrics));
            Assertions.assertEquals((byte)123, (Byte)registryGetter.apply(registry));
        }
        finally {
            registry.shutdown();
        }
    }

    @Test
    public void testReadyCellCount() {
        this.testIntGaugeMetric(m -> m.readyCellCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(CellControllerMetricsTest.metricName("KafkaController", "ReadyCellCount"))).value(), (m, v) -> m.setReadyCellCount(v.intValue()));
    }

    @Test
    public void testQuarantinedCellCount() {
        this.testIntGaugeMetric(m -> m.quarantinedCellCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(CellControllerMetricsTest.metricName("KafkaController", "QuarantinedCellCount"))).value(), (m, v) -> m.setQuarantinedCellCount(v.intValue()));
    }

    @Test
    public void testExcludedCellCount() {
        this.testIntGaugeMetric(m -> m.excludedCellCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(CellControllerMetricsTest.metricName("KafkaController", "ExcludedCellCount"))).value(), (m, v) -> m.setExcludedCellCount(v.intValue()));
    }

    @Test
    public void testNotTenantAssignableCellCount() {
        this.testIntGaugeMetric(m -> m.notTenantAssignableCellCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(CellControllerMetricsTest.metricName("KafkaController", "NotTenantAssignableCellCount"))).value(), (m, v) -> m.setNotTenantAssignableCellCount(v.intValue()));
    }

    @Test
    public void testStrayBrokerCount() {
        this.testIntGaugeMetric(m -> m.strayBrokerCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(CellControllerMetricsTest.metricName("KafkaController", "StrayBrokerCount"))).value(), (m, v) -> m.setStrayBrokerCount(v.intValue()));
    }

    @Test
    public void testCellMigrationState() {
        this.testByteGaugeMetric(m -> m.cellMigrationState(), registry -> (Byte)((Gauge)registry.allMetrics().get(CellControllerMetricsTest.metricName("KafkaController", "CellMigrationState"))).value(), (m, v) -> m.setCellMigrationState(v.byteValue()));
    }

    @Test
    public void testPerCellBrokerCount() {
        MetricsRegistry registry = new MetricsRegistry();
        try (CellControllerMetrics metrics = new CellControllerMetrics(Optional.of(registry));){
            metrics.setCellMetrics(TEST_CELL_METRICS_MAP);
            Assertions.assertEquals((int)10, (Integer)((Integer)((Gauge)registry.allMetrics().get(CellControllerMetrics.cellMetricName((int)0, (String)"BrokerCount"))).value()));
        }
    }

    @Test
    public void testPerCellIncomingTenantCount() {
        MetricsRegistry registry = new MetricsRegistry();
        try (CellControllerMetrics metrics = new CellControllerMetrics(Optional.of(registry));){
            metrics.setCellMetrics(TEST_CELL_METRICS_MAP);
            Assertions.assertEquals((int)1, (Integer)((Integer)((Gauge)registry.allMetrics().get(CellControllerMetrics.cellMetricName((int)1, (String)"IncomingTenantCount"))).value()));
        }
    }

    @Test
    public void testPerCellOutgoingTenantCount() {
        MetricsRegistry registry = new MetricsRegistry();
        try (CellControllerMetrics metrics = new CellControllerMetrics(Optional.of(registry));){
            metrics.setCellMetrics(TEST_CELL_METRICS_MAP);
            Assertions.assertEquals((int)0, (Integer)((Integer)((Gauge)registry.allMetrics().get(CellControllerMetrics.cellMetricName((int)1, (String)"OutgoingTenantCount"))).value()));
        }
    }

    @Test
    public void testPerCellReplicaCount() {
        MetricsRegistry registry = new MetricsRegistry();
        try (CellControllerMetrics metrics = new CellControllerMetrics(Optional.of(registry));){
            metrics.setCellMetrics(TEST_CELL_METRICS_MAP);
            Assertions.assertEquals((int)910, (Integer)((Integer)((Gauge)registry.allMetrics().get(CellControllerMetrics.cellMetricName((int)1, (String)"ReplicaCount"))).value()));
        }
    }

    @Test
    public void testPerCellTenantCount() {
        MetricsRegistry registry = new MetricsRegistry();
        try (CellControllerMetrics metrics = new CellControllerMetrics(Optional.of(registry));){
            metrics.setCellMetrics(TEST_CELL_METRICS_MAP);
            Assertions.assertEquals((int)1, (Integer)((Integer)((Gauge)registry.allMetrics().get(CellControllerMetrics.cellMetricName((int)1, (String)"IncomingTenantCount"))).value()));
        }
    }

    private static MetricName metricName(String type, String name) {
        String mBeanName = String.format("kafka.controller:type=%s,name=%s", type, name);
        return new MetricName("kafka.controller", type, name, null, mBeanName);
    }

    static {
        HashMap<Integer, CellControllerMetrics.CellMetrics> newCellMetricsMap = new HashMap<Integer, CellControllerMetrics.CellMetrics>();
        newCellMetricsMap.put(0, new CellControllerMetrics.CellMetrics(3, 300, new HashSet<String>(Arrays.asList("foo", "bar")), new HashSet<String>(Arrays.asList("baaz")), 10));
        newCellMetricsMap.put(1, new CellControllerMetrics.CellMetrics(5, 910, new HashSet<String>(Arrays.asList("baaz")), new HashSet<String>(Arrays.asList(new String[0])), 10));
        TEST_CELL_METRICS_MAP = Collections.unmodifiableMap(newCellMetricsMap);
    }
}

