/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.CellMigrationRecord;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TenantRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.CellControllerMetrics;
import org.apache.kafka.controller.metrics.CellControllerMetricsPublisher;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.SnapshotManifest;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CellControllerMetricsPublisherTest {
    public static final Function<String, String> TOPIC_NAME_TO_TENANT = input -> {
        if (!input.startsWith("lkc-")) {
            return null;
        }
        int underscoreIndex = input.indexOf("_");
        if (underscoreIndex < 0) {
            return null;
        }
        return input.substring(0, underscoreIndex);
    };
    private static final List<ApiMessageAndVersion> BRROKER_RECORDS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setIncarnationId(Uuid.fromString((String)"FXjVuJultw3kdl8FjC_-qQ")).setFenced(true), 3), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setIncarnationId(Uuid.fromString((String)"8i6bdaNRG3UOc2cHBgiWNQ")).setFenced(true), 3), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(2).setIncarnationId(Uuid.fromString((String)"JS00vZmC0AsP5146SUBMpA")).setFenced(false), 3), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(3).setIncarnationId(Uuid.fromString((String)"_e3w-SNs_zebc66SvAH3QQ")).setFenced(false), 3), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(4).setIncarnationId(Uuid.fromString((String)"xtHAxyhBZ66tg7UHPuPHJg")).setFenced(false), 3));
    private static final List<ApiMessageAndVersion> CELL_RECORDS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setMinSize((short)2).setMaxSize((short)2).setBrokers(Arrays.asList(0, 1)), 0), new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(1).setMinSize((short)2).setMaxSize((short)2).setBrokers(Arrays.asList(2, 3)), 0), new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(2).setMinSize((short)1).setMaxSize((short)1).setBrokers(Arrays.asList(4)), 0));
    private static final List<ApiMessageAndVersion> TENANT_RECORDS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TenantRecord().setCellIds(Collections.singletonList(0)).setTenantId("lkc-a"), 0), new ApiMessageAndVersion((ApiMessage)new TenantRecord().setCellIds(Collections.singletonList(1)).setTenantId("lkc-b"), 0), new ApiMessageAndVersion((ApiMessage)new TenantRecord().setCellIds(Collections.singletonList(1)).setTenantId("lkc-c"), 0), new ApiMessageAndVersion((ApiMessage)new TenantRecord().setCellIds(Collections.singletonList(2)).setTenantId("lkc-d"), 0));
    private static final List<ApiMessageAndVersion> TENANT_RECORDS_WITH_MULTIPLE_CELLS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TenantRecord().setCellIds(Arrays.asList(0, 1)).setTenantId("lkc-a"), 0), new ApiMessageAndVersion((ApiMessage)new TenantRecord().setCellIds(Arrays.asList(0, 1)).setTenantId("lkc-b"), 0), new ApiMessageAndVersion((ApiMessage)new TenantRecord().setCellIds(Arrays.asList(1, 2)).setTenantId("lkc-c"), 0), new ApiMessageAndVersion((ApiMessage)new TenantRecord().setCellIds(Arrays.asList(1, 2)).setTenantId("lkc-d"), 0));
    private static final List<ApiMessageAndVersion> TOPIC_RECORDS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("lkc-a_topic00000").setTopicId(Uuid.fromString((String)"p6OA7NJPBtX_RB-8DL8SFA")), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(Uuid.fromString((String)"p6OA7NJPBtX_RB-8DL8SFA")).setReplicas(Arrays.asList(0, 1)).setIsr(Arrays.asList(0, 1)), 2), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(1).setTopicId(Uuid.fromString((String)"p6OA7NJPBtX_RB-8DL8SFA")).setReplicas(Arrays.asList(1, 0)).setIsr(Arrays.asList(1, 0)), 2), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("lkc-b_topic00000").setTopicId(Uuid.fromString((String)"fwFCzQW_WI81qX_uyCh71g")), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(Uuid.fromString((String)"fwFCzQW_WI81qX_uyCh71g")).setReplicas(Arrays.asList(2, 3)).setIsr(Arrays.asList(2, 3)), 2), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("lkc-b_topic00001").setTopicId(Uuid.fromString((String)"v7mJFvbIh0nwWf_zPlhykg")), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(Uuid.fromString((String)"v7mJFvbIh0nwWf_zPlhykg")).setReplicas(Arrays.asList(3, 2)).setIsr(Arrays.asList(3, 2)), 2), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("lkc-c_topic00000").setTopicId(Uuid.fromString((String)"lMSSCnh_jyYhQAiAQf1BFA")), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(Uuid.fromString((String)"lMSSCnh_jyYhQAiAQf1BFA")).setReplicas(Arrays.asList(3, 4)).setIsr(Arrays.asList(3, 4)), 2));

    static MetadataDelta recordsToDelta(List<ApiMessageAndVersion> records) {
        MetadataDelta delta = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY).setNameToTenantCallback(TOPIC_NAME_TO_TENANT).build();
        return delta;
    }

    static MetadataImage recordsToImage(List<ApiMessageAndVersion> records) {
        MetadataDelta delta = CellControllerMetricsPublisherTest.recordsToDelta(records);
        records.forEach(record -> delta.replay(record.message(), record.version()));
        return delta.apply(MetadataProvenance.EMPTY);
    }

    @Test
    public void testPublishWithoutCells() throws InterruptedException {
        try (TestEnv testEnv = new TestEnv();){
            testEnv.publisher.publishImage(0L, MetadataImage.EMPTY);
            Assertions.assertFalse((boolean)testEnv.metrics.cellMetricsCreated());
        }
    }

    @Test
    public void testPeriodicPublish() throws InterruptedException {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.addAll(BRROKER_RECORDS);
        records.addAll(CELL_RECORDS);
        try (TestEnv testEnv = new TestEnv(TimeUnit.MICROSECONDS.toNanos(1L));){
            testEnv.publisher.onMetadataUpdate(CellControllerMetricsPublisherTest.recordsToDelta(records), CellControllerMetricsPublisherTest.recordsToImage(records), (LoaderManifest)new SnapshotManifest(MetadataProvenance.EMPTY, 0L));
            TestUtils.waitForCondition(() -> testEnv.publisher.numPublishes() > 10L, (String)"Waiting for 10 publishes.");
            Assertions.assertTrue((boolean)testEnv.metrics.cellMetricsCreated());
        }
    }

    @Test
    public void testPublishWithExcludedAndQuarantinedCells() throws InterruptedException {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.addAll(BRROKER_RECORDS);
        records.add(new ApiMessageAndVersion((ApiMessage)((CellRecord)CELL_RECORDS.get(0).message().duplicate()).setState(CellState.EXCLUDED.code()), 0));
        records.add(new ApiMessageAndVersion((ApiMessage)((CellRecord)CELL_RECORDS.get(1).message().duplicate()).setState(CellState.QUARANTINED.code()), 0));
        records.add(new ApiMessageAndVersion((ApiMessage)((CellRecord)CELL_RECORDS.get(2).message().duplicate()).setState(CellState.QUARANTINED.code()), 0));
        records.add(new ApiMessageAndVersion((ApiMessage)new CellMigrationRecord().setState(CellMigrationState.PAUSED.code()), 0));
        try (TestEnv testEnv = new TestEnv();){
            testEnv.publisher.publishImage(0L, CellControllerMetricsPublisherTest.recordsToImage(records));
            Assertions.assertTrue((boolean)testEnv.metrics.cellMetricsCreated());
            Assertions.assertEquals((int)0, (int)testEnv.metrics.readyCellCount());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.excludedCellCount());
            Assertions.assertEquals((int)2, (int)testEnv.metrics.quarantinedCellCount());
            Assertions.assertEquals((byte)CellMigrationState.PAUSED.code(), (byte)testEnv.metrics.cellMigrationState());
        }
    }

    @Test
    public void testPublishWithStrayBrokers() throws InterruptedException {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.addAll(BRROKER_RECORDS);
        records.add(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(5).setIncarnationId(Uuid.fromString((String)"Ao5M5_nX42yOp8-S9WbhcA")).setFenced(false), 3));
        records.addAll(CELL_RECORDS);
        try (TestEnv testEnv = new TestEnv();){
            testEnv.publisher.publishImage(0L, CellControllerMetricsPublisherTest.recordsToImage(records));
            Assertions.assertTrue((boolean)testEnv.metrics.cellMetricsCreated());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.strayBrokerCount());
            Assertions.assertEquals((int)1, (int)testEnv.metrics.notTenantAssignableCellCount());
            Assertions.assertEquals((byte)CellMigrationState.INACTIVE.code(), (byte)testEnv.metrics.cellMigrationState());
        }
    }

    @Test
    public void testPublishPerTenantMetrics() throws InterruptedException {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.addAll(BRROKER_RECORDS);
        records.addAll(CELL_RECORDS);
        records.addAll(TENANT_RECORDS);
        records.addAll(TOPIC_RECORDS);
        try (TestEnv testEnv = new TestEnv();){
            testEnv.publisher.publishImage(0L, CellControllerMetricsPublisherTest.recordsToImage(records));
            Assertions.assertTrue((boolean)testEnv.metrics.cellMetricsCreated());
            Assertions.assertEquals((Object)new CellControllerMetrics.CellMetrics(1, 4, Collections.emptySet(), Collections.emptySet(), 2), (Object)testEnv.metrics.cellMetrics(0));
            Assertions.assertEquals((Object)new CellControllerMetrics.CellMetrics(2, 5, new HashSet<String>(Arrays.asList("lkc-c")), Collections.emptySet(), 2), (Object)testEnv.metrics.cellMetrics(1));
            Assertions.assertEquals((Object)new CellControllerMetrics.CellMetrics(1, 1, Collections.emptySet(), new HashSet<String>(Arrays.asList("lkc-c")), 1), (Object)testEnv.metrics.cellMetrics(2));
            Assertions.assertEquals((Object)new CellControllerMetrics.CellMetrics(), (Object)testEnv.metrics.cellMetrics(3));
        }
    }

    @Test
    public void testPublishPerTenantMetricsWithMultipleCells() throws InterruptedException {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.addAll(BRROKER_RECORDS);
        records.addAll(CELL_RECORDS);
        records.addAll(TENANT_RECORDS_WITH_MULTIPLE_CELLS);
        records.addAll(TOPIC_RECORDS);
        try (TestEnv testEnv = new TestEnv();){
            testEnv.publisher.publishImage(0L, CellControllerMetricsPublisherTest.recordsToImage(records));
            Assertions.assertTrue((boolean)testEnv.metrics.cellMetricsCreated());
            Assertions.assertEquals((Object)new CellControllerMetrics.CellMetrics(2, 4, new HashSet(Collections.emptyList()), Collections.emptySet(), 2), (Object)testEnv.metrics.cellMetrics(0));
            Assertions.assertEquals((Object)new CellControllerMetrics.CellMetrics(4, 5, new HashSet<String>(Arrays.asList("lkc-a")), Collections.emptySet(), 2), (Object)testEnv.metrics.cellMetrics(1));
            Assertions.assertEquals((Object)new CellControllerMetrics.CellMetrics(2, 1, Collections.emptySet(), Collections.emptySet(), 1), (Object)testEnv.metrics.cellMetrics(2));
            Assertions.assertEquals((Object)new CellControllerMetrics.CellMetrics(), (Object)testEnv.metrics.cellMetrics(3));
        }
    }

    @Test
    public void testIncomingTenantMetricsWithMultipleCellsForSinglePartitionTopics() throws InterruptedException {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.addAll(BRROKER_RECORDS);
        records.addAll(CELL_RECORDS);
        records.addAll(TENANT_RECORDS_WITH_MULTIPLE_CELLS);
        records.addAll(TOPIC_RECORDS);
        try (TestEnv testEnv = new TestEnv();){
            testEnv.publisher.publishImage(0L, CellControllerMetricsPublisherTest.recordsToImage(records));
            Assertions.assertTrue((boolean)testEnv.metrics.cellMetricsCreated());
            Assertions.assertEquals((Object)new CellControllerMetrics.CellMetrics(2, 4, new HashSet(Collections.emptyList()), Collections.emptySet(), 2), (Object)testEnv.metrics.cellMetrics(0));
        }
    }

    @Test
    public void testIncomingTenantMetricsWithMultipleCellsForMultiPartitionTopics() throws InterruptedException {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.addAll(BRROKER_RECORDS);
        records.addAll(CELL_RECORDS);
        records.addAll(TENANT_RECORDS_WITH_MULTIPLE_CELLS);
        records.addAll(TOPIC_RECORDS);
        try (TestEnv testEnv = new TestEnv();){
            testEnv.publisher.publishImage(0L, CellControllerMetricsPublisherTest.recordsToImage(records));
            Assertions.assertTrue((boolean)testEnv.metrics.cellMetricsCreated());
            Assertions.assertEquals((Object)new CellControllerMetrics.CellMetrics(4, 5, new HashSet<String>(Arrays.asList("lkc-a")), Collections.emptySet(), 2), (Object)testEnv.metrics.cellMetrics(1));
        }
    }

    static class TestEnv
    implements AutoCloseable {
        final CellControllerMetrics metrics = new CellControllerMetrics(Optional.empty());
        final CellControllerMetricsPublisher publisher;

        TestEnv() {
            this(TimeUnit.DAYS.toNanos(1L));
        }

        TestEnv(long updatePeriodNs) {
            this.publisher = new CellControllerMetricsPublisher(this.metrics, TOPIC_NAME_TO_TENANT, Time.SYSTEM, 1, updatePeriodNs);
        }

        @Override
        public void close() throws InterruptedException {
            this.publisher.close();
        }
    }
}

