/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import org.apache.kafka.controller.ScramControlManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScramCredentialValueTest {
    @Test
    public void testEqualsAndHashCode() {
        byte[] salt1 = new byte[]{1, 2, 3};
        byte[] storedKey1 = new byte[]{4, 5, 6};
        byte[] serverKey1 = new byte[]{7, 8, 9};
        int iterations1 = 1000;
        byte[] salt2 = new byte[]{1, 2, 3};
        byte[] storedKey2 = new byte[]{4, 5, 6};
        byte[] serverKey2 = new byte[]{7, 8, 9};
        int iterations2 = 1000;
        ScramControlManager.ScramCredentialValue credential1 = new ScramControlManager.ScramCredentialValue(salt1, storedKey1, serverKey1, iterations1);
        ScramControlManager.ScramCredentialValue credential2 = new ScramControlManager.ScramCredentialValue(salt2, storedKey2, serverKey2, iterations2);
        Assertions.assertEquals((Object)credential1, (Object)credential2);
        Assertions.assertEquals((int)credential1.hashCode(), (int)credential2.hashCode());
    }

    @Test
    public void testNotEqualsDifferentContent() {
        byte[] salt1 = new byte[]{1, 2, 3};
        byte[] storedKey1 = new byte[]{4, 5, 6};
        byte[] serverKey1 = new byte[]{7, 8, 9};
        int iterations1 = 1000;
        byte[] salt2 = new byte[]{9, 8, 7};
        byte[] storedKey2 = new byte[]{6, 5, 4};
        byte[] serverKey2 = new byte[]{3, 2, 1};
        int iterations2 = 2000;
        ScramControlManager.ScramCredentialValue credential1 = new ScramControlManager.ScramCredentialValue(salt1, storedKey1, serverKey1, iterations1);
        ScramControlManager.ScramCredentialValue credential2 = new ScramControlManager.ScramCredentialValue(salt2, storedKey2, serverKey2, iterations2);
        Assertions.assertNotEquals((Object)credential1, (Object)credential2);
        Assertions.assertNotEquals((int)credential1.hashCode(), (int)credential2.hashCode());
    }

    @Test
    public void testEqualsSameInstance() {
        byte[] salt = new byte[]{1, 2, 3};
        byte[] storedKey = new byte[]{4, 5, 6};
        byte[] serverKey = new byte[]{7, 8, 9};
        int iterations = 1000;
        ScramControlManager.ScramCredentialValue credential = new ScramControlManager.ScramCredentialValue(salt, storedKey, serverKey, iterations);
        Assertions.assertEquals((Object)credential, (Object)credential);
        Assertions.assertEquals((int)credential.hashCode(), (int)credential.hashCode());
    }
}

