/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class QuorumFeaturesTest {
    private static final Map<String, VersionRange> LOCAL = Map.of("foo", VersionRange.of((int)0, (int)3), "bar", VersionRange.of((int)0, (int)4), "baz", VersionRange.of((int)2, (int)2));
    private static final QuorumFeatures QUORUM_FEATURES = new QuorumFeatures(0, LOCAL, Arrays.asList(0, 1, 2));

    @Test
    public void testDefaultFeatureMap() {
        HashMap<String, VersionRange> expectedFeatures = new HashMap<String, VersionRange>(1);
        expectedFeatures.put("confluent.metadata.version", VersionRange.of((int)7, (int)MetadataVersion.LATEST_PRODUCTION.confluentFeatureLevel()));
        expectedFeatures.put("metadata.version", VersionRange.of((short)MetadataVersion.MINIMUM_VERSION.apacheFeatureLevel(), (short)MetadataVersion.LATEST_PRODUCTION.apacheFeatureLevel()));
        for (Feature feature : Feature.PRODUCTION_FEATURES) {
            short maxVersion = feature.latestProduction();
            if (maxVersion <= 0) continue;
            expectedFeatures.put(feature.featureName(), VersionRange.of((short)feature.minimumProduction(), (short)maxVersion));
        }
        Assertions.assertEquals(expectedFeatures, (Object)QuorumFeatures.defaultSupportedFeatureMap((boolean)false));
    }

    @Test
    public void testDefaultFeatureMapWithUnstable() {
        HashMap<String, VersionRange> expectedFeatures = new HashMap<String, VersionRange>(1);
        expectedFeatures.put("confluent.metadata.version", VersionRange.of((int)7, (int)MetadataVersion.latestTesting().confluentFeatureLevel()));
        expectedFeatures.put("metadata.version", VersionRange.of((short)MetadataVersion.MINIMUM_VERSION.apacheFeatureLevel(), (short)MetadataVersion.latestTesting().apacheFeatureLevel()));
        for (Feature feature : Feature.PRODUCTION_FEATURES) {
            short maxVersion = feature.defaultLevel(MetadataVersion.latestTesting());
            if (maxVersion <= 0) continue;
            expectedFeatures.put(feature.featureName(), VersionRange.of((short)feature.minimumProduction(), (short)maxVersion));
        }
        Assertions.assertEquals(expectedFeatures, (Object)QuorumFeatures.defaultSupportedFeatureMap((boolean)true));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void ensureDefaultSupportedFeaturesRangeMaxNotZero(boolean unstableVersionsEnabled) {
        Map quorumFeatures = QuorumFeatures.defaultSupportedFeatureMap((boolean)unstableVersionsEnabled);
        for (VersionRange range : quorumFeatures.values()) {
            Assertions.assertNotEquals((int)0, (int)range.max());
        }
    }

    @Test
    public void testLocalSupportedFeature() {
        Assertions.assertEquals((Object)VersionRange.of((int)0, (int)3), (Object)QUORUM_FEATURES.localSupportedFeature("foo"));
        Assertions.assertEquals((Object)VersionRange.of((int)0, (int)4), (Object)QUORUM_FEATURES.localSupportedFeature("bar"));
        Assertions.assertEquals((Object)VersionRange.of((int)2, (int)2), (Object)QUORUM_FEATURES.localSupportedFeature("baz"));
        Assertions.assertEquals((Object)VersionRange.of((int)0, (int)0), (Object)QUORUM_FEATURES.localSupportedFeature("quux"));
    }

    @Test
    public void testReasonNotSupported() {
        Assertions.assertEquals(Optional.of("Local controller 0 only supports versions 0-3"), (Object)QuorumFeatures.reasonNotSupported((short)10, (String)"Local controller 0", (VersionRange)VersionRange.of((int)0, (int)3)));
        Assertions.assertEquals(Optional.empty(), (Object)QuorumFeatures.reasonNotSupported((short)3, (String)"Local controller 0", (VersionRange)VersionRange.of((int)0, (int)3)));
    }

    @Test
    public void testIsControllerId() {
        Assertions.assertTrue((boolean)QUORUM_FEATURES.isControllerId(0));
        Assertions.assertTrue((boolean)QUORUM_FEATURES.isControllerId(1));
        Assertions.assertTrue((boolean)QUORUM_FEATURES.isControllerId(2));
        Assertions.assertFalse((boolean)QUORUM_FEATURES.isControllerId(3));
    }
}

