/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumControllerIntegrationTestUtils;
import org.apache.kafka.controller.QuorumControllerTestEnv;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.apache.kafka.metalog.LocalLogManagerTestEnv;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class QuorumControllerMetricsIntegrationTest {
    @Test
    public void testClosingQuorumControllerClosesMetrics() throws Throwable {
        MockControllerMetrics metrics = new MockControllerMetrics();
        try (LocalLogManagerTestEnv logEnv = new LocalLogManagerTestEnv.Builder(1).build();
             QuorumControllerTestEnv controlEnv = new QuorumControllerTestEnv.Builder(logEnv).setControllerBuilderInitializer(controllerBuilder -> controllerBuilder.setMetrics((QuorumControllerMetrics)metrics)).build();){
            Assertions.assertEquals((long)1L, (long)controlEnv.activeController().controllerMetrics().newActiveControllers());
        }
        Assertions.assertTrue((boolean)metrics.closed.get(), (String)"metrics were not closed");
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFailingOverIncrementsNewActiveControllerCount(boolean forceFailoverUsingLogLayer) throws Throwable {
        try (LocalLogManagerTestEnv logEnv = new LocalLogManagerTestEnv.Builder(3).build();
             QuorumControllerTestEnv controlEnv = new QuorumControllerTestEnv.Builder(logEnv).build();){
            QuorumControllerIntegrationTestUtils.registerBrokersAndUnfence(controlEnv.activeController(), 1, true);
            TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> {
                for (QuorumController controller : controlEnv.controllers()) {
                    Assertions.assertEquals((long)1L, (long)controller.controllerMetrics().newActiveControllers());
                }
            });
            if (forceFailoverUsingLogLayer) {
                logEnv.activeLogManager().get().throwOnNextAppend();
                TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> QuorumControllerIntegrationTestUtils.createTopics(controlEnv.activeController(), "test_", 1, 1));
            } else {
                QuorumControllerIntegrationTestUtils.forceRenounce(controlEnv.activeController());
            }
            TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> {
                for (QuorumController controller : controlEnv.controllers()) {
                    Assertions.assertEquals((long)2L, (long)controller.controllerMetrics().newActiveControllers());
                }
            });
        }
    }

    @Test
    public void testTimeoutMetrics() throws Throwable {
        try (LocalLogManagerTestEnv logEnv = new LocalLogManagerTestEnv.Builder(3).build();
             QuorumControllerTestEnv controlEnv = new QuorumControllerTestEnv.Builder(logEnv).build();){
            QuorumController active = controlEnv.activeController();
            Map<Integer, Long> brokerEpochs = QuorumControllerIntegrationTestUtils.registerBrokersAndUnfence(active, 3, true);
            Assertions.assertEquals((long)0L, (long)active.controllerMetrics().timedOutHeartbeats());
            Assertions.assertEquals((long)0L, (long)active.controllerMetrics().operationsTimedOut());
            CountDownLatch latch = QuorumControllerIntegrationTestUtils.pause(active);
            ControllerRequestContext expiredTimeoutContext = new ControllerRequestContext(new RequestHeaderData(), KafkaPrincipal.ANONYMOUS, OptionalLong.of(active.time().nanoseconds()));
            CompletableFuture replyFuture = active.processBrokerHeartbeat(expiredTimeoutContext, new BrokerHeartbeatRequestData().setWantFence(false).setBrokerEpoch(brokerEpochs.get(0).longValue()).setBrokerId(0).setCurrentMetadataOffset(100000L));
            latch.countDown();
            Assertions.assertEquals(TimeoutException.class, ((ExecutionException)Assertions.assertThrows(ExecutionException.class, replyFuture::get)).getCause().getClass());
            Assertions.assertEquals((long)1L, (long)active.controllerMetrics().timedOutHeartbeats());
            Assertions.assertEquals((long)1L, (long)active.controllerMetrics().operationsTimedOut());
            CountDownLatch latch2 = QuorumControllerIntegrationTestUtils.pause(active);
            active.appendControlEventWithDeadline("fakeTimeoutOperation", () -> {}, active.time().nanoseconds());
            latch2.countDown();
            TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> {
                Assertions.assertEquals((long)1L, (long)active.controllerMetrics().timedOutHeartbeats());
                Assertions.assertEquals((long)2L, (long)active.controllerMetrics().operationsTimedOut());
            });
            for (QuorumController controller : controlEnv.controllers()) {
                if (controller.isActive()) continue;
                Assertions.assertFalse((boolean)controller.controllerMetrics().active());
                Assertions.assertEquals((long)0L, (long)controller.controllerMetrics().timedOutHeartbeats());
                Assertions.assertEquals((long)0L, (long)controller.controllerMetrics().operationsTimedOut());
            }
        }
    }

    @Test
    public void testEventQueueOperationsStartedMetric() throws Throwable {
        try (LocalLogManagerTestEnv logEnv = new LocalLogManagerTestEnv.Builder(3).build();
             QuorumControllerTestEnv controlEnv = new QuorumControllerTestEnv.Builder(logEnv).build();){
            QuorumController active = controlEnv.activeController();
            Map<Integer, Long> brokerEpochs = QuorumControllerIntegrationTestUtils.registerBrokersAndUnfence(active, 3, true);
            TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> {
                long expectedOperationsStarted = active.controllerMetrics().operationsStarted() + 1L;
                CompletableFuture actualOperationsStarted = new CompletableFuture();
                active.appendControlEvent("checkOperationsStarted", () -> actualOperationsStarted.complete(active.controllerMetrics().operationsStarted()));
                Assertions.assertEquals((long)expectedOperationsStarted, (Long)((Long)actualOperationsStarted.get()));
            });
        }
    }

    @Test
    public void testConfluentMetrics() throws Exception {
        int numControllers = 3;
        ArrayList<MockControllerMetrics> metrics = new ArrayList<MockControllerMetrics>();
        for (int i = 0; i < 3; ++i) {
            metrics.add(new MockControllerMetrics());
        }
        try (LocalLogManagerTestEnv logEnv = new LocalLogManagerTestEnv.Builder(3).build();
             QuorumControllerTestEnv controlEnv = new QuorumControllerTestEnv.Builder(logEnv).setControllerBuilderInitializer(controllerBuilder -> controllerBuilder.setMetrics((QuorumControllerMetrics)metrics.get(controllerBuilder.nodeId()))).build();){
            TestUtils.waitForCondition(() -> {
                QuorumController active = controlEnv.activeController();
                for (int i = 0; i < 3; ++i) {
                    QuorumController controller = controlEnv.controllers().get(i);
                    if (active != controller) continue;
                    return ((MockControllerMetrics)((Object)((Object)metrics.get(i)))).lastControllerLoadMs() > -1L;
                }
                return false;
            }, (String)"Failed to see the active controller's lastControllerLoadMs become non-negative.");
        }
    }

    static class MockControllerMetrics
    extends QuorumControllerMetrics {
        final AtomicBoolean closed = new AtomicBoolean(false);
        private volatile long lastControllerLoadMs = -1L;

        MockControllerMetrics() {
            super(Optional.empty(), Time.SYSTEM, new Metrics());
        }

        public void recordControllerLoadTime(long startMs, long endMs) {
            this.lastControllerLoadMs = endMs - startMs;
            super.recordControllerLoadTime(startMs, endMs);
        }

        public void close() {
            super.close();
            this.closed.set(true);
        }

        public long lastControllerLoadMs() {
            return this.lastControllerLoadMs;
        }
    }
}

