/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ClusterFeatureSupportDescriber;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@Timeout(value=40L)
public class FeatureControlManagerTest {
    private static final FeatureControlManager.Builder TEST_MANAGER_BUILDER1 = new FeatureControlManager.Builder().setQuorumFeatures(FeatureControlManagerTest.features("confluent.metadata.version", MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel(), MetadataVersion.IBP_3_6_IV0.confluentFeatureLevel())).setMetadataVersion(MetadataVersion.IBP_3_4_IV0);

    private static Map<String, VersionRange> rangeMap(Object ... args) {
        HashMap<String, VersionRange> result = new HashMap<String, VersionRange>();
        for (int i = 0; i < args.length; i += 3) {
            String feature = (String)args[i];
            Number low = (Number)args[i + 1];
            Number high = (Number)args[i + 2];
            result.put(feature, VersionRange.of((short)low.shortValue(), (short)high.shortValue()));
        }
        return result;
    }

    private static Map<String, Short> versionMap(Object ... args) {
        HashMap<String, Short> result = new HashMap<String, Short>();
        for (int i = 0; i < args.length; i += 2) {
            String feature = (String)args[i];
            Number ver = (Number)args[i + 1];
            result.put(feature, ver.shortValue());
        }
        return result;
    }

    public static QuorumFeatures features(Object ... args) {
        Map features = QuorumFeatures.defaultSupportedFeatureMap((boolean)true);
        features.putAll(FeatureControlManagerTest.rangeMap(args));
        return new QuorumFeatures(0, features, Collections.emptyList());
    }

    private static Map<String, Short> updateMap(Object ... args) {
        HashMap<String, Short> result = new HashMap<String, Short>();
        for (int i = 0; i < args.length; i += 2) {
            String feature = (String)args[i];
            Number ver = (Number)args[i + 1];
            result.put(feature, ver.shortValue());
        }
        return result;
    }

    @Test
    public void testUpdateFeatures() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager manager = new FeatureControlManager.Builder().setQuorumFeatures(FeatureControlManagerTest.features("test.feature.version", 0, 2)).setSnapshotRegistry(snapshotRegistry).setMetadataVersion(MetadataVersion.MINIMUM_VERSION).build();
        snapshotRegistry.idempotentCreateSnapshot(-1L);
        Assertions.assertEquals((Object)new FinalizedControllerFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()), -1L), (Object)manager.finalizedFeatures(-1L));
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), (Object)new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 3 for feature test.feature.version. Local controller 0 only supports versions 0-2")), (Object)manager.updateFeatures(FeatureControlManagerTest.updateMap("test.feature.version", 3), Collections.singletonMap("test.feature.version", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), false, 0));
        ControllerResult result = manager.updateFeatures(FeatureControlManagerTest.updateMap("test.feature.version", 1, "bar", 1), Collections.emptyMap(), false, 0);
        ApiError expectedError = new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 1 for feature bar. Local controller 0 does not support this feature.");
        ArrayList<ApiMessageAndVersion> expectedMessages = new ArrayList<ApiMessageAndVersion>();
        Assertions.assertEquals((Object)expectedError, (Object)result.response());
        Assertions.assertEquals(expectedMessages, (Object)result.records());
        result = manager.updateFeatures(FeatureControlManagerTest.updateMap("test.feature.version", 1), Collections.emptyMap(), false, 0);
        expectedError = ApiError.NONE;
        Assertions.assertEquals((Object)expectedError, (Object)result.response());
        expectedMessages = new ArrayList();
        expectedMessages.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("test.feature.version").setFeatureLevel((short)1), 0));
        Assertions.assertEquals(expectedMessages, (Object)result.records());
    }

    @Test
    public void testReplay() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        FeatureLevelRecord record = new FeatureLevelRecord().setName("foo").setFeatureLevel((short)2);
        snapshotRegistry.idempotentCreateSnapshot(-1L);
        FeatureControlManager manager = new FeatureControlManager.Builder().setLogContext(logContext).setQuorumFeatures(FeatureControlManagerTest.features("foo", 1, 2)).setSnapshotRegistry(snapshotRegistry).setMetadataVersion(MetadataVersion.MINIMUM_VERSION).build();
        manager.replay(record);
        snapshotRegistry.idempotentCreateSnapshot(123L);
        Assertions.assertEquals((Object)new FinalizedControllerFeatures(FeatureControlManagerTest.versionMap("confluent.metadata.version", MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel(), "foo", 2), 123L), (Object)manager.finalizedFeatures(123L));
    }

    @Test
    public void testReplayKraftVersionFeatureLevel() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        snapshotRegistry.idempotentCreateSnapshot(-1L);
        FeatureControlManager manager = new FeatureControlManager.Builder().setLogContext(logContext).setQuorumFeatures(FeatureControlManagerTest.features("foo", 1, 2)).setSnapshotRegistry(snapshotRegistry).build();
        manager.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.MINIMUM_VERSION.apacheFeatureLevel()));
        manager.replay(new FeatureLevelRecord().setName("kraft.version").setFeatureLevel(KRaftVersion.LATEST_PRODUCTION.featureLevel()));
        snapshotRegistry.idempotentCreateSnapshot(123L);
        Assertions.assertEquals((Object)new FinalizedControllerFeatures(FeatureControlManagerTest.versionMap("confluent.metadata.version", MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()), 123L), (Object)manager.finalizedFeatures(123L));
    }

    static ClusterFeatureSupportDescriber createFakeClusterFeatureSupportDescriber(final List<Map.Entry<Integer, Map<String, VersionRange>>> brokerRanges, final List<Map.Entry<Integer, Map<String, VersionRange>>> controllerRanges) {
        return new ClusterFeatureSupportDescriber(){

            public Iterator<Map.Entry<Integer, Map<String, VersionRange>>> brokerSupported() {
                return brokerRanges.iterator();
            }

            public Iterator<Map.Entry<Integer, Map<String, VersionRange>>> controllerSupported() {
                return controllerRanges.iterator();
            }
        };
    }

    @Test
    public void testUpdateFeaturesErrorCases() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        FeatureControlManager manager = new FeatureControlManager.Builder().setLogContext(logContext).setQuorumFeatures(FeatureControlManagerTest.features("foo", 1, 5, "transaction.version", 0, 3)).setSnapshotRegistry(snapshotRegistry).setClusterFeatureSupportDescriber(FeatureControlManagerTest.createFakeClusterFeatureSupportDescriber(Collections.singletonList(new AbstractMap.SimpleImmutableEntry<Integer, Map<String, VersionRange>>(5, Collections.singletonMap("transaction.version", VersionRange.of((int)0, (int)2)))), Collections.emptyList())).build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), (Object)new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 3 for feature foo. Broker 5 does not support this feature.")), (Object)manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 3), Collections.singletonMap("foo", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), false, 0));
        ControllerResult result = manager.updateFeatures(FeatureControlManagerTest.updateMap("transaction.version", 2), Collections.emptyMap(), false, 0);
        Assertions.assertEquals((Object)ApiError.NONE, (Object)result.response());
        manager.replay((FeatureLevelRecord)((ApiMessageAndVersion)result.records().get(0)).message());
        snapshotRegistry.idempotentCreateSnapshot(3L);
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), (Object)new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 1 for feature transaction.version. Can't downgrade the version of this feature without setting the upgrade type to either safe or unsafe downgrade.")), (Object)manager.updateFeatures(FeatureControlManagerTest.updateMap("transaction.version", 1), Collections.emptyMap(), false, 0));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("transaction.version").setFeatureLevel((short)1), 0)), (Object)ApiError.NONE), (Object)manager.updateFeatures(FeatureControlManagerTest.updateMap("transaction.version", 1), Collections.singletonMap("transaction.version", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), false, 0));
    }

    @Test
    public void testReplayRecords() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        FeatureControlManager manager = new FeatureControlManager.Builder().setLogContext(logContext).setQuorumFeatures(FeatureControlManagerTest.features("test.feature.version", 0, 5, "transaction.version", 0, 2)).setSnapshotRegistry(snapshotRegistry).setMetadataVersion(MetadataVersion.MINIMUM_VERSION).build();
        ControllerResult result = manager.updateFeatures(FeatureControlManagerTest.updateMap("test.feature.version", 1, "transaction.version", 2), Collections.emptyMap(), false, 0);
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals((Object)MetadataVersion.MINIMUM_VERSION, (Object)manager.metadataVersion());
        Assertions.assertEquals(Optional.of((short)1), (Object)manager.finalizedFeatures(Long.MAX_VALUE).get("test.feature.version"));
        Assertions.assertEquals(Optional.of((short)2), (Object)manager.finalizedFeatures(Long.MAX_VALUE).get("transaction.version"));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("confluent.metadata.version", "test.feature.version", "transaction.version")), (Object)manager.finalizedFeatures(Long.MAX_VALUE).featureNames());
    }

    @Test
    public void testApplyMetadataVersionChangeRecord() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        MetadataVersion initialMetadataVersion = manager.metadataVersion();
        manager.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)(initialMetadataVersion.apacheFeatureLevel() + 1)));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV0, (Object)manager.metadataVersion());
    }

    @Test
    public void testCannotDowngradeToHigherVersion() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), (Object)new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 109 for feature confluent.metadata.version. Can't downgrade to a newer version.")), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_5_IV0.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), true, 0));
    }

    @Test
    public void testCannotUnsafeDowngradeToHigherVersion() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), (Object)new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 109 for feature confluent.metadata.version. Can't downgrade to a newer version.")), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_5_IV0.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE), true, 0));
    }

    @Test
    public void testCannotUpgradeToLowerVersion() {
        FeatureControlManager manager = new FeatureControlManager.Builder().setQuorumFeatures(FeatureControlManagerTest.features("confluent.metadata.version", MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel(), MetadataVersion.IBP_3_6_IV0.confluentFeatureLevel())).setMetadataVersion(MetadataVersion.IBP_3_5_IV1).build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), (Object)new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 109 for feature confluent.metadata.version. Can't downgrade the version of this feature without setting the upgrade type to either safe or unsafe downgrade.")), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_5_IV0.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.UPGRADE), true, 0));
    }

    @Test
    public void testCanUpgradeToHigherVersion() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), (Object)ApiError.NONE), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_5_IV0.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.UPGRADE), true, 0));
    }

    @Test
    public void testCanUpgradeToHigherVersionViaApacheVersion() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(MetadataVersion.IBP_3_4_IV0.confluentFeatureLevel()), 0)), (Object)ApiError.NONE), (Object)manager.updateFeatures(Collections.singletonMap("metadata.version", MetadataVersion.IBP_3_4_IV0.apacheFeatureLevel()), Collections.singletonMap("metadata.version", FeatureUpdate.UpgradeType.UPGRADE), false, 0));
    }

    @Test
    public void testCannotUseSafeDowngradeIfMetadataChanged() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), (Object)new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid confluent.metadata.version 107. Refusing to perform the requested downgrade because it might delete metadata information.")), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_3_IV3.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), true, 0));
    }

    @Test
    public void testUnsafeDowngradeIsTemporarilyDisabled() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), (Object)new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid confluent.metadata.version 107. Unsafe metadata downgrade is not supported in this version.")), (Object)manager.updateFeatures(Collections.singletonMap("metadata.version", MetadataVersion.IBP_3_3_IV3.apacheFeatureLevel()), Collections.singletonMap("metadata.version", FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE), true, 0));
    }

    @Disabled
    @Test
    public void testCanUseUnsafeDowngradeIfMetadataChanged() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), (Object)ApiError.NONE), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_3_IV3.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE), true, 0));
    }

    @Test
    public void testCanUseSafeDowngradeIfMetadataDidNotChange() {
        FeatureControlManager manager = new FeatureControlManager.Builder().setQuorumFeatures(FeatureControlManagerTest.features("confluent.metadata.version", MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel(), MetadataVersion.IBP_3_6_IV0.confluentFeatureLevel())).setMetadataVersion(MetadataVersion.IBP_3_6_IV0).build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), (Object)ApiError.NONE), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_5_IV2.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), true, 0));
    }

    @Test
    public void testCannotDowngradeBeforeMinimumKraftVersion() {
        FeatureControlManager manager = new FeatureControlManager.Builder().setQuorumFeatures(FeatureControlManagerTest.features("confluent.metadata.version", MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel(), MetadataVersion.latestTesting().confluentFeatureLevel())).setMetadataVersion(MetadataVersion.MINIMUM_VERSION).build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), (Object)new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 106 for feature confluent.metadata.version. Local controller 0 only supports versions 107-128")), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", (short)106), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE), true, 0));
    }

    @Test
    public void testCreateFeatureLevelRecords() {
        HashMap<String, VersionRange> localSupportedFeatures = new HashMap<String, VersionRange>();
        localSupportedFeatures.put("confluent.metadata.version", VersionRange.of((short)MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel(), (short)MetadataVersion.latestTesting().confluentFeatureLevel()));
        localSupportedFeatures.put(Feature.TEST_VERSION.featureName(), VersionRange.of((int)0, (int)2));
        FeatureControlManager manager = new FeatureControlManager.Builder().setQuorumFeatures(new QuorumFeatures(0, localSupportedFeatures, Collections.emptyList())).setClusterFeatureSupportDescriber(FeatureControlManagerTest.createFakeClusterFeatureSupportDescriber(Collections.singletonList(new AbstractMap.SimpleImmutableEntry<Integer, Map<String, VersionRange>>(1, Collections.singletonMap(Feature.TEST_VERSION.featureName(), VersionRange.of((int)0, (int)3)))), Collections.emptyList())).build();
        ControllerResult result = manager.updateFeatures(Collections.singletonMap(Feature.TEST_VERSION.featureName(), (short)1), Collections.singletonMap(Feature.TEST_VERSION.featureName(), FeatureUpdate.UpgradeType.UPGRADE), false, 0);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(Feature.TEST_VERSION.featureName()).setFeatureLevel((short)1), 0)), (Object)ApiError.NONE), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals(Optional.of((short)1), (Object)manager.finalizedFeatures(Long.MAX_VALUE).get(Feature.TEST_VERSION.featureName()));
        ControllerResult result2 = manager.updateFeatures(Collections.singletonMap(Feature.TEST_VERSION.featureName(), (short)0), Collections.singletonMap(Feature.TEST_VERSION.featureName(), FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE), false, 0);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(Feature.TEST_VERSION.featureName()).setFeatureLevel((short)0), 0)), (Object)ApiError.NONE), (Object)result2);
        RecordTestUtils.replayAll(manager, result2.records());
        Assertions.assertEquals(Optional.empty(), (Object)manager.finalizedFeatures(Long.MAX_VALUE).get(Feature.TEST_VERSION.featureName()));
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsTopicPlacementSupported(MetadataVersion metadataVersion) {
        FeatureControlManager featureControlManager = new FeatureControlManager.Builder().setMetadataVersion(metadataVersion).build();
        if (metadataVersion.isLessThan(MetadataVersion.IBP_3_5_IV0)) {
            Assertions.assertFalse((boolean)featureControlManager.isTopicPlacementSupported());
        } else {
            Assertions.assertTrue((boolean)featureControlManager.isTopicPlacementSupported());
        }
    }

    @Test
    public void testUpgradeElrFeatureLevel() {
        HashMap<String, VersionRange> localSupportedFeatures = new HashMap<String, VersionRange>();
        localSupportedFeatures.put("confluent.metadata.version", VersionRange.of((short)MetadataVersion.IBP_4_0_IV1A.confluentFeatureLevel(), (short)MetadataVersion.latestTesting().confluentFeatureLevel()));
        localSupportedFeatures.put(Feature.ELIGIBLE_LEADER_REPLICAS_VERSION.featureName(), VersionRange.of((int)0, (int)1));
        FeatureControlManager manager = new FeatureControlManager.Builder().setQuorumFeatures(new QuorumFeatures(0, localSupportedFeatures, Collections.emptyList())).setClusterFeatureSupportDescriber(FeatureControlManagerTest.createFakeClusterFeatureSupportDescriber(Collections.singletonList(new AbstractMap.SimpleImmutableEntry<Integer, Map<String, VersionRange>>(1, Collections.singletonMap(Feature.ELIGIBLE_LEADER_REPLICAS_VERSION.featureName(), VersionRange.of((int)0, (int)1)))), Collections.emptyList())).setMetadataVersion(MetadataVersion.IBP_4_0_IV1A).build();
        ControllerResult result = manager.updateFeatures(Collections.singletonMap(Feature.ELIGIBLE_LEADER_REPLICAS_VERSION.featureName(), (short)1), Collections.singletonMap(Feature.ELIGIBLE_LEADER_REPLICAS_VERSION.featureName(), FeatureUpdate.UpgradeType.UPGRADE), false, 0);
        Assertions.assertTrue((boolean)((ApiError)result.response()).isSuccess());
        Assertions.assertEquals(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(Feature.ELIGIBLE_LEADER_REPLICAS_VERSION.featureName()).setFeatureLevel((short)1), 0)), (Object)result.records());
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals(Optional.of((short)1), (Object)manager.finalizedFeatures(Long.MAX_VALUE).get(Feature.ELIGIBLE_LEADER_REPLICAS_VERSION.featureName()));
    }
}

