/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import net.jqwik.api.arbitraries.ShortArbitrary;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.BrokerRegistrationDoesNotContainEncryptorSecretException;
import org.apache.kafka.common.errors.DemotionLimitReachedException;
import org.apache.kafka.common.errors.InconsistentClusterIdException;
import org.apache.kafka.common.errors.InvalidRegistrationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.InstallMetadataEncryptorRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.AlterBrokerHealthRequest;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.BrokerIdAndEpoch;
import org.apache.kafka.controller.CellControlManager;
import org.apache.kafka.controller.ClusterControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.EncryptionControlManager;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.AesGcm128MetadataEncryptor;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerRegistrationFencingChange;
import org.apache.kafka.metadata.BrokerRegistrationInControlledShutdownChange;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.metadata.placement.PlacementSpec;
import org.apache.kafka.metadata.placement.ReplicaPlacer;
import org.apache.kafka.metadata.placement.StripedReplicaPlacer;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.apache.kafka.server.common.AlterReplicaExclusionsReply;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TestFeatureVersion;
import org.apache.kafka.server.util.MockRandom;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class ClusterControlManagerTest {
    private static final Uuid ENCRYPTOR_ID_FROM_FILE = Uuid.fromString((String)"oozG5ebNR9yf2xrWNI_1QA");
    private static final String ENCRYPTOR_FILE_JSON_ONE_SECRET = "{\n  \"encryptors_by_uuid\": {\n    \"" + String.valueOf(ENCRYPTOR_ID_FROM_FILE) + "\": {\n      \"created\": \"2023-10-15T17:26:49.335813Z\",\n      \"class_name\": \"org.apache.kafka.metadata.AesGcm128MetadataEncryptor\",\n      \"bytes\": \"KE9KWGMEwd6zGWyXdYksdA\"\n    }\n  }\n}";
    private static final Uuid ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG = Uuid.fromString((String)"ZUpeNz1eSKyT_qiVKswGfA");
    private static final Uuid INACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG = Uuid.fromString((String)"8PKWuzWBR3C7cFAZKzdmkg");
    private static final Map<String, Object> LEGACY_ENCRYPTOR_CONFIG;
    private RegisterBrokerRecord.DegradedComponent externalConnectivityStartup = new RegisterBrokerRecord.DegradedComponent().setComponentCode(BrokerComponent.EXTERNAL_CONNECTIVITY_STARTUP.id()).setReason(AlterBrokerHealthRequest.networkHealthStartupAlterBrokerHealthReason);

    @Test
    public void testReplay() {
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1);
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        clusterControl.checkBrokerEpoch(1, 100L);
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> clusterControl.checkBrokerEpoch(1, 101L));
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> clusterControl.checkBrokerEpoch(2, 100L));
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(1));
        BrokerRegistrationChangeRecord changeRecord = new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.UNFENCE.value());
        clusterControl.replay(changeRecord);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(1));
        changeRecord = new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.FENCE.value());
        clusterControl.replay(changeRecord);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(1));
    }

    @Test
    public void testReplayRegisterBrokerRecord() {
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setFenced(true).setInControlledShutdown(true);
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
        brokerRecord.setInControlledShutdown(false);
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        Assertions.assertEquals((long)100L, (long)clusterControl.registerBrokerRecordOffset(brokerRecord.brokerId()).getAsLong());
        brokerRecord.setFenced(false);
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
    }

    @Test
    public void testReplayBrokerRegistrationChangeRecord() {
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setFenced(false);
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        BrokerRegistrationChangeRecord.DegradedComponent degradedComponent1 = new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-123").setComponentCode((byte)0);
        BrokerRegistrationChangeRecord registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setDegradedComponents(Collections.singletonList(degradedComponent1));
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        Set<DegradedBrokerHealthState> expectedDegradedStates = Collections.singleton(DegradedBrokerHealthState.fromDegradedComponent((BrokerRegistrationChangeRecord.DegradedComponent)degradedComponent1));
        Assertions.assertTrue((boolean)clusterControl.activeBrokerComponentDegradations().containsKey(0));
        Assertions.assertEquals(expectedDegradedStates, clusterControl.activeBrokerComponentDegradations().get(0));
        registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value());
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
        Assertions.assertTrue((boolean)clusterControl.activeBrokerComponentDegradations().containsKey(0));
        Assertions.assertEquals(expectedDegradedStates, clusterControl.activeBrokerComponentDegradations().get(0));
        BrokerRegistrationChangeRecord.DegradedComponent degradedComponent2 = new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-234").setComponentCode((byte)0);
        BrokerRegistrationChangeRecord.DegradedComponent degradedComponent3 = new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-345").setComponentCode((byte)1);
        BrokerRegistrationChangeRecord.DegradedComponent degradedComponent4 = new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-456").setComponentCode((byte)2);
        registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.FENCE.value()).setDegradedComponents(Arrays.asList(degradedComponent2, degradedComponent3, degradedComponent4));
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
        Assertions.assertTrue((boolean)clusterControl.activeBrokerComponentDegradations().containsKey(0));
        expectedDegradedStates = new HashSet<DegradedBrokerHealthState>(Arrays.asList(DegradedBrokerHealthState.fromDegradedComponent((BrokerRegistrationChangeRecord.DegradedComponent)degradedComponent2), DegradedBrokerHealthState.fromDegradedComponent((BrokerRegistrationChangeRecord.DegradedComponent)degradedComponent3), DegradedBrokerHealthState.fromDegradedComponent((BrokerRegistrationChangeRecord.DegradedComponent)degradedComponent4)));
        Assertions.assertEquals(expectedDegradedStates, clusterControl.activeBrokerComponentDegradations().get(0));
        registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.UNFENCE.value());
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
        Assertions.assertTrue((boolean)clusterControl.activeBrokerComponentDegradations().containsKey(0));
        expectedDegradedStates = new HashSet<DegradedBrokerHealthState>(Arrays.asList(DegradedBrokerHealthState.fromDegradedComponent((BrokerRegistrationChangeRecord.DegradedComponent)degradedComponent2), DegradedBrokerHealthState.fromDegradedComponent((BrokerRegistrationChangeRecord.DegradedComponent)degradedComponent3), DegradedBrokerHealthState.fromDegradedComponent((BrokerRegistrationChangeRecord.DegradedComponent)degradedComponent4)));
        Assertions.assertEquals(expectedDegradedStates, clusterControl.activeBrokerComponentDegradations().get(0));
        registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setDegradedComponents(Collections.emptyList());
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
        Assertions.assertFalse((boolean)clusterControl.activeBrokerComponentDegradations().containsKey(0));
    }

    @Provide
    private Arbitrary<Short> validConfluentMetadataVersions() {
        ShortArbitrary oldVersionRange = Arbitraries.shorts().between((short)1, (short)7);
        ShortArbitrary newVersionRange = Arbitraries.shorts().between(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel(), MetadataVersion.latestTesting().confluentFeatureLevel());
        return Arbitraries.oneOf(Arrays.asList(oldVersionRange, newVersionRange));
    }

    @Property
    public void testRegistrationConfluentMetadataVersion(@ForAll(value="validConfluentMetadataVersions") short featureLevel) {
        if (featureLevel > 107) {
            Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testRegistrationWithConfluentMetadataVersion(featureLevel, (short)1, MetadataVersion.latestTesting().apacheFeatureLevel()));
        } else {
            this.testRegistrationWithConfluentMetadataVersion(featureLevel, (short)1, (short)7);
        }
        this.testRegistrationWithConfluentMetadataVersion(featureLevel, (short)1, MetadataVersion.latestTesting().confluentFeatureLevel());
        this.testRegistrationWithConfluentMetadataVersion(featureLevel, MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel(), MetadataVersion.latestTesting().confluentFeatureLevel());
    }

    private void testRegistrationWithConfluentMetadataVersion(short featureLevel, short brokerMinSupportedLevel, short brokerMaxSupportedLevel) {
        MockTime time = new MockTime();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        QuorumFeatures quorumFeatures = new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.emptyList());
        String clusterId = "WIjw3grwRZmR2uOpdpVXbg";
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(quorumFeatures).setMetadataVersion(MetadataVersion.MINIMUM_VERSION).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setClusterId(clusterId).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        FeatureLevelRecord confluentMetadataVersion = new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(featureLevel);
        featureControl.replay(confluentMetadataVersion);
        if (featureLevel >= 1 && featureLevel <= 7) {
            Assertions.assertEquals((short)featureLevel, (short)featureControl.metadataVersion().apacheFeatureLevel(), (String)("Unexpected apacheFeatureLevel for " + String.valueOf(featureControl.metadataVersion())));
        } else {
            Assertions.assertEquals((short)featureLevel, (short)featureControl.metadataVersion().confluentFeatureLevel(), (String)("Unexpected confluentFeatureLevel for " + String.valueOf(featureControl.metadataVersion())));
        }
        int brokerId2 = 0;
        List logDirs = featureControl.metadataVersion().isDirectoryAssignmentSupported() ? Arrays.asList(Uuid.fromString((String)("TESTBROKER" + Integer.toString(100000 + brokerId2).substring(1) + "DIRAAAA"))) : Collections.emptyList();
        BrokerRegistrationRequestData registration = new BrokerRegistrationRequestData().setClusterId(clusterId).setBrokerId(brokerId2).setLogDirs(logDirs).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg"));
        registration.features().add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(brokerMinSupportedLevel).setMaxSupportedVersion(brokerMaxSupportedLevel));
        long brokerEpoch = 12345L;
        ControllerResult result = clusterControl.registerBroker(registration, brokerEpoch, featureControl.finalizedFeatures(Long.MAX_VALUE), true, false);
        BrokerRegistrationReply reply = (BrokerRegistrationReply)result.response();
        Assertions.assertEquals((long)brokerEpoch, (long)reply.epoch());
        List records2 = result.records();
        RegisterBrokerRecord registerBrokerRecord = (RegisterBrokerRecord)((ApiMessageAndVersion)records2.get(0)).message();
        if (featureControl.metadataVersion().isCellsSupported()) {
            Assertions.assertEquals((int)2, (int)records2.size());
            CellRecord cellRecord = (CellRecord)((ApiMessageAndVersion)records2.get(1)).message();
            CellRecord expectedCellRecord = new CellRecord().setCellId(0).setMinSize((short)6).setMaxSize((short)15).setState(CellState.READY.code()).setBrokers(Collections.singletonList(brokerId2));
            Assertions.assertEquals((Object)expectedCellRecord, (Object)cellRecord);
        } else {
            Assertions.assertEquals((int)1, (int)records2.size());
        }
        if (featureControl.metadataVersion().isExternalConnectivitySupported()) {
            Assertions.assertTrue((boolean)registerBrokerRecord.degradedComponents().contains(this.externalConnectivityStartup));
        }
        Assertions.assertEquals((int)brokerId2, (int)registerBrokerRecord.brokerId());
        clusterControl.replay(registerBrokerRecord, brokerEpoch);
        VersionRange versionRange = (VersionRange)clusterControl.registration(brokerId2).supportedFeatures().get("confluent.metadata.version");
        Assertions.assertEquals((Object)VersionRange.of((short)brokerMinSupportedLevel, (short)brokerMaxSupportedLevel), (Object)versionRange);
        if (featureControl.metadataVersion().isExternalConnectivitySupported()) {
            Assertions.assertEquals((int)1, (int)clusterControl.activeBrokerComponentDegradations().size());
            Assertions.assertEquals(Collections.singleton(DegradedBrokerHealthState.fromDegradedComponent((RegisterBrokerRecord.DegradedComponent)this.externalConnectivityStartup)), clusterControl.activeBrokerComponentDegradations().get(0));
        }
    }

    @Test
    public void testRegisterBrokerWithImplicitCellCreationDisabled() {
        MockTime time = new MockTime();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        QuorumFeatures quorumFeatures = new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.emptyList());
        String clusterId = "WIjw3grwRZmR2uOpdpVXbg";
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(quorumFeatures).setMetadataVersion(MetadataVersion.MINIMUM_VERSION).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setClusterId(clusterId).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        int brokerId2 = 0;
        BrokerRegistrationRequestData registration = new BrokerRegistrationRequestData().setClusterId(clusterId).setBrokerId(brokerId2).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg"));
        registration.features().add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.latestTesting().confluentFeatureLevel()));
        long brokerEpoch = 12345L;
        ControllerResult result = clusterControl.registerBroker(registration, brokerEpoch, featureControl.finalizedFeatures(Long.MAX_VALUE), true, false);
        BrokerRegistrationReply reply = (BrokerRegistrationReply)result.response();
        Assertions.assertEquals((long)brokerEpoch, (long)reply.epoch());
        List records2 = result.records();
        Assertions.assertEquals((int)1, (int)records2.size());
        RegisterBrokerRecord registerBrokerRecord = (RegisterBrokerRecord)((ApiMessageAndVersion)records2.get(0)).message();
        Assertions.assertEquals((int)brokerId2, (int)registerBrokerRecord.brokerId());
        clusterControl.replay(registerBrokerRecord, brokerEpoch);
    }

    @Test
    public void testRegistrationWithIncorrectClusterId() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        Assertions.assertThrows(InconsistentClusterIdException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("WIjw3grwRZmR2uOpdpVXbg").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, new FinalizedControllerFeatures(Collections.emptyMap(), 456L), true, false));
    }

    private static Stream<Arguments> metadataVersions() {
        return Stream.of(MetadataVersion.MINIMUM_VERSION, MetadataVersion.IBP_3_7_IV2, MetadataVersion.latestTesting()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"metadataVersions"})
    public void testRegisterBrokerRecordVersion(MetadataVersion metadataVersion) {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(metadataVersion).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        List logDirs = metadataVersion.isDirectoryAssignmentSupported() ? Arrays.asList(Uuid.fromString((String)"63k9SN1nQOS0dFHSCIMA0A"), Uuid.fromString((String)"Vm1MjsOCR1OjDDydOsDbzg")) : Collections.emptyList();
        ControllerResult result = clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setLogDirs(logDirs).setRack(null).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(List.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(metadataVersion.apacheFeatureLevel()).setMaxSupportedVersion(metadataVersion.apacheFeatureLevel()), new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(metadataVersion.confluentFeatureLevel()).setMaxSupportedVersion(metadataVersion.confluentFeatureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, new FinalizedControllerFeatures(Map.of("confluent.metadata.version", metadataVersion.confluentFeatureLevel()), 456L), true, false);
        short expectedVersion = metadataVersion.registerBrokerRecordVersion();
        ArrayList<ApiMessageAndVersion> expectedRecords = new ArrayList<ApiMessageAndVersion>();
        expectedRecords.add(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(123L).setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")).setFenced(true).setLogDirs(logDirs).setDegradedComponents(metadataVersion.isExternalConnectivitySupported() ? Collections.singletonList(this.externalConnectivityStartup) : new ArrayList()).setFeatures(new RegisterBrokerRecord.BrokerFeatureCollection(Arrays.asList(new RegisterBrokerRecord.BrokerFeature().setName("metadata.version").setMinSupportedVersion(metadataVersion.apacheFeatureLevel()).setMaxSupportedVersion(metadataVersion.apacheFeatureLevel()), new RegisterBrokerRecord.BrokerFeature().setName("confluent.metadata.version").setMinSupportedVersion(metadataVersion.confluentFeatureLevel()).setMaxSupportedVersion(metadataVersion.confluentFeatureLevel())).iterator())).setInControlledShutdown(false), expectedVersion));
        if (featureControl.metadataVersion().isCellsSupported()) {
            CellRecord expectedCellRecord = new CellRecord().setCellId(0).setMinSize((short)6).setMaxSize((short)15).setState(CellState.READY.code()).setBrokers(Collections.singletonList(0));
            expectedRecords.add(new ApiMessageAndVersion((ApiMessage)expectedCellRecord, MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        }
        Assertions.assertEquals(expectedRecords, (Object)result.records());
    }

    @Test
    public void testUnfencedBrokerEndpoints() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        ListenerName externalListenerName = new ListenerName("EXTERNAL");
        ListenerName internalListenerName = new ListenerName("INTERNAL");
        ListenerName nonExistingListenerName = new ListenerName("NONEXISTING");
        RegisterBrokerRecord broker1Record = new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L).setIncarnationId(Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w")).setRack("rack1");
        broker1Record.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.SASL_PLAINTEXT.id).setPort(9092).setName(externalListenerName.value()).setHost("localhost"));
        broker1Record.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9093).setName(internalListenerName.value()).setHost("localhost"));
        clusterControl.replay(broker1Record, 100L);
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Collections.emptySet());
        clusterControl.replay(new UnfenceBrokerRecord().setId(1).setEpoch(100L));
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Set.of(new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("localhost").setPort(9092).setRack("rack1")));
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Set.of(new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("localhost").setPort(9093).setRack("rack1")));
        RegisterBrokerRecord broker2Record = new RegisterBrokerRecord().setBrokerId(2).setBrokerEpoch(100L).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")).setRack("rack2");
        broker2Record.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.SASL_PLAINTEXT.id).setPort(9094).setName(externalListenerName.value()).setHost("localhost"));
        clusterControl.replay(broker2Record, 200L);
        clusterControl.replay(new UnfenceBrokerRecord().setId(2).setEpoch(100L));
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Set.of(new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("localhost").setPort(9092).setRack("rack1"), new MetadataResponseData.MetadataResponseBroker().setNodeId(2).setHost("localhost").setPort(9094).setRack("rack2")));
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Set.of(new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("localhost").setPort(9093).setRack("rack1")));
        clusterControl.replay(new FenceBrokerRecord().setId(1).setEpoch(100L));
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Set.of(new MetadataResponseData.MetadataResponseBroker().setNodeId(2).setHost("localhost").setPort(9094).setRack("rack2")));
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Collections.emptySet());
        clusterControl.replay(new FenceBrokerRecord().setId(2).setEpoch(100L));
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Collections.emptySet());
    }

    private void assertUnfencedEndpoints(ClusterControlManager clusterControl, ListenerName listenerName, Set<MetadataResponseData.MetadataResponseBroker> expectedUnfenced) {
        MetadataResponseData.MetadataResponseBrokerCollection actualUnfenced = clusterControl.unfencedBrokerEndpoints(listenerName);
        Assertions.assertEquals((int)expectedUnfenced.size(), (int)actualUnfenced.size());
        for (MetadataResponseData.MetadataResponseBroker expectedBroker : expectedUnfenced) {
            Assertions.assertEquals((Object)expectedBroker, (Object)actualUnfenced.find((ImplicitLinkedHashCollection.Element)expectedBroker));
        }
    }

    @Test
    public void testUnregister() {
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L).setIncarnationId(Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w")).setRack("arack");
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertEquals((Object)new BrokerRegistration.Builder().setId(1).setEpoch(100L).setIncarnationId(Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w")).setListeners(Collections.singletonMap("PLAINTEXT", new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "example.com", 9092))).setRack(Optional.of("arack")).setFenced(true).setInControlledShutdown(false).setMetadataEncryptors(null).build(), clusterControl.brokerRegistrations().get(1));
        Assertions.assertEquals((long)100L, (long)clusterControl.registerBrokerRecordOffset(brokerRecord.brokerId()).getAsLong());
        UnregisterBrokerRecord unregisterRecord = new UnregisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L);
        clusterControl.replay(unregisterRecord);
        Assertions.assertFalse((boolean)clusterControl.brokerRegistrations().containsKey(1));
        Assertions.assertFalse((boolean)clusterControl.registerBrokerRecordOffset(brokerRecord.brokerId()).isPresent());
    }

    @ParameterizedTest
    @ValueSource(ints={3, 10})
    public void testPlaceReplicas(int numUsableBrokers) {
        int i;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        MockRandom random = new MockRandom();
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        final ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setReplicaPlacer((ReplicaPlacer)new StripedReplicaPlacer((Random)random)).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        int replicationFactor = 3;
        for (i = 0; i < numUsableBrokers; ++i) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i);
            brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord, 100L);
            UnfenceBrokerRecord unfenceRecord = new UnfenceBrokerRecord().setId(i).setEpoch(100L);
            clusterControl.replay(unfenceRecord);
            clusterControl.heartbeatManager().touch(i, false, 0L);
        }
        for (i = 0; i < numUsableBrokers; ++i) {
            Assertions.assertTrue((boolean)clusterControl.isUnfenced(i), (String)String.format("broker %d was not unfenced.", i));
        }
        int excludedBrokerId = -1;
        if (numUsableBrokers > replicationFactor) {
            excludedBrokerId = random.nextInt(numUsableBrokers);
            BrokerReplicaExclusionRecord exclusionRecord = new BrokerReplicaExclusionRecord().setBrokerExclusions(Collections.singletonList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(excludedBrokerId).setReason("test")));
            clusterControl.replay(exclusionRecord);
            Assertions.assertTrue((boolean)clusterControl.activeBrokerReplicaExclusions().containsKey(excludedBrokerId), (String)"Expected the excluded broker %d to be in the active broker replica exclusions");
        }
        for (int i2 = 0; i2 < 100; ++i2) {
            List results = clusterControl.replicaPlacer().place(new PlacementSpec(0, 1, 3, "foo", KafkaPrincipal.ANONYMOUS, Collections.emptySet(), PartitionPlacementStrategy.CLUSTER_WIDE, Optional.empty()), new ClusterDescriber(){

                public Iterator<UsableBroker> usableBrokers() {
                    return clusterControl.usableBrokers();
                }

                public Iterator<String> topicNames() {
                    throw new RuntimeException("not implemented");
                }

                public List<List<Integer>> replicasForTopicName(String topicName) {
                    throw new RuntimeException("not implemented");
                }

                public Uuid defaultDir(int brokerId) {
                    return DirectoryId.UNASSIGNED;
                }
            }).assignments();
            HashSet<Integer> seen = new HashSet<Integer>();
            for (Integer result : ((PartitionAssignment)results.get(0)).replicas()) {
                Assertions.assertTrue((result >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((result < numUsableBrokers ? 1 : 0) != 0);
                Assertions.assertNotEquals((Integer)result, (int)excludedBrokerId, (String)String.format("Expected the replica to not be assigned to the excluded broker %d", excludedBrokerId));
                Assertions.assertTrue((boolean)seen.add(result));
            }
        }
    }

    @Test
    public void testUsableBrokers() {
        List<RegisterBrokerRecord> brokerRecords = Arrays.asList(new RegisterBrokerRecord().setBrokerId(0).setRack("0"), new RegisterBrokerRecord().setBrokerId(1).setRack("1"));
        HashMap<String, String> rackMigrationMap = new HashMap<String, String>();
        rackMigrationMap.put("0", "usw2-az0");
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).setRackMigrationMapConfig(rackMigrationMap).build();
        clusterControl.activate();
        for (RegisterBrokerRecord brokerRecord : brokerRecords) {
            clusterControl.replay(brokerRecord, 100L);
        }
        Assertions.assertEquals((int)2, (int)clusterControl.brokerRegistrations().size());
        Assertions.assertTrue((boolean)clusterControl.brokerRegistrations().containsKey(0));
        Assertions.assertTrue((boolean)clusterControl.brokerRegistrations().containsKey(1));
        Assertions.assertEquals((int)1, (int)rackMigrationMap.size());
        Assertions.assertTrue((boolean)rackMigrationMap.containsKey("0"));
        Iterator usableBroker = clusterControl.usableBrokers();
        UsableBroker brokerWithRegisteredRack = (UsableBroker)usableBroker.next();
        Assertions.assertEquals((int)0, (int)brokerWithRegisteredRack.id());
        Assertions.assertEquals(Optional.of((String)rackMigrationMap.get(brokerRecords.get(0).rack())), (Object)brokerWithRegisteredRack.rack());
        UsableBroker brokerWithoutRegisteredRack = (UsableBroker)usableBroker.next();
        Assertions.assertEquals((int)1, (int)brokerWithoutRegisteredRack.id());
        Assertions.assertEquals(Optional.of(brokerRecords.get(1).rack()), (Object)brokerWithoutRegisteredRack.rack());
        Assertions.assertFalse((boolean)usableBroker.hasNext());
    }

    @ParameterizedTest
    @ValueSource(ints={3, 10})
    public void testPlaceReplicasWithRackMigrationMap(int numUsableBrokers) {
        int i;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        MockRandom random = new MockRandom();
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        HashMap<String, String> rackMigrationMap = new HashMap<String, String>();
        rackMigrationMap.put("0", "usw2-az0");
        rackMigrationMap.put("1", "usw2-az1");
        short replicationFactor = 2;
        final ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setReplicaPlacer((ReplicaPlacer)new StripedReplicaPlacer((Random)random)).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).setRackMigrationMapConfig(rackMigrationMap).build();
        clusterControl.activate();
        for (i = 0; i < numUsableBrokers; ++i) {
            String rack = this.originalZoneFromRackRegistrationRecord(i, replicationFactor, rackMigrationMap);
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i).setRack(rack);
            brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord, 100L);
            UnfenceBrokerRecord unfenceRecord = new UnfenceBrokerRecord().setId(i).setEpoch(100L);
            clusterControl.replay(unfenceRecord);
            clusterControl.heartbeatManager().touch(i, false, 0L);
        }
        for (i = 0; i < numUsableBrokers; ++i) {
            Assertions.assertTrue((boolean)clusterControl.isUnfenced(i), (String)String.format("broker %d was not unfenced.", i));
        }
        for (i = 0; i < 100; ++i) {
            List assignments = clusterControl.replicaPlacer().place(new PlacementSpec(0, 1, replicationFactor, "foo", KafkaPrincipal.ANONYMOUS, Collections.emptySet(), PartitionPlacementStrategy.CLUSTER_WIDE, Optional.empty()), new ClusterDescriber(){

                public Iterator<UsableBroker> usableBrokers() {
                    return clusterControl.usableBrokers();
                }

                public Iterator<String> topicNames() {
                    throw new RuntimeException("not implemented");
                }

                public List<List<Integer>> replicasForTopicName(String topicName) {
                    throw new RuntimeException("not implemented");
                }

                public Uuid defaultDir(int brokerId) {
                    return DirectoryId.UNASSIGNED;
                }
            }).assignments();
            HashSet<String> zones = new HashSet<String>();
            for (Integer replica : ((PartitionAssignment)assignments.get(0)).replicas()) {
                Assertions.assertTrue((replica >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((replica < numUsableBrokers ? 1 : 0) != 0);
                String zone = this.originalZoneFromRackRegistrationRecord(replica, replicationFactor, rackMigrationMap);
                String mappedZone = rackMigrationMap.getOrDefault(zone, zone);
                Assertions.assertTrue((boolean)zones.add(mappedZone), (String)String.format("Rack %s has more than one replica ", zone));
            }
        }
    }

    private String originalZoneFromRackRegistrationRecord(int brokerId, short replicationFactor, Map<String, String> rackMigrationMap) {
        return rackMigrationMap.getOrDefault(String.valueOf(brokerId), String.valueOf(brokerId % replicationFactor));
    }

    @Test
    public void testRegistrationsToRecords() {
        int i;
        MetadataVersion metadataVersion = MetadataVersion.MINIMUM_VERSION;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(metadataVersion).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        for (i = 0; i < 3; ++i) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i).setRack(null);
            brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092 + i).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord, 100L);
        }
        for (i = 0; i < 2; ++i) {
            UnfenceBrokerRecord unfenceBrokerRecord = new UnfenceBrokerRecord().setId(i).setEpoch(100L);
            clusterControl.replay(unfenceBrokerRecord);
        }
        BrokerRegistrationChangeRecord registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value());
        clusterControl.replay(registrationChangeRecord);
        BrokerReplicaExclusionRecord exclusionRecord = new BrokerReplicaExclusionRecord().setBrokerExclusions(Arrays.asList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(1).setReason("1"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(2).setReason("2"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(3).setReason("3")));
        clusterControl.replay(exclusionRecord);
        short expectedVersion = metadataVersion.registerBrokerRecordVersion();
        ImageWriterOptions options = new ImageWriterOptions.Builder(metadataVersion).setLossHandler(__ -> {}).build();
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com")).iterator())).setInControlledShutdown(true).setFenced(false).setMetadataEncryptors(null), expectedVersion), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(0)).toRecord(options));
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9093).setName("PLAINTEXT").setHost("example.com")).iterator())).setFenced(false).setMetadataEncryptors(null), expectedVersion), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).toRecord(options));
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(2).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9094).setName("PLAINTEXT").setHost("example.com")).iterator())).setFenced(true).setMetadataEncryptors(null), expectedVersion), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(2)).toRecord(options));
    }

    @Test
    public void testReplayExclusionRecordWorks() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        BrokerReplicaExclusionRecord record = new BrokerReplicaExclusionRecord().setBrokerExclusions(Arrays.asList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(1).setReason("1"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(2).setReason("2"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(3).setReason("3")));
        HashMap<Integer, String> expectedExclusionState = new HashMap<Integer, String>();
        expectedExclusionState.put(1, "1");
        expectedExclusionState.put(2, "2");
        expectedExclusionState.put(3, "3");
        clusterControl.replay(record);
        Assertions.assertEquals(expectedExclusionState, (Object)clusterControl.activeBrokerReplicaExclusions());
        BrokerReplicaExclusionRecord newRecord = new BrokerReplicaExclusionRecord().setBrokerExclusions(Arrays.asList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(1).setReason("1"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(2).setReason("10")));
        clusterControl.replay(newRecord);
        expectedExclusionState.put(2, "10");
        expectedExclusionState.remove(3);
        Assertions.assertEquals(expectedExclusionState, (Object)clusterControl.activeBrokerReplicaExclusions());
    }

    @Test
    public void testProcessAlterReplicaExclusions() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        QuorumControllerMetrics controllerMetrics = new QuorumControllerMetrics(Optional.empty(), Time.SYSTEM, new Metrics());
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(2, "2", ExclusionOp.OpType.SET)));
        HashMap<Integer, String> expectedExclusionState = new HashMap<Integer, String>();
        expectedExclusionState.put(1, "1");
        expectedExclusionState.put(2, "2");
        ControllerResult result = clusterControl.processAlterReplicaExclusions(requestedExclusions);
        this.verifyExclusionResponse(expectedExclusionState, requestedExclusions, true, false, (ControllerResult<AlterReplicaExclusionsReply>)result, clusterControl);
        BrokerReplicaExclusionRecord record = new BrokerReplicaExclusionRecord().setBrokerExclusions(((AlterReplicaExclusionsReply)result.response()).exclusionResults().stream().map(r -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(r.brokerId()).setReason(r.reason())).collect(Collectors.toList()));
        clusterControl.replay(record);
        Assertions.assertEquals(expectedExclusionState, (Object)clusterControl.activeBrokerReplicaExclusions());
        result = clusterControl.processAlterReplicaExclusions(requestedExclusions);
        this.verifyExclusionResponse(expectedExclusionState, expectedExclusionState, requestedExclusions, true, true, (ControllerResult<AlterReplicaExclusionsReply>)result, clusterControl);
    }

    @Test
    public void testProcessAlterReplicaExclusionsDoesNotApplyWhenAnErrorIsPresent() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(2, "2", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(3, "3", ExclusionOp.OpType.DELETE)));
        HashMap<Integer, String> expectedExclusionState = new HashMap<Integer, String>();
        ControllerResult result = clusterControl.processAlterReplicaExclusions(requestedExclusions);
        this.verifyExclusionResponse(expectedExclusionState, requestedExclusions, false, false, (ControllerResult<AlterReplicaExclusionsReply>)result, clusterControl);
    }

    @ParameterizedTest
    @EnumSource(value=BrokerComponent.class, names={"UNSPECIFIED", "STORAGE", "NETWORK"})
    public void testProcessAlterBrokerHealth(BrokerComponent component) {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        CellControlManager cellControl = new CellControlManager(new LogContext(), (Time)new MockTime(0L, 0L, 0L), snapshotRegistry, featureControl, new Random(), 15, 6, 15, true, -1);
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setCellControlManager(cellControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        for (int b = 0; b < 3; ++b) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(b).setRack(null).setFenced(false);
            brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord, 100L);
            Assertions.assertTrue((boolean)clusterControl.isUnfenced(b));
            Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(b));
        }
        AlterBrokerHealthRequestData requested = new AlterBrokerHealthRequestData().setBrokerIds(Collections.singletonList(0)).setReason("rcca-123").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.DEGRADED.id()).setForce(false);
        ControllerResult result = clusterControl.processAlterBrokerHealth(requested, 0.0);
        DegradedBrokerHealthState newDegradation = new DegradedBrokerHealthState("rcca-123", BrokerComponent.UNSPECIFIED);
        HashMap<Integer, List<DegradedBrokerHealthState>> expectedHealthState = new HashMap<Integer, List<DegradedBrokerHealthState>>();
        HashMap<Integer, List<DegradedBrokerHealthState>> expectedInMemoryState = new HashMap<Integer, List<DegradedBrokerHealthState>>();
        expectedHealthState.put(0, Collections.singletonList(newDegradation));
        expectedInMemoryState.put(0, new ArrayList<DegradedBrokerHealthState>(Collections.singletonList(newDegradation)));
        this.verifyAlterBrokerResponse(expectedInMemoryState, expectedInMemoryState, requested, true, false, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
        AlterBrokerHealthRequestData finalrequested = requested = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(1, 2)).setReason("rcca-234").setComponentCode(component.id()).setStatusCode(ComponentHealthStatus.DEGRADED.id()).setForce(false);
        Assertions.assertThrows(DemotionLimitReachedException.class, () -> clusterControl.processAlterBrokerHealth(finalrequested, 0.0));
        requested = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(1, 2)).setReason("rcca-234").setComponentCode(component.id()).setStatusCode(ComponentHealthStatus.DEGRADED.id()).setForce(false);
        result = clusterControl.processAlterBrokerHealth(requested, 100.0);
        newDegradation = new DegradedBrokerHealthState("rcca-234", component);
        expectedHealthState = new HashMap();
        expectedHealthState.put(1, Collections.singletonList(newDegradation));
        expectedHealthState.put(2, Collections.singletonList(newDegradation));
        expectedInMemoryState.put(1, Collections.singletonList(newDegradation));
        expectedInMemoryState.put(2, new ArrayList<DegradedBrokerHealthState>(Collections.singletonList(newDegradation)));
        this.verifyAlterBrokerResponse(expectedHealthState, expectedInMemoryState, requested, true, false, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
        requested = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(0, 2)).setReason("rcca-345").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.DEGRADED.id()).setForce(true);
        result = clusterControl.processAlterBrokerHealth(requested, 0.0);
        newDegradation = new DegradedBrokerHealthState("rcca-345", BrokerComponent.UNSPECIFIED);
        expectedHealthState = new HashMap();
        expectedHealthState.put(0, Collections.singletonList(newDegradation));
        expectedHealthState.put(2, Collections.singletonList(newDegradation));
        ((List)expectedInMemoryState.get(0)).add(newDegradation);
        ((List)expectedInMemoryState.get(2)).add(newDegradation);
        this.verifyAlterBrokerResponse(expectedHealthState, expectedInMemoryState, requested, true, false, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
        requested = new AlterBrokerHealthRequestData().setBrokerIds(Collections.singletonList(0)).setReason("rcca-123").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.HEALTHY.id()).setForce(false);
        result = clusterControl.processAlterBrokerHealth(requested, 0.0);
        newDegradation = new DegradedBrokerHealthState("rcca-123", BrokerComponent.UNSPECIFIED);
        expectedHealthState = new HashMap();
        expectedHealthState.put(0, Collections.singletonList(newDegradation));
        ((List)expectedInMemoryState.get(0)).remove(newDegradation);
        this.verifyAlterBrokerResponse(expectedHealthState, expectedInMemoryState, requested, true, false, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
        requested = new AlterBrokerHealthRequestData().setBrokerIds(Collections.singletonList(1)).setReason("rcca-234").setComponentCode(component.id()).setStatusCode(ComponentHealthStatus.HEALTHY.id()).setForce(false);
        result = clusterControl.processAlterBrokerHealth(requested, 0.0);
        newDegradation = new DegradedBrokerHealthState("rcca-234", component);
        expectedHealthState = new HashMap();
        expectedHealthState.put(1, Collections.singletonList(newDegradation));
        expectedInMemoryState.remove(1);
        this.verifyAlterBrokerResponse(expectedHealthState, expectedInMemoryState, requested, true, false, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
        requested = new AlterBrokerHealthRequestData().setBrokerIds(Collections.singletonList(2)).setReason("rcca-234").setComponentCode(component.id()).setStatusCode(ComponentHealthStatus.HEALTHY.id()).setForce(false);
        result = clusterControl.processAlterBrokerHealth(requested, 0.0);
        newDegradation = new DegradedBrokerHealthState("rcca-234", component);
        expectedHealthState = new HashMap();
        expectedHealthState.put(2, Collections.singletonList(newDegradation));
        ((List)expectedInMemoryState.get(2)).remove(newDegradation);
        this.verifyAlterBrokerResponse(expectedHealthState, expectedInMemoryState, requested, true, false, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
        requested = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(0, 2)).setReason("rcca-345").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.HEALTHY.id()).setForce(false);
        result = clusterControl.processAlterBrokerHealth(requested, 0.0);
        newDegradation = new DegradedBrokerHealthState("rcca-345", BrokerComponent.UNSPECIFIED);
        expectedHealthState = new HashMap();
        expectedHealthState.put(0, Collections.singletonList(newDegradation));
        expectedHealthState.put(2, Collections.singletonList(newDegradation));
        this.verifyAlterBrokerResponse(expectedHealthState, Collections.emptyMap(), requested, true, false, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
    }

    @Test
    public void testProcessAlterBrokerHealthDoesNotApplyWhenAnErrorIsPresent() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        CellControlManager cellControl = new CellControlManager(new LogContext(), (Time)new MockTime(0L, 0L, 0L), snapshotRegistry, featureControl, new Random(), 15, 6, 15, true, -1);
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setCellControlManager(cellControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        for (int b = 0; b < 3; ++b) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(b).setRack(null).setFenced(false);
            brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord, 100L);
            Assertions.assertTrue((boolean)clusterControl.isUnfenced(b));
            Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(b));
        }
        Assertions.assertThrows(InvalidRequestException.class, () -> clusterControl.processAlterBrokerHealth(new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(0, 1, 3)).setReason("rcca-123").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.DEGRADED.id()).setForce(true), 100.0));
        AlterBrokerHealthRequestData requested = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(0, 1)).setReason("rcca-123").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.DEGRADED.id()).setForce(false);
        ControllerResult result = clusterControl.processAlterBrokerHealth(requested, 100.0);
        HashMap<Integer, List<DegradedBrokerHealthState>> expectedInMemoryState = new HashMap<Integer, List<DegradedBrokerHealthState>>();
        expectedInMemoryState.put(0, Collections.singletonList(new DegradedBrokerHealthState("rcca-123", BrokerComponent.UNSPECIFIED)));
        expectedInMemoryState.put(1, Collections.singletonList(new DegradedBrokerHealthState("rcca-123", BrokerComponent.UNSPECIFIED)));
        this.verifyAlterBrokerResponse(expectedInMemoryState, expectedInMemoryState, requested, true, false, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
        requested = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(0, 1)).setReason("rcca-123").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.DEGRADED.id()).setForce(true);
        result = clusterControl.processAlterBrokerHealth(requested, 100.0);
        this.verifyAlterBrokerResponse(expectedInMemoryState, expectedInMemoryState, requested, true, true, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
        requested = new AlterBrokerHealthRequestData().setBrokerIds(Collections.singletonList(0)).setReason("rcca-123").setComponentCode(BrokerComponent.STORAGE.id()).setStatusCode(ComponentHealthStatus.HEALTHY.id()).setForce(false);
        result = clusterControl.processAlterBrokerHealth(requested, 0.0);
        this.verifyAlterBrokerResponse(Collections.emptyMap(), expectedInMemoryState, requested, true, true, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
        requested = new AlterBrokerHealthRequestData().setBrokerIds(Collections.singletonList(0)).setReason("rcca-234").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.HEALTHY.id()).setForce(false);
        result = clusterControl.processAlterBrokerHealth(requested, 0.0);
        this.verifyAlterBrokerResponse(Collections.emptyMap(), expectedInMemoryState, requested, true, true, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
        requested = new AlterBrokerHealthRequestData().setBrokerIds(Collections.singletonList(2)).setReason("rcca-123").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.HEALTHY.id()).setForce(false);
        result = clusterControl.processAlterBrokerHealth(requested, 0.0);
        this.verifyAlterBrokerResponse(Collections.emptyMap(), expectedInMemoryState, requested, true, true, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
        requested = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(0, 1, 2)).setReason("rcca-123").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.HEALTHY.id()).setForce(false);
        result = clusterControl.processAlterBrokerHealth(requested, 0.0);
        HashMap<Integer, List<DegradedBrokerHealthState>> expectedHealthState = expectedInMemoryState;
        this.verifyAlterBrokerResponse(expectedHealthState, Collections.emptyMap(), requested, true, false, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
    }

    @Test
    public void testRegistrationWithDegradations() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        CellControlManager cellControl = new CellControlManager(new LogContext(), (Time)new MockTime(0L, 0L, 0L), snapshotRegistry, featureControl, new Random(), 15, 6, 15, true, -1);
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setCellControlManager(cellControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        RegisterBrokerRecord.DegradedComponent degradedComponent = new RegisterBrokerRecord.DegradedComponent().setReason("rcca-123").setComponentCode((byte)0);
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setFenced(false).setDegradedComponents(Collections.singletonList(degradedComponent));
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        HashMap<Integer, Set<DegradedBrokerHealthState>> expectedInMemoryState = new HashMap<Integer, Set<DegradedBrokerHealthState>>();
        expectedInMemoryState.put(0, Collections.singleton(DegradedBrokerHealthState.fromDegradedComponent((RegisterBrokerRecord.DegradedComponent)degradedComponent)));
        Assertions.assertEquals(expectedInMemoryState, (Object)clusterControl.activeBrokerComponentDegradations());
        degradedComponent = new RegisterBrokerRecord.DegradedComponent().setReason("rcca-234").setComponentCode((byte)0);
        brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setFenced(false).setDegradedComponents(Collections.singletonList(degradedComponent));
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        expectedInMemoryState.put(0, Collections.singleton(DegradedBrokerHealthState.fromDegradedComponent((RegisterBrokerRecord.DegradedComponent)degradedComponent)));
        Assertions.assertEquals(expectedInMemoryState, (Object)clusterControl.activeBrokerComponentDegradations());
    }

    @Test
    public void testReregistrationPersistsDegradations() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        String clusterId = "fPZv1VBsRFmnlRvmGcOW9w";
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId(clusterId).setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setLogDirs(Collections.singletonList(Uuid.fromString((String)"AYV9dP9B5DgBLLgDla3xqg")));
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        UnfenceBrokerRecord unfenceRecord = new UnfenceBrokerRecord().setId(0).setEpoch(100L);
        clusterControl.replay(unfenceRecord);
        Assertions.assertEquals((int)0, (int)clusterControl.activeBrokerComponentDegradations().size());
        RegisterBrokerRecord.DegradedComponent expectedDegradation = new RegisterBrokerRecord.DegradedComponent().setReason("rcca-123").setComponentCode(BrokerComponent.UNSPECIFIED.id());
        AlterBrokerHealthRequestData requested = new AlterBrokerHealthRequestData().setBrokerIds(Collections.singletonList(0)).setReason("rcca-123").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.DEGRADED.id()).setForce(true);
        ControllerResult healthResult = clusterControl.processAlterBrokerHealth(requested, 100.0);
        clusterControl.replay((BrokerRegistrationChangeRecord)((ApiMessageAndVersion)healthResult.records().get(0)).message());
        Assertions.assertEquals((int)1, (int)clusterControl.activeBrokerComponentDegradations().size());
        BrokerRegistrationChangeRecord registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.FENCE.value());
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertEquals((int)1, (int)clusterControl.activeBrokerComponentDegradations().size());
        Assertions.assertEquals(Collections.singleton(DegradedBrokerHealthState.fromDegradedComponent((RegisterBrokerRecord.DegradedComponent)expectedDegradation)), clusterControl.activeBrokerComponentDegradations().get(0));
        registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value());
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
        Assertions.assertEquals((int)1, (int)clusterControl.activeBrokerComponentDegradations().size());
        Assertions.assertEquals(Collections.singleton(DegradedBrokerHealthState.fromDegradedComponent((RegisterBrokerRecord.DegradedComponent)expectedDegradation)), clusterControl.activeBrokerComponentDegradations().get(0));
        ControllerResult brokerResult2 = clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId(clusterId).setBrokerId(0).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel())).iterator())).setLogDirs(Collections.singletonList(Uuid.fromString((String)"AYV9dP9B5DgBLLgDla3xqg"))).setRack(null).setIncarnationId(Uuid.fromString((String)"kyWZIGpUTNqTwKd03VFOHg")), 200L, new FinalizedControllerFeatures(Collections.emptyMap(), 456L), true, false);
        List records2 = brokerResult2.records();
        RegisterBrokerRecord registerBrokerRecord = (RegisterBrokerRecord)((ApiMessageAndVersion)records2.get(0)).message();
        Assertions.assertEquals((int)2, (int)registerBrokerRecord.degradedComponents().size());
        HashSet<RegisterBrokerRecord.DegradedComponent> expectedComponents = new HashSet<RegisterBrokerRecord.DegradedComponent>(Arrays.asList(expectedDegradation, this.externalConnectivityStartup));
        Assertions.assertEquals(expectedComponents, new HashSet(registerBrokerRecord.degradedComponents()));
        clusterControl.replay(registerBrokerRecord, 200L);
        Assertions.assertEquals((int)1, (int)clusterControl.activeBrokerComponentDegradations().size());
        HashSet<DegradedBrokerHealthState> expectedHealthStates = new HashSet<DegradedBrokerHealthState>(Arrays.asList(DegradedBrokerHealthState.fromDegradedComponent((RegisterBrokerRecord.DegradedComponent)expectedDegradation), DegradedBrokerHealthState.fromDegradedComponent((RegisterBrokerRecord.DegradedComponent)this.externalConnectivityStartup)));
        Assertions.assertEquals(expectedHealthStates, clusterControl.activeBrokerComponentDegradations().get(0));
    }

    @Test
    public void testUnregisterRemovesDegradations() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        CellControlManager cellControl = new CellControlManager(new LogContext(), (Time)new MockTime(0L, 0L, 0L), snapshotRegistry, featureControl, new Random(), 15, 6, 15, true, -1);
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setCellControlManager(cellControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        HashMap<Integer, List<DegradedBrokerHealthState>> expectedHealthState = new HashMap<Integer, List<DegradedBrokerHealthState>>();
        HashMap<Integer, List<DegradedBrokerHealthState>> expectedInMemoryState = new HashMap<Integer, List<DegradedBrokerHealthState>>();
        RegisterBrokerRecord.DegradedComponent degradedComponent = new RegisterBrokerRecord.DegradedComponent().setReason("rcca-123").setComponentCode((byte)0);
        for (int b = 0; b < 3; ++b) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(b).setRack(null).setLogDirs(Arrays.asList(Uuid.fromString((String)("TESTBROKER" + Integer.toString(100000 + b).substring(1) + "DIRAAAA")))).setFenced(false);
            brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord, 100L);
            expectedHealthState.put(b, Collections.singletonList(DegradedBrokerHealthState.fromDegradedComponent((RegisterBrokerRecord.DegradedComponent)degradedComponent)));
        }
        expectedInMemoryState = new HashMap(expectedHealthState);
        AlterBrokerHealthRequestData requested = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(0, 1, 2)).setReason("rcca-123").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.DEGRADED.id()).setForce(true);
        ControllerResult result = clusterControl.processAlterBrokerHealth(requested, 0.0);
        this.verifyAlterBrokerResponse(expectedHealthState, expectedInMemoryState, requested, true, false, (ControllerResult<AlterBrokerHealthResponseData>)result, clusterControl);
        UnregisterBrokerRecord unregisterBrokerRecord = new UnregisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(2);
        clusterControl.replay(unregisterBrokerRecord);
        expectedInMemoryState.remove(2);
        this.assertActiveBrokerDegradations(clusterControl, expectedInMemoryState);
    }

    private void assertActiveBrokerDegradations(ClusterControlManager clusterControl, Map<Integer, List<DegradedBrokerHealthState>> expectedDegradations) {
        Map actualDegradations = clusterControl.activeBrokerComponentDegradations();
        Assertions.assertEquals(expectedDegradations.keySet(), actualDegradations.keySet());
        for (Integer brokerId : expectedDegradations.keySet()) {
            Assertions.assertEquals(new HashSet(expectedDegradations.get(brokerId)), actualDegradations.get(brokerId));
        }
    }

    @Test
    public void testCellBrokers() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        CellControlManager cellControl = new CellControlManager(new LogContext(), (Time)new MockTime(0L, 0L, 0L), snapshotRegistry, featureControl, new Random(), 15, 6, 15, true, -1);
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setCellControlManager(cellControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        cellControl.replay(new CellRecord().setCellId(0).setBrokers(new ArrayList<Integer>(Arrays.asList(0, 1, 2))).setMinSize((short)6).setMaxSize((short)15));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1, 2)), (Object)clusterControl.cellBrokers(0));
    }

    private void verifyExclusionResponse(Map<Integer, String> expectedExclusions, Set<AlterReplicaExclusionOp> requestedExclusions, boolean expectedToBeSuccessful, boolean expectedToBeSuccessfulNoOp, ControllerResult<AlterReplicaExclusionsReply> receivedResult, ClusterControlManager controlManager) {
        this.verifyExclusionResponse(expectedExclusions, Collections.emptyMap(), requestedExclusions, expectedToBeSuccessful, expectedToBeSuccessfulNoOp, receivedResult, controlManager);
    }

    private void verifyExclusionResponse(Map<Integer, String> expectedExclusions, Map<Integer, String> expectedInMemoryExclusions, Set<AlterReplicaExclusionOp> requestedExclusions, boolean expectedToBeSuccessful, boolean expectedToBeSuccessfulNoOp, ControllerResult<AlterReplicaExclusionsReply> receivedResult, ClusterControlManager controlManager) {
        if (expectedToBeSuccessfulNoOp) {
            Assertions.assertTrue((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessful(), (String)"Expected the exclusions to have applied successfully");
            Assertions.assertTrue((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessfulNoOp(), (String)"Expected the request to be a no-op");
            Assertions.assertEquals((int)0, (int)receivedResult.records().size(), (String)"Expected no records to be persisted because the request was a no-op");
            Assertions.assertEquals((int)requestedExclusions.size(), (int)((AlterReplicaExclusionsReply)receivedResult.response()).exclusionResults().size());
            Assertions.assertEquals(expectedInMemoryExclusions, (Object)controlManager.activeBrokerReplicaExclusions());
        } else if (expectedToBeSuccessful) {
            Assertions.assertTrue((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessful(), (String)"Expected the exclusions to have applied successfully");
            Assertions.assertFalse((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessfulNoOp(), (String)"Expected the exclusion request to NOT have been a no-op");
            Assertions.assertEquals((int)1, (int)receivedResult.records().size());
            BrokerReplicaExclusionRecord expectedRecord = new BrokerReplicaExclusionRecord().setBrokerExclusions(expectedExclusions.entrySet().stream().map(entry -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setReason((String)entry.getValue()).setBrokerId(((Integer)entry.getKey()).intValue())).collect(Collectors.toList()));
            Assertions.assertEquals((Object)expectedRecord, (Object)((ApiMessageAndVersion)receivedResult.records().get(0)).message());
            Assertions.assertEquals((int)requestedExclusions.size(), (int)((AlterReplicaExclusionsReply)receivedResult.response()).exclusionResults().size());
            Assertions.assertEquals(expectedInMemoryExclusions, (Object)controlManager.activeBrokerReplicaExclusions());
        } else {
            Assertions.assertFalse((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessful(), (String)"Expected the exclusions to have NOT applied");
            Assertions.assertEquals((int)0, (int)receivedResult.records().size(), (String)"No records should have been persistent when exclusions were not applied successfully");
            Assertions.assertEquals(expectedInMemoryExclusions, (Object)controlManager.activeBrokerReplicaExclusions());
        }
    }

    private void verifyAlterBrokerResponse(Map<Integer, List<DegradedBrokerHealthState>> expectedHealthState, Map<Integer, List<DegradedBrokerHealthState>> expectedInMemoryState, AlterBrokerHealthRequestData requested, boolean expectedToBeSuccessful, boolean expectedToBeSuccessfulNoOp, ControllerResult<AlterBrokerHealthResponseData> receivedResult, ClusterControlManager controlManager) {
        if (expectedToBeSuccessfulNoOp) {
            Assertions.assertEquals((int)0, (int)receivedResult.records().size(), (String)"Expected no records to be persisted because the request was a no-op");
            Assertions.assertEquals((int)Optional.ofNullable(requested.brokerIds()).orElse(Collections.emptyList()).size(), (int)((AlterBrokerHealthResponseData)receivedResult.response()).brokerHealthStatusResults().size());
        } else if (expectedToBeSuccessful) {
            Assertions.assertEquals((int)expectedHealthState.keySet().size(), (int)receivedResult.records().size());
            List expectedRecords = expectedHealthState.entrySet().stream().map(entry -> new BrokerRegistrationChangeRecord().setBrokerId(((Integer)entry.getKey()).intValue()).setBrokerEpoch(100L).setDegradedComponents(expectedInMemoryState.getOrDefault(entry.getKey(), Collections.emptyList()).stream().map(healthState -> new BrokerRegistrationChangeRecord.DegradedComponent().setReason(healthState.reason()).setComponentCode(healthState.component().id())).collect(Collectors.toList()))).collect(Collectors.toList());
            Assertions.assertEquals(expectedRecords, receivedResult.records().stream().map(r -> r.message()).collect(Collectors.toList()));
            Assertions.assertEquals((int)Optional.ofNullable(requested.brokerIds()).orElse(Collections.emptyList()).size(), (int)((AlterBrokerHealthResponseData)receivedResult.response()).brokerHealthStatusResults().size());
            receivedResult.records().forEach(record -> controlManager.replay((BrokerRegistrationChangeRecord)record.message()));
            this.assertActiveBrokerDegradations(controlManager, expectedInMemoryState);
        } else {
            Assertions.assertEquals((int)0, (int)receivedResult.records().size(), (String)"No records should have been persistent when exclusions were not applied successfully");
            this.assertActiveBrokerDegradations(controlManager, expectedInMemoryState);
        }
    }

    @Test
    public void testRegistrationWithUnsupportedFeature() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        HashMap<String, VersionRange> supportedFeatures = new HashMap<String, VersionRange>();
        supportedFeatures.put("confluent.metadata.version", VersionRange.of((short)MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel(), (short)MetadataVersion.IBP_3_7_IV0.confluentFeatureLevel()));
        supportedFeatures.put("test.feature.version", VersionRange.of((short)TestFeatureVersion.TEST_0.featureLevel(), (short)TestFeatureVersion.TEST_1.featureLevel()));
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, supportedFeatures, Collections.singletonList(0))).setMetadataVersion(MetadataVersion.IBP_3_7_IV0).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        FeatureLevelRecord testFeatureRecord = new FeatureLevelRecord().setName("test.feature.version").setFeatureLevel((short)1);
        featureControl.replay(testFeatureRecord);
        List<Uuid> logDirs = Arrays.asList(Uuid.fromString((String)"yJGxmjfbQZSVFAlNM3uXZg"), Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ"));
        BrokerRegistrationRequestData baseRequest = new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")).setLogDirs(logDirs);
        Assertions.assertEquals((Object)"Unable to register because the broker does not support finalized version 1 of test.feature.version. The broker wants a version between 0 and 0, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(baseRequest.setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_7_IV0.confluentFeatureLevel())).iterator())), 123L, featureControl.finalizedFeatures(Long.MAX_VALUE), false, false))).getMessage());
    }

    @Test
    public void testRegistrationWithUnsupportedKraftVersion() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        HashMap<String, VersionRange> supportedFeatures = new HashMap<String, VersionRange>();
        supportedFeatures.put("confluent.metadata.version", VersionRange.of((short)MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel(), (short)MetadataVersion.IBP_3_9_IV0A.confluentFeatureLevel()));
        supportedFeatures.put("kraft.version", VersionRange.of((short)KRaftVersion.KRAFT_VERSION_1.featureLevel(), (short)KRaftVersion.KRAFT_VERSION_1.featureLevel()));
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, supportedFeatures, Collections.singletonList(0))).setMetadataVersion(MetadataVersion.IBP_3_9_IV0A).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        List<Uuid> logDirs = Arrays.asList(Uuid.fromString((String)"yJGxmjfbQZSVFAlNM3uXZg"), Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ"));
        BrokerRegistrationRequestData baseRequest = new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")).setLogDirs(logDirs);
        HashMap<String, Short> updatedFeaturesMap = new HashMap<String, Short>(featureControl.finalizedFeatures(Long.MAX_VALUE).featureMap());
        updatedFeaturesMap.put("kraft.version", KRaftVersion.KRAFT_VERSION_1.featureLevel());
        FinalizedControllerFeatures updatedFinalizedFeatures = new FinalizedControllerFeatures(updatedFeaturesMap, Long.MAX_VALUE);
        Assertions.assertEquals((Object)"Unable to register because the broker does not support finalized version 1 of kraft.version. The broker wants a version between 0 and 0, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(baseRequest.setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_9_IV0A.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_9_IV0A.confluentFeatureLevel())).iterator())), 123L, updatedFinalizedFeatures, false, false))).getMessage());
        Assertions.assertEquals((Object)"Unable to register because the broker does not support finalized version 1 of kraft.version. The broker wants a version between 0 and 0, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(baseRequest.setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Arrays.asList(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_9_IV0A.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_9_IV0A.confluentFeatureLevel()), new BrokerRegistrationRequestData.Feature().setName("kraft.version").setMinSupportedVersion(KRaftVersion.KRAFT_VERSION_0.featureLevel()).setMaxSupportedVersion(KRaftVersion.KRAFT_VERSION_0.featureLevel())).iterator())), 123L, updatedFinalizedFeatures, false, false))).getMessage());
        clusterControl.registerBroker(baseRequest.setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Arrays.asList(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_9_IV0A.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_9_IV0A.confluentFeatureLevel()), new BrokerRegistrationRequestData.Feature().setName("kraft.version").setMinSupportedVersion(KRaftVersion.KRAFT_VERSION_1.featureLevel()).setMaxSupportedVersion(KRaftVersion.KRAFT_VERSION_1.featureLevel())).iterator())), 123L, updatedFinalizedFeatures, true, false);
    }

    @Test
    public void testRegistrationWithUnsupportedMetadataVersion() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, Collections.singletonMap("confluent.metadata.version", VersionRange.of((short)MetadataVersion.IBP_3_5_IV0.confluentFeatureLevel(), (short)MetadataVersion.IBP_3_6_IV0.confluentFeatureLevel())), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.IBP_3_5_IV0).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        Assertions.assertEquals((Object)"Unable to register broker 0 because it does not support finalized version 109 of confluent.metadata.version. The broker wants a version between 107 and 107, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, featureControl.finalizedFeatures(Long.MAX_VALUE), true, false))).getMessage());
        Assertions.assertEquals((Object)"Unable to register broker 0 because it does not support finalized version 109 of confluent.metadata.version. The broker wants a version between 108 and 108, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_4_IV0.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_4_IV0.confluentFeatureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, featureControl.finalizedFeatures(Long.MAX_VALUE), true, false))).getMessage());
        Assertions.assertEquals((Object)"Unable to register broker 0 because it does not support confluent.metadata.version. Please upgrade your broker to Confluent Platform, or downgrade your controller to Apache Kafka. Brokers must be upgraded first in a rolling upgrade from Apache to CP.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_3_IV3.apacheFeatureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_3_IV3.apacheFeatureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, featureControl.finalizedFeatures(Long.MAX_VALUE), true, false))).getMessage());
    }

    @Test
    public void testRegisterControlWithUnsupportedMetadataVersion() {
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setMetadataVersion(MetadataVersion.IBP_3_6_IV2).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        Assertions.assertEquals((Object)"The current MetadataVersion is too old to support controller registrations.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerController(new ControllerRegistrationRequestData().setControllerId(1), featureControl.finalizedFeatures(Long.MAX_VALUE)))).getMessage());
    }

    @Test
    public void testReplayRegisterControllerRecord() {
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        Assertions.assertFalse((boolean)clusterControl.hasControllerRegistrationForId(0));
        RegisterControllerRecord controllerRecord = new RegisterControllerRecord().setControllerId(0);
        controllerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterControllerRecord.ControllerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(controllerRecord);
        Assertions.assertTrue((boolean)clusterControl.hasControllerRegistrationForId(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterWithEncryptor() throws IOException {
        MetadataEncryptorFactory staticEncryptorOnlyFactory = new MetadataEncryptorFactory(LEGACY_ENCRYPTOR_CONFIG);
        File tempJsonFile = null;
        try {
            tempJsonFile = TestUtils.tempFile((String)ENCRYPTOR_FILE_JSON_ONE_SECRET);
            HashMap<String, Object> map = new HashMap<String, Object>(LEGACY_ENCRYPTOR_CONFIG);
            map.put("confluent.metadata.encryptor.secret.file", tempJsonFile.getAbsolutePath());
            MetadataEncryptorFactory staticAndFileBasedEncryptorFactory = new MetadataEncryptorFactory(map);
            AtomicReference<MetadataEncryptorFactory> refFactoryToSupply = new AtomicReference<MetadataEncryptorFactory>(staticEncryptorOnlyFactory);
            Supplier<MetadataEncryptorFactory> encryptorFactorySupplier = () -> (MetadataEncryptorFactory)refFactoryToSupply.get();
            LogContext logContext = new LogContext();
            SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
            EncryptionControlManager encryptionControl = new EncryptionControlManager.Builder().setLogContext(logContext).setSnapshotRegistry(snapshotRegistry).setEncryptorFactorySupplier(encryptorFactorySupplier).build();
            MockTime time = new MockTime(0L, 0L, 0L);
            FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
            String clusterId = "fPZv1VBsRFmnlRvmGcOW9w";
            ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId(clusterId).setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setEncryptionControlManager(encryptionControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
            clusterControl.activate();
            Assertions.assertEquals((Object)NoOpMetadataEncryptor.INSTANCE, (Object)encryptionControl.encryptor());
            List<ControllerRegistrationRequestData.Encryptor> twoLegacyControllerEncryptors = Arrays.asList(new ControllerRegistrationRequestData.Encryptor().setEncryptorId(INACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG), new ControllerRegistrationRequestData.Encryptor().setEncryptorId(ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG));
            List<BrokerRegistrationRequestData.Encryptor> twoLegacyBrokerEncryptors = Arrays.asList(new BrokerRegistrationRequestData.Encryptor().setEncryptorId(INACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG), new BrokerRegistrationRequestData.Encryptor().setEncryptorId(ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG));
            List<ControllerRegistrationRequestData.Encryptor> threeControllerEncryptors = Arrays.asList(new ControllerRegistrationRequestData.Encryptor().setEncryptorId(INACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG), new ControllerRegistrationRequestData.Encryptor().setEncryptorId(ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG), new ControllerRegistrationRequestData.Encryptor().setEncryptorId(ENCRYPTOR_ID_FROM_FILE));
            List<BrokerRegistrationRequestData.Encryptor> threeBrokerEncryptors = Arrays.asList(new BrokerRegistrationRequestData.Encryptor().setEncryptorId(INACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG), new BrokerRegistrationRequestData.Encryptor().setEncryptorId(ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG), new BrokerRegistrationRequestData.Encryptor().setEncryptorId(ENCRYPTOR_ID_FROM_FILE));
            ClusterControlManagerTest.registerControllerThenCheckAndProcessResults(featureControl, clusterControl, encryptionControl, twoLegacyControllerEncryptors, ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG);
            long brokerEpoch = 12345L;
            int brokerId2 = 1;
            ClusterControlManagerTest.registerBrokerThenCheckAndProcessResults(featureControl, clusterId, clusterControl, encryptionControl, brokerEpoch, brokerId2, null, null);
            brokerId2 = 2;
            ClusterControlManagerTest.registerBrokerThenCheckAndProcessResults(featureControl, clusterId, clusterControl, encryptionControl, brokerEpoch, brokerId2, null, null);
            ClusterControlManagerTest.registerControllerThenCheckAndProcessResults(featureControl, clusterControl, encryptionControl, twoLegacyControllerEncryptors, null);
            brokerId2 = 1;
            ClusterControlManagerTest.registerBrokerThenCheckAndProcessResults(featureControl, clusterId, clusterControl, encryptionControl, brokerEpoch, brokerId2, twoLegacyBrokerEncryptors, null);
            brokerId2 = 2;
            ClusterControlManagerTest.registerBrokerThenCheckAndProcessResults(featureControl, clusterId, clusterControl, encryptionControl, brokerEpoch, brokerId2, twoLegacyBrokerEncryptors, null);
            refFactoryToSupply.set(staticAndFileBasedEncryptorFactory);
            ClusterControlManagerTest.registerControllerThenCheckAndProcessResults(featureControl, clusterControl, encryptionControl, threeControllerEncryptors, null);
            brokerId2 = 1;
            ClusterControlManagerTest.registerBrokerThenCheckAndProcessResults(featureControl, clusterId, clusterControl, encryptionControl, brokerEpoch, brokerId2, threeBrokerEncryptors, null);
            brokerId2 = 2;
            ClusterControlManagerTest.registerBrokerThenCheckAndProcessResults(featureControl, clusterId, clusterControl, encryptionControl, brokerEpoch, brokerId2, threeBrokerEncryptors, ENCRYPTOR_ID_FROM_FILE);
            brokerId2 = 3;
            BrokerRegistrationDoesNotContainEncryptorSecretException e = (BrokerRegistrationDoesNotContainEncryptorSecretException)Assertions.assertThrows(BrokerRegistrationDoesNotContainEncryptorSecretException.class, () -> ClusterControlManagerTest.registerBroker(featureControl, clusterId, clusterControl, brokerEpoch, 3, twoLegacyBrokerEncryptors));
            Assertions.assertEquals((Object)("Broker Registration with broker ID 3 does not contain the active secret " + String.valueOf(ENCRYPTOR_ID_FROM_FILE)), (Object)e.getMessage());
            BrokerRegistrationRequestData.Encryptor activeBrokerEncryptor = new BrokerRegistrationRequestData.Encryptor().setEncryptorId(ENCRYPTOR_ID_FROM_FILE);
            ClusterControlManagerTest.registerBrokerThenCheckAndProcessResults(featureControl, clusterId, clusterControl, encryptionControl, brokerEpoch, brokerId2, Collections.singletonList(activeBrokerEncryptor), null);
        }
        finally {
            if (tempJsonFile != null) {
                tempJsonFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrokerRegistersFirstWithoutEncryptorWhenRequired() throws IOException {
        File tempJsonFile = null;
        try {
            tempJsonFile = TestUtils.tempFile((String)ENCRYPTOR_FILE_JSON_ONE_SECRET);
            Map<String, String> map = Collections.singletonMap("confluent.metadata.encryptor.secret.file", tempJsonFile.getAbsolutePath());
            MetadataEncryptorFactory fileBasedEncryptorFactory = new MetadataEncryptorFactory(map);
            Supplier<MetadataEncryptorFactory> encryptorFactorySupplier = () -> fileBasedEncryptorFactory;
            LogContext logContext = new LogContext();
            SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
            EncryptionControlManager encryptionControl = new EncryptionControlManager.Builder().setLogContext(logContext).setSnapshotRegistry(snapshotRegistry).setEncryptorFactorySupplier(encryptorFactorySupplier).setIsEncryptorRequired(Boolean.TRUE).build();
            MockTime time = new MockTime(0L, 0L, 0L);
            FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
            String clusterId = "fPZv1VBsRFmnlRvmGcOW9w";
            ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId(clusterId).setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setEncryptionControlManager(encryptionControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
            clusterControl.activate();
            List<ControllerRegistrationRequestData.Encryptor> controllerEncryptor = Arrays.asList(new ControllerRegistrationRequestData.Encryptor().setEncryptorId(ENCRYPTOR_ID_FROM_FILE));
            long brokerEpoch = 12345L;
            int brokerId2 = 1;
            BrokerRegistrationDoesNotContainEncryptorSecretException e = (BrokerRegistrationDoesNotContainEncryptorSecretException)Assertions.assertThrows(BrokerRegistrationDoesNotContainEncryptorSecretException.class, () -> ClusterControlManagerTest.registerBroker(featureControl, clusterId, clusterControl, brokerEpoch, brokerId2, null));
            Assertions.assertEquals((Object)"Broker Registration with broker ID 1 does not contain any encryptor secret while the confluent.metadata.encryptor.required is true", (Object)e.getMessage());
        }
        finally {
            if (tempJsonFile != null) {
                tempJsonFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterWithEncryptorButNoRegisterControllerRequestSupported() throws IOException {
        MetadataEncryptorFactory staticEncryptorOnlyFactory = new MetadataEncryptorFactory(LEGACY_ENCRYPTOR_CONFIG);
        File tempJsonFile = null;
        try {
            tempJsonFile = TestUtils.tempFile((String)ENCRYPTOR_FILE_JSON_ONE_SECRET);
            HashMap<String, Object> map = new HashMap<String, Object>(LEGACY_ENCRYPTOR_CONFIG);
            map.put("confluent.metadata.encryptor.secret.file", tempJsonFile.getAbsolutePath());
            MetadataEncryptorFactory staticAndFileBasedEncryptorFactory = new MetadataEncryptorFactory(map);
            AtomicReference<MetadataEncryptorFactory> refFactoryToSupply = new AtomicReference<MetadataEncryptorFactory>(staticEncryptorOnlyFactory);
            Supplier<MetadataEncryptorFactory> encryptorFactorySupplier = () -> (MetadataEncryptorFactory)refFactoryToSupply.get();
            LogContext logContext = new LogContext();
            SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
            EncryptionControlManager encryptionControl = new EncryptionControlManager.Builder().setLogContext(logContext).setSnapshotRegistry(snapshotRegistry).setEncryptorFactorySupplier(encryptorFactorySupplier).build();
            MockTime time = new MockTime(0L, 0L, 0L);
            FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.IBP_3_6_IV2).build();
            String clusterId = "fPZv1VBsRFmnlRvmGcOW9w";
            ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId(clusterId).setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setEncryptionControlManager(encryptionControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
            clusterControl.activate();
            Assertions.assertEquals((Object)NoOpMetadataEncryptor.INSTANCE, (Object)encryptionControl.encryptor());
            List<BrokerRegistrationRequestData.Encryptor> threeBrokerEncryptors = Arrays.asList(new BrokerRegistrationRequestData.Encryptor().setEncryptorId(INACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG), new BrokerRegistrationRequestData.Encryptor().setEncryptorId(ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG), new BrokerRegistrationRequestData.Encryptor().setEncryptorId(ENCRYPTOR_ID_FROM_FILE));
            long brokerEpoch = 12345L;
            int brokerId2 = 1;
            ClusterControlManagerTest.registerBrokerThenCheckAndProcessResults(featureControl, clusterId, clusterControl, encryptionControl, brokerEpoch, brokerId2, threeBrokerEncryptors, ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG);
            brokerId2 = 2;
            ClusterControlManagerTest.registerBrokerThenCheckAndProcessResults(featureControl, clusterId, clusterControl, encryptionControl, brokerEpoch, brokerId2, threeBrokerEncryptors, null);
            refFactoryToSupply.set(staticAndFileBasedEncryptorFactory);
            brokerId2 = 1;
            ClusterControlManagerTest.registerBrokerThenCheckAndProcessResults(featureControl, clusterId, clusterControl, encryptionControl, brokerEpoch, brokerId2, threeBrokerEncryptors, ENCRYPTOR_ID_FROM_FILE);
            brokerId2 = 2;
            ClusterControlManagerTest.registerBrokerThenCheckAndProcessResults(featureControl, clusterId, clusterControl, encryptionControl, brokerEpoch, brokerId2, threeBrokerEncryptors, null);
        }
        finally {
            if (tempJsonFile != null) {
                tempJsonFile.delete();
            }
        }
    }

    private static void registerControllerThenCheckAndProcessResults(FeatureControlManager featureControl, ClusterControlManager clusterControl, EncryptionControlManager encryptionControl, List<ControllerRegistrationRequestData.Encryptor> controllerEncryptors, Uuid expectedEncryptorInstalled) {
        ControllerResult voidControllerResult = clusterControl.registerController(new ControllerRegistrationRequestData().setControllerId(0).setListeners(new ControllerRegistrationRequestData.ListenerCollection()).setFeatures(new ControllerRegistrationRequestData.FeatureCollection()).setMetadataEncryptors(controllerEncryptors), featureControl.finalizedFeatures(Long.MAX_VALUE));
        List records = voidControllerResult.records();
        if (expectedEncryptorInstalled != null) {
            Assertions.assertEquals((int)2, (int)records.size());
        } else {
            Assertions.assertEquals((int)1, (int)records.size());
        }
        RegisterControllerRecord registerControllerRecord = (RegisterControllerRecord)((ApiMessageAndVersion)records.get(0)).message();
        Assertions.assertEquals((int)0, (int)registerControllerRecord.controllerId());
        Assertions.assertEquals((int)controllerEncryptors.size(), (int)registerControllerRecord.metadataEncryptors().size());
        for (int i = 0; i < controllerEncryptors.size(); ++i) {
            Assertions.assertEquals((Object)controllerEncryptors.get(i).encryptorId(), (Object)((RegisterControllerRecord.Encryptor)registerControllerRecord.metadataEncryptors().get(i)).encryptorId());
        }
        clusterControl.replay(registerControllerRecord);
        Assertions.assertTrue((boolean)clusterControl.hasControllerRegistrationForId(0));
        if (expectedEncryptorInstalled != null) {
            InstallMetadataEncryptorRecord installMetadataEncryptorRecord = (InstallMetadataEncryptorRecord)((ApiMessageAndVersion)records.get(1)).message();
            Assertions.assertEquals((Object)expectedEncryptorInstalled, (Object)installMetadataEncryptorRecord.keyId());
            encryptionControl.replay(installMetadataEncryptorRecord);
            Assertions.assertEquals(AesGcm128MetadataEncryptor.class, (Object)encryptionControl.encryptor().getClass());
            Assertions.assertEquals((Object)expectedEncryptorInstalled, (Object)encryptionControl.activeEncryptorId());
        }
    }

    private static void registerBrokerThenCheckAndProcessResults(FeatureControlManager featureControl, String clusterId, ClusterControlManager clusterControl, EncryptionControlManager encryptionControl, long brokerEpoch, int brokerId, List<BrokerRegistrationRequestData.Encryptor> brokerEncryptors, Uuid expectedEncryptorInstalled) {
        List<ApiMessageAndVersion> records = ClusterControlManagerTest.registerBroker(featureControl, clusterId, clusterControl, brokerEpoch, brokerId, brokerEncryptors);
        if (expectedEncryptorInstalled != null) {
            Assertions.assertEquals((int)3, (int)records.size());
        } else {
            Assertions.assertEquals((int)2, (int)records.size());
        }
        RegisterBrokerRecord registerBrokerRecord = (RegisterBrokerRecord)records.get(0).message();
        if (expectedEncryptorInstalled != null) {
            Assertions.assertEquals(CellRecord.class, (Object)records.get(2).message().getClass());
        } else {
            Assertions.assertEquals(CellRecord.class, (Object)records.get(1).message().getClass());
        }
        Assertions.assertEquals((int)brokerId, (int)registerBrokerRecord.brokerId());
        if (brokerEncryptors == null) {
            Assertions.assertEquals(registerBrokerRecord.metadataEncryptors().stream().map(RegisterBrokerRecord.Encryptor::encryptorId).collect(Collectors.toSet()), (Object)((MetadataEncryptorFactory)encryptionControl.getMetadataEncryptorFactorySupplier().get()).legacyEncryptorIds());
        } else {
            Assertions.assertEquals((int)brokerEncryptors.size(), (int)registerBrokerRecord.metadataEncryptors().size());
            for (int i = 0; i < brokerEncryptors.size(); ++i) {
                Assertions.assertEquals((Object)brokerEncryptors.get(i).encryptorId(), (Object)((RegisterBrokerRecord.Encryptor)registerBrokerRecord.metadataEncryptors().get(i)).encryptorId());
            }
        }
        clusterControl.replay(registerBrokerRecord, 100L);
        Assertions.assertTrue((boolean)clusterControl.hasBrokerRegistrationForId(brokerId));
        if (expectedEncryptorInstalled != null) {
            InstallMetadataEncryptorRecord installMetadataEncryptorRecord = (InstallMetadataEncryptorRecord)records.get(1).message();
            Assertions.assertEquals((Object)expectedEncryptorInstalled, (Object)installMetadataEncryptorRecord.keyId());
            encryptionControl.replay(installMetadataEncryptorRecord);
            Assertions.assertEquals(AesGcm128MetadataEncryptor.class, (Object)encryptionControl.encryptor().getClass());
            Assertions.assertEquals((Object)expectedEncryptorInstalled, (Object)encryptionControl.activeEncryptorId());
        }
    }

    private static List<ApiMessageAndVersion> registerBroker(FeatureControlManager featureControl, String clusterId, ClusterControlManager clusterControl, long brokerEpoch, int brokerId, List<BrokerRegistrationRequestData.Encryptor> brokerEncryptors) {
        List logDirs = featureControl.metadataVersion().isDirectoryAssignmentSupported() ? Arrays.asList(Uuid.fromString((String)("TESTBROKER" + Integer.toString(100000 + brokerId).substring(1) + "DIRAAAA"))) : Collections.emptyList();
        BrokerRegistrationRequestData newRegistration = new BrokerRegistrationRequestData().setClusterId(clusterId).setBrokerId(brokerId).setLogDirs(logDirs).setRack(null).setIncarnationId(Uuid.randomUuid()).setMetadataEncryptors(brokerEncryptors);
        newRegistration.features().add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.latestTesting().confluentFeatureLevel()));
        ControllerResult brokerRegistrationResult = clusterControl.registerBroker(newRegistration, brokerEpoch, featureControl.finalizedFeatures(Long.MAX_VALUE), true, false);
        List records = brokerRegistrationResult.records();
        return records;
    }

    @Test
    public void testRegisterWithDuplicateDirectoryId() {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("QzZZEtC7SxucRM29Xdzijw").setFeatureControlManager(new FeatureControlManager.Builder().setMetadataVersion(MetadataVersion.latestTesting()).build()).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setLogDirs(Arrays.asList(Uuid.fromString((String)"yJGxmjfbQZSVFAlNM3uXZg"), Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ")));
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("127.0.0.1"));
        clusterControl.replay(brokerRecord, 100L);
        clusterControl.activate();
        Assertions.assertDoesNotThrow(() -> this.registerNewBrokerWithDirs(clusterControl, 0, Arrays.asList(Uuid.fromString((String)"yJGxmjfbQZSVFAlNM3uXZg"), Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ"))), (String)"it should be possible to re-register the same broker with the same directories");
        Assertions.assertEquals((Object)"No directories specified in request", (Object)((InvalidRegistrationException)Assertions.assertThrows(InvalidRegistrationException.class, () -> this.registerNewBrokerWithDirs(clusterControl, 1, Collections.emptyList()))).getMessage());
        Assertions.assertEquals((Object)"Broker 0 is already registered with directory Mj3CW3OSRi29cFeNJlXuAQ", (Object)((InvalidRegistrationException)Assertions.assertThrows(InvalidRegistrationException.class, () -> this.registerNewBrokerWithDirs(clusterControl, 1, Arrays.asList(Uuid.fromString((String)"TyNK6XSSQJaJc2q9uflNHg"), Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ"))))).getMessage());
        Assertions.assertEquals((Object)"Reserved directory ID in request", (Object)((InvalidRegistrationException)Assertions.assertThrows(InvalidRegistrationException.class, () -> this.registerNewBrokerWithDirs(clusterControl, 1, Arrays.asList(Uuid.fromString((String)"TyNK6XSSQJaJc2q9uflNHg"), DirectoryId.UNASSIGNED)))).getMessage());
        Assertions.assertEquals((Object)"Duplicate directory ID in request", (Object)((InvalidRegistrationException)Assertions.assertThrows(InvalidRegistrationException.class, () -> this.registerNewBrokerWithDirs(clusterControl, 1, Arrays.asList(Uuid.fromString((String)"aR6lssMrSeyXRf65hiUovQ"), Uuid.fromString((String)"aR6lssMrSeyXRf65hiUovQ"))))).getMessage());
    }

    void registerNewBrokerWithDirs(ClusterControlManager clusterControl, int brokerId, List<Uuid> dirs) {
        BrokerRegistrationRequestData data = new BrokerRegistrationRequestData().setBrokerId(brokerId).setClusterId(clusterControl.clusterId()).setIncarnationId(new Uuid((long)brokerId, (long)brokerId)).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel())).iterator())).setLogDirs(dirs);
        FinalizedControllerFeatures finalizedFeatures = new FinalizedControllerFeatures(Map.of("confluent.metadata.version", MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()), 456L);
        ControllerResult result = clusterControl.registerBroker(data, 123L, finalizedFeatures, true, false);
        RecordTestUtils.replayAll(clusterControl, result.records());
    }

    @Test
    public void testHasOnlineDir() {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setFeatureControlManager(new FeatureControlManager.Builder().setMetadataVersion(MetadataVersion.latestTesting()).build()).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        this.registerNewBrokerWithDirs(clusterControl, 1, Arrays.asList(Uuid.fromString((String)"dir1SEbpRuG1dcpTRGOvJw"), Uuid.fromString((String)"dir2xaEwR2m3JHTiy7PWwA")));
        Assertions.assertTrue((boolean)clusterControl.registration(1).hasOnlineDir(Uuid.fromString((String)"dir1SEbpRuG1dcpTRGOvJw")));
        Assertions.assertTrue((boolean)clusterControl.hasOnlineDir(1, Uuid.fromString((String)"dir1SEbpRuG1dcpTRGOvJw")));
        Assertions.assertTrue((boolean)clusterControl.hasOnlineDir(1, Uuid.fromString((String)"dir2xaEwR2m3JHTiy7PWwA")));
        Assertions.assertTrue((boolean)clusterControl.hasOnlineDir(1, DirectoryId.UNASSIGNED));
        Assertions.assertTrue((boolean)clusterControl.hasOnlineDir(1, DirectoryId.MIGRATING));
        Assertions.assertFalse((boolean)clusterControl.hasOnlineDir(1, Uuid.fromString((String)"otherAA1QFK4U1GWzkjZ5A")));
        Assertions.assertFalse((boolean)clusterControl.hasOnlineDir(77, Uuid.fromString((String)"8xVRVs6UQHGVonA9SRYseQ")));
        Assertions.assertFalse((boolean)clusterControl.hasOnlineDir(1, DirectoryId.LOST));
    }

    @Test
    public void testDefaultDir() {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setFeatureControlManager(new FeatureControlManager.Builder().setMetadataVersion(MetadataVersion.latestTesting()).build()).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1).setLogDirs(Collections.emptyList());
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("127.0.0.1"));
        clusterControl.replay(brokerRecord, 100L);
        this.registerNewBrokerWithDirs(clusterControl, 2, Collections.singletonList(Uuid.fromString((String)"singleOnlineDirectoryA")));
        this.registerNewBrokerWithDirs(clusterControl, 3, Arrays.asList(Uuid.fromString((String)"s4fRmyNFSH6J0vI8AVA5ew"), Uuid.fromString((String)"UbtxBcqYSnKUEMcnTyZFWw")));
        Assertions.assertEquals((Object)DirectoryId.MIGRATING, (Object)clusterControl.defaultDir(1));
        Assertions.assertEquals((Object)Uuid.fromString((String)"singleOnlineDirectoryA"), (Object)clusterControl.defaultDir(2));
        Assertions.assertEquals((Object)DirectoryId.UNASSIGNED, (Object)clusterControl.defaultDir(3));
        Assertions.assertEquals((Object)DirectoryId.UNASSIGNED, (Object)clusterControl.defaultDir(4));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReRegistrationAndBrokerEpoch(boolean newIncarnationId) {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setFeatureControlManager(new FeatureControlManager.Builder().build()).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        FinalizedControllerFeatures finalizedFeatures = new FinalizedControllerFeatures(Map.of("confluent.metadata.version", MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()), 100L);
        RecordTestUtils.replayAll(clusterControl, clusterControl.registerBroker(new BrokerRegistrationRequestData().setBrokerId(1).setClusterId(clusterControl.clusterId()).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"mISEfEFwQIuaD1gKCc5tzQ")).setLogDirs(Arrays.asList(Uuid.fromString((String)"Vv1gzkM2QpuE-PPrIc6XEw"))), 100L, finalizedFeatures, false, false).records());
        RecordTestUtils.replayAll(clusterControl, clusterControl.registerBroker(new BrokerRegistrationRequestData().setBrokerId(1).setClusterId(clusterControl.clusterId()).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel())).iterator())).setIncarnationId(newIncarnationId ? Uuid.fromString((String)"07OOcU7MQFeSmGAFPP2Zww") : Uuid.fromString((String)"mISEfEFwQIuaD1gKCc5tzQ")).setLogDirs(Arrays.asList(Uuid.fromString((String)"Vv1gzkM2QpuE-PPrIc6XEw"))), 111L, finalizedFeatures, false, false).records());
        if (newIncarnationId) {
            Assertions.assertEquals((Object)Uuid.fromString((String)"07OOcU7MQFeSmGAFPP2Zww"), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).incarnationId());
            Assertions.assertEquals((long)111L, (long)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).epoch());
        } else {
            Assertions.assertEquals((Object)Uuid.fromString((String)"mISEfEFwQIuaD1gKCc5tzQ"), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).incarnationId());
            Assertions.assertEquals((long)100L, (long)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).epoch());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReRegistrationWithCleanShutdownDetection(boolean isCleanShutdown) {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setFeatureControlManager(new FeatureControlManager.Builder().build()).setBrokerShutdownHandler((brokerId, cleanShutdown, records) -> {
            if (!cleanShutdown) {
                records.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord(), 2));
            }
        }).build();
        clusterControl.activate();
        FinalizedControllerFeatures finalizedFeatures = new FinalizedControllerFeatures(Map.of("confluent.metadata.version", MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()), 100L);
        List records2 = clusterControl.registerBroker(new BrokerRegistrationRequestData().setBrokerId(1).setClusterId(clusterControl.clusterId()).setIncarnationId(Uuid.fromString((String)"mISEfEFwQIuaD1gKCc5tzQ")).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel())).iterator())).setLogDirs(Arrays.asList(Uuid.fromString((String)"Vv1gzkM2QpuE-PPrIc6XEw"))), 100L, finalizedFeatures, false, true).records();
        records2.add(new ApiMessageAndVersion((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value()), 1));
        RecordTestUtils.replayAll(clusterControl, records2);
        records2 = clusterControl.registerBroker(new BrokerRegistrationRequestData().setBrokerId(1).setClusterId(clusterControl.clusterId()).setIncarnationId(Uuid.fromString((String)"07OOcU7MQFeSmGAFPP2Zww")).setPreviousBrokerEpoch(isCleanShutdown ? 100L : 10L).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel())).iterator())).setLogDirs(Arrays.asList(Uuid.fromString((String)"Vv1gzkM2QpuE-PPrIc6XEw"))), 111L, finalizedFeatures, false, true).records();
        RecordTestUtils.replayAll(clusterControl, records2);
        Assertions.assertEquals((Object)Uuid.fromString((String)"07OOcU7MQFeSmGAFPP2Zww"), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).incarnationId());
        Assertions.assertFalse((boolean)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).inControlledShutdown());
        Assertions.assertEquals((long)111L, (long)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).epoch());
        if (isCleanShutdown) {
            Assertions.assertEquals((int)2, (int)records2.size(), (String)records2.toString());
        } else {
            Assertions.assertEquals((int)3, (int)records2.size(), (String)records2.toString());
        }
    }

    @Test
    public void testBrokerContactTimesAreUpdatedOnClusterControlActivation() {
        MockTime time = new MockTime(0L, 20L, 1000L);
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setFeatureControlManager(new FeatureControlManager.Builder().build()).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).setTime((Time)time).build();
        clusterControl.replay(new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setLogDirs(Arrays.asList(Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ"))), 10002L);
        clusterControl.replay(new RegisterBrokerRecord().setBrokerEpoch(123L).setBrokerId(1).setLogDirs(Arrays.asList(Uuid.fromString((String)"TyNK6XSSQJaJc2q9uflNHg"))), 10005L);
        clusterControl.activate();
        Assertions.assertEquals((Object)OptionalLong.of(1000L), (Object)clusterControl.heartbeatManager().tracker().contactTime(new BrokerIdAndEpoch(0, 100L)));
        Assertions.assertEquals((Object)OptionalLong.of(1000L), (Object)clusterControl.heartbeatManager().tracker().contactTime(new BrokerIdAndEpoch(1, 123L)));
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)clusterControl.heartbeatManager().tracker().contactTime(new BrokerIdAndEpoch(1, 124L)));
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)clusterControl.heartbeatManager().tracker().contactTime(new BrokerIdAndEpoch(2, 100L)));
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("confluent.metadata.active.encryptor", ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG.toString());
        map.put("confluent.metadata.encryptor.classes", String.valueOf(ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG) + "=" + AesGcm128MetadataEncryptor.class.getCanonicalName() + "," + String.valueOf(INACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG) + "=" + AesGcm128MetadataEncryptor.class.getCanonicalName());
        map.put("confluent.metadata.encryptor.secrets", String.valueOf(ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG) + "=cG9ubWxramloZ2ZlZGNiYQ," + String.valueOf(INACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG) + "=YWJjZGVmZ2hpamtsbW5vcA");
        LEGACY_ENCRYPTOR_CONFIG = Collections.unmodifiableMap(map);
    }
}

