/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.storage;

import java.util.AbstractMap;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.metadata.storage.ScramParser;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ScramParserTest {
    static final byte[] TEST_SALT = new byte[]{49, 108, 118, 52, 112, 100, 110, 119, 52, 102, 119, 113, 55, 110, 111, 116, 99, 120, 109, 48, 121, 121, 49, 107, 55, 113};
    static final byte[] TEST_SALTED_PASSWORD = new byte[]{-103, 61, 50, -55, 69, 49, -98, 82, 90, 11, -33, 71, 94, 4, 83, 73, -119, 91, -70, -90, -72, 21, 33, -83, 36, 34, 95, 76, -53, -29, 96, 33};

    @Test
    public void testSplitTrimmedConfigStringComponentOnNameEqualsFoo() {
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<String, String>("name", "foo"), (Object)ScramParser.splitTrimmedConfigStringComponent((String)"name=foo"));
    }

    @Test
    public void testSplitTrimmedConfigStringComponentOnNameEqualsQuotedFoo() {
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<String, String>("name", "foo"), (Object)ScramParser.splitTrimmedConfigStringComponent((String)"name=\"foo\""));
    }

    @Test
    public void testSplitTrimmedConfigStringComponentOnNameEqualsEmpty() {
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<String, String>("name", ""), (Object)ScramParser.splitTrimmedConfigStringComponent((String)"name="));
    }

    @Test
    public void testSplitTrimmedConfigStringComponentOnNameEqualsQuotedEmpty() {
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<String, String>("name", ""), (Object)ScramParser.splitTrimmedConfigStringComponent((String)"name=\"\""));
    }

    @Test
    public void testSplitTrimmedConfigStringComponentWithNoEquals() {
        Assertions.assertEquals((Object)"No equals sign found in SCRAM component: name", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> ScramParser.splitTrimmedConfigStringComponent((String)"name"))).getMessage());
    }

    @Test
    public void testRandomSalt() throws Exception {
        ScramParser.PerMechanismData data = new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "bob", Optional.empty(), OptionalInt.empty(), Optional.of("my pass"), Optional.empty());
        TestUtils.retryOnExceptionWithTimeout((long)10000L, () -> Assertions.assertNotEquals((Object)data.salt().toString(), (Object)data.salt().toString()));
    }

    @Test
    public void testConfiguredSalt() throws Exception {
        Assertions.assertArrayEquals((byte[])TEST_SALT, (byte[])new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "bob", Optional.of(TEST_SALT), OptionalInt.empty(), Optional.of("my pass"), Optional.empty()).salt());
    }

    @Test
    public void testDefaultIterations() {
        Assertions.assertEquals((int)4096, (int)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "bob", Optional.empty(), OptionalInt.empty(), Optional.of("my pass"), Optional.empty()).iterations());
    }

    @Test
    public void testConfiguredIterations() {
        Assertions.assertEquals((int)8192, (int)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "bob", Optional.empty(), OptionalInt.of(8192), Optional.of("my pass"), Optional.empty()).iterations());
    }

    @Test
    public void testParsePerMechanismArgument() {
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<ScramMechanism, String>(ScramMechanism.SCRAM_SHA_512, "name=scram-admin,password=scram-user-secret"), (Object)ScramParser.parsePerMechanismArgument((String)"SCRAM-SHA-512=[name=scram-admin,password=scram-user-secret]"));
    }

    @Test
    public void testParsePerMechanismArgumentWithoutEqualsSign() {
        Assertions.assertEquals((Object)"Failed to find equals sign in SCRAM argument 'SCRAM-SHA-512'", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> ScramParser.parsePerMechanismArgument((String)"SCRAM-SHA-512"))).getMessage());
    }

    @Test
    public void testParsePerMechanismArgumentWithUnsupportedScramMethod() {
        Assertions.assertEquals((Object)"The add-scram mechanism SCRAM-SHA-UNSUPPORTED is not supported.", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> ScramParser.parsePerMechanismArgument((String)"SCRAM-SHA-UNSUPPORTED=[name=scram-admin,password=scram-user-secret]"))).getMessage());
    }

    @Test
    public void testParsePerMechanismArgumentWithConfigStringWithoutBraces() {
        Assertions.assertEquals((Object)"Expected configuration string to start with [", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> ScramParser.parsePerMechanismArgument((String)"SCRAM-SHA-256=name=scram-admin,password=scram-user-secret"))).getMessage());
    }

    @Test
    public void testParsePerMechanismArgumentWithConfigStringWithoutEndBrace() {
        Assertions.assertEquals((Object)"Expected configuration string to end with ]", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> ScramParser.parsePerMechanismArgument((String)"SCRAM-SHA-256=[name=scram-admin,password=scram-user-secret"))).getMessage());
    }

    @Test
    public void testParsePerMechanismData() {
        Assertions.assertEquals((Object)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "bob", Optional.empty(), OptionalInt.empty(), Optional.of("mypass"), Optional.empty()), (Object)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "name=bob,password=mypass"));
    }

    @Test
    public void testParsePerMechanismDataFailsWithoutName() {
        Assertions.assertEquals((Object)"You must supply 'name' to add-scram", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "password=mypass"))).getMessage());
    }

    @Test
    public void testParsePerMechanismDataFailsWithoutPassword() {
        Assertions.assertEquals((Object)"You must supply one of 'password' or 'saltedpassword' to add-scram", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "name=bar"))).getMessage());
    }

    @Test
    public void testParsePerMechanismDataFailsWithExtraArguments() {
        Assertions.assertEquals((Object)"Unknown SCRAM configurations: unknown, unknown2", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "name=bob,password=mypass,unknown=something,unknown2=somethingelse"))).getMessage());
    }

    @Test
    public void testParsePerMechanismDataWithIterations() {
        Assertions.assertEquals((Object)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "bob", Optional.empty(), OptionalInt.of(8192), Optional.of("my pass"), Optional.empty()), (Object)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "name=bob,password=my pass,iterations=8192"));
    }

    @Test
    public void testParsePerMechanismDataWithConfiguredSalt() {
        Assertions.assertEquals((Object)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_512, "bob", Optional.of(TEST_SALT), OptionalInt.empty(), Optional.of("my pass"), Optional.empty()), (Object)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_512, "name=bob,password=my pass,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\""));
    }

    @Test
    public void testParsePerMechanismDataWithIterationsAndConfiguredSalt() {
        Assertions.assertEquals((Object)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "bob", Optional.of(TEST_SALT), OptionalInt.of(8192), Optional.of("my pass"), Optional.empty()), (Object)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "name=bob,password=my pass,iterations=8192,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\""));
    }

    @Test
    public void testParsePerMechanismDataWithConfiguredSaltedPasswordFailsWithoutSalt() {
        Assertions.assertEquals((Object)"You must supply 'salt' with 'saltedpassword' to add-scram", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "name=alice,saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\""))).getMessage());
    }

    @Test
    public void testParsePerMechanismDataWithConfiguredSaltedPassword() {
        Assertions.assertEquals((Object)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "alice", Optional.of(TEST_SALT), OptionalInt.empty(), Optional.empty(), Optional.of(TEST_SALTED_PASSWORD)), (Object)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_256, "name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\""));
    }

    @Test
    public void testPerMechanismDataToRecord() throws Exception {
        ScramFormatter formatter = new ScramFormatter(ScramMechanism.SCRAM_SHA_512);
        Assertions.assertEquals((Object)new UserScramCredentialRecord().setName("alice").setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setSalt(TEST_SALT).setStoredKey(formatter.storedKey(formatter.clientKey(TEST_SALTED_PASSWORD))).setServerKey(formatter.serverKey(TEST_SALTED_PASSWORD)).setIterations(4096), (Object)new ScramParser.PerMechanismData(ScramMechanism.SCRAM_SHA_512, "alice", Optional.of(TEST_SALT), OptionalInt.empty(), Optional.empty(), Optional.of(TEST_SALTED_PASSWORD)).toRecord());
    }
}

