/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.metadata.placement.StripedReplicaPlacer;
import org.apache.kafka.metadata.placement.TopicAssignment;
import org.apache.kafka.metadata.placement.TopicPlacementReplicaPlacer;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.util.MockRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TopicPlacementReplicaPlacerTest {
    private LogContext logContext = new LogContext();

    @Test
    public void testBuildTopicAssignmentInputUsesSharedRackInstanceIfNeeded() {
        List<UsableBroker> brokers = this.usableBrokerList(6, 2, false);
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}},{\"count\":1,\"constraints\":{}},{\"count\":1,\"constraints\":{\"rack\":\"rack1\"}}],\"observers\": [{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}},{\"count\":1,\"constraints\":{}},{\"count\":1,\"constraints\":{\"rack\":\"rack2\"}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 10);
        TopicPlacementReplicaPlacer.TopicAssignmentInput topicAssignmentInput = TopicPlacementReplicaPlacer.buildTopicAssignmentInput((Logger)((Logger)Mockito.mock(Logger.class)), (Random)new MockRandom(), (TopicPlacementReplicaPlacer.PlacementSpec)placementSpec, brokers.iterator());
        Assertions.assertEquals((int)topicAssignmentInput.syncReplicas.size(), (int)topicAssignmentInput.observers.size());
        Assertions.assertEquals((int)3, (int)topicAssignmentInput.syncReplicas.size());
        Assertions.assertEquals(Optional.of("rack0"), (Object)((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.syncReplicas.get((int)0)).rackName);
        Assertions.assertEquals(Optional.of("rack0"), (Object)((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.observers.get((int)0)).rackName);
        Assertions.assertSame((Object)((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.syncReplicas.get((int)0)).matchingBrokers, (Object)((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.observers.get((int)0)).matchingBrokers);
        Assertions.assertEquals(Optional.empty(), (Object)((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.syncReplicas.get((int)1)).rackName);
        Assertions.assertEquals(Optional.empty(), (Object)((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.observers.get((int)1)).rackName);
        Assertions.assertSame((Object)((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.syncReplicas.get((int)1)).matchingBrokers, (Object)((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.observers.get((int)1)).matchingBrokers);
        Assertions.assertEquals(Optional.of("rack1"), (Object)((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.syncReplicas.get((int)2)).rackName);
        Assertions.assertEquals(Optional.of("rack2"), (Object)((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.observers.get((int)2)).rackName);
        Assertions.assertNotSame((Object)((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.syncReplicas.get((int)2)).matchingBrokers, (Object)((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.observers.get((int)2)).matchingBrokers);
    }

    @Test
    public void testBuildTopicAssignmentInputMatchingBrokers() {
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(2, Optional.of("rack1"), false));
        usableBrokers.add(new UsableBroker(3, Optional.of("rack2"), false));
        usableBrokers.add(new UsableBroker(4, Optional.empty(), false));
        usableBrokers.add(new UsableBroker(5, Optional.empty(), false));
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}},{\"count\":1,\"constraints\":{\"rack\":\"rack1\"}},{\"count\":1,\"constraints\":{\"rack\":\"rack2\"}},{\"count\":1,\"constraints\":{\"rack\":\"rack3\"}},{\"count\":1,\"constraints\":{}},{\"count\":1}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        TopicPlacementReplicaPlacer.TopicAssignmentInput topicAssignmentInput = TopicPlacementReplicaPlacer.buildTopicAssignmentInput((Logger)((Logger)Mockito.mock(Logger.class)), (Random)new MockRandom(), (TopicPlacementReplicaPlacer.PlacementSpec)placementSpec, usableBrokers.iterator());
        Assertions.assertEquals((int)6, (int)topicAssignmentInput.syncReplicas.size());
        Assertions.assertEquals((int)0, (int)topicAssignmentInput.observers.size());
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1)), this.brokerIdsInRack(((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.syncReplicas.get((int)0)).matchingBrokers));
        Assertions.assertEquals(Collections.singleton(2), this.brokerIdsInRack(((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.syncReplicas.get((int)1)).matchingBrokers));
        Assertions.assertEquals(Collections.singleton(3), this.brokerIdsInRack(((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.syncReplicas.get((int)2)).matchingBrokers));
        Assertions.assertEquals(Collections.emptySet(), this.brokerIdsInRack(((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.syncReplicas.get((int)3)).matchingBrokers));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), this.brokerIdsInRack(((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.syncReplicas.get((int)4)).matchingBrokers));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), this.brokerIdsInRack(((TopicPlacementReplicaPlacer.ConstraintAndMatchingBrokers)topicAssignmentInput.syncReplicas.get((int)5)).matchingBrokers));
    }

    @Test
    public void testRackAwareWithConstraintReplicaAssignmentWithRackMixing() {
        List<UsableBroker> brokers = this.usableBrokerList(25, 5, false);
        Map<Integer, UsableBroker> idToBroker = this.idToBroker(brokers);
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":2,\"constraints\":{\"rack\":\"rack0\"}},{\"count\":2,\"constraints\":{\"rack\":\"rack1\"}},{\"count\":2,\"constraints\":{\"rack\":\"rack2\"}},{\"count\":2,\"constraints\":{\"rack\":\"rack3\"}},{\"count\":2,\"constraints\":{\"rack\":\"rack4\"}}],\"observers\": [{\"count\":2,\"constraints\":{\"rack\":\"rack0\"}},{\"count\":2,\"constraints\":{\"rack\":\"rack1\"}},{\"count\":2,\"constraints\":{\"rack\":\"rack2\"}},{\"count\":2,\"constraints\":{\"rack\":\"rack3\"}},{\"count\":2,\"constraints\":{\"rack\":\"rack4\"}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 10);
        List partitionAssignments = new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom()).place(placementSpec, brokers.iterator(), __ -> DirectoryId.MIGRATING).assignments();
        Assertions.assertEquals((int)10, (int)partitionAssignments.size());
        for (PartitionAssignment partitionAssignment : partitionAssignments) {
            List replicas = partitionAssignment.replicas();
            Assertions.assertEquals((int)20, (int)replicas.size());
            this.assertStructureOfPartitionAssignment(partitionAssignment);
            this.assertSatisfiesPlacement(topicPlacementJson, partitionAssignment, idToBroker);
            this.assertAssignment(idToBroker, replicas.subList(0, 2), "rack0", 0, 4);
            this.assertAssignment(idToBroker, replicas.subList(2, 4), "rack1", 5, 9);
            this.assertAssignment(idToBroker, replicas.subList(4, 6), "rack2", 10, 14);
            this.assertAssignment(idToBroker, replicas.subList(6, 8), "rack3", 15, 19);
            this.assertAssignment(idToBroker, replicas.subList(8, 10), "rack4", 20, 24);
            this.assertAssignment(idToBroker, replicas.subList(10, 12), "rack0", 0, 4);
            this.assertAssignment(idToBroker, replicas.subList(12, 14), "rack1", 5, 9);
            this.assertAssignment(idToBroker, replicas.subList(14, 16), "rack2", 10, 14);
            this.assertAssignment(idToBroker, replicas.subList(16, 18), "rack3", 15, 19);
            this.assertAssignment(idToBroker, replicas.subList(18, 20), "rack4", 20, 24);
            List observers = partitionAssignment.observers();
            this.assertAssignment(idToBroker, observers.subList(0, 2), "rack0", 0, 4);
            this.assertAssignment(idToBroker, observers.subList(2, 4), "rack1", 5, 9);
            this.assertAssignment(idToBroker, observers.subList(4, 6), "rack2", 10, 14);
            this.assertAssignment(idToBroker, observers.subList(6, 8), "rack3", 15, 19);
            this.assertAssignment(idToBroker, observers.subList(8, 10), "rack4", 20, 24);
        }
        List<List<Integer>> assignmentsByReplicaIndex = this.transpose(partitionAssignments.stream().map(x -> x.replicas()).collect(Collectors.toList()));
        for (List<Integer> assignmentByReplicaIndex : assignmentsByReplicaIndex) {
            Map brokerToCount = assignmentByReplicaIndex.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            brokerToCount.forEach((brokerId, count) -> Assertions.assertEquals((long)2L, (Long)count));
        }
    }

    @Test
    public void testRackAwareWithConstraintReplicaAssignment() {
        List<UsableBroker> brokers = this.usableBrokerList(15, 5, false);
        Map<Integer, UsableBroker> idToBroker = this.idToBroker(brokers);
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":3,\"constraints\":{\"rack\":\"rack0\"}},{\"count\":2,\"constraints\":{\"rack\":\"rack1\"}}],\"observers\": [{\"count\":2,\"constraints\":{\"rack\":\"rack2\"}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 10);
        List partitionAssignments = new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom()).place(placementSpec, brokers.iterator(), __ -> DirectoryId.MIGRATING).assignments();
        Assertions.assertEquals((int)10, (int)partitionAssignments.size());
        for (PartitionAssignment partitionAssignment : partitionAssignments) {
            List replicas = partitionAssignment.replicas();
            Assertions.assertEquals((int)7, (int)replicas.size());
            this.assertStructureOfPartitionAssignment(partitionAssignment);
            this.assertSatisfiesPlacement(topicPlacementJson, partitionAssignment, idToBroker);
            this.assertAssignment(idToBroker, replicas.subList(0, 3), "rack0", 0, 4);
            this.assertAssignment(idToBroker, replicas.subList(3, 5), "rack1", 5, 9);
            this.assertAssignment(idToBroker, replicas.subList(5, 7), "rack2", 10, 14);
            List observers = partitionAssignment.observers();
            this.assertAssignment(idToBroker, observers.subList(0, 2), "rack2", 10, 14);
        }
        List<List<Integer>> assignmentsByReplicaIndex = this.transpose(partitionAssignments.stream().map(x -> x.replicas()).collect(Collectors.toList()));
        for (List<Integer> assignmentByReplicaIndex : assignmentsByReplicaIndex) {
            Map brokerToCount = assignmentByReplicaIndex.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            brokerToCount.forEach((brokerId, count) -> Assertions.assertEquals((long)2L, (Long)count));
        }
    }

    @Test
    public void testNotEnoughMatchingBrokersThrowsException() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":2,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), false));
        Throwable ex = Assertions.assertThrows(InvalidConfigurationException.class, () -> new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom()).place(placementSpec, usableBrokers.iterator(), __ -> DirectoryId.MIGRATING).assignments());
        Assertions.assertEquals((Object)"Not enough brokers on rack rack0", (Object)ex.getMessage());
    }

    @Test
    public void testDuplicateConstraintThrowsException() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}},{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(2, Optional.of("rack0"), false));
        Throwable ex = Assertions.assertThrows(InvalidConfigurationException.class, () -> new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom()).place(placementSpec, usableBrokers.iterator(), __ -> DirectoryId.MIGRATING).assignments());
        Assertions.assertEquals((Object)"Contains duplicate rack rack0", (Object)ex.getMessage());
    }

    @Test
    public void testNotEnoughMatchingBrokersEmptyConstraintThrowsException() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":2,\"constraints\":{}}],\"observers\":[{\"count\":1,\"constraints\":{}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.empty(), false));
        usableBrokers.add(new UsableBroker(1, Optional.empty(), false));
        Throwable ex = Assertions.assertThrows(InvalidConfigurationException.class, () -> new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom()).place(placementSpec, usableBrokers.iterator(), __ -> DirectoryId.MIGRATING).assignments());
        Assertions.assertEquals((Object)"Not enough brokers", (Object)ex.getMessage());
    }

    @Test
    public void testMatchingBrokersEmptyConstraint() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{}}],\"observers\":[{\"count\":1,\"constraints\":{}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), false));
        Map<Integer, UsableBroker> idToBroker = this.idToBroker(usableBrokers);
        TopicPlacementReplicaPlacer placer = new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom());
        TopicAssignment topicAssignment = placer.place(placementSpec, usableBrokers.iterator(), __ -> DirectoryId.MIGRATING);
        List partitionAssignments = topicAssignment.assignments();
        Assertions.assertEquals((int)1, (int)partitionAssignments.size());
        for (PartitionAssignment partitionAssignment : partitionAssignments) {
            List replicas = partitionAssignment.replicas();
            Assertions.assertEquals((int)2, (int)replicas.size());
            this.assertStructureOfPartitionAssignment(partitionAssignment);
            this.assertSatisfiesPlacement(topicPlacementJson, partitionAssignment, idToBroker);
        }
    }

    @Test
    public void testMatchingBrokersMissingConstraint() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1}],\"observers\":[{\"count\":1}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), false));
        Map<Integer, UsableBroker> idToBroker = this.idToBroker(usableBrokers);
        TopicPlacementReplicaPlacer placer = new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom());
        TopicAssignment topicAssignment = placer.place(placementSpec, usableBrokers.iterator(), __ -> DirectoryId.MIGRATING);
        List partitionAssignments = topicAssignment.assignments();
        Assertions.assertEquals((int)1, (int)partitionAssignments.size());
        for (PartitionAssignment partitionAssignment : partitionAssignments) {
            List replicas = partitionAssignment.replicas();
            Assertions.assertEquals((int)2, (int)replicas.size());
            this.assertStructureOfPartitionAssignment(partitionAssignment);
            this.assertSatisfiesPlacement(topicPlacementJson, partitionAssignment, idToBroker);
        }
    }

    @Test
    public void testMatchingBrokersEmptyConstraintNoRacksInBrokers() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{}}],\"observers\":[{\"count\":1,\"constraints\":{}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.empty(), false));
        usableBrokers.add(new UsableBroker(1, Optional.empty(), false));
        Map<Integer, UsableBroker> idToBroker = this.idToBroker(usableBrokers);
        TopicPlacementReplicaPlacer placer = new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom());
        TopicAssignment topicAssignment = placer.place(placementSpec, usableBrokers.iterator(), __ -> DirectoryId.MIGRATING);
        List partitionAssignments = topicAssignment.assignments();
        Assertions.assertEquals((int)1, (int)partitionAssignments.size());
        for (PartitionAssignment partitionAssignment : partitionAssignments) {
            List replicas = partitionAssignment.replicas();
            Assertions.assertEquals((int)2, (int)replicas.size());
            this.assertStructureOfPartitionAssignment(partitionAssignment);
            this.assertSatisfiesPlacement(topicPlacementJson, partitionAssignment, idToBroker);
        }
    }

    @Test
    public void testPlaceHandlesMixOfEmptyAndNonEmptyConstraintWhereSyncReplicasHaveNonEmptyConstraint() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}},{\"count\":1,\"constraints\":{}}],\"observers\":[{\"count\":1,\"constraints\":{}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.empty(), false));
        usableBrokers.add(new UsableBroker(2, Optional.empty(), false));
        Map<Integer, UsableBroker> idToBroker = this.idToBroker(usableBrokers);
        TopicPlacementReplicaPlacer placer = new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom());
        TopicAssignment topicAssignment = placer.place(placementSpec, usableBrokers.iterator(), __ -> DirectoryId.MIGRATING);
        List partitionAssignments = topicAssignment.assignments();
        Assertions.assertEquals((int)1, (int)partitionAssignments.size());
        for (PartitionAssignment partitionAssignment : partitionAssignments) {
            this.assertStructureOfPartitionAssignment(partitionAssignment);
            this.assertSatisfiesPlacement(topicPlacementJson, partitionAssignment, idToBroker);
        }
    }

    @Test
    public void testPlaceHandlesMixOfEmptyAndNonEmptyConstraintWhereSyncReplicasHaveEmptyConstraint() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(2, Optional.empty(), false));
        Map<Integer, UsableBroker> idToBroker = this.idToBroker(usableBrokers);
        TopicPlacementReplicaPlacer placer = new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom());
        TopicAssignment topicAssignment = placer.place(placementSpec, usableBrokers.iterator(), __ -> DirectoryId.MIGRATING);
        List partitionAssignments = topicAssignment.assignments();
        Assertions.assertEquals((int)1, (int)partitionAssignments.size());
        for (PartitionAssignment partitionAssignment : partitionAssignments) {
            this.assertStructureOfPartitionAssignment(partitionAssignment);
            this.assertSatisfiesPlacement(topicPlacementJson, partitionAssignment, idToBroker);
        }
    }

    @Test
    public void testPlacePrefersUnfencedBrokers() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), true));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), true));
        usableBrokers.add(new UsableBroker(2, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(3, Optional.of("rack0"), false));
        Map<Integer, UsableBroker> idToBroker = this.idToBroker(usableBrokers);
        TopicPlacementReplicaPlacer placer = new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom());
        TopicAssignment topicAssignment = placer.place(placementSpec, usableBrokers.iterator(), __ -> DirectoryId.MIGRATING);
        List partitionAssignments = topicAssignment.assignments();
        Assertions.assertEquals((int)1, (int)partitionAssignments.size());
        for (PartitionAssignment partitionAssignment : partitionAssignments) {
            this.assertStructureOfPartitionAssignment(partitionAssignment);
            this.assertSatisfiesPlacement(topicPlacementJson, partitionAssignment, idToBroker);
            Iterator iterator = partitionAssignment.replicas().iterator();
            while (iterator.hasNext()) {
                int replica = (Integer)iterator.next();
                Assertions.assertFalse((boolean)idToBroker.get(replica).fenced());
            }
        }
    }

    @Test
    public void testPlacePrefersUnfencedBrokersButUsesFencedBrokersIfNeeded() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":3,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), true));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), true));
        usableBrokers.add(new UsableBroker(2, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(3, Optional.of("rack0"), false));
        Map<Integer, UsableBroker> idToBroker = this.idToBroker(usableBrokers);
        TopicPlacementReplicaPlacer placer = new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom());
        TopicAssignment topicAssignment = placer.place(placementSpec, usableBrokers.iterator(), __ -> DirectoryId.MIGRATING);
        List partitionAssignments = topicAssignment.assignments();
        Assertions.assertEquals((int)1, (int)partitionAssignments.size());
        for (PartitionAssignment partitionAssignment : partitionAssignments) {
            this.assertStructureOfPartitionAssignment(partitionAssignment);
            this.assertSatisfiesPlacement(topicPlacementJson, partitionAssignment, idToBroker);
            Assertions.assertEquals((int)4, (int)partitionAssignment.replicas().size());
            Assertions.assertFalse((boolean)idToBroker.get(partitionAssignment.replicas().get(0)).fenced());
            Assertions.assertFalse((boolean)idToBroker.get(partitionAssignment.replicas().get(1)).fenced());
            for (int i = 2; i < partitionAssignment.replicas().size(); ++i) {
                Assertions.assertTrue((boolean)idToBroker.get(partitionAssignment.replicas().get(i)).fenced());
            }
        }
    }

    @Test
    public void testPlaceHandlesMixOfEmptyAndNonEmptyConstraintWhereSyncReplicasAndObserversHaveNonEmptyConstraint() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}},{\"count\":1,\"constraints\":{}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(2, Optional.empty(), false));
        Map<Integer, UsableBroker> idToBroker = this.idToBroker(usableBrokers);
        TopicPlacementReplicaPlacer placer = new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom());
        TopicAssignment topicAssignment = placer.place(placementSpec, usableBrokers.iterator(), __ -> DirectoryId.MIGRATING);
        List partitionAssignments = topicAssignment.assignments();
        Assertions.assertEquals((int)1, (int)partitionAssignments.size());
        for (PartitionAssignment partitionAssignment : partitionAssignments) {
            this.assertStructureOfPartitionAssignment(partitionAssignment);
            this.assertSatisfiesPlacement(topicPlacementJson, partitionAssignment, idToBroker);
        }
    }

    @Test
    public void testNotEnoughUnfencedBrokers() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1);
        List<UsableBroker> fencedBrokers = this.usableBrokerList(1, 1, true);
        Throwable ex = Assertions.assertThrows(InvalidConfigurationException.class, () -> new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom()).place(placementSpec, fencedBrokers.iterator(), __ -> DirectoryId.MIGRATING).assignments());
        Assertions.assertEquals((Object)"Not enough unfenced brokers for the preferred leader on rack rack0", (Object)ex.getMessage());
        List<UsableBroker> unFencedBrokers = this.usableBrokerList(1, 1, false);
        new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom()).place(placementSpec, unFencedBrokers.iterator(), __ -> DirectoryId.MIGRATING).assignments();
    }

    @Test
    public void testExcludedBrokers() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        List<UsableBroker> brokers = this.usableBrokerList(1, 1, false);
        Set<Integer> excludedBrokers = Collections.singleton(brokers.get(0).id());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom()).place(new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), excludedBrokers, 0, 1), brokers.iterator(), __ -> DirectoryId.MIGRATING).assignments());
        new TopicPlacementReplicaPlacer(this.logContext, (Random)new MockRandom()).place(new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), Collections.emptySet(), 0, 1), brokers.iterator(), __ -> DirectoryId.MIGRATING).assignments();
    }

    @Test
    public void testPlacementSpecToString() {
        String topicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        Set<Integer> excludedBrokersIds = Collections.singleton(0);
        TopicPlacementReplicaPlacer.PlacementSpec placementSpec = new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get(), excludedBrokersIds, 0, 1);
        Assertions.assertEquals((Object)"PlacementSpec(topicPlacement=TopicPlacement(version=1,replicas=[ConstraintCount(count=1,constraints={rack=rack0})],observers=[]), excludedBrokerIds=[0], startPartition=0, numPartitions=1)", (Object)placementSpec.toString());
    }

    @Test
    public void testPlacementSpecEqualsAndHashCode() {
        String topicPlacementJsonOne = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        String topicPlacementJsonTwo = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack1\"}}]}";
        List<TopicPlacementReplicaPlacer.PlacementSpec> placementSpecs = Arrays.asList(new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJsonOne).get(), Collections.singleton(0), 0, 1), new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJsonOne).get(), Collections.singleton(1), 0, 1), new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJsonOne).get(), Collections.singleton(0), 1, 1), new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJsonOne).get(), Collections.singleton(0), 0, 0), new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)TopicPlacement.parse((String)topicPlacementJsonTwo).get(), Collections.singleton(0), 0, 1));
        for (int i = 0; i < placementSpecs.size(); ++i) {
            for (int j = 0; j < placementSpecs.size(); ++j) {
                if (i == j) {
                    Assertions.assertEquals((Object)placementSpecs.get(i), (Object)placementSpecs.get(j));
                    Assertions.assertEquals((int)placementSpecs.get(i).hashCode(), (int)placementSpecs.get(j).hashCode());
                    continue;
                }
                Assertions.assertNotEquals((Object)placementSpecs.get(i), (Object)placementSpecs.get(j));
                Assertions.assertNotEquals((int)placementSpecs.get(i).hashCode(), (int)placementSpecs.get(j).hashCode());
            }
        }
    }

    @Test
    public void testValidateTopicPlacementUpdateSuccess() {
        String validTopicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), false));
        Optional topicPlacement = TopicPlacement.parse((String)validTopicPlacementJson);
        Assertions.assertTrue((boolean)topicPlacement.isPresent());
        TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange((TopicPlacement)((TopicPlacement)topicPlacement.get()), usableBrokers.iterator(), (Logger)((Logger)Mockito.mock(Logger.class)), __ -> DirectoryId.MIGRATING);
    }

    @Test
    public void testValidateTopicPlacementUpdateSuccessEvenWithSomeFencedBrokers() {
        String validTopicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), true));
        Optional topicPlacement = TopicPlacement.parse((String)validTopicPlacementJson);
        Assertions.assertTrue((boolean)topicPlacement.isPresent());
        TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange((TopicPlacement)((TopicPlacement)topicPlacement.get()), usableBrokers.iterator(), (Logger)((Logger)Mockito.mock(Logger.class)), __ -> DirectoryId.MIGRATING);
    }

    @Test
    public void testValidateTopicPlacementUpdateNotEnoughSyncReplicas() {
        String validTopicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":2,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack1\"}}]}";
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack1"), false));
        usableBrokers.add(new UsableBroker(2, Optional.of("rack1"), false));
        Optional topicPlacement = TopicPlacement.parse((String)validTopicPlacementJson);
        Assertions.assertTrue((boolean)topicPlacement.isPresent());
        Throwable throwable = Assertions.assertThrows(InvalidConfigurationException.class, () -> TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange((TopicPlacement)((TopicPlacement)topicPlacement.get()), usableBrokers.iterator(), (Logger)((Logger)Mockito.mock(Logger.class)), __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals((Object)"Not enough brokers on rack rack0", (Object)throwable.getMessage());
    }

    @Test
    public void testValidateTopicPlacementUpdateNotEnoughObservers() {
        String validTopicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":2,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":2,\"constraints\":{\"rack\":\"rack1\"}}]}";
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(2, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(3, Optional.of("rack1"), false));
        Optional topicPlacement = TopicPlacement.parse((String)validTopicPlacementJson);
        Assertions.assertTrue((boolean)topicPlacement.isPresent());
        Throwable throwable = Assertions.assertThrows(InvalidConfigurationException.class, () -> TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange((TopicPlacement)((TopicPlacement)topicPlacement.get()), usableBrokers.iterator(), (Logger)((Logger)Mockito.mock(Logger.class)), __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals((Object)"Not enough brokers on rack rack1", (Object)throwable.getMessage());
    }

    @Test
    public void testValidateTopicPlacementUpdateUnknownRackOnSyncReplicaLeader() {
        String validTopicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack1\"}}]}";
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack1"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack1"), false));
        Optional topicPlacement = TopicPlacement.parse((String)validTopicPlacementJson);
        Assertions.assertTrue((boolean)topicPlacement.isPresent());
        Throwable throwable = Assertions.assertThrows(InvalidConfigurationException.class, () -> TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange((TopicPlacement)((TopicPlacement)topicPlacement.get()), usableBrokers.iterator(), (Logger)((Logger)Mockito.mock(Logger.class)), __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals((Object)"Not enough brokers on rack rack0", (Object)throwable.getMessage());
    }

    @Test
    public void testValidateTopicPlacementUpdateUnknownRackOnSyncReplicaFollower() {
        String validTopicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}},{\"count\":1,\"constraints\":{\"rack\":\"rack2\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack1\"}}]}";
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack1"), false));
        Optional topicPlacement = TopicPlacement.parse((String)validTopicPlacementJson);
        Assertions.assertTrue((boolean)topicPlacement.isPresent());
        Throwable throwable = Assertions.assertThrows(InvalidConfigurationException.class, () -> TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange((TopicPlacement)((TopicPlacement)topicPlacement.get()), usableBrokers.iterator(), (Logger)((Logger)Mockito.mock(Logger.class)), __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals((Object)"Not enough brokers on rack rack2", (Object)throwable.getMessage());
    }

    @Test
    public void testValidateTopicPlacementUpdateNotEnoughBrokersOnRackMixedObserver() {
        String validTopicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        Optional topicPlacement = TopicPlacement.parse((String)validTopicPlacementJson);
        Assertions.assertTrue((boolean)topicPlacement.isPresent());
        Throwable throwable = Assertions.assertThrows(InvalidConfigurationException.class, () -> TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange((TopicPlacement)((TopicPlacement)topicPlacement.get()), usableBrokers.iterator(), (Logger)((Logger)Mockito.mock(Logger.class)), __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals((Object)"Not enough brokers on rack rack0", (Object)throwable.getMessage());
    }

    @Test
    public void testValidateTopicPlacementUpdateUnknownRackOnObserver() {
        String validTopicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack1\"}}]}";
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), false));
        Optional topicPlacement = TopicPlacement.parse((String)validTopicPlacementJson);
        Assertions.assertTrue((boolean)topicPlacement.isPresent());
        Throwable throwable = Assertions.assertThrows(InvalidConfigurationException.class, () -> TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange((TopicPlacement)((TopicPlacement)topicPlacement.get()), usableBrokers.iterator(), (Logger)((Logger)Mockito.mock(Logger.class)), __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals((Object)"Not enough brokers on rack rack1", (Object)throwable.getMessage());
    }

    @Test
    public void testValidateTopicPlacementFailsDueToDuplicateConstraint() {
        String validTopicPlacementJson = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}},{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"rack0\"}}]}";
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        usableBrokers.add(new UsableBroker(0, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(1, Optional.of("rack0"), false));
        usableBrokers.add(new UsableBroker(2, Optional.of("rack0"), false));
        Optional topicPlacement = TopicPlacement.parse((String)validTopicPlacementJson);
        Assertions.assertTrue((boolean)topicPlacement.isPresent());
        Throwable throwable = Assertions.assertThrows(InvalidConfigurationException.class, () -> TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange((TopicPlacement)((TopicPlacement)topicPlacement.get()), usableBrokers.iterator(), (Logger)((Logger)Mockito.mock(Logger.class)), __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals((Object)"Contains duplicate rack rack0", (Object)throwable.getMessage());
    }

    private void assertAssignment(Map<Integer, UsableBroker> idToBroker, List<Integer> brokers, String expectedRack, int minBrokerId, int maxBrokerId) {
        Assertions.assertEquals((int)brokers.size(), (int)new HashSet<Integer>(brokers).size());
        for (Integer broker : brokers) {
            Assertions.assertEquals((Object)expectedRack, idToBroker.get(broker).rack().get());
            Assertions.assertTrue((broker >= minBrokerId && broker <= maxBrokerId ? 1 : 0) != 0);
        }
    }

    private Set<Integer> brokerIdsInRack(StripedReplicaPlacer.Rack rack) {
        HashSet<Integer> ids = new HashSet<Integer>(rack.unfenced().brokers());
        ids.addAll(rack.fenced().brokers());
        return ids;
    }

    private void assertSatisfiesPlacement(String topicPlacementJson, PartitionAssignment partitionAssignment, Map<Integer, UsableBroker> idToBroker) {
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)topicPlacementJson).get();
        Optional expectedLeaderRack = Optional.ofNullable(((TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)).constraints().get("rack"));
        int leader = (Integer)partitionAssignment.syncReplicas().get(0);
        if (expectedLeaderRack.isPresent()) {
            Assertions.assertEquals(expectedLeaderRack, (Object)idToBroker.get(leader).rack());
        }
        List syncReplicas = partitionAssignment.syncReplicas();
        List observers = partitionAssignment.observers();
        List topicPlacementSyncReplicas = syncReplicas.stream().map(x -> {
            Optional rack = ((UsableBroker)idToBroker.get(x)).rack();
            Map constraint = rack.isPresent() ? Collections.singletonMap("rack", rack.get()) : Collections.emptyMap();
            return TopicPlacement.Replica.of((int)x, Optional.of(constraint));
        }).collect(Collectors.toList());
        List topicPlacementObservers = observers.stream().map(x -> {
            Optional rack = ((UsableBroker)idToBroker.get(x)).rack();
            Map constraint = rack.isPresent() ? Collections.singletonMap("rack", rack.get()) : Collections.emptyMap();
            return TopicPlacement.Replica.of((int)x, Optional.of(constraint));
        }).collect(Collectors.toList());
        Optional errMsg = TopicPlacement.validateAssignment((TopicPlacement)topicPlacement, topicPlacementSyncReplicas, topicPlacementObservers);
        Assertions.assertFalse((boolean)errMsg.isPresent());
    }

    private void assertStructureOfPartitionAssignment(PartitionAssignment partitionAssignment) {
        List replicas = partitionAssignment.replicas();
        List syncReplicas = partitionAssignment.syncReplicas();
        List observers = partitionAssignment.observers();
        Assertions.assertEquals((int)replicas.size(), (int)(syncReplicas.size() + observers.size()));
        Assertions.assertEquals((int)replicas.size(), (int)new HashSet(replicas).size());
        Assertions.assertEquals((int)syncReplicas.size(), (int)new HashSet(syncReplicas).size());
        Assertions.assertEquals((int)observers.size(), (int)new HashSet(observers).size());
        Assertions.assertEquals((Object)observers, replicas.subList(replicas.size() - observers.size(), replicas.size()));
        HashSet duplicateIds = new HashSet(syncReplicas);
        duplicateIds.retainAll(observers);
        Assertions.assertEquals(Collections.emptySet(), duplicateIds);
    }

    private List<List<Integer>> transpose(List<List<Integer>> listOfLists) {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        int n = listOfLists.get(0).size();
        for (int i = 0; i < n; ++i) {
            ArrayList<Integer> col = new ArrayList<Integer>();
            for (List<Integer> row : listOfLists) {
                col.add(row.get(i));
            }
            result.add(col);
        }
        return result;
    }

    private List<UsableBroker> usableBrokerList(int numBrokers, int brokersPerRack, boolean fenced) {
        ArrayList<UsableBroker> usableBrokers = new ArrayList<UsableBroker>();
        for (int brokerId = 0; brokerId < numBrokers; ++brokerId) {
            String rack = "rack" + Integer.valueOf(brokerId / brokersPerRack);
            usableBrokers.add(new UsableBroker(brokerId, Optional.of(rack), fenced));
        }
        return usableBrokers;
    }

    private Map<Integer, UsableBroker> idToBroker(List<UsableBroker> brokers) {
        HashMap<Integer, UsableBroker> idToBroker = new HashMap<Integer, UsableBroker>();
        for (UsableBroker usableBroker : brokers) {
            idToBroker.put(usableBroker.id(), usableBroker);
        }
        return idToBroker;
    }
}

