/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.metadata.placement.PartitionAssignmentTest;
import org.apache.kafka.metadata.placement.PlacementSpec;
import org.apache.kafka.metadata.placement.ReplicaPlacer;
import org.apache.kafka.metadata.placement.StripedReplicaPlacer;
import org.apache.kafka.metadata.placement.TopicAssignment;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.util.MockRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class StripedReplicaPlacerTest {
    @Test
    public void testBrokerList() {
        Assertions.assertEquals((int)0, (int)StripedReplicaPlacer.BrokerList.EMPTY.size());
        Assertions.assertEquals((int)-1, (int)StripedReplicaPlacer.BrokerList.EMPTY.next(1));
        StripedReplicaPlacer.BrokerList brokers = new StripedReplicaPlacer.BrokerList().add(0).add(1).add(2).add(3);
        Assertions.assertEquals((int)4, (int)brokers.size());
        Assertions.assertEquals((int)0, (int)brokers.next(0));
        Assertions.assertEquals((int)1, (int)brokers.next(0));
        Assertions.assertEquals((int)2, (int)brokers.next(0));
        Assertions.assertEquals((int)3, (int)brokers.next(0));
        Assertions.assertEquals((int)-1, (int)brokers.next(0));
        Assertions.assertEquals((int)-1, (int)brokers.next(0));
        Assertions.assertEquals((int)1, (int)brokers.next(1));
        Assertions.assertEquals((int)2, (int)brokers.next(1));
        Assertions.assertEquals((int)3, (int)brokers.next(1));
        Assertions.assertEquals((int)0, (int)brokers.next(1));
        Assertions.assertEquals((int)-1, (int)brokers.next(1));
    }

    @Test
    public void testAvoidFencedReplicaIfPossibleOnSingleRack() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer.RackList rackList = new StripedReplicaPlacer.RackList((Random)random, Arrays.asList(new UsableBroker(3, Optional.empty(), false), new UsableBroker(1, Optional.empty(), true), new UsableBroker(0, Optional.empty(), false), new UsableBroker(4, Optional.empty(), false), new UsableBroker(2, Optional.empty(), false)).iterator());
        Assertions.assertEquals((int)5, (int)rackList.numTotalBrokers());
        Assertions.assertEquals((int)4, (int)rackList.numUnfencedBrokers());
        Assertions.assertEquals(Collections.singletonList(Optional.empty()), (Object)rackList.rackNames());
        Assertions.assertThrows(InvalidReplicationFactorException.class, () -> rackList.place(0));
        Assertions.assertThrows(InvalidReplicationFactorException.class, () -> rackList.place(-1));
        Assertions.assertEquals(Arrays.asList(3, 4, 0, 2), (Object)rackList.place(4));
        Assertions.assertEquals(Arrays.asList(4, 0, 2, 3), (Object)rackList.place(4));
        Assertions.assertEquals(Arrays.asList(0, 2, 3, 4), (Object)rackList.place(4));
        Assertions.assertEquals(Arrays.asList(2, 3, 4, 0), (Object)rackList.place(4));
        Assertions.assertEquals(Arrays.asList(0, 4, 3, 2), (Object)rackList.place(4));
    }

    private TopicAssignment place(ReplicaPlacer placer, int startPartition, int numPartitions, short replicationFactor, final List<UsableBroker> brokers) {
        PlacementSpec placementSpec = new PlacementSpec(startPartition, numPartitions, replicationFactor, "", KafkaPrincipal.ANONYMOUS, Collections.emptySet(), PartitionPlacementStrategy.CLUSTER_WIDE, Optional.empty());
        ClusterDescriber cluster = new ClusterDescriber(){

            public Iterator<UsableBroker> usableBrokers() {
                return brokers.iterator();
            }

            public Iterator<String> topicNames() {
                throw new RuntimeException("Not implemented");
            }

            public List<List<Integer>> replicasForTopicName(String topicName) {
                throw new RuntimeException("Not implemented");
            }

            public Uuid defaultDir(int brokerId) {
                return DirectoryId.MIGRATING;
            }
        };
        return placer.place(placementSpec, cluster);
    }

    @Test
    public void testMultiPartitionTopicPlacementOnSingleUnfencedBroker() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer placer = new StripedReplicaPlacer((Random)random);
        Assertions.assertEquals((Object)new TopicAssignment(Arrays.asList(PartitionAssignmentTest.partitionAssignment(Collections.singletonList(0)), PartitionAssignmentTest.partitionAssignment(Collections.singletonList(0)), PartitionAssignmentTest.partitionAssignment(Collections.singletonList(0)))), (Object)this.place((ReplicaPlacer)placer, 0, 3, (short)1, Arrays.asList(new UsableBroker(0, Optional.empty(), false), new UsableBroker(1, Optional.empty(), true))));
    }

    @Test
    public void testPlacementOnFencedReplicaOnSingleRack() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer.RackList rackList = new StripedReplicaPlacer.RackList((Random)random, Arrays.asList(new UsableBroker(3, Optional.empty(), false), new UsableBroker(1, Optional.empty(), true), new UsableBroker(2, Optional.empty(), false)).iterator());
        Assertions.assertEquals((int)3, (int)rackList.numTotalBrokers());
        Assertions.assertEquals((int)2, (int)rackList.numUnfencedBrokers());
        Assertions.assertEquals(Collections.singletonList(Optional.empty()), (Object)rackList.rackNames());
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)rackList.place(3));
        Assertions.assertEquals(Arrays.asList(2, 3, 1), (Object)rackList.place(3));
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)rackList.place(3));
        Assertions.assertEquals(Arrays.asList(2, 3, 1), (Object)rackList.place(3));
    }

    @Test
    public void testRackListWithMultipleRacks() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer.RackList rackList = new StripedReplicaPlacer.RackList((Random)random, Arrays.asList(new UsableBroker(11, Optional.of("1"), false), new UsableBroker(10, Optional.of("1"), false), new UsableBroker(30, Optional.of("3"), false), new UsableBroker(31, Optional.of("3"), false), new UsableBroker(21, Optional.of("2"), false), new UsableBroker(20, Optional.of("2"), true)).iterator());
        Assertions.assertEquals((int)6, (int)rackList.numTotalBrokers());
        Assertions.assertEquals((int)5, (int)rackList.numUnfencedBrokers());
        Assertions.assertEquals(Arrays.asList(Optional.of("1"), Optional.of("2"), Optional.of("3")), (Object)rackList.rackNames());
        Assertions.assertEquals(Arrays.asList(11, 21, 31, 10), (Object)rackList.place(4));
        Assertions.assertEquals(Arrays.asList(21, 30, 10, 20), (Object)rackList.place(4));
        Assertions.assertEquals(Arrays.asList(31, 11, 21, 30), (Object)rackList.place(4));
    }

    @Test
    public void testRackListWithInvalidRacks() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer.RackList rackList = new StripedReplicaPlacer.RackList((Random)random, Arrays.asList(new UsableBroker(11, Optional.of("1"), false), new UsableBroker(10, Optional.of("1"), false), new UsableBroker(30, Optional.of("3"), true), new UsableBroker(31, Optional.of("3"), true), new UsableBroker(20, Optional.of("2"), true), new UsableBroker(21, Optional.of("2"), true), new UsableBroker(41, Optional.of("4"), false), new UsableBroker(40, Optional.of("4"), true)).iterator());
        Assertions.assertEquals((int)8, (int)rackList.numTotalBrokers());
        Assertions.assertEquals((int)3, (int)rackList.numUnfencedBrokers());
        Assertions.assertEquals(Arrays.asList(Optional.of("1"), Optional.of("2"), Optional.of("3"), Optional.of("4")), (Object)rackList.rackNames());
        Assertions.assertEquals(Arrays.asList(41, 11, 21, 30), (Object)rackList.place(4));
        Assertions.assertEquals(Arrays.asList(10, 20, 31, 41), (Object)rackList.place(4));
        Assertions.assertEquals(Arrays.asList(41, 21, 30, 11), (Object)rackList.place(4));
    }

    @Test
    public void testAllBrokersFenced() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer placer = new StripedReplicaPlacer((Random)random);
        Assertions.assertEquals((Object)"All brokers are currently fenced.", (Object)((InvalidReplicationFactorException)Assertions.assertThrows(InvalidReplicationFactorException.class, () -> this.place((ReplicaPlacer)placer, 0, 1, (short)1, Arrays.asList(new UsableBroker(11, Optional.of("1"), true), new UsableBroker(10, Optional.of("1"), true))))).getMessage());
    }

    @Test
    public void testNotEnoughBrokers() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer placer = new StripedReplicaPlacer((Random)random);
        Assertions.assertEquals((Object)"The target replication factor of 3 cannot be reached because only 2 broker(s) are registered.", (Object)((InvalidReplicationFactorException)Assertions.assertThrows(InvalidReplicationFactorException.class, () -> this.place((ReplicaPlacer)placer, 0, 1, (short)3, Arrays.asList(new UsableBroker(11, Optional.of("1"), false), new UsableBroker(10, Optional.of("1"), false))))).getMessage());
    }

    @Test
    public void testNonPositiveReplicationFactor() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer placer = new StripedReplicaPlacer((Random)random);
        Assertions.assertEquals((Object)"Invalid replication factor 0: the replication factor must be positive.", (Object)((InvalidReplicationFactorException)Assertions.assertThrows(InvalidReplicationFactorException.class, () -> this.place((ReplicaPlacer)placer, 0, 1, (short)0, Arrays.asList(new UsableBroker(11, Optional.of("1"), false), new UsableBroker(10, Optional.of("1"), false))))).getMessage());
    }

    @Test
    public void testSuccessfulPlacement() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer placer = new StripedReplicaPlacer((Random)random);
        Assertions.assertEquals((Object)new TopicAssignment(Arrays.asList(PartitionAssignmentTest.partitionAssignment(Arrays.asList(2, 3, 0)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(3, 0, 1)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(0, 1, 2)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(1, 2, 3)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(1, 0, 2)))), (Object)this.place((ReplicaPlacer)placer, 0, 5, (short)3, Arrays.asList(new UsableBroker(0, Optional.empty(), false), new UsableBroker(3, Optional.empty(), false), new UsableBroker(2, Optional.empty(), false), new UsableBroker(1, Optional.empty(), false))));
    }

    @Test
    public void testEvenDistribution() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer placer = new StripedReplicaPlacer((Random)random);
        TopicAssignment topicAssignment = this.place((ReplicaPlacer)placer, 0, 200, (short)2, Arrays.asList(new UsableBroker(0, Optional.empty(), false), new UsableBroker(1, Optional.empty(), false), new UsableBroker(2, Optional.empty(), false), new UsableBroker(3, Optional.empty(), false)));
        HashMap<List, Integer> counts = new HashMap<List, Integer>();
        for (PartitionAssignment partitionAssignment : topicAssignment.assignments()) {
            counts.put(partitionAssignment.replicas(), counts.getOrDefault(partitionAssignment.replicas(), 0) + 1);
        }
        Assertions.assertEquals((int)14, (Integer)((Integer)counts.get(Arrays.asList(0, 1))));
        Assertions.assertEquals((int)22, (Integer)((Integer)counts.get(Arrays.asList(0, 2))));
        Assertions.assertEquals((int)14, (Integer)((Integer)counts.get(Arrays.asList(0, 3))));
        Assertions.assertEquals((int)17, (Integer)((Integer)counts.get(Arrays.asList(1, 0))));
        Assertions.assertEquals((int)17, (Integer)((Integer)counts.get(Arrays.asList(1, 2))));
        Assertions.assertEquals((int)16, (Integer)((Integer)counts.get(Arrays.asList(1, 3))));
        Assertions.assertEquals((int)13, (Integer)((Integer)counts.get(Arrays.asList(2, 0))));
        Assertions.assertEquals((int)17, (Integer)((Integer)counts.get(Arrays.asList(2, 1))));
        Assertions.assertEquals((int)20, (Integer)((Integer)counts.get(Arrays.asList(2, 3))));
        Assertions.assertEquals((int)20, (Integer)((Integer)counts.get(Arrays.asList(3, 0))));
        Assertions.assertEquals((int)19, (Integer)((Integer)counts.get(Arrays.asList(3, 1))));
        Assertions.assertEquals((int)11, (Integer)((Integer)counts.get(Arrays.asList(3, 2))));
    }

    @Test
    public void testRackListAllBrokersFenced() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer.RackList rackList = new StripedReplicaPlacer.RackList((Random)random, Arrays.asList(new UsableBroker(0, Optional.empty(), true), new UsableBroker(1, Optional.empty(), true), new UsableBroker(2, Optional.empty(), true)).iterator());
        Assertions.assertEquals((int)3, (int)rackList.numTotalBrokers());
        Assertions.assertEquals((int)0, (int)rackList.numUnfencedBrokers());
        Assertions.assertEquals(Collections.singletonList(Optional.empty()), (Object)rackList.rackNames());
        Assertions.assertEquals((Object)"All brokers are currently fenced.", (Object)((InvalidReplicationFactorException)Assertions.assertThrows(InvalidReplicationFactorException.class, () -> rackList.place(3))).getMessage());
    }

    @Test
    public void testRackListNotEnoughBrokers() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer.RackList rackList = new StripedReplicaPlacer.RackList((Random)random, Arrays.asList(new UsableBroker(11, Optional.of("1"), false), new UsableBroker(10, Optional.of("1"), false)).iterator());
        Assertions.assertEquals((Object)"The target replication factor of 3 cannot be reached because only 2 broker(s) are registered.", (Object)((InvalidReplicationFactorException)Assertions.assertThrows(InvalidReplicationFactorException.class, () -> rackList.place(3))).getMessage());
    }

    @Test
    public void testRackListNonPositiveReplicationFactor() {
        MockRandom random = new MockRandom();
        StripedReplicaPlacer.RackList rackList = new StripedReplicaPlacer.RackList((Random)random, Arrays.asList(new UsableBroker(11, Optional.of("1"), false), new UsableBroker(10, Optional.of("1"), false)).iterator());
        Assertions.assertEquals((Object)"Invalid replication factor -1: the replication factor must be positive.", (Object)((InvalidReplicationFactorException)Assertions.assertThrows(InvalidReplicationFactorException.class, () -> rackList.place(-1))).getMessage());
    }
}

