/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.config.ConfigMonitorKey;
import org.apache.kafka.metadata.config.ConfigMonitorKeyAndDefinition;

public final class ConfigRegistryTestConstants {
    static final Map<ConfigResource.Type, ConfigDef> CONFIGS = new HashMap<ConfigResource.Type, ConfigDef>();
    static final KafkaConfigSchema SCHEMA;
    static final Map<String, Object> STATIC_CONFIG_MAP;
    static final ConfigMonitorKeyAndDefinition BROKER_NUM_FOOBARS;
    static final ConfigMonitorKeyAndDefinition BROKER_NUM_QUUX;
    static final ConfigMonitorKeyAndDefinition BROKER_BAAZ_ENABLED;
    static final ConfigMonitorKeyAndDefinition TOPIC_NUM_FOOBARS;
    static final ConfigMonitorKeyAndDefinition TOPIC_BAAZ_ENABLED;
    static final List<ConfigMonitorKeyAndDefinition> ALL_KEYS;

    static {
        CONFIGS.put(ConfigResource.Type.BROKER, new ConfigDef().define("num.foobars", ConfigDef.Type.SHORT, (Object)"2", ConfigDef.Importance.HIGH, "the number of foobars").define("num.quux", ConfigDef.Type.INT, (Object)"5", ConfigDef.Importance.HIGH, "the number of quuxes").define("baaz.enabled", ConfigDef.Type.BOOLEAN, (Object)"true", ConfigDef.Importance.HIGH, "if the baaz is enabled"));
        CONFIGS.put(ConfigResource.Type.TOPIC, new ConfigDef().define("num.foobars", ConfigDef.Type.SHORT, (Object)"2", ConfigDef.Importance.HIGH, "the number of foobars").define("baaz.enabled", ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.HIGH, "if the baaz is enabled"));
        SCHEMA = new KafkaConfigSchema(CONFIGS, Collections.emptyMap());
        HashMap<String, Object> staticConfigMap = new HashMap<String, Object>();
        staticConfigMap.put("num.foobars", (short)3);
        staticConfigMap.put("baaz.enabled", "true");
        STATIC_CONFIG_MAP = Collections.unmodifiableMap(staticConfigMap);
        BROKER_NUM_FOOBARS = new ConfigMonitorKeyAndDefinition(new ConfigMonitorKey(ConfigResource.Type.BROKER, "num.foobars"), SCHEMA.configKey(ConfigResource.Type.BROKER, "num.foobars"));
        BROKER_NUM_QUUX = new ConfigMonitorKeyAndDefinition(new ConfigMonitorKey(ConfigResource.Type.BROKER, "num.quux"), SCHEMA.configKey(ConfigResource.Type.BROKER, "num.quux"));
        BROKER_BAAZ_ENABLED = new ConfigMonitorKeyAndDefinition(new ConfigMonitorKey(ConfigResource.Type.BROKER, "baaz.enabled"), SCHEMA.configKey(ConfigResource.Type.BROKER, "baaz.enabled"));
        TOPIC_NUM_FOOBARS = new ConfigMonitorKeyAndDefinition(new ConfigMonitorKey(ConfigResource.Type.TOPIC, "num.foobars"), SCHEMA.configKey(ConfigResource.Type.TOPIC, "num.foobars"));
        TOPIC_BAAZ_ENABLED = new ConfigMonitorKeyAndDefinition(new ConfigMonitorKey(ConfigResource.Type.TOPIC, "baaz.enabled"), SCHEMA.configKey(ConfigResource.Type.TOPIC, "baaz.enabled"));
        ALL_KEYS = Arrays.asList(BROKER_NUM_FOOBARS, BROKER_NUM_QUUX, BROKER_BAAZ_ENABLED, TOPIC_NUM_FOOBARS, TOPIC_BAAZ_ENABLED);
    }
}

