/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.config;

import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.metadata.config.ConfigMonitorKey;
import org.apache.kafka.metadata.config.ConfigRegistryTestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=120L)
public final class ConfigMonitorKeyTest {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigMonitorKeyTest.class);

    @Test
    public void testEquals() {
        for (int i = 0; i < ConfigRegistryTestConstants.ALL_KEYS.size(); ++i) {
            for (int j = 0; j < ConfigRegistryTestConstants.ALL_KEYS.size(); ++j) {
                if (i == j) {
                    Assertions.assertEquals((Object)ConfigRegistryTestConstants.ALL_KEYS.get(i).key(), (Object)ConfigRegistryTestConstants.ALL_KEYS.get(j).key());
                    Assertions.assertEquals((Object)ConfigRegistryTestConstants.ALL_KEYS.get(j).key(), (Object)ConfigRegistryTestConstants.ALL_KEYS.get(i).key());
                    continue;
                }
                Assertions.assertNotEquals((Object)ConfigRegistryTestConstants.ALL_KEYS.get(i).key(), (Object)ConfigRegistryTestConstants.ALL_KEYS.get(j).key());
                Assertions.assertNotEquals((Object)ConfigRegistryTestConstants.ALL_KEYS.get(j).key(), (Object)ConfigRegistryTestConstants.ALL_KEYS.get(i).key());
            }
        }
    }

    @Test
    public void testEquivalentsWithEquals() {
        Assertions.assertEquals((Object)new ConfigMonitorKey(ConfigResource.Type.BROKER, "num.foobars"), (Object)ConfigRegistryTestConstants.BROKER_NUM_FOOBARS.key());
    }

    @Test
    public void testEquivalentsWithHashCode() {
        Assertions.assertEquals((int)new ConfigMonitorKey(ConfigResource.Type.BROKER, "num.foobars").hashCode(), (int)ConfigRegistryTestConstants.BROKER_NUM_FOOBARS.key().hashCode());
    }

    @Test
    public void testBrokerNumFoobarsKeyName() {
        Assertions.assertEquals((Object)"num.foobars", (Object)ConfigRegistryTestConstants.BROKER_NUM_FOOBARS.key().keyName());
    }

    @Test
    public void testBrokerNumFoobarsResourceType() {
        Assertions.assertEquals((Object)ConfigResource.Type.BROKER, (Object)ConfigRegistryTestConstants.BROKER_NUM_FOOBARS.key().resourceType());
    }

    @Test
    public void testBrokerNumFoobarsToString() {
        Assertions.assertEquals((Object)"ConfigMonitorKey(resourceType=BROKER, keyName=num.foobars)", (Object)ConfigRegistryTestConstants.BROKER_NUM_FOOBARS.key().toString());
    }

    @Test
    public void testTopicBaazEnabledToString() {
        Assertions.assertEquals((Object)"ConfigMonitorKey(resourceType=TOPIC, keyName=baaz.enabled)", (Object)ConfigRegistryTestConstants.TOPIC_BAAZ_ENABLED.key().toString());
    }
}

