/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.client;

import java.util.Arrays;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.ClusterDelta;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.ControllerRegistration;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.client.CannotCreateClientWithCurrentMetadataException;
import org.apache.kafka.metadata.client.InternalClientInfo;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InternalClientInfoTest {
    static InternalClientInfo.Builder createBuilder(boolean includeControllers) {
        ClusterDelta clusterDelta = new ClusterDelta(ClusterImage.EMPTY);
        if (includeControllers) {
            clusterDelta.replay(RecordTestUtils.createTestControllerRegistration(1000, true));
            clusterDelta.replay(RecordTestUtils.createTestControllerRegistration(1001, true));
            clusterDelta.replay(RecordTestUtils.createTestControllerRegistration(1002, true));
            clusterDelta.replay(RecordTestUtils.createTestControllerRegistration(1003, true));
            clusterDelta.replay(RecordTestUtils.createTestControllerRegistration(1004, true));
        }
        clusterDelta.replay(RecordTestUtils.createTestBrokerRegistration(0));
        clusterDelta.replay(RecordTestUtils.createTestBrokerRegistration(1));
        clusterDelta.replay(RecordTestUtils.createTestBrokerRegistration(2));
        clusterDelta.replay(RecordTestUtils.createTestBrokerRegistration(4));
        ClusterImage clusterImage = clusterDelta.apply();
        return new InternalClientInfo.Builder().setNodeId(1004).setMaxComponents(3).setMetadataVersion(MetadataVersion.IBP_3_7_IV0).setClusterImage(clusterImage).setTryControllerBootstrap(true).setTryBrokerBootstrap(true).setFirstControllerEndpointName("CONTROLLER").setInterBrokerEndpointName("INTERNAL");
    }

    @Test
    public void testMustSetInterBrokerEndpointName() {
        Assertions.assertThrows(ConfigException.class, () -> InternalClientInfoTest.createBuilder(true).setInterBrokerEndpointName(null).build());
    }

    @Test
    public void testMustSetFirstControllerEndpointName() {
        Assertions.assertThrows(ConfigException.class, () -> InternalClientInfoTest.createBuilder(true).setFirstControllerEndpointName(null).build());
    }

    @Test
    public void testCannotGenerateBootstrapControllersWithoutMetadata() {
        Assertions.assertThrows(CannotCreateClientWithCurrentMetadataException.class, () -> InternalClientInfoTest.createBuilder(true).setClusterImage(ClusterImage.EMPTY).setTryBrokerBootstrap(false).build());
    }

    @Test
    public void testEndpointToConfigComponent() {
        Assertions.assertEquals((Object)"localhost:8020", (Object)InternalClientInfo.Builder.endpointToConfigComponent((Endpoint)new Endpoint("BROKER", SecurityProtocol.PLAINTEXT, "localhost", 8020)));
    }

    @Test
    public void testControllerRegistrationToConfigComponentSuccess() {
        Assertions.assertEquals((Object)"localhost:9000", (Object)InternalClientInfoTest.createBuilder(true).registrationToConfigComponent(new ControllerRegistration.Builder(RecordTestUtils.createTestControllerRegistration(1000, true)).build()));
    }

    @Test
    public void testControllerRegistrationToConfigComponentCannotFindEndpoint() {
        Assertions.assertNull((Object)InternalClientInfoTest.createBuilder(true).setFirstControllerEndpointName("CONTROLLER2").registrationToConfigComponent(new ControllerRegistration.Builder(RecordTestUtils.createTestControllerRegistration(1000, true)).build()));
    }

    @Test
    public void testBrokerRegistrationToConfigComponentSuccess() {
        Assertions.assertEquals((Object)"localhost:6000", (Object)InternalClientInfoTest.createBuilder(true).registrationToConfigComponent(BrokerRegistration.fromRecord((RegisterBrokerRecord)RecordTestUtils.createTestBrokerRegistration(0))));
    }

    @Test
    public void testBrokerRegistrationToConfigComponentCannotFindEndpoint() {
        Assertions.assertNull((Object)InternalClientInfoTest.createBuilder(true).setInterBrokerEndpointName("BROKER2").registrationToConfigComponent(BrokerRegistration.fromRecord((RegisterBrokerRecord)RecordTestUtils.createTestBrokerRegistration(0))));
    }

    @Test
    public void testFindSecurityProtocolFromControllers() {
        Assertions.assertEquals((Object)SecurityProtocol.SSL, (Object)InternalClientInfo.Builder.findSecurityProtocolFromControllers((String)"CONTROLLER_SSL", Arrays.asList(new ControllerRegistration.Builder(RecordTestUtils.createTestControllerRegistration(0, true)).build(), new ControllerRegistration.Builder(RecordTestUtils.createTestControllerRegistration(1, true)).build())));
    }

    @Test
    public void testFindSecurityProtocolFromBrokers() {
        Assertions.assertEquals((Object)SecurityProtocol.SSL, (Object)InternalClientInfo.Builder.findSecurityProtocolFromBrokers((String)"EXTERNAL", Arrays.asList(BrokerRegistration.fromRecord((RegisterBrokerRecord)RecordTestUtils.createTestBrokerRegistration(0)), BrokerRegistration.fromRecord((RegisterBrokerRecord)RecordTestUtils.createTestBrokerRegistration(1)))));
    }

    @Test
    public void testFindBootstrapControllers() {
        Assertions.assertEquals((Object)new InternalClientInfo("CONTROLLER", SecurityProtocol.PLAINTEXT, "localhost:9004,localhost:9000,localhost:9001", true), (Object)InternalClientInfoTest.createBuilder(true).build());
    }

    @Test
    public void testFindBootstrapBrokersBecauseMetadataVersionTooLow() {
        Assertions.assertEquals((Object)new InternalClientInfo("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost:6000,localhost:6001,localhost:6002", false), (Object)InternalClientInfoTest.createBuilder(true).setMetadataVersion(MetadataVersion.IBP_3_6_IV2).build());
    }

    @Test
    public void testFindBootstrapBrokersBecauseBootstrapControllersDisabled() {
        Assertions.assertEquals((Object)new InternalClientInfo("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost:6004,localhost:6000,localhost:6001", false), (Object)InternalClientInfoTest.createBuilder(true).setTryControllerBootstrap(false).setNodeId(4).build());
    }

    @Test
    public void testFindBootstrapBrokersBecauseNoControllerMetadataPresent() {
        Assertions.assertEquals((Object)new InternalClientInfo("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost:6000,localhost:6001,localhost:6002", false), (Object)InternalClientInfoTest.createBuilder(false).setNodeId(3).build());
    }
}

