/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class StandardAclTest {
    @Test
    public void testResource() {
        Assertions.assertEquals((Object)new Resource(ResourceType.CLUSTER, "kafka-cluster"), (Object)StandardAuthorizerTestConstants.LITERAL_ACLS.get(0).resource());
        Assertions.assertEquals((Object)new Resource(ResourceType.TOPIC, "foo_"), (Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(0).resource());
    }

    @Test
    public void testToBindingRoundTrips() {
        StandardAuthorizerTestConstants.ALL.forEach(acl -> {
            AclBinding binding = acl.toBinding();
            StandardAcl acl2 = StandardAcl.fromAclBinding((AclBinding)binding);
            Assertions.assertEquals((Object)acl2, (Object)acl);
        });
    }

    @Test
    public void testEquals() {
        StandardAuthorizerTestConstants.ALL.forEach(acl1 -> StandardAuthorizerTestConstants.ALL.forEach(acl2 -> {
            if (acl1 == acl2) {
                Assertions.assertEquals((Object)acl1, (Object)acl2);
            } else {
                Assertions.assertNotEquals((Object)acl1, (Object)acl2);
            }
        }));
    }

    @Test
    public void testIsWildcard() {
        StandardAuthorizerTestConstants.WILDCARD_ACLS.forEach(acl -> Assertions.assertTrue((boolean)acl.isWildcard()));
        StandardAuthorizerTestConstants.LITERAL_ACLS.forEach(acl -> Assertions.assertFalse((boolean)acl.isWildcard()));
        StandardAuthorizerTestConstants.PREFIX_ACLS.forEach(acl -> Assertions.assertFalse((boolean)acl.isWildcard()));
    }

    @Test
    public void testIsWildcardOrPrefix() {
        StandardAuthorizerTestConstants.WILDCARD_ACLS.forEach(acl -> Assertions.assertTrue((boolean)acl.isWildcardOrPrefix()));
        StandardAuthorizerTestConstants.PREFIX_ACLS.forEach(acl -> Assertions.assertTrue((boolean)acl.isWildcardOrPrefix()));
        StandardAuthorizerTestConstants.LITERAL_ACLS.forEach(acl -> Assertions.assertFalse((boolean)acl.isWildcardOrPrefix()));
    }

    @Test
    public void testResourceNameForPrefixNode() {
        StandardAuthorizerTestConstants.WILDCARD_ACLS.forEach(acl -> Assertions.assertEquals((Object)"", (Object)acl.resourceNameForPrefixNode()));
        StandardAuthorizerTestConstants.LITERAL_ACLS.forEach(acl -> Assertions.assertEquals((Object)acl.resourceName(), (Object)acl.resourceNameForPrefixNode()));
        StandardAuthorizerTestConstants.PREFIX_ACLS.forEach(acl -> Assertions.assertEquals((Object)acl.resourceName(), (Object)acl.resourceNameForPrefixNode()));
    }
}

