/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Optional;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.metadata.authorizer.AuthorizeVisitor;
import org.apache.kafka.metadata.authorizer.PrefixNode;
import org.apache.kafka.metadata.authorizer.ResourceAcls;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTestConstants;
import org.apache.kafka.metadata.authorizer.Visitor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AuthorizeVisitorTest {
    @Test
    public void testResourceAclsAuthorize() {
        ResourceAcls resourceAcls = new ResourceAcls(StandardAuthorizerTestConstants.WILDCARD_ACLS_1);
        AuthorizeVisitor visitor = new AuthorizeVisitor("any", AclOperation.WRITE, "127.0.0.1");
        resourceAcls.walk((Visitor)visitor);
        Optional matchingAclOpt = visitor.matchingAcl();
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(0), matchingAclOpt.get());
        visitor = new AuthorizeVisitor("any", AclOperation.READ, "127.0.0.1");
        resourceAcls.walk((Visitor)visitor);
        matchingAclOpt = visitor.matchingAcl();
        Assertions.assertFalse((boolean)matchingAclOpt.isPresent());
        visitor = new AuthorizeVisitor("any", AclOperation.READ, "127.0.0.10");
        resourceAcls.walk((Visitor)visitor);
        matchingAclOpt = visitor.matchingAcl();
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(1), matchingAclOpt.get());
    }

    @Test
    public void testRootPrefixNodeAuthorize() {
        PrefixNode root = new PrefixNode("", new ResourceAcls(StandardAuthorizerTestConstants.WILDCARD_ACLS_1), new PrefixNode[0]);
        AuthorizeVisitor visitor = new AuthorizeVisitor("any", AclOperation.WRITE, "127.0.0.1");
        root.walk((Visitor)visitor);
        Optional matchingAclOpt = visitor.matchingAcl();
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(0), matchingAclOpt.get());
        visitor = new AuthorizeVisitor("any", AclOperation.READ, "127.0.0.1");
        root.walk((Visitor)visitor);
        matchingAclOpt = visitor.matchingAcl();
        Assertions.assertFalse((boolean)matchingAclOpt.isPresent());
        visitor = new AuthorizeVisitor("any", AclOperation.READ, "127.0.0.10");
        root.walk((Visitor)visitor);
        matchingAclOpt = visitor.matchingAcl();
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(1), matchingAclOpt.get());
    }

    @Test
    public void testPrefixNodeAuthorize() {
        PrefixNode root = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("f", new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5)), new PrefixNode[]{new PrefixNode("fo", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("foo", new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2)), new PrefixNode[0]), new PrefixNode("four", new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(6)), new PrefixNode[]{new PrefixNode("four_", new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(9)), new PrefixNode[0])})})})});
        AuthorizeVisitor visitor = new AuthorizeVisitor("any", AclOperation.WRITE, "127.0.0.1");
        root.walk((Visitor)visitor);
        Optional matchingAclOpt = visitor.matchingAcl();
        Assertions.assertFalse((boolean)matchingAclOpt.isPresent());
        visitor = new AuthorizeVisitor("f", AclOperation.READ, "127.0.0.1");
        root.walk((Visitor)visitor);
        matchingAclOpt = visitor.matchingAcl();
        Assertions.assertFalse((boolean)matchingAclOpt.isPresent());
        visitor = new AuthorizeVisitor("focus", AclOperation.WRITE, "127.0.0.10");
        root.walk((Visitor)visitor);
        matchingAclOpt = visitor.matchingAcl();
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(5), matchingAclOpt.get());
        visitor = new AuthorizeVisitor("fool", AclOperation.WRITE, "127.0.0.10");
        root.walk((Visitor)visitor);
        matchingAclOpt = visitor.matchingAcl();
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(5), matchingAclOpt.get());
        visitor = new AuthorizeVisitor("fool", AclOperation.READ, "127.0.0.10");
        root.walk((Visitor)visitor);
        matchingAclOpt = visitor.matchingAcl();
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(2), matchingAclOpt.get());
        visitor = new AuthorizeVisitor("four_4", AclOperation.CREATE, "127.0.0.10");
        root.walk((Visitor)visitor);
        matchingAclOpt = visitor.matchingAcl();
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(6), matchingAclOpt.get());
        visitor = new AuthorizeVisitor("four_4", AclOperation.CREATE, "127.0.0.100");
        root.walk((Visitor)visitor);
        matchingAclOpt = visitor.matchingAcl();
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(9), matchingAclOpt.get());
        visitor = new AuthorizeVisitor("four4", AclOperation.CREATE, "127.0.0.10");
        root.walk((Visitor)visitor);
        matchingAclOpt = visitor.matchingAcl();
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(6), matchingAclOpt.get());
    }
}

