/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.metadata.ConfluentPartitionsPerTopicListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ConfluentPartitionsPerTopicListenerTest {
    @Test
    public void testFullUpdateOnTopicPartitionCollection() {
        ArrayList<TopicPartition> parts = new ArrayList<TopicPartition>();
        parts.add(new TopicPartition("foo", 0));
        parts.add(new TopicPartition("foo", 1));
        parts.add(new TopicPartition("bar", 0));
        parts.add(new TopicPartition("baz", 2));
        parts.add(new TopicPartition("baz", 3));
        parts.add(new TopicPartition("baz", 4));
        parts.add(new TopicPartition("baz", 5));
        TestConfluentPartitionsPerTopicListener listener = new TestConfluentPartitionsPerTopicListener();
        HashMap<String, Integer> topicsToNumPartitions = new HashMap<String, Integer>();
        for (TopicPartition topicPartition : parts) {
            topicsToNumPartitions.put(topicPartition.topic(), topicsToNumPartitions.getOrDefault(topicPartition.topic(), 0) + 1);
        }
        listener.fullUpdate(topicsToNumPartitions.entrySet().iterator(), new HashMap<Integer, Integer>(), new HashSet<String>());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Map.Entry<String, Integer> entry = listener.iterator.next();
        map.put(entry.getKey(), entry.getValue());
        entry = listener.iterator.next();
        map.put(entry.getKey(), entry.getValue());
        entry = listener.iterator.next();
        map.put(entry.getKey(), entry.getValue());
        HashMap<String, Integer> expectedMap = new HashMap<String, Integer>();
        expectedMap.put("foo", 2);
        expectedMap.put("bar", 1);
        expectedMap.put("baz", 4);
        Assertions.assertEquals(expectedMap, map);
        Assertions.assertFalse((boolean)listener.iterator.hasNext());
    }

    static class TestConfluentPartitionsPerTopicListener
    implements ConfluentPartitionsPerTopicListener {
        Iterator<Map.Entry<String, Integer>> iterator = null;

        TestConfluentPartitionsPerTopicListener() {
        }

        public void fullUpdate(Iterator<Map.Entry<String, Integer>> iterator, Map<Integer, Integer> brokersToNumReplicas, Set<String> compactedTopics) {
            this.iterator = iterator;
        }

        public void partialUpdate(String topicName, int numPartitionsAddedOrDeleted, int numTopicsAddedOrDeleted, Map<Integer, List<Integer>> partitionIdToReplicasAdded, Map<Integer, List<Integer>> partitionIdToReplicasDeleted, boolean pending, boolean isCompacted) {
            throw new RuntimeException("Unexpected call to partialUpdate");
        }

        public void clearPending() {
            throw new RuntimeException("Unexpected call to clearPending");
        }
    }
}

