/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.nio.ByteBuffer;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ClusterLinkRecordTest {
    ClusterLinkRecordTest() {
    }

    @Test
    public void testSerde() {
        MetadataRecordSerde serde = MetadataRecordSerde.INSTANCE;
        for (short version = 0; version <= 1; version = (short)(version + 1)) {
            ClusterLinkRecord clusterLinkRecord = new ClusterLinkRecord().setClusterLinkId(Uuid.randomUuid()).setClusterLinkName("test").setRemoteClusterId("source-cluster-id");
            if (version >= 1) {
                clusterLinkRecord = clusterLinkRecord.setLinkMode("SOURCE");
            }
            ApiMessageAndVersion messageAndVersion = new ApiMessageAndVersion((ApiMessage)clusterLinkRecord, version);
            ObjectSerializationCache cache = new ObjectSerializationCache();
            int size = serde.recordSize(messageAndVersion, cache);
            ByteBuffer buffer = ByteBuffer.allocate(size);
            ByteBufferAccessor bufferAccessor = new ByteBufferAccessor(buffer);
            serde.write(messageAndVersion, cache, (Writable)bufferAccessor);
            buffer.flip();
            Assertions.assertEquals((int)size, (int)buffer.remaining());
            ApiMessageAndVersion parsedMessageAndVersion = serde.read((Readable)bufferAccessor, size);
            Assertions.assertEquals((Object)messageAndVersion, (Object)parsedMessageAndVersion);
        }
    }
}

