/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Tenant;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.node.TenantImageNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class TenantImageNodeTest {
    private static final Map<String, Tenant> TENANT_ID_TO_TENANT;
    private static final TenantImage IMAGE;
    private static final TenantImageNode NODE;

    @Test
    public void testChild() {
        Assertions.assertEquals((Object)"Tenant{tenantId=pgg01o, cellIds=[1]}", (Object)NODE.child("pgg01o").stringify());
    }

    @Test
    public void testChild2() {
        Assertions.assertEquals((Object)"Tenant{tenantId=kpvnp, cellIds=[0]}", (Object)NODE.child("kpvnp").stringify());
    }

    @Test
    public void testNonExistentChild() {
        Assertions.assertNull((Object)NODE.child("zf2fj"));
    }

    static {
        HashMap<String, Tenant> tenants = new HashMap<String, Tenant>();
        tenants.put("pgg01o", new Tenant("pgg01o", Arrays.asList(1)));
        tenants.put("kpvnp", new Tenant("kpvnp", Arrays.asList(0)));
        TENANT_ID_TO_TENANT = Collections.unmodifiableMap(tenants);
        IMAGE = new TenantImage(TENANT_ID_TO_TENANT);
        NODE = new TenantImageNode(IMAGE);
    }
}

