/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ProducerIdsDelta;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ProducerIdsImageTest {
    public static final ProducerIdsImage IMAGE1 = new ProducerIdsImage(123L);
    static final List<ApiMessageAndVersion> DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
    static final ProducerIdsDelta DELTA1;
    static final ProducerIdsImage IMAGE2;

    @Test
    public void testEmptyImageRoundTrip() {
        ProducerIdsImageTest.testToImage(ProducerIdsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        ProducerIdsImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = ProducerIdsImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        ProducerIdsImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        ProducerIdsImageTest.testToImage(IMAGE2);
    }

    private static void testToImage(ProducerIdsImage image) {
        ProducerIdsImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(ProducerIdsImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        ProducerIdsImageTest.testToImage(image, fromRecords.orElseGet(() -> ProducerIdsImageTest.getImageRecords(image)));
    }

    private static void testToImage(ProducerIdsImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<ProducerIdsDelta, ProducerIdsImage>(() -> ProducerIdsImage.EMPTY, ProducerIdsDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(ProducerIdsImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        return writer.records();
    }

    static {
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerId(2).setBrokerEpoch(100L).setNextProducerId(456L), 0));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerId(3).setBrokerEpoch(100L).setNextProducerId(780L), 0));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerId(3).setBrokerEpoch(100L).setNextProducerId(785L), 0));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerId(2).setBrokerEpoch(100L).setNextProducerId(800L), 0));
        DELTA1 = new ProducerIdsDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        IMAGE2 = new ProducerIdsImage(800L);
    }
}

