/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControllerMetadataMetricsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricNames() {
        MetricsRegistry registry = new MetricsRegistry();
        try {
            try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
                ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.controller:", new HashSet<String>(Arrays.asList("kafka.controller:type=KafkaController,name=ActiveBrokerCount", "kafka.controller:type=KafkaController,name=BrokersExcludedForReplicaPlacementCount", "kafka.controller:type=KafkaController,name=BrokersWithDegradedHealthCount", "kafka.controller:type=KafkaController,name=BrokersWithDegradedStorageCount", "kafka.controller:type=KafkaController,name=BrokersWithDegradedNetworkCount", "kafka.controller:type=KafkaController,name=FencedBrokerCount", "kafka.controller:type=KafkaController,name=MetadataErrorCount", "kafka.controller:type=KafkaController,name=IgnoredStaticVoters", "kafka.controller:type=KafkaController,name=MigratingZkBrokerCount", "kafka.controller:type=KafkaController,name=ZkMigrationState")));
            }
            ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "KafkaController", Collections.emptySet());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataErrorCount() {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            Gauge metadataErrorCount = (Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "MetadataErrorCount"));
            Assertions.assertEquals((int)0, (Integer)((Integer)metadataErrorCount.value()));
            metrics.incrementMetadataErrorCount();
            Assertions.assertEquals((int)1, (Integer)((Integer)metadataErrorCount.value()));
        }
        finally {
            registry.shutdown();
        }
    }

    private static MetricName metricName(String type, String name) {
        String mBeanName = String.format("kafka.controller:type=%s,name=%s", type, name);
        return new MetricName("kafka.controller", type, name, null, mBeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIntGaugeMetric(Function<ControllerMetadataMetrics, Integer> metricsGetter, Function<MetricsRegistry, Integer> registryGetter, BiConsumer<ControllerMetadataMetrics, Integer> setter, BiConsumer<ControllerMetadataMetrics, Integer> incrementer) {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            Assertions.assertEquals((int)0, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)0, (Integer)registryGetter.apply(registry));
            setter.accept(metrics, 123);
            Assertions.assertEquals((int)123, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)123, (Integer)registryGetter.apply(registry));
            incrementer.accept(metrics, 123);
            Assertions.assertEquals((int)246, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)246, (Integer)registryGetter.apply(registry));
            incrementer.accept(metrics, -246);
            Assertions.assertEquals((int)0, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)0, (Integer)registryGetter.apply(registry));
        }
        finally {
            registry.shutdown();
        }
    }

    @Test
    public void testFencedBrokerMetric() {
        this.testIntGaugeMetric(m -> m.fencedBrokerCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "FencedBrokerCount"))).value(), (m, v) -> m.setFencedBrokerCount(v.intValue()), (m, v) -> m.addToFencedBrokerCount(v.intValue()));
    }

    @Test
    public void testActiveBrokerCountMetric() {
        this.testIntGaugeMetric(m -> m.activeBrokerCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "ActiveBrokerCount"))).value(), (m, v) -> m.setActiveBrokerCount(v.intValue()), (m, v) -> m.addToActiveBrokerCount(v.intValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrokersWithDegradedStorageCount() {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            Gauge brokersWithDegradedStorageCount = (Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "BrokersWithDegradedStorageCount"));
            Assertions.assertEquals((int)0, (Integer)((Integer)brokersWithDegradedStorageCount.value()));
            metrics.setBrokersWithDegradedStorageCount(-1);
            Assertions.assertEquals((int)0, (Integer)((Integer)brokersWithDegradedStorageCount.value()));
            metrics.setBrokersWithDegradedStorageCount(1);
            Assertions.assertEquals((int)1, (Integer)((Integer)brokersWithDegradedStorageCount.value()));
            metrics.addToBrokersWithDegradedStorageCount(1);
            Assertions.assertEquals((int)2, (Integer)((Integer)brokersWithDegradedStorageCount.value()));
            metrics.addToBrokersWithDegradedStorageCount(-2);
            Assertions.assertEquals((int)0, (Integer)((Integer)brokersWithDegradedStorageCount.value()));
            metrics.addToBrokersWithDegradedStorageCount(2);
            Assertions.assertEquals((int)2, (Integer)((Integer)brokersWithDegradedStorageCount.value()));
            metrics.addToBrokersWithDegradedStorageCount(-3);
            Assertions.assertEquals((int)0, (Integer)((Integer)brokersWithDegradedStorageCount.value()));
            metrics.addToBrokersWithDegradedStorageCount(-1);
            Assertions.assertEquals((int)0, (Integer)((Integer)brokersWithDegradedStorageCount.value()));
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrokersWithDegradedNetworkCount() {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            Gauge brokersWithDegradedNetworkCount = (Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "BrokersWithDegradedNetworkCount"));
            Assertions.assertEquals((int)0, (Integer)((Integer)brokersWithDegradedNetworkCount.value()));
            metrics.setBrokersWithDegradedNetworkCount(-1);
            Assertions.assertEquals((int)0, (Integer)((Integer)brokersWithDegradedNetworkCount.value()));
            metrics.setBrokersWithDegradedNetworkCount(1);
            Assertions.assertEquals((int)1, (Integer)((Integer)brokersWithDegradedNetworkCount.value()));
            metrics.addToBrokersWithDegradedNetworkCount(1);
            Assertions.assertEquals((int)2, (Integer)((Integer)brokersWithDegradedNetworkCount.value()));
            metrics.addToBrokersWithDegradedNetworkCount(-2);
            Assertions.assertEquals((int)0, (Integer)((Integer)brokersWithDegradedNetworkCount.value()));
            metrics.addToBrokersWithDegradedNetworkCount(2);
            Assertions.assertEquals((int)2, (Integer)((Integer)brokersWithDegradedNetworkCount.value()));
            metrics.addToBrokersWithDegradedNetworkCount(-3);
            Assertions.assertEquals((int)0, (Integer)((Integer)brokersWithDegradedNetworkCount.value()));
            metrics.addToBrokersWithDegradedNetworkCount(-1);
            Assertions.assertEquals((int)0, (Integer)((Integer)brokersWithDegradedNetworkCount.value()));
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIgnoredStaticVoters() {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            Gauge ignoredStaticVoters = (Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "IgnoredStaticVoters"));
            Assertions.assertEquals((int)0, (Integer)((Integer)ignoredStaticVoters.value()));
            metrics.setIgnoredStaticVoters(true);
            Assertions.assertEquals((int)1, (Integer)((Integer)ignoredStaticVoters.value()));
            metrics.setIgnoredStaticVoters(false);
            Assertions.assertEquals((int)0, (Integer)((Integer)ignoredStaticVoters.value()));
        }
        finally {
            registry.shutdown();
        }
    }
}

