/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.controller.metrics.ConfluentControllerMetricsUtils;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfluentControllerMetricsUtilsTest {
    private static final PartitionRegistration LEADERLESS_PARTITION = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"m2XTezCtRgGuNSsoygINmQ"), Uuid.fromString((String)"ApmLNV9STQqLFew4u98jpQ"), Uuid.fromString((String)"qNxwZ0C9QoihnnUcdc6lJw")}).setIsr(new int[0]).setLeader(Integer.valueOf(-1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(123)).setPartitionEpoch(Integer.valueOf(456)).build();
    private static final PartitionRegistration IMBALANCED_PARTITION = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"8h1HqYKNSM6A-kJDw5eN2A"), Uuid.fromString((String)"Dn_fCWXsT1Oat5OHCh91zg"), Uuid.fromString((String)"pyCBJdwYQJi93jC9hfSEbw")}).setIsr(new int[]{1, 2}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(123)).setPartitionEpoch(Integer.valueOf(456)).build();
    private static final PartitionRegistration NORMAL_PARTITION = new PartitionRegistration.Builder().setLeader(Integer.valueOf(1)).setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"zhGqKCjrTz6cHQquqr59UQ"), Uuid.fromString((String)"6TI5eqCLQxGFkOnj_M-Ryw"), Uuid.fromString((String)"FV0dtldkQ3yslfKt1ADBCQ")}).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(123)).setPartitionEpoch(Integer.valueOf(456)).build();

    @Test
    public void testPartitionHasOfflineLeaderWithLeaderless() {
        Assertions.assertTrue((boolean)ConfluentControllerMetricsUtils.partitionHasOfflineLeader((PartitionRegistration)LEADERLESS_PARTITION));
    }

    @Test
    public void testPartitionHasNoOfflineLeaderWithImbalanced() {
        Assertions.assertFalse((boolean)ConfluentControllerMetricsUtils.partitionHasOfflineLeader((PartitionRegistration)IMBALANCED_PARTITION));
    }

    @Test
    public void testPartitionHasNoOfflineLeaderWithNormal() {
        Assertions.assertFalse((boolean)ConfluentControllerMetricsUtils.partitionHasOfflineLeader((PartitionRegistration)NORMAL_PARTITION));
    }

    @Test
    public void testPartitionHasNoImbalancedLeaderWithLeaderless() {
        Assertions.assertFalse((boolean)ConfluentControllerMetricsUtils.partitionHasImbalancedLeader((PartitionRegistration)LEADERLESS_PARTITION));
    }

    @Test
    public void testPartitionHasImbalancedLeaderWithImbalanced() {
        Assertions.assertTrue((boolean)ConfluentControllerMetricsUtils.partitionHasImbalancedLeader((PartitionRegistration)IMBALANCED_PARTITION));
    }

    @Test
    public void testPartitionHasNoImbalancedLeaderWithNormal() {
        Assertions.assertFalse((boolean)ConfluentControllerMetricsUtils.partitionHasImbalancedLeader((PartitionRegistration)NORMAL_PARTITION));
    }

    @Test
    public void testWithParsedUnderMinIsrConfigWithNoInput() {
        AtomicInteger validCallbacks = new AtomicInteger();
        ConfluentControllerMetricsUtils.withParsedUnderMinIsrConfig(Optional.empty(), (FaultHandler)new MockFaultHandler("ConfluentControllerMetricsUtilsTest"), v -> {
            if (!v.isPresent()) {
                validCallbacks.getAndIncrement();
            }
        });
        Assertions.assertEquals((int)1, (int)validCallbacks.get());
    }

    @Test
    public void testWithParsedUnderMinIsrConfigWithIntegerInput() {
        AtomicInteger validCallbacks = new AtomicInteger();
        ConfluentControllerMetricsUtils.withParsedUnderMinIsrConfig(Optional.of("3"), (FaultHandler)new MockFaultHandler("ConfluentControllerMetricsUtilsTest"), v -> {
            if (v.isPresent() && v.getAsInt() == 3) {
                validCallbacks.getAndIncrement();
            }
        });
        Assertions.assertEquals((int)1, (int)validCallbacks.get());
    }
}

