/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ResourceNotFoundException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterCellMigrationResponseData;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.message.AssignTenantsToCellResponseData;
import org.apache.kafka.common.message.DeleteTenantsResponseData;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.common.metadata.CellMigrationRecord;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RemoveTenantRecord;
import org.apache.kafka.common.metadata.TenantRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterCellMigrationRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.AssignTenantsToCellRequest;
import org.apache.kafka.common.requests.DeleteTenantsRequest;
import org.apache.kafka.common.requests.DescribeTenantsRequest;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.CellControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.controller.TenantControlManager;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TenantControlManagerTest {
    LogContext logContext = new LogContext();
    SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
    FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(this.snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();
    FeatureControlManager legacyFeatureControl = new FeatureControlManager.Builder().setSnapshotRegistry(this.snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.IBP_3_3_IV3).build();
    Random random = new Random(0L);
    CellControlManager cellControl = new CellControlManager(this.logContext, Time.SYSTEM, this.snapshotRegistry, this.featureControl, this.random, 2, 2, 3, true);
    CellControlManager legacyCellControl = new CellControlManager(this.logContext, Time.SYSTEM, this.snapshotRegistry, this.legacyFeatureControl, this.random, 2, 2, 3, true);
    PartitionPlacementStrategy placementStrategy = PartitionPlacementStrategy.TENANT_IN_CELL;
    short replicationFactor = (short)3;
    private short describeTenantRequestVersion = 1;

    TenantControlManagerTest() {
    }

    @Test
    void testCreateTenantToCellAssignmentIfNotExists() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, this.replicationFactor);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(Arrays.asList(0, 1, 2));
        this.cellControl.replay(cellRecord);
        String tenant = "lkc-abcd";
        Cell expectedCell = new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 2, 3);
        ArrayList records = new ArrayList();
        Assertions.assertEquals(Arrays.asList(0), (Object)control.createTenantToCellAssignmentIfNotExists(tenant, new HashSet<Integer>(Arrays.asList(0, 1, 2)), records::add));
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(tenant).setCellId(0).setCellIds(Arrays.asList(0)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(0));
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)));
        Assertions.assertEquals(Arrays.asList(0), (Object)control.createTenantToCellAssignmentIfNotExists(tenant, new HashSet<Integer>(Arrays.asList(0, 1, 2)), records::add));
        Assertions.assertEquals((int)1, (int)records.size());
        String secondTenant = "lkc-defg";
        Assertions.assertThrows(ResourceNotFoundException.class, () -> control.createTenantToCellAssignmentIfNotExists(secondTenant, new HashSet<Integer>(Collections.singletonList(0)), records::add));
    }

    @Test
    void testCreateTenantToCellAssignIfCellDoesNotExist() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, this.replicationFactor);
        String tenant = "lkc-abcd";
        ArrayList records = new ArrayList();
        Assertions.assertThrows(ResourceNotFoundException.class, () -> control.createTenantToCellAssignmentIfNotExists(tenant, new HashSet<Integer>(Arrays.asList(0, 1, 2)), records::add));
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(Arrays.asList(0, 1, 2));
        this.cellControl.replay(cellRecord);
        Assertions.assertEquals(Arrays.asList(0), (Object)control.createTenantToCellAssignmentIfNotExists(tenant, new HashSet<Integer>(Arrays.asList(0, 1, 2)), records::add));
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(0));
    }

    @Test
    void testCreateTenantToCellAssignForCellMigration() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, this.replicationFactor);
        ControllerResult controllerAlterMigrationStateResult = this.cellControl.alterCellMigration((AlterCellMigrationRequest)new AlterCellMigrationRequest.Builder().setState(CellMigrationState.INITIATED).build());
        CellMigrationRecord cellMigrationRecord = new CellMigrationRecord().setState(CellMigrationState.INITIATED.code());
        List<ApiMessageAndVersion> expectedCellMigrationRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)cellMigrationRecord, MetadataRecordType.CELL_MIGRATION_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedCellMigrationRecords, (Object)controllerAlterMigrationStateResult.records());
        String tenant = "lkc-abcd";
        ArrayList records = new ArrayList();
        control.createTenantToCellAssignmentIfNotExists(tenant, new HashSet<Integer>(Arrays.asList(0, 1, 2)), records::add);
        Assertions.assertEquals(Arrays.asList(-1), (Object)control.createTenantToCellAssignmentIfNotExists(tenant, new HashSet<Integer>(Arrays.asList(0, 1, 2)), records::add));
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(Arrays.asList(0, 1, 2));
        this.cellControl.replay(cellRecord);
        Assertions.assertEquals(Arrays.asList(0), (Object)control.createTenantToCellAssignmentIfNotExists(tenant, new HashSet<Integer>(Arrays.asList(0, 1, 2)), records::add));
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(0));
    }

    @Test
    void testCreateTenant() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, this.replicationFactor);
        String tenant = "lkc-abcd";
        ArrayList records = new ArrayList();
        Assertions.assertEquals((Object)Errors.CELL_NOT_FOUND, (Object)control.createTenant(tenant, 0, records::add).error());
        Assertions.assertEquals((int)0, (int)records.size());
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        this.cellControl.replay(cellRecord);
        Assertions.assertEquals((Object)Errors.NONE, (Object)control.createTenant(tenant, 0, records::add).error());
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(0));
        control.replay(new TenantRecord().setTenantId(tenant).setCellId(0));
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)control.createTenant(tenant, 0, records::add).error());
    }

    @Test
    void testAssignTenantToCell() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, 2);
        String tenant = "lkc-abcd";
        ArrayList records = new ArrayList();
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(0, 1)));
        this.cellControl.replay(cellRecord.setCellId(1).setBrokers(Arrays.asList(2, 3)));
        this.cellControl.replay(cellRecord.setCellId(2).setBrokers(Arrays.asList(4, 5)));
        Assertions.assertEquals((Object)Errors.TENANT_NOT_FOUND, (Object)control.assignTenantToCells(tenant, Collections.singletonList(0), true, new HashSet(), records::add).error());
        Assertions.assertEquals((int)0, (int)records.size());
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(1)));
        Assertions.assertEquals((Object)Errors.NONE, (Object)control.assignTenantToCells(tenant, Collections.singletonList(0), true, new HashSet<Integer>(Arrays.asList(0, 1)), records::add).error());
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(0));
        Assertions.assertEquals((Object)Errors.NONE, (Object)control.assignTenantToCells(tenant, Arrays.asList(1, 2), true, new HashSet<Integer>(Arrays.asList(2, 3, 4, 5)), records::add).error());
        Assertions.assertEquals((int)2, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(1, 2)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(1));
    }

    @Test
    void testAssignTenantToCellToProhibitedTargetStates() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, 2);
        String tenant = "lkc-abcd";
        String secondTenant = "lkc-efgh";
        ArrayList records = new ArrayList();
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.QUARANTINED.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(Arrays.asList(0, 1));
        this.cellControl.replay(cellRecord);
        Assertions.assertEquals((Object)Errors.TENANT_NOT_FOUND, (Object)control.assignTenantToCells(tenant, Collections.singletonList(0), false, new HashSet<Integer>(Arrays.asList(0, 1)), records::add).error());
        Assertions.assertEquals((int)0, (int)records.size());
        CellRecord secondCellRecord = new CellRecord().setCellId(1).setState(CellState.EXCLUDED.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(Arrays.asList(2, 3));
        this.cellControl.replay(secondCellRecord);
        Assertions.assertEquals((Object)Errors.TENANT_NOT_FOUND, (Object)control.assignTenantToCells(tenant, Collections.singletonList(1), false, new HashSet<Integer>(Arrays.asList(2, 3)), records::add).error());
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(1)));
        Assertions.assertEquals((Object)Errors.NONE, (Object)control.assignTenantToCells(tenant, Collections.singletonList(0), true, new HashSet<Integer>(Arrays.asList(0, 1)), records::add).error());
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(0));
        control.replay(new TenantRecord().setTenantId(secondTenant).setCellIds(Arrays.asList(0)));
        Assertions.assertEquals((Object)Errors.NONE, (Object)control.assignTenantToCells(secondTenant, Collections.singletonList(1), true, new HashSet<Integer>(Arrays.asList(2, 3)), records::add).error());
        Assertions.assertEquals((int)2, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(secondTenant).setCellIds(Arrays.asList(1)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(1));
        CellRecord thirdCellRecord = new CellRecord().setCellId(2).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(Arrays.asList(4, 5));
        this.cellControl.replay(thirdCellRecord);
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(1)));
        Assertions.assertEquals((Object)Errors.NONE, (Object)control.assignTenantToCells(tenant, Arrays.asList(0, 2), true, new HashSet<Integer>(Arrays.asList(0, 1, 4, 5)), records::add).error());
        Assertions.assertEquals((int)3, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0, 2)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(2));
        control.replay(new TenantRecord().setTenantId(secondTenant).setCellIds(Arrays.asList(0)));
        Assertions.assertEquals((Object)Errors.NONE, (Object)control.assignTenantToCells(secondTenant, Arrays.asList(1, 2), true, new HashSet<Integer>(Arrays.asList(2, 3, 4, 5)), records::add).error());
        Assertions.assertEquals((int)4, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(secondTenant).setCellIds(Arrays.asList(1, 2)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(3));
    }

    @Test
    void testAssignTenantToCellToProhibitedSourceStates() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, 1);
        String tenant = "lkc-abcd";
        String secondTenant = "lkc-efgh";
        ArrayList records = new ArrayList();
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.QUARANTINED.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(Arrays.asList(0, 1));
        this.cellControl.replay(cellRecord);
        CellRecord secondCellRecord = new CellRecord().setCellId(1).setState(CellState.EXCLUDED.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(Arrays.asList(2, 3));
        this.cellControl.replay(secondCellRecord);
        CellRecord thirdCellRecord = new CellRecord().setCellId(2).setState(CellState.READY.code()).setMinSize((short)1).setMaxSize((short)1).setBrokers(Collections.singletonList(4));
        this.cellControl.replay(thirdCellRecord);
        CellRecord fourthCellRecord = new CellRecord().setCellId(3).setState(CellState.READY.code()).setMinSize((short)1).setMaxSize((short)1).setBrokers(Collections.singletonList(5));
        this.cellControl.replay(fourthCellRecord);
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)));
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)control.assignTenantToCells(tenant, Collections.singletonList(2), false, Collections.singleton(4), records::add).error());
        Assertions.assertEquals((int)0, (int)records.size());
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0, 3)));
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)control.assignTenantToCells(tenant, Collections.singletonList(2), false, Collections.singleton(4), records::add).error());
        Assertions.assertEquals((int)0, (int)records.size());
        Assertions.assertEquals((Object)Errors.NONE, (Object)control.assignTenantToCells(tenant, Collections.singletonList(2), true, Collections.singleton(4), records::add).error());
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(2)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(0));
        Assertions.assertEquals((Object)Errors.NONE, (Object)control.assignTenantToCells(tenant, Collections.singletonList(2), true, Collections.singleton(4), records::add).error());
        Assertions.assertEquals((int)2, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(2)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(1));
        control.replay(new TenantRecord().setTenantId(secondTenant).setCellIds(Arrays.asList(1)));
        Assertions.assertEquals((Object)Errors.NONE, (Object)control.assignTenantToCells(secondTenant, Collections.singletonList(2), false, Collections.singleton(4), records::add).error());
        Assertions.assertEquals((int)3, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(secondTenant).setCellIds(Arrays.asList(2)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(2));
        control.replay(new TenantRecord().setTenantId(secondTenant).setCellIds(Arrays.asList(1, 3)));
        Assertions.assertEquals((Object)Errors.NONE, (Object)control.assignTenantToCells(secondTenant, Collections.singletonList(2), false, Collections.singleton(4), records::add).error());
        Assertions.assertEquals((int)4, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(secondTenant).setCellIds(Arrays.asList(2)), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), records.get(3));
    }

    @Test
    void testGetTenantRecordVersionBased() {
        MetadataVersion metadataVersionmock = (MetadataVersion)Mockito.mock(MetadataVersion.class);
        Mockito.when((Object)metadataVersionmock.isTenantStripingSupported()).thenReturn((Object)true);
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(this.snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(metadataVersionmock).build();
        TenantControlManager controlManager = new TenantControlManager(this.logContext, featureControl, this.cellControl, this.placementStrategy, 3);
        String tenant = "lkc-abcd";
        Cell cell = (Cell)Mockito.mock(Cell.class);
        Mockito.when((Object)cell.cellId()).thenReturn((Object)1);
        TenantRecord record = controlManager.getTenantRecord(tenant, cell);
        Assertions.assertEquals((Object)"lkc-abcd", (Object)record.tenantId());
        Assertions.assertEquals((int)1, (int)record.cellId());
    }

    @Test
    void testAssignTenantToCellToCellNotOpenForAssignment() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, 3);
        String tenant = "lkc-abcd";
        ArrayList records = new ArrayList();
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(0, 1, 2)));
        this.cellControl.replay(cellRecord.setCellId(1).setBrokers(Arrays.asList(3, 4, 5)));
        this.cellControl.replay(cellRecord.setCellId(2).setMinSize((short)10).setMaxSize((short)10).setBrokers(Arrays.asList(6, 7, 8, 9)));
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(1)));
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)control.assignTenantToCells(tenant, Collections.singletonList(0), true, new HashSet<Integer>(Arrays.asList(0, 1)), records::add).error());
        Assertions.assertEquals((int)0, (int)records.size());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)control.assignTenantToCells(tenant, Arrays.asList(0, 1), true, new HashSet<Integer>(Arrays.asList(0, 1, 3, 4, 5)), records::add).error());
        Assertions.assertEquals((int)0, (int)records.size());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)control.assignTenantToCells(tenant, Collections.singletonList(0), true, new HashSet<Integer>(Arrays.asList(0, 1, 3, 4, 5)), records::add).error());
        Assertions.assertEquals((int)0, (int)records.size());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)control.assignTenantToCells(tenant, Arrays.asList(0, 1), true, new HashSet<Integer>(Arrays.asList(0, 1, 4, 5)), records::add).error());
        Assertions.assertEquals((int)0, (int)records.size());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)control.assignTenantToCells(tenant, Collections.singletonList(2), true, new HashSet<Integer>(Arrays.asList(6, 7, 8, 9)), records::add).error());
        Assertions.assertEquals((int)0, (int)records.size());
    }

    @Test
    void testUnregisterTenant() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, this.replicationFactor);
        String tenant = "lkc-abcd";
        ArrayList records = new ArrayList();
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(Collections.singletonList(0));
        this.cellControl.replay(cellRecord);
        Assertions.assertFalse((boolean)control.removeTenant(tenant, records::add));
        Assertions.assertEquals((int)0, (int)records.size());
        control.replay(new TenantRecord().setTenantId(tenant).setCellId(0));
        Assertions.assertTrue((boolean)control.removeTenant(tenant, records::add));
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new RemoveTenantRecord().setTenantId(tenant), MetadataRecordType.REMOVE_TENANT_RECORD.highestSupportedVersion()), records.get(0));
    }

    @Test
    void testAssignTenantsToCellOldVersion() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.legacyFeatureControl, this.legacyCellControl, this.placementStrategy, this.replicationFactor);
        AssignTenantsToCellRequest assignRequest = (AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setCellIds(Collections.singletonList(0)).setTenantId("lkc-abcd"))).build();
        Assertions.assertThrows(UnsupportedVersionException.class, () -> control.assignTenantsToCells(assignRequest, Collections.emptySet(), (short)1));
    }

    @Test
    void testDeleteTenantsOldVersion() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.legacyFeatureControl, this.legacyCellControl, this.placementStrategy, this.replicationFactor);
        DeleteTenantsRequest deleteRequest = (DeleteTenantsRequest)new DeleteTenantsRequest.Builder().setTenants(Collections.singletonList("lkc-abcd")).build();
        Assertions.assertThrows(UnsupportedVersionException.class, () -> control.deleteTenants(deleteRequest));
    }

    @Test
    void testDescribeTenantsOldVersion() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.legacyFeatureControl, this.legacyCellControl, this.placementStrategy, this.replicationFactor);
        DescribeTenantsRequest describeRequest = (DescribeTenantsRequest)new DescribeTenantsRequest.Builder().setTenants(Collections.singletonList("lkc-abcd")).build();
        Assertions.assertThrows(UnsupportedVersionException.class, () -> control.describeTenants(describeRequest, this.describeTenantRequestVersion));
    }

    @Test
    void testDescribeTenantsRequest() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, this.replicationFactor);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(0, 1)));
        String tenant = "lkc-abcd";
        String secondTenant = "lkc-efgh";
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)));
        control.replay(new TenantRecord().setTenantId(secondTenant).setCellIds(Arrays.asList(0)));
        ControllerResult invalidResult = control.describeTenants((DescribeTenantsRequest)new DescribeTenantsRequest.Builder().setTenants(Collections.singletonList("lkc-invalid")).build(), this.describeTenantRequestVersion);
        Assertions.assertEquals(new ArrayList(), (Object)invalidResult.records());
        Assertions.assertEquals((short)Errors.TENANT_NOT_FOUND.code(), (short)((DescribeTenantsResponseData)invalidResult.response()).errorCode());
        DescribeTenantsResponseData expectedResponseData = new DescribeTenantsResponseData().setTenantDescriptions(Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(tenant).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(secondTenant).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue())));
        ControllerResult controllerResult = control.describeTenants((DescribeTenantsRequest)new DescribeTenantsRequest.Builder().setTenants(new ArrayList()).build(), this.describeTenantRequestVersion);
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((Object)expectedResponseData, (Object)controllerResult.response());
        DescribeTenantsResponseData expectedFilteringResponseData = new DescribeTenantsResponseData().setTenantDescriptions(Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(tenant).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue())));
        ControllerResult controllerFilteringResult = control.describeTenants((DescribeTenantsRequest)new DescribeTenantsRequest.Builder().setTenants(Collections.singletonList(tenant)).build(), this.describeTenantRequestVersion);
        Assertions.assertEquals(new ArrayList(), (Object)controllerFilteringResult.records());
        Assertions.assertEquals((Object)expectedFilteringResponseData, (Object)controllerFilteringResult.response());
    }

    @Test
    void testUpdateUnassignedTenantDescription() {
        TenantControlManager tenantControl = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, this.replicationFactor);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6);
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5)));
        String tenant = "lkc-abcd";
        String secondTenant = "lkc-efgh";
        tenantControl.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)));
        tenantControl.replay(new TenantRecord().setTenantId(secondTenant).setCellIds(Arrays.asList(0)));
        DescribeTenantsResponseData expectedResponseData = new DescribeTenantsResponseData().setTenantDescriptions(Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(tenant).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(secondTenant).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue())));
        DescribeTenantsResponseData controllerResult = (DescribeTenantsResponseData)tenantControl.describeTenants((DescribeTenantsRequest)new DescribeTenantsRequest.Builder().setTenants(new ArrayList()).build(), this.describeTenantRequestVersion).response();
        Assertions.assertEquals((Object)expectedResponseData.tenantDescriptions(), (Object)controllerResult.tenantDescriptions());
        List tenantDescriptions = controllerResult.tenantDescriptions();
        HashMap<String, Uuid> clusterTopicIds = new HashMap<String, Uuid>();
        clusterTopicIds.put("lkc-abcd_topic_0", Uuid.randomUuid());
        clusterTopicIds.put("lkc-abcd_topic_1", Uuid.randomUuid());
        clusterTopicIds.put("lkc-efgh_topic_3", Uuid.randomUuid());
        clusterTopicIds.put("lkc-jklm_topic_4", Uuid.randomUuid());
        String unassignedTenant = "lkc-jklm";
        tenantControl.updateUnassignedTenantDescription(tenantDescriptions, clusterTopicIds, this.describeTenantRequestVersion);
        DescribeTenantsResponseData updatedTenantDescriptionData = new DescribeTenantsResponseData().setTenantDescriptions(Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(tenant).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(secondTenant).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(unassignedTenant).setCellIds(Arrays.asList(-1)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue())));
        Assertions.assertEquals((Object)updatedTenantDescriptionData.tenantDescriptions(), (Object)tenantDescriptions);
    }

    @Test
    void testAssignTenantsToCellRequest() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, 2);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(0, 1)));
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(2, 3)).setCellId(1));
        String tenant = "lkc-abcd";
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)));
        ControllerResult invalidTenantResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId("lkc-invalid").setCellIds(Collections.singletonList(0)))).build(), Collections.emptySet(), (short)1);
        AssignTenantsToCellResponseData expectedInvalidTenantResponseData = new AssignTenantsToCellResponseData().setFailedTenants(Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId("lkc-invalid").setError(Errors.TENANT_NOT_FOUND.code()).setErrorMessage("Tenant lkc-invalid does not exist").setCellIds(Collections.singletonList(0))));
        Assertions.assertEquals(new ArrayList(), (Object)invalidTenantResult.records());
        Assertions.assertEquals((Object)expectedInvalidTenantResponseData, (Object)invalidTenantResult.response());
        ControllerResult invalidCellIdResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenant).setCellIds(Collections.singletonList(5)))).build(), Collections.emptySet(), (short)1);
        AssignTenantsToCellResponseData expectedInvalidCellIdResponseData = new AssignTenantsToCellResponseData().setFailedTenants(Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId(tenant).setError(Errors.CELL_NOT_FOUND.code()).setErrorMessage("Cells 5 does not exist").setCellIds(Collections.singletonList(5))));
        Assertions.assertEquals(new ArrayList(), (Object)invalidCellIdResult.records());
        Assertions.assertEquals((Object)expectedInvalidCellIdResponseData, (Object)invalidCellIdResult.response());
        ControllerResult insufficientBrokersResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenant).setCellIds(Collections.singletonList(1)))).build(), new HashSet<Integer>(Arrays.asList(0, 3)), (short)1);
        AssignTenantsToCellResponseData expectedInsufficientBrokersResponseData = new AssignTenantsToCellResponseData().setFailedTenants(Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId(tenant).setError(Errors.INVALID_REQUEST.code()).setErrorMessage("Tenant lkc-abcd cannot be moved to cells 1 since the cells either does not have enough brokers to meet its minSize or does not have at least 2 alive brokers").setCellIds(Collections.singletonList(1))));
        Assertions.assertEquals(new ArrayList(), (Object)insufficientBrokersResult.records());
        Assertions.assertEquals((Object)expectedInsufficientBrokersResponseData, (Object)insufficientBrokersResult.response());
        ControllerResult tenantAssignmentResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenant).setCellIds(Collections.singletonList(1)))).build(), new HashSet<Integer>(Arrays.asList(2, 3)), (short)1);
        TenantRecord expectedRecord = new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(1));
        List<ApiMessageAndVersion> expectedRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedRecord, MetadataRecordType.TENANT_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedRecords, (Object)tenantAssignmentResult.records());
        Assertions.assertEquals((Object)new AssignTenantsToCellResponseData(), (Object)tenantAssignmentResult.response());
    }

    @Test
    void testAssignTenantsToCellRequestWithOldRequestVersion() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, 2);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(0, 1)));
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(2, 3)).setCellId(1));
        String tenant = "lkc-abcd";
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)));
        ControllerResult invalidTenantResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId("lkc-invalid").setCellId(0))).build(), Collections.emptySet(), (short)0);
        AssignTenantsToCellResponseData expectedInvalidTenantResponseData = new AssignTenantsToCellResponseData().setFailedTenants(Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId("lkc-invalid").setError(Errors.TENANT_NOT_FOUND.code()).setErrorMessage("Tenant lkc-invalid does not exist").setCellId(0)));
        Assertions.assertEquals(new ArrayList(), (Object)invalidTenantResult.records());
        Assertions.assertEquals((Object)expectedInvalidTenantResponseData, (Object)invalidTenantResult.response());
        ControllerResult invalidCellIdResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenant).setCellId(5))).build(), Collections.emptySet(), (short)0);
        AssignTenantsToCellResponseData expectedInvalidCellIdResponseData = new AssignTenantsToCellResponseData().setFailedTenants(Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId(tenant).setError(Errors.CELL_NOT_FOUND.code()).setErrorMessage("Cells 5 does not exist").setCellId(5)));
        Assertions.assertEquals(new ArrayList(), (Object)invalidCellIdResult.records());
        Assertions.assertEquals((Object)expectedInvalidCellIdResponseData, (Object)invalidCellIdResult.response());
        ControllerResult insufficientBrokersResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenant).setCellId(1))).build(), new HashSet<Integer>(Arrays.asList(0, 3)), (short)0);
        AssignTenantsToCellResponseData expectedInsufficientBrokersResponseData = new AssignTenantsToCellResponseData().setFailedTenants(Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId(tenant).setError(Errors.INVALID_REQUEST.code()).setErrorMessage("Tenant lkc-abcd cannot be moved to cells 1 since the cells either does not have enough brokers to meet its minSize or does not have at least 2 alive brokers").setCellId(1)));
        Assertions.assertEquals(new ArrayList(), (Object)insufficientBrokersResult.records());
        Assertions.assertEquals((Object)expectedInsufficientBrokersResponseData, (Object)insufficientBrokersResult.response());
        ControllerResult tenantAssignmentResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenant).setCellId(1))).build(), new HashSet<Integer>(Arrays.asList(2, 3)), (short)0);
        TenantRecord expectedRecord = new TenantRecord().setTenantId(tenant).setCellIds(Collections.singletonList(1));
        List<ApiMessageAndVersion> expectedRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedRecord, MetadataRecordType.TENANT_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedRecords, (Object)tenantAssignmentResult.records());
        Assertions.assertEquals((Object)new AssignTenantsToCellResponseData(), (Object)tenantAssignmentResult.response());
    }

    @Test
    void testAssignTenantsToMultipleCellsRequest() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, 2);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(0, 1)));
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(2, 3)).setCellId(1));
        String tenant = "lkc-abcd";
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)));
        ControllerResult invalidTenantResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId("lkc-invalid").setCellIds(Arrays.asList(0, 1)))).build(), Collections.emptySet(), (short)1);
        AssignTenantsToCellResponseData expectedInvalidTenantResponseData = new AssignTenantsToCellResponseData().setFailedTenants(Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId("lkc-invalid").setError(Errors.TENANT_NOT_FOUND.code()).setErrorMessage("Tenant lkc-invalid does not exist").setCellIds(Arrays.asList(0, 1))));
        Assertions.assertEquals(new ArrayList(), (Object)invalidTenantResult.records());
        Assertions.assertEquals((Object)expectedInvalidTenantResponseData, (Object)invalidTenantResult.response());
        ControllerResult invalidCellIdResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenant).setCellIds(Arrays.asList(0, 5)))).build(), Collections.emptySet(), (short)1);
        AssignTenantsToCellResponseData expectedInvalidCellIdResponseData = new AssignTenantsToCellResponseData().setFailedTenants(Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId(tenant).setError(Errors.CELL_NOT_FOUND.code()).setErrorMessage("Cells 5 does not exist").setCellIds(Arrays.asList(0, 5))));
        Assertions.assertEquals(new ArrayList(), (Object)invalidCellIdResult.records());
        Assertions.assertEquals((Object)expectedInvalidCellIdResponseData, (Object)invalidCellIdResult.response());
        ControllerResult insufficientBrokersResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenant).setCellIds(Arrays.asList(0, 1)))).build(), new HashSet<Integer>(Arrays.asList(0, 3)), (short)1);
        AssignTenantsToCellResponseData expectedInsufficientBrokersResponseData = new AssignTenantsToCellResponseData().setFailedTenants(Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId(tenant).setError(Errors.INVALID_REQUEST.code()).setErrorMessage("Tenant lkc-abcd cannot be moved to cells 0, 1 since the cells either does not have enough brokers to meet its minSize or does not have at least 2 alive brokers").setCellIds(Arrays.asList(0, 1))));
        Assertions.assertEquals(new ArrayList(), (Object)insufficientBrokersResult.records());
        Assertions.assertEquals((Object)expectedInsufficientBrokersResponseData, (Object)insufficientBrokersResult.response());
        ControllerResult tenantAssignmentResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenant).setCellIds(Arrays.asList(0, 1)))).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2, 3)), (short)1);
        TenantRecord expectedRecord = new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0, 1));
        List<ApiMessageAndVersion> expectedRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedRecord, MetadataRecordType.TENANT_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedRecords, (Object)tenantAssignmentResult.records());
        Assertions.assertEquals((Object)new AssignTenantsToCellResponseData(), (Object)tenantAssignmentResult.response());
    }

    @Test
    void testAssignTenantsToCellRequestWithCellMigrationEnabled() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, 2);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(0, 1)));
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(2, 3)).setCellId(1));
        String tenant = "lkc-abcd";
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)));
        ControllerResult tenantAssignmentResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenant).setCellIds(Collections.singletonList(1)))).build(), new HashSet<Integer>(Arrays.asList(2, 3)), (short)1);
        TenantRecord expectedRecord = new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(1));
        List<ApiMessageAndVersion> expectedRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedRecord, MetadataRecordType.TENANT_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedRecords, (Object)tenantAssignmentResult.records());
        Assertions.assertEquals((Object)new AssignTenantsToCellResponseData(), (Object)tenantAssignmentResult.response());
        ControllerResult invalidTenantResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId("lkc-invalid").setCellIds(Collections.singletonList(1)))).build(), new HashSet<Integer>(Arrays.asList(0, 1)), (short)1);
        AssignTenantsToCellResponseData expectedInvalidTenantResponseData = new AssignTenantsToCellResponseData().setFailedTenants(Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId("lkc-invalid").setError(Errors.TENANT_NOT_FOUND.code()).setErrorMessage("Tenant lkc-invalid does not exist").setCellIds(Collections.singletonList(1))));
        Assertions.assertEquals(new ArrayList(), (Object)invalidTenantResult.records());
        Assertions.assertEquals((Object)expectedInvalidTenantResponseData, (Object)invalidTenantResult.response());
        ControllerResult controllerAlterMigrationStateResult = this.cellControl.alterCellMigration((AlterCellMigrationRequest)new AlterCellMigrationRequest.Builder().setState(CellMigrationState.INITIATED).build());
        CellMigrationRecord cellMigrationRecord = new CellMigrationRecord().setState(CellMigrationState.INITIATED.code());
        List<ApiMessageAndVersion> expectedCellMigrationRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)cellMigrationRecord, MetadataRecordType.CELL_MIGRATION_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedCellMigrationRecords, (Object)controllerAlterMigrationStateResult.records());
        Assertions.assertEquals((short)ApiError.NONE.error().code(), (short)((AlterCellMigrationResponseData)controllerAlterMigrationStateResult.response()).errorCode());
        ControllerResult invalidTenantAssignmentResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId("lkc-invalid").setCellIds(Collections.singletonList(0)))).build(), new HashSet<Integer>(Arrays.asList(0, 1)), (short)1);
        TenantRecord expectedInvalidTenantAssignmentRecord = new TenantRecord().setTenantId("lkc-invalid").setCellIds(Arrays.asList(0));
        List<ApiMessageAndVersion> expectedInvalidTenantAssignmentRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedInvalidTenantAssignmentRecord, MetadataRecordType.TENANT_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedInvalidTenantAssignmentRecords, (Object)invalidTenantAssignmentResult.records());
        Assertions.assertEquals((Object)new AssignTenantsToCellResponseData(), (Object)invalidTenantAssignmentResult.response());
    }

    @Test
    void testAssignTenantsToMultipleCellsRequestWithCellMigrationEnabled() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, 2);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(0, 1)));
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(2, 3)).setCellId(1));
        String tenant = "lkc-abcd";
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)));
        ControllerResult tenantAssignmentResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenant).setCellIds(Arrays.asList(0, 1)))).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2, 3)), (short)1);
        TenantRecord expectedRecord = new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0, 1));
        List<ApiMessageAndVersion> expectedRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedRecord, MetadataRecordType.TENANT_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedRecords, (Object)tenantAssignmentResult.records());
        Assertions.assertEquals((Object)new AssignTenantsToCellResponseData(), (Object)tenantAssignmentResult.response());
        ControllerResult invalidTenantResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId("lkc-invalid").setCellIds(Arrays.asList(0, 1)))).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2, 3)), (short)1);
        AssignTenantsToCellResponseData expectedInvalidTenantResponseData = new AssignTenantsToCellResponseData().setFailedTenants(Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId("lkc-invalid").setError(Errors.TENANT_NOT_FOUND.code()).setErrorMessage("Tenant lkc-invalid does not exist").setCellIds(Arrays.asList(0, 1))));
        Assertions.assertEquals(new ArrayList(), (Object)invalidTenantResult.records());
        Assertions.assertEquals((Object)expectedInvalidTenantResponseData, (Object)invalidTenantResult.response());
        ControllerResult controllerAlterMigrationStateResult = this.cellControl.alterCellMigration((AlterCellMigrationRequest)new AlterCellMigrationRequest.Builder().setState(CellMigrationState.INITIATED).build());
        CellMigrationRecord cellMigrationRecord = new CellMigrationRecord().setState(CellMigrationState.INITIATED.code());
        List<ApiMessageAndVersion> expectedCellMigrationRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)cellMigrationRecord, MetadataRecordType.CELL_MIGRATION_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedCellMigrationRecords, (Object)controllerAlterMigrationStateResult.records());
        Assertions.assertEquals((short)ApiError.NONE.error().code(), (short)((AlterCellMigrationResponseData)controllerAlterMigrationStateResult.response()).errorCode());
        ControllerResult invalidTenantAssignmentResult = control.assignTenantsToCells((AssignTenantsToCellRequest)new AssignTenantsToCellRequest.Builder().setTenants(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId("lkc-invalid").setCellIds(Arrays.asList(0, 1)))).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2, 3)), (short)1);
        TenantRecord expectedInvalidTenantAssignmentRecord = new TenantRecord().setTenantId("lkc-invalid").setCellIds(Arrays.asList(0, 1));
        List<ApiMessageAndVersion> expectedInvalidTenantAssignmentRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedInvalidTenantAssignmentRecord, MetadataRecordType.TENANT_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedInvalidTenantAssignmentRecords, (Object)invalidTenantAssignmentResult.records());
        Assertions.assertEquals((Object)new AssignTenantsToCellResponseData(), (Object)invalidTenantAssignmentResult.response());
    }

    @Test
    void testDeleteTenantsRequest() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, this.placementStrategy, this.replicationFactor);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        this.cellControl.replay(cellRecord.setBrokers(Arrays.asList(0, 1)));
        this.cellControl.replay(cellRecord.setBrokers(new ArrayList()).setCellId(1));
        String tenant = "lkc-abcd";
        control.replay(new TenantRecord().setTenantId(tenant).setCellIds(Arrays.asList(0)));
        ControllerResult invalidTenantResult = control.deleteTenants((DeleteTenantsRequest)new DeleteTenantsRequest.Builder().setTenants(Collections.singletonList("lkc-invalid")).build());
        DeleteTenantsResponseData expectedInvalidTenantResponseData = new DeleteTenantsResponseData().setFailedTenants(Collections.emptyList());
        Assertions.assertEquals(new ArrayList(), (Object)invalidTenantResult.records());
        Assertions.assertEquals((Object)expectedInvalidTenantResponseData, (Object)invalidTenantResult.response());
        ControllerResult validResult = control.deleteTenants((DeleteTenantsRequest)new DeleteTenantsRequest.Builder().setTenants(Collections.singletonList(tenant)).build());
        Assertions.assertEquals(new ArrayList(), (Object)invalidTenantResult.records());
        Assertions.assertEquals((Object)new DeleteTenantsResponseData().setFailedTenants(new ArrayList()), (Object)validResult.response());
        validResult = control.deleteTenants((DeleteTenantsRequest)new DeleteTenantsRequest.Builder().setTenants(Arrays.asList(tenant, "lkc-invalid")).build());
        Assertions.assertEquals(new ArrayList(), (Object)invalidTenantResult.records());
        Assertions.assertEquals((Object)new DeleteTenantsResponseData().setFailedTenants(new ArrayList()), (Object)validResult.response());
    }

    @Test
    void testIsTenantCellPlacementEnabled() {
        MultiTenantPrincipal healthcheckTenantPrincipal = new MultiTenantPrincipal("lkc-abcd", new TenantMetadata.Builder("tenant1", null).healthcheckTenant(true).build());
        MultiTenantPrincipal multiTenantPrincipal = new MultiTenantPrincipal("lkc-abcd", new TenantMetadata.Builder("tenant1", null).healthcheckTenant(false).build());
        KafkaPrincipal kafkaPrincipal = KafkaPrincipal.ANONYMOUS;
        Assertions.assertTrue((boolean)new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.TENANT_IN_CELL, this.replicationFactor).isTenantCellPlacementEnabled(Optional.of(multiTenantPrincipal)));
        Assertions.assertFalse((boolean)new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.CLUSTER_WIDE, this.replicationFactor).isTenantCellPlacementEnabled(Optional.of(multiTenantPrincipal)));
        Assertions.assertFalse((boolean)new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.PARTITION_IN_CELL, this.replicationFactor).isTenantCellPlacementEnabled(Optional.of(multiTenantPrincipal)));
        Assertions.assertFalse((boolean)new TenantControlManager(this.logContext, this.legacyFeatureControl, this.cellControl, PartitionPlacementStrategy.TENANT_IN_CELL, this.replicationFactor).isTenantCellPlacementEnabled(Optional.of(multiTenantPrincipal)));
        for (KafkaPrincipal principal : Arrays.asList(healthcheckTenantPrincipal, kafkaPrincipal, null)) {
            Assertions.assertFalse((boolean)new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.TENANT_IN_CELL, this.replicationFactor).isTenantCellPlacementEnabled(Optional.ofNullable(principal)));
            Assertions.assertFalse((boolean)new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.CLUSTER_WIDE, this.replicationFactor).isTenantCellPlacementEnabled(Optional.ofNullable(principal)));
            Assertions.assertFalse((boolean)new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.PARTITION_IN_CELL, this.replicationFactor).isTenantCellPlacementEnabled(Optional.ofNullable(principal)));
            Assertions.assertFalse((boolean)new TenantControlManager(this.logContext, this.legacyFeatureControl, this.cellControl, PartitionPlacementStrategy.TENANT_IN_CELL, this.replicationFactor).isTenantCellPlacementEnabled(Optional.ofNullable(principal)));
        }
    }

    @Test
    void testCalculatePartitionPlacementStrategy() {
        TenantControlManager control = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.TENANT_IN_CELL, this.replicationFactor);
        KafkaPrincipal principal = new KafkaPrincipal("User", "user");
        MultiTenantPrincipal healthCheckTenantPrincipal = new MultiTenantPrincipal("user", new TenantMetadata.Builder("user", "u-user").apiKeyAuthenticated(true).serviceAccount(true).healthcheckTenant(true).build());
        MultiTenantPrincipal multitenantPrincipal = new MultiTenantPrincipal("user", new TenantMetadata.Builder("user", "u-user").apiKeyAuthenticated(true).serviceAccount(true).healthcheckTenant(false).build());
        Assertions.assertEquals((Object)PartitionPlacementStrategy.PARTITION_IN_CELL, (Object)control.calculatePartitionPlacementStrategy(Optional.empty()));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.PARTITION_IN_CELL, (Object)control.calculatePartitionPlacementStrategy(Optional.of(principal)));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.PARTITION_IN_CELL, (Object)control.calculatePartitionPlacementStrategy(Optional.of(healthCheckTenantPrincipal)));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.TENANT_IN_CELL, (Object)control.calculatePartitionPlacementStrategy(Optional.of(multitenantPrincipal)));
        TenantControlManager clusterWideControl = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.CLUSTER_WIDE, this.replicationFactor);
        Assertions.assertEquals((Object)PartitionPlacementStrategy.CLUSTER_WIDE, (Object)clusterWideControl.calculatePartitionPlacementStrategy(Optional.of(principal)));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.CLUSTER_WIDE, (Object)clusterWideControl.calculatePartitionPlacementStrategy(Optional.of(healthCheckTenantPrincipal)));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.CLUSTER_WIDE, (Object)clusterWideControl.calculatePartitionPlacementStrategy(Optional.of(multitenantPrincipal)));
        TenantControlManager unsupportedControl = new TenantControlManager(this.logContext, this.legacyFeatureControl, this.cellControl, PartitionPlacementStrategy.TENANT_IN_CELL, this.replicationFactor);
        Assertions.assertEquals((Object)PartitionPlacementStrategy.CLUSTER_WIDE, (Object)unsupportedControl.calculatePartitionPlacementStrategy(Optional.of(principal)));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.CLUSTER_WIDE, (Object)unsupportedControl.calculatePartitionPlacementStrategy(Optional.of(healthCheckTenantPrincipal)));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.CLUSTER_WIDE, (Object)unsupportedControl.calculatePartitionPlacementStrategy(Optional.of(multitenantPrincipal)));
    }

    @Test
    void testGetTenantCellId() {
        TenantControlManager tenantControl = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.TENANT_IN_CELL, this.replicationFactor);
        String tenantId = "lkc-abcd";
        Assertions.assertEquals((int)-1, (Integer)((Integer)tenantControl.getTenantCellIds(tenantId).get(0)));
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(Arrays.asList(0, 1, 2));
        this.cellControl.replay(cellRecord);
        this.cellControl.replay(new TenantRecord().setTenantId(tenantId).setCellIds(Arrays.asList(0)));
        Assertions.assertEquals((int)0, (Integer)((Integer)tenantControl.getTenantCellIds(tenantId).get(0)));
        this.cellControl.replay(new RemoveTenantRecord().setTenantId(tenantId));
        Assertions.assertEquals((int)-1, (Integer)((Integer)tenantControl.getTenantCellIds(tenantId).get(0)));
        TenantControlManager partitionInCellTenantControl = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.PARTITION_IN_CELL, this.replicationFactor);
        this.cellControl.replay(cellRecord);
        this.cellControl.replay(new TenantRecord().setTenantId(tenantId).setCellId(0));
        Assertions.assertEquals((int)-1, (Integer)((Integer)partitionInCellTenantControl.getTenantCellIds(tenantId).get(0)));
        TenantControlManager clusterWideTenantControl = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.CLUSTER_WIDE, this.replicationFactor);
        this.cellControl.replay(cellRecord);
        this.cellControl.replay(new TenantRecord().setTenantId(tenantId).setCellId(0));
        Assertions.assertEquals((int)-1, (Integer)((Integer)clusterWideTenantControl.getTenantCellIds(tenantId).get(0)));
    }

    @Test
    void testGetTenantCellIdLegacyCellControl() {
        TenantControlManager tenantControl = new TenantControlManager(this.logContext, this.legacyFeatureControl, this.legacyCellControl, PartitionPlacementStrategy.TENANT_IN_CELL, this.replicationFactor);
        String tenantId = "lkc-abcd";
        Assertions.assertEquals((int)-1, (Integer)((Integer)tenantControl.getTenantCellIds(tenantId).get(0)));
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(Arrays.asList(0, 1, 2));
        this.legacyCellControl.replay(cellRecord);
        this.legacyCellControl.replay(new TenantRecord().setTenantId(tenantId).setCellId(0));
        Assertions.assertEquals((int)-1, (Integer)((Integer)tenantControl.getTenantCellIds(tenantId).get(0)));
        this.legacyCellControl.replay(new RemoveTenantRecord().setTenantId(tenantId));
        Assertions.assertEquals((int)-1, (Integer)((Integer)tenantControl.getTenantCellIds(tenantId).get(0)));
        TenantControlManager partitionInCellTenantControl = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.PARTITION_IN_CELL, this.replicationFactor);
        this.legacyCellControl.replay(cellRecord);
        this.legacyCellControl.replay(new TenantRecord().setTenantId(tenantId).setCellId(0));
        Assertions.assertEquals((int)-1, (Integer)((Integer)partitionInCellTenantControl.getTenantCellIds(tenantId).get(0)));
        TenantControlManager clusterWideTenantControl = new TenantControlManager(this.logContext, this.featureControl, this.cellControl, PartitionPlacementStrategy.CLUSTER_WIDE, this.replicationFactor);
        this.legacyCellControl.replay(cellRecord);
        this.legacyCellControl.replay(new TenantRecord().setTenantId(tenantId).setCellId(0));
        Assertions.assertEquals((int)-1, (Integer)((Integer)clusterWideTenantControl.getTenantCellIds(tenantId).get(0)));
    }

    @Test
    void testIsTenantExisting() {
        Optional emptyList = Optional.empty();
        Assertions.assertEquals((Object)false, (Object)TenantControlManager.isTenantExisting(emptyList));
        ArrayList<Cell> nonEmptyList = new ArrayList<Cell>(Arrays.asList(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 2, 3)));
        Assertions.assertEquals((Object)true, (Object)TenantControlManager.isTenantExisting(Optional.of(nonEmptyList)));
    }

    @Test
    void testIsTenantMappedToCells() {
        ArrayList emptyList = new ArrayList();
        Assertions.assertEquals((Object)false, (Object)TenantControlManager.isTenantMappedToCells(Optional.of(emptyList)));
        ArrayList<Cell> nonEmptyList = new ArrayList<Cell>(Arrays.asList(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 2, 3)));
        Assertions.assertEquals((Object)true, (Object)TenantControlManager.isTenantExisting(Optional.of(nonEmptyList)));
    }
}

