/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.metadata.AbortTransactionRecord;
import org.apache.kafka.common.metadata.BeginTransactionRecord;
import org.apache.kafka.common.metadata.EndTransactionRecord;
import org.apache.kafka.common.metadata.NoOpRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.OffsetControlManager;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TrackingSnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class OffsetControlManagerTest {
    @Test
    public void testInitialValues() {
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().build();
        Assertions.assertNull((Object)offsetControl.currentSnapshotId());
        Assertions.assertNull((Object)offsetControl.currentSnapshotName());
        Assertions.assertEquals((long)-1L, (long)offsetControl.lastCommittedOffset());
        Assertions.assertEquals((int)-1, (int)offsetControl.lastCommittedEpoch());
        Assertions.assertEquals((long)-1L, (long)offsetControl.lastStableOffset());
        Assertions.assertEquals((long)-1L, (long)offsetControl.transactionStartOffset());
        Assertions.assertEquals((long)-1L, (long)offsetControl.nextWriteOffset());
        Assertions.assertFalse((boolean)offsetControl.active());
        Assertions.assertEquals(Collections.singletonList(-1L), (Object)offsetControl.snapshotRegistry().epochsList());
    }

    @Test
    public void testActivate() {
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().build();
        offsetControl.activate(1000L);
        Assertions.assertEquals((long)1000L, (long)offsetControl.nextWriteOffset());
        Assertions.assertTrue((boolean)offsetControl.active());
        Assertions.assertTrue((boolean)offsetControl.metrics().active());
        Assertions.assertEquals(Collections.singletonList(-1L), (Object)offsetControl.snapshotRegistry().epochsList());
    }

    @Test
    public void testActivateFailsIfAlreadyActive() {
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().build();
        offsetControl.activate(1000L);
        Assertions.assertEquals((Object)"Can't activate already active OffsetControlManager.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> offsetControl.activate(2000L))).getMessage());
    }

    @Test
    public void testActivateFailsIfNewNextWriteOffsetIsNegative() {
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().build();
        Assertions.assertEquals((Object)"Invalid negative newNextWriteOffset -2.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> offsetControl.activate(-2L))).getMessage());
    }

    @Test
    public void testActivateAndDeactivate() {
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().build();
        offsetControl.activate(1000L);
        Assertions.assertEquals((long)1000L, (long)offsetControl.nextWriteOffset());
        offsetControl.deactivate();
        Assertions.assertEquals((long)-1L, (long)offsetControl.nextWriteOffset());
    }

    @Test
    public void testDeactivateFailsIfNotActive() {
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().build();
        Assertions.assertEquals((Object)"Can't deactivate inactive OffsetControlManager.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ((OffsetControlManager)offsetControl).deactivate())).getMessage());
    }

    private static Batch<ApiMessageAndVersion> newFakeBatch(long lastOffset, int epoch, long appendTimestamp) {
        return Batch.data((long)lastOffset, (int)epoch, (long)appendTimestamp, (int)100, Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new NoOpRecord(), 0)));
    }

    @Test
    public void testHandleCommitBatch() {
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().build();
        offsetControl.handleCommitBatch(OffsetControlManagerTest.newFakeBatch(1000L, 200, 3000L));
        Assertions.assertEquals(Collections.singletonList(1000L), (Object)offsetControl.snapshotRegistry().epochsList());
        Assertions.assertEquals((long)1000L, (long)offsetControl.lastCommittedOffset());
        Assertions.assertEquals((int)200, (int)offsetControl.lastCommittedEpoch());
        Assertions.assertEquals((long)1000L, (long)offsetControl.lastStableOffset());
        Assertions.assertEquals((long)-1L, (long)offsetControl.transactionStartOffset());
        Assertions.assertEquals((long)-1L, (long)offsetControl.nextWriteOffset());
        Assertions.assertFalse((boolean)offsetControl.active());
        Assertions.assertFalse((boolean)offsetControl.metrics().active());
        Assertions.assertEquals((long)1000L, (long)offsetControl.metrics().lastAppliedRecordOffset());
        Assertions.assertEquals((long)1000L, (long)offsetControl.metrics().lastCommittedRecordOffset());
        Assertions.assertEquals((long)3000L, (long)offsetControl.metrics().lastAppliedRecordTimestamp());
    }

    @Test
    public void testHandleScheduleAtomicAppend() {
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().build();
        offsetControl.handleScheduleAppend(2000L);
        Assertions.assertEquals((long)2001L, (long)offsetControl.nextWriteOffset());
        Assertions.assertEquals((long)2000L, (long)offsetControl.metrics().lastAppliedRecordOffset());
        Assertions.assertEquals((long)-1L, (long)offsetControl.lastStableOffset());
        Assertions.assertEquals((long)-1L, (long)offsetControl.lastCommittedOffset());
        Assertions.assertEquals(Arrays.asList(-1L, 2000L), (Object)offsetControl.snapshotRegistry().epochsList());
        offsetControl.handleCommitBatch(OffsetControlManagerTest.newFakeBatch(2000L, 200, 3000L));
        Assertions.assertEquals((long)2000L, (long)offsetControl.lastStableOffset());
        Assertions.assertEquals((long)2000L, (long)offsetControl.lastCommittedOffset());
        Assertions.assertEquals(Collections.singletonList(2000L), (Object)offsetControl.snapshotRegistry().epochsList());
    }

    @Test
    public void testHandleLoadSnapshot() {
        TrackingSnapshotRegistry snapshotRegistry = new TrackingSnapshotRegistry(new LogContext());
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().setSnapshotRegistry((SnapshotRegistry)snapshotRegistry).build();
        offsetControl.beginLoadSnapshot(new OffsetAndEpoch(4000L, 300));
        Assertions.assertEquals(Arrays.asList("snapshot[-1]", "reset"), (Object)snapshotRegistry.operations());
        Assertions.assertEquals((Object)new OffsetAndEpoch(4000L, 300), (Object)offsetControl.currentSnapshotId());
        Assertions.assertEquals((Object)"00000000000000004000-0000000300", (Object)offsetControl.currentSnapshotName());
        Assertions.assertEquals(Collections.emptyList(), (Object)offsetControl.snapshotRegistry().epochsList());
        offsetControl.endLoadSnapshot(3456L);
        Assertions.assertEquals(Arrays.asList("snapshot[-1]", "reset", "snapshot[4000]"), (Object)snapshotRegistry.operations());
        Assertions.assertNull((Object)offsetControl.currentSnapshotId());
        Assertions.assertNull((Object)offsetControl.currentSnapshotName());
        Assertions.assertEquals(Collections.singletonList(4000L), (Object)offsetControl.snapshotRegistry().epochsList());
        Assertions.assertEquals((long)4000L, (long)offsetControl.lastCommittedOffset());
        Assertions.assertEquals((int)300, (int)offsetControl.lastCommittedEpoch());
        Assertions.assertEquals((long)4000L, (long)offsetControl.lastStableOffset());
        Assertions.assertEquals((long)-1L, (long)offsetControl.transactionStartOffset());
        Assertions.assertEquals((long)-1L, (long)offsetControl.nextWriteOffset());
        Assertions.assertEquals((long)4000L, (long)offsetControl.metrics().lastCommittedRecordOffset());
        Assertions.assertEquals((long)4000L, (long)offsetControl.metrics().lastAppliedRecordOffset());
        Assertions.assertEquals((long)3456L, (long)offsetControl.metrics().lastAppliedRecordTimestamp());
    }

    @Test
    public void testBeginTransactionRecordNotAllowedInSnapshot() {
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().build();
        offsetControl.beginLoadSnapshot(new OffsetAndEpoch(4000L, 300));
        Assertions.assertEquals((Object)"BeginTransactionRecord cannot appear within a snapshot.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> offsetControl.replay(new BeginTransactionRecord(), 1000L))).getMessage());
    }

    @Test
    public void testEndTransactionRecordNotAllowedInSnapshot() {
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().build();
        offsetControl.beginLoadSnapshot(new OffsetAndEpoch(4000L, 300));
        Assertions.assertEquals((Object)"EndTransactionRecord cannot appear within a snapshot.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> offsetControl.replay(new EndTransactionRecord(), 1000L))).getMessage());
    }

    @Test
    public void testAbortTransactionRecordNotAllowedInSnapshot() {
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().build();
        offsetControl.beginLoadSnapshot(new OffsetAndEpoch(4000L, 300));
        Assertions.assertEquals((Object)"AbortTransactionRecord cannot appear within a snapshot.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> offsetControl.replay(new AbortTransactionRecord(), 1000L))).getMessage());
    }

    @Test
    public void testEndLoadSnapshotFailsWhenNotInSnapshot() {
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().build();
        Assertions.assertEquals((Object)"Can't end loading snapshot, because there is no current snapshot.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> offsetControl.endLoadSnapshot(1000L))).getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReplayTransaction(boolean aborted) {
        TrackingSnapshotRegistry snapshotRegistry = new TrackingSnapshotRegistry(new LogContext());
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().setSnapshotRegistry((SnapshotRegistry)snapshotRegistry).build();
        offsetControl.replay(new BeginTransactionRecord(), 1500L);
        Assertions.assertEquals((long)1500L, (long)offsetControl.transactionStartOffset());
        Assertions.assertEquals(Arrays.asList(-1L, 1499L), (Object)offsetControl.snapshotRegistry().epochsList());
        offsetControl.handleCommitBatch(OffsetControlManagerTest.newFakeBatch(1550L, 100, 2000L));
        Assertions.assertEquals((long)1550L, (long)offsetControl.lastCommittedOffset());
        Assertions.assertEquals((int)100, (int)offsetControl.lastCommittedEpoch());
        Assertions.assertEquals((long)1499L, (long)offsetControl.lastStableOffset());
        Assertions.assertEquals(Collections.singletonList(1499L), (Object)offsetControl.snapshotRegistry().epochsList());
        if (aborted) {
            offsetControl.replay(new AbortTransactionRecord(), 1600L);
            Assertions.assertEquals(Arrays.asList("snapshot[-1]", "snapshot[1499]", "revert[1499]"), (Object)snapshotRegistry.operations());
        } else {
            offsetControl.replay(new EndTransactionRecord(), 1600L);
            Assertions.assertEquals(Arrays.asList("snapshot[-1]", "snapshot[1499]"), (Object)snapshotRegistry.operations());
        }
        Assertions.assertEquals((long)-1L, (long)offsetControl.transactionStartOffset());
        Assertions.assertEquals((long)1499L, (long)offsetControl.lastStableOffset());
        offsetControl.handleCommitBatch(OffsetControlManagerTest.newFakeBatch(1650L, 100, 2100L));
        Assertions.assertEquals((long)1650L, (long)offsetControl.lastStableOffset());
        Assertions.assertEquals(Collections.singletonList(1650L), (Object)offsetControl.snapshotRegistry().epochsList());
    }

    @Test
    public void testLoadSnapshotClearsTransactionalState() {
        TrackingSnapshotRegistry snapshotRegistry = new TrackingSnapshotRegistry(new LogContext());
        OffsetControlManager offsetControl = new OffsetControlManager.Builder().setSnapshotRegistry((SnapshotRegistry)snapshotRegistry).build();
        offsetControl.replay(new BeginTransactionRecord(), 1500L);
        offsetControl.beginLoadSnapshot(new OffsetAndEpoch(4000L, 300));
        Assertions.assertEquals((long)-1L, (long)offsetControl.transactionStartOffset());
        Assertions.assertEquals(Arrays.asList("snapshot[-1]", "snapshot[1499]", "reset"), (Object)snapshotRegistry.operations());
    }
}

