/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.controller.AclControlManager;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;

public class MockAclMutator
implements AclMutator {
    private final StandardAuthorizer authorizer;
    private final AclControlManager aclControl;

    public MockAclMutator(StandardAuthorizer authorizer) {
        this.authorizer = authorizer;
        this.aclControl = new AclControlManager.Builder().build();
    }

    private void syncIdToAcl(Map<Uuid, ConfluentStandardAcl> prevIdToAcl, Map<Uuid, ConfluentStandardAcl> nextIdToAcl) {
        for (Map.Entry<Uuid, ConfluentStandardAcl> entry : prevIdToAcl.entrySet()) {
            if (entry.getValue().equals((Object)nextIdToAcl.get(entry.getKey()))) continue;
            this.authorizer.applyAclChanges(Collections.singletonMap(entry.getKey(), Optional.empty()));
        }
        for (Map.Entry<Uuid, ConfluentStandardAcl> entry : nextIdToAcl.entrySet()) {
            if (entry.getValue().equals((Object)prevIdToAcl.get(entry.getKey()))) continue;
            this.authorizer.applyAclChanges(Collections.singletonMap(entry.getKey(), Optional.of(entry.getValue())));
        }
    }

    public synchronized CompletableFuture<List<AclCreateResult>> createAcls(ControllerRequestContext context, List<AclBinding> aclBindings) {
        return this.createAcls(context, aclBindings, AclState.ACTIVE);
    }

    public synchronized CompletableFuture<List<AclCreateResult>> createAcls(ControllerRequestContext context, List<AclBinding> aclBindings, AclState aclState) {
        HashMap<Uuid, ConfluentStandardAcl> prevIdToAcl = new HashMap<Uuid, ConfluentStandardAcl>(this.aclControl.idToAcl());
        ControllerResult result = this.aclControl.createAcls(aclBindings, aclState);
        RecordTestUtils.replayAll(this.aclControl, result.records());
        this.syncIdToAcl(prevIdToAcl, this.aclControl.idToAcl());
        return CompletableFuture.completedFuture(result.response());
    }

    public synchronized CompletableFuture<List<AclDeleteResult>> deleteAcls(ControllerRequestContext context, List<AclBindingFilter> aclBindingFilters) {
        return this.deleteAcls(context, aclBindingFilters, AclState.ANY);
    }

    public synchronized CompletableFuture<List<AclDeleteResult>> deleteAcls(ControllerRequestContext context, List<AclBindingFilter> aclBindingFilters, AclState aclState) {
        HashMap<Uuid, ConfluentStandardAcl> prevIdToAcl = new HashMap<Uuid, ConfluentStandardAcl>(this.aclControl.idToAcl());
        ControllerResult result = this.aclControl.deleteAcls(aclBindingFilters, aclState);
        RecordTestUtils.replayAll(this.aclControl, result.records());
        this.syncIdToAcl(prevIdToAcl, this.aclControl.idToAcl());
        return CompletableFuture.completedFuture(result.response());
    }
}

