/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.InstallMetadataEncryptorRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.EncryptionControlManager;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.apache.kafka.metadata.AesGcm128MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MetadataEncryptorFactoryTest;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class EncryptionControlManagerTest {
    private static final Uuid ENCRYPTOR_ID_FROM_FILE = Uuid.fromString((String)"oozG5ebNR9yf2xrWNI_1QA");
    private static final String ENCRYPTOR_FILE_JSON_ONE_SECRET = "{\n  \"encryptors_by_uuid\": {\n    \"" + ENCRYPTOR_ID_FROM_FILE + "\": {\n      \"created\": \"2023-10-15T17:26:49.335813Z\",\n      \"class_name\": \"org.apache.kafka.metadata.AesGcm128MetadataEncryptor\",\n      \"bytes\": \"KE9KWGMEwd6zGWyXdYksdA\"\n    }\n  }\n}";
    private static final Uuid ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG = Uuid.fromString((String)"ZUpeNz1eSKyT_qiVKswGfA");
    private static final Uuid INACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG = Uuid.fromString((String)"8PKWuzWBR3C7cFAZKzdmkg");
    private static final Map<String, Object> LEGACY_ENCRYPTOR_CONFIG;

    @Test
    public void testEncryptionControlManagerWithoutConfig() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        EncryptionControlManager manager = new EncryptionControlManager.Builder().setSnapshotRegistry(snapshotRegistry).build();
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)manager.activeEncryptorId());
        Assertions.assertEquals(NoOpMetadataEncryptor.class, manager.encryptor().getClass());
        EncryptionControlManager.EncryptionControlIterator iterator = manager.iterator(Long.MAX_VALUE);
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new InstallMetadataEncryptorRecord().setKeyId(Uuid.ZERO_UUID), 0)), (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testEncryptionControlManagerWithConfiguredEncryptor() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        snapshotRegistry.getOrCreateSnapshot(0L);
        EncryptionControlManager manager = new EncryptionControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setEncryptorFactorySupplier(() -> new MetadataEncryptorFactory(MetadataEncryptorFactoryTest.TEST_LEGACY_CONFIG)).build();
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)manager.activeEncryptorId());
        Assertions.assertEquals(NoOpMetadataEncryptor.class, manager.encryptor().getClass());
        RecordTestUtils.replayAll(manager, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new InstallMetadataEncryptorRecord().setKeyId(((MetadataEncryptorFactory)manager.getMetadataEncryptorFactorySupplier().get()).activeIdFromLegacyConfig()), 0)));
        Assertions.assertEquals((Object)MetadataEncryptorFactoryTest.FOO_ID, (Object)manager.activeEncryptorId());
        Assertions.assertEquals(AesGcm128MetadataEncryptor.class, manager.encryptor().getClass());
        snapshotRegistry.getOrCreateSnapshot(1L);
        Assertions.assertEquals(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new InstallMetadataEncryptorRecord().setKeyId(Uuid.ZERO_UUID), 0)), (Object)manager.iterator(0L).next());
        Assertions.assertEquals(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new InstallMetadataEncryptorRecord().setKeyId(MetadataEncryptorFactoryTest.FOO_ID), 0)), (Object)manager.iterator(1L).next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstallMetadataEncryptor() throws IOException {
        File tempJsonFile = null;
        try {
            tempJsonFile = TestUtils.tempFile((String)ENCRYPTOR_FILE_JSON_ONE_SECRET);
            HashMap<String, Object> map = new HashMap<String, Object>(LEGACY_ENCRYPTOR_CONFIG);
            map.put("confluent.metadata.encryptor.secret.file", tempJsonFile.getAbsolutePath());
            MetadataEncryptorFactory staticAndFileBasedEncryptorFactory = new MetadataEncryptorFactory(map);
            MockTime time = new MockTime(0L, 0L, 0L);
            try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.empty(), (Time)time, new Metrics(), false);){
                EncryptionControlManager manager = new EncryptionControlManager.Builder().setEncryptorFactorySupplier(() -> staticAndFileBasedEncryptorFactory).setMetrics(metrics).build();
                QuorumControllerMetrics.EncryptorAndAge encryptorAndAge = metrics.currentEncryptorAndAge();
                Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)encryptorAndAge.encryptorId());
                double ageInDays = encryptorAndAge.encryptorAgeInDays((Time)time);
                long expectedAgeInMillis = time.milliseconds() - -62125920000000L;
                double expectedAgeInDays = 1.0 * (double)expectedAgeInMillis / 8.64E7;
                Assertions.assertEquals((double)expectedAgeInDays, (double)ageInDays);
                manager.replay(new InstallMetadataEncryptorRecord().setKeyId(ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG));
                encryptorAndAge = metrics.currentEncryptorAndAge();
                Assertions.assertEquals((Object)ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG, (Object)encryptorAndAge.encryptorId());
                int numDaysSinceEpoch = 1;
                time.setCurrentTimeMs((long)numDaysSinceEpoch * 1000L * 60L * 60L * 24L);
                Assertions.assertEquals((double)numDaysSinceEpoch, (double)encryptorAndAge.encryptorAgeInDays((Time)time));
                manager.replay(new InstallMetadataEncryptorRecord().setKeyId(ENCRYPTOR_ID_FROM_FILE));
                encryptorAndAge = metrics.currentEncryptorAndAge();
                Assertions.assertEquals((Object)ENCRYPTOR_ID_FROM_FILE, (Object)encryptorAndAge.encryptorId());
                long numMillisSinceEpoch = 1697414400000L;
                time.setCurrentTimeMs(numMillisSinceEpoch);
                Assertions.assertEquals((double)0.27, (double)((double)Math.round(100.0 * encryptorAndAge.encryptorAgeInDays((Time)time)) / 100.0));
            }
        }
        finally {
            if (tempJsonFile != null) {
                tempJsonFile.delete();
            }
        }
    }

    @Test
    public void testInstallZeroUuidMetadataEncryptor() {
        MetadataEncryptorFactory staticAndFileBasedEncryptorFactory = new MetadataEncryptorFactory(Collections.emptyMap());
        MockTime time = new MockTime(0L, 0L, 0L);
        try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.empty(), (Time)time, new Metrics(), false);){
            EncryptionControlManager manager = new EncryptionControlManager.Builder().setEncryptorFactorySupplier(() -> staticAndFileBasedEncryptorFactory).setMetrics(metrics).build();
            QuorumControllerMetrics.EncryptorAndAge encryptorAndAge = metrics.currentEncryptorAndAge();
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)encryptorAndAge.encryptorId());
            double ageInDays = encryptorAndAge.encryptorAgeInDays((Time)time);
            long expectedAgeInMillis = time.milliseconds() - -62125920000000L;
            double expectedAgeInDays = 1.0 * (double)expectedAgeInMillis / 8.64E7;
            Assertions.assertEquals((double)expectedAgeInDays, (double)ageInDays);
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(byteBuffer);
            InstallMetadataEncryptorRecord installMetadataEncryptorRecord = new InstallMetadataEncryptorRecord().setKeyId(Uuid.ZERO_UUID);
            short version = installMetadataEncryptorRecord.highestSupportedVersion();
            installMetadataEncryptorRecord.write((Writable)byteBufferAccessor, new ObjectSerializationCache(), version);
            manager.replay(new InstallMetadataEncryptorRecord((Readable)byteBufferAccessor, version));
            encryptorAndAge = metrics.currentEncryptorAndAge();
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)encryptorAndAge.encryptorId());
        }
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("confluent.metadata.active.encryptor", ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG.toString());
        map.put("confluent.metadata.encryptor.classes", ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG + "=" + AesGcm128MetadataEncryptor.class.getCanonicalName() + "," + INACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG + "=" + AesGcm128MetadataEncryptor.class.getCanonicalName());
        map.put("confluent.metadata.encryptor.secrets", ACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG + "=cG9ubWxramloZ2ZlZGNiYQ," + INACTIVE_ENCRYPTOR_ID_FROM_STATIC_CONFIG + "=YWJjZGVmZ2hpamtsbW5vcA");
        LEGACY_ENCRYPTOR_CONFIG = Collections.unmodifiableMap(map);
    }
}

