/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ClientQuotaControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.TimelineHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ClientQuotaControlManagerTest {
    private static final HashMap<String, ConfigDef.ConfigKey> VALID_CLIENT_ID_QUOTA_KEYS = new HashMap();

    @Test
    public void testInvalidEntityTypes() {
        ClientQuotaControlManager manager = new ClientQuotaControlManager.Builder().build();
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("foo", "bar"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity(null, "null"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("user", "user-1", "foo", "bar"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("foo", "bar", "ip", "1.2.3.4"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("foo", "bar", "confluent-tenant", "lkc-abcd"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("user", "user-1", "ip", "1.2.3.4"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("client-id", "user-1", "ip", "1.2.3.4"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("user", "user-1", "confluent-tenant", "lkc-abcd"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("client-id", "user-1", "confluent-tenant", "lkc-abcd"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("ip", "1.2.3.4", "confluent-tenant", "lkc-abcd"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("confluent-tenant", "lkc-abcd", "confluent-tenant", "1.2.3.4"));
        this.assertInvalidEntity(manager, new ClientQuotaEntity(Collections.emptyMap()));
    }

    private void assertInvalidEntity(ClientQuotaControlManager manager, ClientQuotaEntity entity) {
        this.assertInvalidQuota(manager, entity, ClientQuotaControlManagerTest.quotas("producer_byte_rate", 10000.0));
    }

    @Test
    public void testInvalidQuotaKeys() {
        ClientQuotaControlManager manager = new ClientQuotaControlManager.Builder().build();
        ClientQuotaEntity entity = ClientQuotaControlManagerTest.entity("user", "user-1");
        this.assertInvalidQuota(manager, entity, ClientQuotaControlManagerTest.quotas("not.a.quota.key", 0.0, "request_percentage", 99.9));
        this.assertInvalidQuota(manager, entity, ClientQuotaControlManagerTest.quotas("request_percentage", 99.9, "not.a.quota.key", 0.0));
        this.assertInvalidQuota(manager, entity, ClientQuotaControlManagerTest.quotas(null, 99.9));
    }

    private void assertInvalidQuota(ClientQuotaControlManager manager, ClientQuotaEntity entity, Map<String, Double> quota) {
        ArrayList alters = new ArrayList();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(entity, quota, alters::add);
        ControllerResult result = manager.alterClientQuotas(alters);
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)((ApiError)((Map)result.response()).get(entity)).error());
        Assertions.assertEquals((int)0, (int)result.records().size());
    }

    @Test
    public void testAlterAndRemove() {
        ClientQuotaControlManager manager = new ClientQuotaControlManager.Builder().build();
        ClientQuotaEntity userEntity = ClientQuotaControlManagerTest.userEntity("user-1");
        ArrayList<ClientQuotaAlteration> alters = new ArrayList<ClientQuotaAlteration>();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, ClientQuotaControlManagerTest.quotas("producer_byte_rate", 10000.0), alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertEquals((int)1, (int)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).size());
        Assertions.assertEquals((double)10000.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"producer_byte_rate")), (double)1.0E-6);
        alters.clear();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, ClientQuotaControlManagerTest.quotas("producer_byte_rate", 10001.0, "consumer_byte_rate", 20000.0), alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertEquals((int)2, (int)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).size());
        Assertions.assertEquals((double)10001.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"producer_byte_rate")), (double)1.0E-6);
        Assertions.assertEquals((double)20000.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"consumer_byte_rate")), (double)1.0E-6);
        alters.clear();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, ClientQuotaControlManagerTest.quotas("producer_byte_rate", null), alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertEquals((int)1, (int)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).size());
        Assertions.assertEquals((double)20000.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"consumer_byte_rate")), (double)1.0E-6);
        alters.clear();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, ClientQuotaControlManagerTest.quotas("request_percentage", null), alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertEquals((int)1, (int)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).size());
        Assertions.assertEquals((double)20000.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"consumer_byte_rate")), (double)1.0E-6);
        alters.clear();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, ClientQuotaControlManagerTest.quotas("consumer_byte_rate", null), alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertFalse((boolean)manager.clientQuotaData.containsKey((Object)userEntity));
        alters.clear();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, ClientQuotaControlManagerTest.quotas("consumer_byte_rate", null), alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertFalse((boolean)manager.clientQuotaData.containsKey((Object)userEntity));
        alters.clear();
        HashMap<String, Double> quotas = new HashMap<String, Double>(4);
        quotas.put("request_percentage", 99.0);
        quotas.put("controller_mutation_rate", null);
        quotas.put("producer_byte_rate", 10002.0);
        quotas.put("consumer_byte_rate", 20001.0);
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, quotas, alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertEquals((int)3, (int)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).size());
        Assertions.assertEquals((double)20001.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"consumer_byte_rate")), (double)1.0E-6);
        Assertions.assertEquals((double)10002.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"producer_byte_rate")), (double)1.0E-6);
        Assertions.assertEquals((double)99.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"request_percentage")), (double)1.0E-6);
    }

    @Test
    public void testEntityTypes() throws Exception {
        ClientQuotaControlManager manager = new ClientQuotaControlManager.Builder().build();
        HashMap<ClientQuotaEntity, Map> quotasToTest = new HashMap<ClientQuotaEntity, Map>();
        quotasToTest.put(ClientQuotaControlManagerTest.userClientEntity("user-1", "client-id-1"), ClientQuotaControlManagerTest.quotas("request_percentage", 50.5));
        quotasToTest.put(ClientQuotaControlManagerTest.userClientEntity("user-2", "client-id-1"), ClientQuotaControlManagerTest.quotas("request_percentage", 51.51));
        quotasToTest.put(ClientQuotaControlManagerTest.userClientEntity("user-3", "client-id-2"), ClientQuotaControlManagerTest.quotas("request_percentage", 52.52));
        quotasToTest.put(ClientQuotaControlManagerTest.userClientEntity(null, "client-id-1"), ClientQuotaControlManagerTest.quotas("request_percentage", 53.53));
        quotasToTest.put(ClientQuotaControlManagerTest.userClientEntity("user-1", null), ClientQuotaControlManagerTest.quotas("request_percentage", 54.54));
        quotasToTest.put(ClientQuotaControlManagerTest.userClientEntity("user-3", null), ClientQuotaControlManagerTest.quotas("request_percentage", 55.55));
        quotasToTest.put(ClientQuotaControlManagerTest.userEntity("user-1"), ClientQuotaControlManagerTest.quotas("request_percentage", 56.56));
        quotasToTest.put(ClientQuotaControlManagerTest.userEntity("user-2"), ClientQuotaControlManagerTest.quotas("request_percentage", 57.57));
        quotasToTest.put(ClientQuotaControlManagerTest.userEntity("user-3"), ClientQuotaControlManagerTest.quotas("request_percentage", 58.58));
        quotasToTest.put(ClientQuotaControlManagerTest.userEntity(null), ClientQuotaControlManagerTest.quotas("request_percentage", 59.59));
        quotasToTest.put(ClientQuotaControlManagerTest.clientEntity("client-id-2"), ClientQuotaControlManagerTest.quotas("request_percentage", 60.6));
        quotasToTest.put(ClientQuotaControlManagerTest.ipEntity("1.2.3.4"), ClientQuotaControlManagerTest.quotas("connection_creation_rate", 100.0));
        quotasToTest.put(ClientQuotaControlManagerTest.tenantEntity("lkc-abcd"), ClientQuotaControlManagerTest.quotas("connection_creation_rate", 300.0));
        quotasToTest.put(ClientQuotaControlManagerTest.tenantEntity("lkc-efgh"), ClientQuotaControlManagerTest.quotas("producer_id_expiration_ms", 1000.0));
        ArrayList<ClientQuotaAlteration> alters = new ArrayList<ClientQuotaAlteration>();
        quotasToTest.forEach((entity, quota) -> ClientQuotaControlManagerTest.entityQuotaToAlterations(entity, quota, alters::add));
        List<ApiMessageAndVersion> records = ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        List<ApiMessageAndVersion> expectedRecords = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-1"), new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName("client-id-1"))).setKey("request_percentage").setValue(50.5).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-2"), new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName("client-id-1"))).setKey("request_percentage").setValue(51.51).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-3"), new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName("client-id-2"))).setKey("request_percentage").setValue(52.52).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName(null), new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName("client-id-1"))).setKey("request_percentage").setValue(53.53).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-1"), new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName(null))).setKey("request_percentage").setValue(54.54).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-3"), new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName(null))).setKey("request_percentage").setValue(55.55).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Collections.singletonList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-1"))).setKey("request_percentage").setValue(56.56).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Collections.singletonList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-2"))).setKey("request_percentage").setValue(57.57).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Collections.singletonList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-3"))).setKey("request_percentage").setValue(58.58).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Collections.singletonList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName(null))).setKey("request_percentage").setValue(59.59).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Collections.singletonList(new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName("client-id-2"))).setKey("request_percentage").setValue(60.6).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("ip").setEntityName("1.2.3.4"))).setKey("connection_creation_rate").setValue(100.0).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("confluent-tenant").setEntityName("lkc-abcd"))).setKey("connection_creation_rate").setValue(300.0).setRemove(false), 0), new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("confluent-tenant").setEntityName("lkc-efgh"))).setKey("producer_id_expiration_ms").setValue(1000.0).setRemove(false), 0));
        records = new ArrayList<ApiMessageAndVersion>(records);
        RecordTestUtils.deepSortRecords(records);
        RecordTestUtils.deepSortRecords(expectedRecords);
        Assertions.assertEquals(expectedRecords, records);
    }

    static void entityQuotaToAlterations(ClientQuotaEntity entity, Map<String, Double> quota, Consumer<ClientQuotaAlteration> acceptor) {
        Collection ops = quota.entrySet().stream().map(quotaEntry -> new ClientQuotaAlteration.Op((String)quotaEntry.getKey(), (Double)quotaEntry.getValue())).collect(Collectors.toList());
        acceptor.accept(new ClientQuotaAlteration(entity, ops));
    }

    static List<ApiMessageAndVersion> alterQuotas(List<ClientQuotaAlteration> alterations, ClientQuotaControlManager manager) {
        ControllerResult result = manager.alterClientQuotas(alterations);
        Assertions.assertTrue((boolean)((Map)result.response()).values().stream().allMatch(ApiError::isSuccess));
        result.records().forEach(apiMessageAndVersion -> manager.replay((ClientQuotaRecord)apiMessageAndVersion.message()));
        return result.records();
    }

    static Map<String, Double> quotas(String key, Double value) {
        return Collections.singletonMap(key, value);
    }

    static Map<String, Double> quotas(String key1, Double value1, String key2, Double value2) {
        HashMap<String, Double> quotas = new HashMap<String, Double>(2);
        quotas.put(key1, value1);
        quotas.put(key2, value2);
        return quotas;
    }

    static ClientQuotaEntity entity(String type, String name) {
        return new ClientQuotaEntity(Collections.singletonMap(type, name));
    }

    static ClientQuotaEntity entity(String type1, String name1, String type2, String name2) {
        HashMap<String, String> entries = new HashMap<String, String>(2);
        entries.put(type1, name1);
        entries.put(type2, name2);
        return new ClientQuotaEntity(entries);
    }

    static ClientQuotaEntity userEntity(String user) {
        return new ClientQuotaEntity(Collections.singletonMap("user", user));
    }

    static ClientQuotaEntity clientEntity(String clientId) {
        return new ClientQuotaEntity(Collections.singletonMap("client-id", clientId));
    }

    static ClientQuotaEntity tenantEntity(String tenantId) {
        return new ClientQuotaEntity(Collections.singletonMap("confluent-tenant", tenantId));
    }

    static ClientQuotaEntity ipEntity(String ip) {
        return new ClientQuotaEntity(Collections.singletonMap("ip", ip));
    }

    static ClientQuotaEntity userClientEntity(String user, String clientId) {
        HashMap<String, String> entries = new HashMap<String, String>(2);
        entries.put("user", user);
        entries.put("client-id", clientId);
        return new ClientQuotaEntity(entries);
    }

    @Test
    public void testIsValidIpEntityWithNull() {
        Assertions.assertTrue((boolean)ClientQuotaControlManager.isValidIpEntity(null));
    }

    @Test
    public void testIsValidIpEntityWithUnresolvableHostname() {
        Assertions.assertFalse((boolean)ClientQuotaControlManager.isValidIpEntity((String)"example.invalid"));
    }

    @Test
    public void testIsValidIpEntityWithLocalhost() {
        Assertions.assertTrue((boolean)ClientQuotaControlManager.isValidIpEntity((String)"127.0.0.1"));
    }

    @Test
    public void testConfigKeysForEntityTypeWithUser() {
        ClientQuotaControlManagerTest.testConfigKeysForEntityType(Collections.singletonList("user"), Arrays.asList("producer_byte_rate", "consumer_byte_rate", "controller_mutation_rate", "request_percentage"));
    }

    @Test
    public void testConfigKeysForEntityTypeWithClientId() {
        ClientQuotaControlManagerTest.testConfigKeysForEntityType(Collections.singletonList("client-id"), Arrays.asList("producer_byte_rate", "consumer_byte_rate", "controller_mutation_rate", "request_percentage"));
    }

    @Test
    public void testConfigKeysForEntityTypeWithUserAndClientId() {
        ClientQuotaControlManagerTest.testConfigKeysForEntityType(Arrays.asList("client-id", "user"), Arrays.asList("producer_byte_rate", "consumer_byte_rate", "controller_mutation_rate", "request_percentage"));
    }

    @Test
    public void testConfigKeysForEntityTypeWithIp() {
        ClientQuotaControlManagerTest.testConfigKeysForEntityType(Collections.singletonList("ip"), Collections.singletonList("connection_creation_rate"));
    }

    @Test
    public void testConfigKeysForEntityTypeWithTenant() {
        ClientQuotaControlManagerTest.testConfigKeysForEntityType(Arrays.asList("confluent-tenant"), Arrays.asList("connection_creation_rate", "producer_id_expiration_ms", "connection_creation_count", "metadata_request_minimum_throttle_ms", "acl_count"));
    }

    private static Map<String, String> keysToEntity(List<String> entityKeys) {
        HashMap<String, String> entity = new HashMap<String, String>();
        for (String entityKey : entityKeys) {
            if (entityKey.equals("ip")) {
                entity.put(entityKey, "127.0.0.1");
                continue;
            }
            entity.put(entityKey, "foo");
        }
        return entity;
    }

    private static void testConfigKeysForEntityType(List<String> entityKeys, List<String> expectedConfigs) {
        HashMap output = new HashMap();
        Assertions.assertEquals((Object)ApiError.NONE, (Object)ClientQuotaControlManager.configKeysForEntityType(ClientQuotaControlManagerTest.keysToEntity(entityKeys), output));
        Assertions.assertEquals(new HashSet<String>(expectedConfigs), output.keySet());
    }

    @Test
    public void testConfigKeysForEmptyEntity() {
        ClientQuotaControlManagerTest.testConfigKeysError(Collections.emptyList(), new ApiError(Errors.INVALID_REQUEST, "Invalid empty client quota entity"));
    }

    @Test
    public void testConfigKeysForEntityTypeWithIpAndUser() {
        ClientQuotaControlManagerTest.testConfigKeysError(Arrays.asList("ip", "user"), new ApiError(Errors.INVALID_REQUEST, "Invalid quota entity combination, IP entity shouldnot be combined with User or ClientId or Tenant"));
    }

    @Test
    public void testConfigKeysForEntityTypeWithIpAndClientId() {
        ClientQuotaControlManagerTest.testConfigKeysError(Arrays.asList("ip", "client-id"), new ApiError(Errors.INVALID_REQUEST, "Invalid quota entity combination, IP entity shouldnot be combined with User or ClientId or Tenant"));
    }

    @Test
    public void testConfigKeysForEntityTypeWithTenantAndUser() {
        ClientQuotaControlManagerTest.testConfigKeysError(Arrays.asList("confluent-tenant", "user"), new ApiError(Errors.INVALID_REQUEST, "Invalid quota entity combination, Tenant entity shouldnot be combined with User or ClientId or IP"));
    }

    @Test
    public void testConfigKeysForEntityTypeWithTenantAndClientId() {
        ClientQuotaControlManagerTest.testConfigKeysError(Arrays.asList("confluent-tenant", "client-id"), new ApiError(Errors.INVALID_REQUEST, "Invalid quota entity combination, Tenant entity shouldnot be combined with User or ClientId or IP"));
    }

    private static void testConfigKeysError(List<String> entityKeys, ApiError expectedError) {
        ClientQuotaControlManagerTest.testConfigKeysError(ClientQuotaControlManagerTest.keysToEntity(entityKeys), expectedError);
    }

    @Test
    public void testConfigKeysForUnresolvableIpEntity() {
        ClientQuotaControlManagerTest.testConfigKeysError(Collections.singletonMap("ip", "example.invalid"), new ApiError(Errors.INVALID_REQUEST, "example.invalid is not a valid IP or resolvable host."));
    }

    private static void testConfigKeysError(Map<String, String> entity, ApiError expectedError) {
        HashMap output = new HashMap();
        Assertions.assertEquals((Object)expectedError, (Object)ClientQuotaControlManager.configKeysForEntityType(entity, output));
    }

    @Test
    public void testValidateQuotaKeyValueForUnknownQuota() {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Invalid configuration key foobar"), (Object)ClientQuotaControlManager.validateQuotaKeyValue(VALID_CLIENT_ID_QUOTA_KEYS, (String)"foobar", (double)1.0));
    }

    @Test
    public void testValidateQuotaKeyValueForZeroQuota() {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Quota producer_byte_rate must be greater than 0"), (Object)ClientQuotaControlManager.validateQuotaKeyValue(VALID_CLIENT_ID_QUOTA_KEYS, (String)"producer_byte_rate", (double)0.0));
    }

    @Test
    public void testValidateQuotaKeyValueForNegativeQuota() {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Quota consumer_byte_rate must be greater than 0"), (Object)ClientQuotaControlManager.validateQuotaKeyValue(VALID_CLIENT_ID_QUOTA_KEYS, (String)"consumer_byte_rate", (double)-2.0));
    }

    @Test
    public void testValidateQuotaKeyValueForValidConsumerByteRate() {
        Assertions.assertEquals((Object)ApiError.NONE, (Object)ClientQuotaControlManager.validateQuotaKeyValue(VALID_CLIENT_ID_QUOTA_KEYS, (String)"consumer_byte_rate", (double)1234.0));
    }

    @Test
    public void testValidateQuotaKeyValueForConsumerByteRateTooLarge() {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Proposed value for consumer_byte_rate is too large for a LONG."), (Object)ClientQuotaControlManager.validateQuotaKeyValue(VALID_CLIENT_ID_QUOTA_KEYS, (String)"consumer_byte_rate", (double)3.689349E19f));
    }

    @Test
    public void testValidateQuotaKeyValueForFractionalConsumerByteRate() {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "consumer_byte_rate cannot be a fractional value."), (Object)ClientQuotaControlManager.validateQuotaKeyValue(VALID_CLIENT_ID_QUOTA_KEYS, (String)"consumer_byte_rate", (double)2.245));
    }

    @Test
    public void testValidateQuotaKeyValueForValidConsumerByteRate2() {
        Assertions.assertEquals((Object)ApiError.NONE, (Object)ClientQuotaControlManager.validateQuotaKeyValue(VALID_CLIENT_ID_QUOTA_KEYS, (String)"consumer_byte_rate", (double)1235.0000001));
    }

    @Test
    public void testValidateQuotaKeyValueForValidRequestPercentage() {
        Assertions.assertEquals((Object)ApiError.NONE, (Object)ClientQuotaControlManager.validateQuotaKeyValue(VALID_CLIENT_ID_QUOTA_KEYS, (String)"request_percentage", (double)56.62367));
    }

    static {
        Assertions.assertEquals((Object)ApiError.NONE, (Object)ClientQuotaControlManager.configKeysForEntityType(ClientQuotaControlManagerTest.keysToEntity(Collections.singletonList("client-id")), VALID_CLIENT_ID_QUOTA_KEYS));
    }
}

