/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.BrokersToIsrs;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class BrokersToIsrsTest {
    private static final Uuid[] UUIDS = new Uuid[]{Uuid.fromString((String)"z5XgH_fQSAK3-RYoF2ymgw"), Uuid.fromString((String)"U52uRe20RsGI0RvpcTx33Q")};

    private static Set<TopicIdPartition> toSet(TopicIdPartition ... partitions) {
        return new HashSet<TopicIdPartition>(Arrays.asList(partitions));
    }

    private static Set<TopicIdPartition> toSet(BrokersToIsrs.PartitionsOnReplicaIterator iterator) {
        HashSet<TopicIdPartition> set = new HashSet<TopicIdPartition>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    @Test
    public void testIterator() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        BrokersToIsrs brokersToIsrs = new BrokersToIsrs(snapshotRegistry);
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition[0]), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(1, false)));
        brokersToIsrs.update(UUIDS[0], 0, null, new int[]{1, 2, 3}, -1, 1);
        brokersToIsrs.update(UUIDS[1], 1, null, new int[]{2, 3, 4}, -1, 4);
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition(UUIDS[0], 0)), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(1, false)));
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition(UUIDS[0], 0), new TopicIdPartition(UUIDS[1], 1)), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(2, false)));
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition(UUIDS[1], 1)), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(4, false)));
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition[0]), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(5, false)));
        brokersToIsrs.update(UUIDS[1], 2, null, new int[]{3, 2, 1}, -1, 3);
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition(UUIDS[0], 0), new TopicIdPartition(UUIDS[1], 1), new TopicIdPartition(UUIDS[1], 2)), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(2, false)));
    }

    @Test
    public void testLeadersOnlyIterator() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        BrokersToIsrs brokersToIsrs = new BrokersToIsrs(snapshotRegistry);
        brokersToIsrs.update(UUIDS[0], 0, null, new int[]{1, 2, 3}, -1, 1);
        brokersToIsrs.update(UUIDS[1], 1, null, new int[]{2, 3, 4}, -1, 4);
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition(UUIDS[0], 0)), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(1, true)));
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition[0]), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(2, true)));
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition(UUIDS[1], 1)), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(4, true)));
        brokersToIsrs.update(UUIDS[0], 0, new int[]{1, 2, 3}, new int[]{1, 2, 3}, 1, 2);
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition[0]), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(1, true)));
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition(UUIDS[0], 0)), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(2, true)));
    }

    @Test
    public void testNoLeader() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        BrokersToIsrs brokersToIsrs = new BrokersToIsrs(snapshotRegistry);
        brokersToIsrs.update(UUIDS[0], 2, null, new int[]{1, 2, 3}, -1, 3);
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition(UUIDS[0], 2)), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(3, true)));
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition[0]), BrokersToIsrsTest.toSet(brokersToIsrs.iterator(2, true)));
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition[0]), BrokersToIsrsTest.toSet(brokersToIsrs.partitionsWithNoLeader()));
        brokersToIsrs.update(UUIDS[0], 2, new int[]{1, 2, 3}, new int[]{1, 2, 3}, 3, -1);
        Assertions.assertEquals(BrokersToIsrsTest.toSet(new TopicIdPartition(UUIDS[0], 2)), BrokersToIsrsTest.toSet(brokersToIsrs.partitionsWithNoLeader()));
    }
}

