/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.BrokersToElrs;
import org.apache.kafka.controller.BrokersToIsrs;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BrokerToElrsTest {
    private static final Uuid[] UUIDS = new Uuid[]{Uuid.fromString((String)"z5XgH_fQSAK3-RYoF2ymgw"), Uuid.fromString((String)"U52uRe20RsGI0RvpcTx33Q")};

    private static Set<TopicIdPartition> toSet(TopicIdPartition ... partitions) {
        return new HashSet<TopicIdPartition>(Arrays.asList(partitions));
    }

    private static Set<TopicIdPartition> toSet(BrokersToIsrs.PartitionsOnReplicaIterator iterator) {
        HashSet<TopicIdPartition> set = new HashSet<TopicIdPartition>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    @Test
    public void testIterator() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        BrokersToElrs brokersToElrs = new BrokersToElrs(snapshotRegistry);
        Assertions.assertEquals(BrokerToElrsTest.toSet(new TopicIdPartition[0]), BrokerToElrsTest.toSet(brokersToElrs.partitionsWithBrokerInElr(1)));
        brokersToElrs.update(UUIDS[0], 0, null, new int[]{1, 2, 3});
        brokersToElrs.update(UUIDS[1], 1, null, new int[]{2, 3, 4});
        Assertions.assertEquals(BrokerToElrsTest.toSet(new TopicIdPartition(UUIDS[0], 0)), BrokerToElrsTest.toSet(brokersToElrs.partitionsWithBrokerInElr(1)));
        Assertions.assertEquals(BrokerToElrsTest.toSet(new TopicIdPartition(UUIDS[0], 0), new TopicIdPartition(UUIDS[1], 1)), BrokerToElrsTest.toSet(brokersToElrs.partitionsWithBrokerInElr(2)));
        Assertions.assertEquals(BrokerToElrsTest.toSet(new TopicIdPartition(UUIDS[1], 1)), BrokerToElrsTest.toSet(brokersToElrs.partitionsWithBrokerInElr(4)));
        Assertions.assertEquals(BrokerToElrsTest.toSet(new TopicIdPartition[0]), BrokerToElrsTest.toSet(brokersToElrs.partitionsWithBrokerInElr(5)));
        brokersToElrs.update(UUIDS[1], 2, null, new int[]{3, 2, 1});
        Assertions.assertEquals(BrokerToElrsTest.toSet(new TopicIdPartition(UUIDS[0], 0), new TopicIdPartition(UUIDS[1], 1), new TopicIdPartition(UUIDS[1], 2)), BrokerToElrsTest.toSet(brokersToElrs.partitionsWithBrokerInElr(2)));
    }
}

